
;;; Disjunction test.

(defun facts-about-disjunction ()
  (a-assert "New slots."
            '((:slot A (things things))
              (:slot B (things things))
              (:slot C (things things))))
  (a-assert "The rule."
            '((:rules things
                      ((A ?x ?x) <- (not (B ?x ?x)) (not (C ?x ?x))))))
  (a-assert "Frames."
            '((:create ?x1 x1)
              (:create ?x2 x2)
              (:create ?x3 x3)))
  (a-assert "Facts."
            '((not (A x1 x1)) (not (B x1 x1))
              (not (A x2 x2)) (not (C x2 x2))
              (not (B x3 x3)) (not (C x3 x3)))))

(defun queries-about-disjunction ()
  (a-query "C should hold for x1."
           '((C x1 x1)))
  (a-query "B should hold for x2."
           '((B x2 x2)))
  (a-query "A should hold for x3."
           '((A x3 x3))))

(defun facts-about-disjunction-2 ()
  (a-assert "New slots."
            '((:slot A (things things))
              (:slot B (things things))
              (:slot C (things things))
              (:slot D (things things))))
  (a-assert "The rule."
            '((:rules things
                      ((A ?x ?x) <- (not (B ?x ?x)) (not (C ?x ?x)) (not (D ?x ?x))))))
  (a-assert "Frames."
            '((:create ?x1 x1)
              (:create ?x2 x2)
              (:create ?x3 x3)
              (:create ?x4 x4)))
  (a-assert "Facts."
            '((not (B x1 x1)) (not (C x1 x1)) (not (D x1 x1))
              (not (A x2 x2)) (not (C x2 x2)) (not (D x2 x2))
              (not (A x3 x3)) (not (B x3 x3)) (not (D x3 x3))
              (not (A x4 x4)) (not (B x4 x4)) (not (C x4 x4)))))

(defun queries-about-disjunction-2 ()
  (a-query "A should hold for x1."
           '((A x1 x1)))
  (a-query "B should hold for x2."
           '((B x2 x2)))
  (a-query "C should hold for x3."
           '((C x3 x3)))
  (a-query "D should hold for x4."
           '((D x4 x4))))

            