
(defun build-frames (n)
  (a-assert "Link slot" '((:slot link (objects objects))
                          (:slot first-frame (contexts objects))))
  (let (current-frame
        last-frame)
    (dotimes (x n)
      (setq current-frame (intern (format nil "BF~a" x)))
      (a-assert nil `((:create ?x ,current-frame)))
      (if last-frame
        (a-assert nil `((link ,last-frame ,current-frame)))
        (a-assert nil `((first-frame global-context ,current-frame))))
      (setq last-frame current-frame))))

(defun bf (n)
  (a-assert "Link slot" '((:slot link (objects objects))
                          (:slot first-frame (contexts objects))))
  (let (last-frame)
    (flet ((my-setq (x) (setq last-frame x)))
      (dotimes (x n)
        (if last-frame
          (a-assert nil `((:create ?x) (link (:quote ,last-frame) ?x)
                          (:apply ,#'my-setq (?x))))
          (a-assert nil `((:create ?x) (first-frame global-context ?x)
                          (:apply ,#'my-setq (?x)))))))))