;;; -*- Mode:Common-Lisp; Package:USER; Syntax:COMMON-LISP; Base:10 -*-

; Bank Problem

;This is puzzle 1 in "101 Puzzles in Thought and Logic" by C.R. Wylie Jr:
;
;  In a certain bank the positions of cashier, manager, and teller
;  are held by Brown, Jones and Smith, though not necessarily respectively.
;    The teller, who was an only child, earns the least.
;    Smith, who married Brown's sister, earns more than the manager.
;  What position does each man fill ?
  
;I think this problem is interesting for Algernon for several reasons:

;  1. It relies on only a relatively small amount of common-sense knowledge.
;  2. It involves a little bit of negation.
;  3. It involves a lot of reasoning with sets.
;  4. The 'natural' approach to it involves the use of co-reference.
;  5. It is non-trivial (in that a person does not immediately see the
;  answer), but short (a person could probably solve it in 5-10 minutes).
;  Thus its solution in Algernon should involve a fairly short series of queries.
				      
;My solution in english is as follows:
;  1. Smith earns more than the manager and hence Smith is not the manager.
;  2. Smith earns more than the manager and hence Smith is not the teller
;  (who earns the least).
;  3. Hence Smith is the cashier.
;  4. The teller is an only child hence Brown is not the teller.
;  5. Hence Brown is the manager (since we already know that Smith is the cashier).

; To represent the problem in Algy we first need to define terms:
(defun facts-about-bank ()
  (a-assert "New sets."
            '((:taxonomy (objects (companies Bank)
                                  (positions cashier manager teller)
                                  (people)))))
  (a-assert "New slots."
	    '((:slot sister (people people)
		   :comment "(sister a b) = The sister of a is b.")
              (:slot only-child (people booleans)
                     :cardinality 1
                     :comment "(only-child a true) = a is an only child.")
              (:slot holds (people companies positions)
                     :comment "(holds ?p ?c ?pos) = ?p holds position ?pos in company ?c.")
              (:slot position (companies positions people)
                     :comment "(position ?c ?pos ?p) = In company ?c, ?pos is held by ?p.")))

  (a-assert "Sisters and only children."
            '((:RULES people
                      ((sister ?p1 ?p2) -> (not (only-child ?p1 true))))))

  (a-assert "Holds and position."
            '((:SRULES (:slot position)
                       ((position ?c ?pos ?p) -> (holds ?p ?c ?pos)))
              (:SRULES (:slot holds)
                       ((holds ?p ?c ?pos) -> (position ?c ?pos ?p)))))

  ;; Hack -- This should replace the rule in akbase (assuming we really want to do
  ;; this inference forward -- in this example it is necessary due to partition problems ...).
  (a-assert "Forward chaining rule for cf-member."
            '((:RULES sets
                      ((one-to-one-into ?s1 ?s2) (member ?s1 ?x) -> (cf-member ?x ?s2)))))

  (a-assert "In a certain bank the positions of cashier, manager, and teller
	    are held by Brown, Jones and Smith, though not necessarily respectively."
	    '(; First the bank and its positions (note that we are carefull here to distinguish
	      ; between the position of cashier and the person holding the job cashier):
              (:forc ?cp (position Bank cashier ?cp))
              (:forc ?mp (position Bank manager ?mp))
              (:forc ?tp (position Bank teller ?tp))
	      ;
              (:create ?b Brown) (:create ?s Smith) (:create ?j Jones)
	      (isa ?b people) (isa ?j people) (isa ?s people)
	      ;
	      ; the set of people holding the positions:
              (:create ?pos posts) (member ?pos ?cp) (member ?pos ?mp) (member ?pos ?tp)
	      (complete ?pos true)
	      ;
	      ; the set {brown,smith,jones}:
	      (:create ?emp employes) (member ?emp ?b) (member ?emp ?j) (member ?emp ?s)
	      (complete ?emp true)
	      ;
	      ; and the relationship between these sets:
	      (one-to-one ?pos ?emp)
	      ;
	      ; finally, the implicit assumption that Brown, Jones and Smith are different people:
	      (:assume (not (coreferent ?b ?j)))
	      (:assume (not (coreferent ?j ?s)))
	      (:assume (not (coreferent ?s ?b)))))

  ;; Hack -- Here I use "least" when I really should use "earns-least".
  (a-assert "The teller, who was an only child, earns the least."
	    '((position Bank teller ?tp) (only-child ?tp true)
	      (least ?tp posts)))
  
  (a-assert "Smith, who married Brown's sister, earns more than the manager."
	    '((:forc ?sis (sister Brown ?sis))
              (spouse Smith ?sis)
              (position Bank manager ?man)
              (greater Smith ?man))))

(defun queries-about-bank ()
  (a-query "What positions do Brown, Smith and Jones hold ?"
	   '((coreferent Brown ?be) (holds ?be bank ?bpost)
             (coreferent Smith ?se) (holds ?se bank ?spost)
             (coreferent Jones ?je) (holds ?je bank ?jpost)))
  (a-query "If Smith were the manager then how could he earn more than the manager ?"
	   '((position Bank manager ?man)
             (:assume (coreferent Smith ?man))
             (not (greater Smith ?man))))
  (a-query "If Smith were the teller then how could he earn more than the manager?"
	   '((position Bank teller ?t)
             (:assume (coreferent Smith ?t))
             (position Bank manager ?man)
             (not (greater Smith ?man))))
  (a-query "Hence, Smith is which employee ?"
	   '((coreferent Smith ?se) (holds ?se bank ?spost)))
  (a-query "If Brown were the teller then would he be an only child ?"
	   '((position Bank teller ?t)
             (:assume (coreferent Brown ?t))
             (only-child Brown true)))
  (a-query "Hence Brown is which employee ?"
	   '((coreferent Brown ?be) (holds ?be bank ?bpost)))
  (a-query "Hence Jones is which employee ?"
	   '((coreferent Jones ?je) (holds ?je bank ?jpost))))

(defun new-qab ()
  (a-assert "First, we need to know how to prove not least and not greatest."
	    ;; This is a good example of a useful rule that can only fire if
	    ;; on a GROUND query:
	    '((:rules objects
		      ((not (least ?x ?set)) <-
		       (member ?set ?y) (:neq ?x ?y) (not (less ?x ?y)))
		      ((not (greatest ?x ?set)) <-
		       (member ?set ?y) (:neq ?x ?y) (not (greater ?x ?y))))))

  (a-query "What positions do Brown, Smith and Jones hold ?"
	   '((coreferent Brown ?be) (holds ?be bank ?bpost)
             (coreferent Smith ?se) (holds ?se bank ?spost)
             (coreferent Jones ?je) (holds ?je bank ?jpost)))

  ;; (trace-contra)
  (coref-tester '(Brown Smith Jones)
		'(frame1 frame2 frame3)
		'(;; Is the teller not an only child?
		  ((position Bank teller ?tp) (not (only-child ?tp true)))
		  ;; Does the teller not earn the least?"
		  ((position Bank teller ?tp) (not (least ?tp posts)))
		  ;; Is Smith's wife not Brown's sister?"
		  ((spouse Smith ?s) (not (sister Brown ?s)))
		  ;; Is Brown's sister not Smith's wife?"
		  ((sister Brown ?s) (not (spouse Smith ?s)))
		  ;; Does Smith not earn more than the manager?"
		  ((position Bank manager ?man) (not (greater Smith ?man)))))

  (a-query "What positions do Brown, Smith and Jones hold ?"
	   '((coreferent Smith ?se) (holds ?se bank ?spost)
	     (coreferent Brown ?be) (holds ?be bank ?bpost)
             (coreferent Jones ?je) (holds ?je bank ?jpost))))