;;; -*- Mode: LISP; Syntax: Zetalisp; Base: 10; Fonts: CPTFONT,CPTFONTB; Package: USER -*-

1;;Copyright (c) 1986 by John C. Hogge, The University of Illinois.
;;
;;File DEFSYSTEM.LISP of system Zgraph.

;;This system is Zgraph, a general graph display system by John Hogge.
;;
;;To compile and load Zgraph, load this file and then evaluate 
;;  (MAKE-SYSTEM 'zgraph :RECOMPILE)
;;
;;To get to the user interface, which has decent on-line help and some graph examples,
;;press SELECT G.

0;;This is the TI Explorer System version of Zgraph.  Where conversion from the Symbolics
;;dialect has been necessary, I've added conditional compile flags, #+Symbolics vs. #+Explorer.
;;Exceptions and notes:
;;1. Symbolics currently requires lots of calls to SI:STRING.  These are superfluous on the 
;;   Explorer.
;;2. CPTFONTCB is called CPTFONTB on the Explorer.  All mode-lines have been updated.

#+Symbolics
(DEFPACKAGE zg
  (:USE SYMBOLICS-COMMON-LISP))
#+Explorer
(DEFPACKAGE zg)


(DEFSYSTEM zgraph
  (:NAME "Zgraph")
  #+Symbolics
  (:PATHNAME-DEFAULT "swift:>hogge>zg>")
  #+Explorer
  (:PATHNAME-DEFAULT "lm:ZG;")
  (:MODULE definitions "definitions")
  (:MODULE trees "2trees0")
  (:MODULE guts ("graph-type" "graph"))
  (:MODULE interface ("interface"))
  (:MODULE examples ("example" "finterface"))
  (:COMPILE-LOAD definitions)
  (:COMPILE-LOAD trees)
  (:COMPILE-LOAD guts (:FASLOAD definitions))
  (:COMPILE-LOAD interface (:FASLOAD definitions guts))
  (:COMPILE-LOAD examples (:FASLOAD definitions guts)))

1;;
;; Known bugs:
;;

0;;; Stepper doesn't work right for the second (default) method of laying
;;; out graphs--shows more vertices than it is dealing with at a time.

;;; Approximation of Y positions in hexagonal grid needs to be replaced
;;; by the real value.  (Do string search on "CRC".)

;;; The code that you get via SUPER-HELP doesn't run on the TI Explorer.
;;; Refer to the note in this code for more details (appears to be a window
;;; system bug).

;;; Fast panning via LHold can be done when the mouse is over any of the panes
;;; other than the menu pane.  This is especially nice when using the description
;;; scroll window configuration, which takes up about half the screen.  But,
;;; on the Explorer fast panning stops when the mouse moves between any of the
;;; panes.  Minor nuisance.  Problem occurs because TV:MOUSE-BUTTONS returns
;;; 0, even when left mouse button is still being held down, as soon as the mouse
;;; crosses to a new pane.
