;; -*- LISP -*-

#+lucid (in-package "EDITOR")

#+lucid (defvar *typescript-window-number* 0)

#+lucid (defun attach-editor-to-window
    (window &key
	    (buffer-name (format nil "Typescript-Window-~D"
				 (incf *typescript-window-number*)))
	    modeline)
  (let* ((vpt (coerce-to-viewport window))
	 (height (pixels-to-lines (region-height vpt)))
	 (width (pixels-to-chars (region-width vpt)))
	 (new-buffer (make-buffer buffer-name '("Lisp")))
	 (editor-window (internal-make-window))
	 )
    (setup-window-image (buffer-point new-buffer) editor-window 0
			(if modeline (1-& height) height)
			width)
    (when modeline
      (setup-modeline-image editor-window (value default-modeline-function)
			    (value default-modeline-string)))
    (prepare-window-for-redisplay editor-window)
    (setf (window-dpy-window editor-window) window
	  (buffer-minor-mode new-buffer "Top-Level") t)
    (values new-buffer editor-window (buffer-stream new-buffer))
    ))

#+lucid (defun select-window (win)
  (setf (current-window) win
	(current-buffer) (window-buffer win)))

#+lucid (defvar *previous-point* nil)

;;--------------------------------------------------------------------------
;;
;; doit-window
;; This command gets bound to carriage-return during the dialog box. It's
;; function is to gather up all of the text from the prompt to the current
;; point and return it as the value of dialogbox.
;;
;;--------------------------------------------------------------------------

#+lucid (defcommand "doit-window" (&rest yow) "" ""
	    (buffer-end (current-point))
	    (let ((the-point (current-point)))
		 (if (mark> *previous-point* the-point)
		     (beep)
		     (throw 'return-input
			    (region-to-string (region *previous-point*
						      the-point))))))

;;--------------------------------------------------------------------------
;;
;; myrubout, mybacksp
;; These two commands are bound to rubout and backp-space respectively. They
;; are just like the normal commands, but prevent one from back-spacing or
;; deleting across the cursor.
;;
;;--------------------------------------------------------------------------

#+lucid (defcommand "myrubout" (p) "" ""
    (if (mark<= (current-point) *previous-point*)
	(beep)
	(delete-previous-character-command p)))

#+lucid (defcommand "mybacksp" (p) "" ""
    (if (mark<= (current-point) *previous-point*)
	(beep)
	(backward-character-command p)))

;;--------------------------------------------------------------------------
;;
;; dialogbox
;; this function takes three arguments: the name of a window to do the dialog
;; in, a prompt string to display, and then a default string for the user to
;; type. When called from with the editor, the function will let the user
;; enter a line of text, edit it, and terminate the dialog when the user
;; presses carriage return. Whatever had been typed at that point gets returned.
;; If the user presses return without typing anytihng else the default is
;; returned. It is possible to backspace over all or part of the default to
;; change it.
;;
;;--------------------------------------------------------------------------

#+lucid (defun dialogbox (window prompt-string &optional (default-string ""))
    (let ((old-window *current-window*)
	  (old-return (command-name (get-command #\return)))
	  (old-rubout (command-name (get-command #\rubout)))
	  (old-backsp (command-name (get-command #\control-b))))
	 (multiple-value-bind (editor-buffer
			       editor-window
			       editor-stream)
	    (attach-editor-to-window window)
	    (catch 'return-input
		(unwind-protect
		   (progn (select-window editor-window)
			  (end-of-buffer-command nil)
			  (format editor-stream prompt-string)
			  (setq *previous-point*
				(mark (mark-line (current-point))
				      (mark-charpos (current-point))))
			  (format editor-stream default-string)
			  (bind-key "doit-window" #\return
						  :mode "Top-Level")
			  (bind-key "myrubout" #\rubout :mode "Top-Level")
			  (bind-key "mybacksp" #\control-b :mode "Top-Level")
			  (recursive-edit))
		   (select-window old-window)
		   (bind-key old-rubout #\rubout :mode "Top-Level")
		   (bind-key old-return #\return :mode "Top-Level")
		   (bind-key old-backsp #\control-b :mode "Top-Level")
		   "")))))

