;;; -*- Mode: LISP; Syntax: Common-lisp; Base: 10; Package: ZG; Default-character-style: (:FIX :ROMAN :NORMAL) -*-

D,#TD1PsT[Begin using 006 escapes](1 0 (NIL 0) (NIL :BOLD-EXTENDED NIL) "CPTFONTB");(2 0 (NIL 0) (NIL NIL NIL) "CPTFONT")From forbus Fri Oct 11 15:33:52 1985
1;2Date: Fri, 11 Oct 85 15:33:35 CDT
1;2From: forbus (Kenneth Forbus)
1;2To: falken, hogge, selig
1;2Subject: Drawing trees

1;2Here's some trivial code that will assign display coordinates
1;2to trees.  How they should be put onto screen coordinates is
1;2not solved here.

1;2It's grungo code, written late one night when I was sick of writing
1;2on the thesis.

;;;; Drawing trees
;first step in drawing graphs is drawing trees.
;
;   Weickert's algorithm works as follows:

;1. Compute the depth of each node, and record the maximum.
;   Add "phantom" offspring to branches whose depth is less than
;   maximum.  The depth of a node will form the one of the coordinates
;   for the drawing 
;
;2. Now assign the 2nd coordinate by recursive descent.  If a node
;   has offspring, then the 2nd coordinate is the average of the
;   2nd coordinates of its offspring.  If there are no offspring
;   (it is a leaf node), then the 2nd coordinate is the value
;   of a global counter (which is then incremented).
;
;  So coordinates are completely assigned by two depth-first searches.
;  
;  Attempt to generalize to arbitrary graphs -
;   First pass - assign coordinates according to tree algorithm,
;    treating nodes of in-degree 0 as roots.  A mark search is
;    required to prevent looping.


;bookkeeping
(defvar *DR-NODES* nil)
(defvar *DR-LINKS* nil)
(defvar *DR-CONNECTIONS* nil)
(defvar *DR-FCOORDS* nil)
(defvar *DR-SCOORDS* nil)

;Internals

(defvar *DR-SCOORD-COUNTER* 0.0)
(defvar *DR-MARK-ALIST* nil)

(defun dr-init ()
  (setq *DR-NODES* nil)
  (setq *DR-LINKS* nil)
  (setq *DR-CONNECTIONS* nil)
  (setq *DR-FCOORDS* nil)
  (setq *DR-SCOORDS* nil)
  (setq *DR-SCOORD-COUNTER* 0.0)
  (setq *DR-MARK-ALIST* nil))


;format assumptions
;Input is a list of nodes, assumed to be distinguishable
;by EQUAL, and a list of links with the form (<name> <tail> <head>).
;(A name is stored because other parts of the drawing code may want to
;label the arcs)

(defun dr-link-name (n) (car n))
(defun dr-link-tail (n) (cadr n))
(defun dr-link-head (n) (caddr n))
(defun dr-in-links (n) (cadr n))
(defun dr-out-links (n) (caddr n))

(defun dr-node-out-links (node)
 (dr-out-links (assoc node *DR-CONNECTIONS*)))

(defun dr-node-in-links (node)
  (dr-in-links (assoc node *DR-CONNECTIONS*)))


;;;; entry

(Defun dr-graph-coordinates (nodes links)
  (dr-init)
  (setq *DR-NODES* nodes)
  (setq *DR-LINKS* links)
  (setq *DR-MARK-ALIST* (mapcar '(lambda (n) (ncons n))
				nodes))
  (build-graph-connection-table)
  (let ((roots (dr-find-roots)))
    (dr-assign-fcoords roots)
    (dr-assign-scoords roots))
  (VALUES *DR-FCOORDS* *DR-SCOORDS*))


;Initial processing of the graph
;first build up the connections table
;format is (<node> <in-pointers> <out-pointers>)

(defun build-graph-connection-table ()
;assumes globals are properly set
  (dolist (link *DR-LINKS*)
    (let ((entry (assoc (dr-link-tail link) *DR-CONNECTIONS*)))
      (cond ((null entry)
	     (setq entry (list (dr-link-tail link) NIL NIL))
	     (push entry *DR-CONNECTIONS*)))
      (rplaca (cddr entry) (cons link (caddr entry)))
      (setq entry (assoc (dr-link-head link) *DR-CONNECTIONS*))
      (cond ((null entry)
	     (setq entry (list (dr-link-head link) NIL NIL))
	     (push entry *DR-CONNECTIONS*)))
      (rplaca (cdr entry) (cons link (cadr entry))))))

(defun dr-find-roots ()
  (do ((entries *DR-CONNECTIONS*
		(cdr entries))
       (result nil))
      ((null entries) result)
    (cond ((null (dr-in-links (car entries)))
	   (push (car (car entries)) result)))))

(defun dr-marked? (node)
  (cdr (assoc node *DR-MARK-ALIST*)))

(defun dr-mark! (node mark)
  (rplacd (assoc node *DR-MARK-ALIST*) mark))

(defun clear-dr-marks ()
  (dolist (entry *DR-MARK-ALIST*)
    (rplacd entry NIL)))


;;;; Assigning the first coordinate

(defun dr-assign-fcoords (roots)
  (do ((nodes roots
	      next-nodes)
       (next-nodes nil nil)
       (number 0.0 (+ 1.0 number)))
      ((null nodes) (clear-dr-marks) number)
    (dolist (node nodes)
      (dr-mark! node T)
      (push (cons node number) *DR-FCOORDS*))
    (dolist (node nodes)
      (dolist (link (dr-node-out-links node))
	(cond ((dr-marked? (dr-link-head link)))
	      (t (push (dr-link-head link) next-nodes)))))))

;;; Assigning second coordinate

(defun dr-assign-scoords (roots)
  (dolist (node roots)
    (dr-assign-scoord node)))

(defun dr-assign-scoord (node)
  (cond ((dr-marked? node)) ;already looking at it
	(t (let ((entry (assoc node *DR-SCOORDS*)))
	     (cond ((null entry)
		    (setq entry (cons node nil))
		    (push entry *DR-SCOORDS*)))
	     (cond ((and entry (numberp (cdr entry)))
		    (cdr entry))
		   ((null (dr-node-out-links node))
		    (let ((n *DR-SCOORD-COUNTER*))
		      (rplacd entry *DR-SCOORD-COUNTER*)
		      (setq *DR-SCOORD-COUNTER*
			    (+ 1.0 *DR-SCOORD-COUNTER*))
		      n))
		   (t (do ((links (dr-node-out-links node)
				  (cdr links))
			   (n 0.0)
			   (counter 0.0))
			  ((null links)
			   (setq counter (/ counter n))
			   (rplacd entry counter)
			   counter)
			(setq n (+ 1.0 n))
			(setq counter (+ counter
					  (dr-assign-scoord
					   (dr-link-head (car links))))))))))))

;test case
(setq nodes '(n1 n2 n3 n4 n5 n6)
      links '((l1 n1 n2) (l2 n1 n3) (l3 n2 n4) (l4 n3 n5) (l5 n3 n6)))

1;2(dr-graph-coordinates nodes links)
