;; -*- LISP -*-

;;;; LaTeX output generators

;; Why write code to format and align tables when you can let LaTeX do it?
;; Warning: These routines are not "user friendly".  They do not completely
;; insulate you from LaTeX, nor do they do error checking.  Their purpose
;; is to speed tool building.

;;; Beginning and ending LaTeX files

(defun start-LaTeX-file (stream)
  (dolist (line *latex-file-header*) (format stream "~%~A" line)))

(defun end-LaTeX-file (stream)
  (dolist (line *latex-file-trailer*) (format stream "~%~A" line)))

(defun New-LaTeX-Page (stream) (format stream "~%\\newpage"))

(setq *latex-file-header*
  '("\\batchmode"
"\\documentstyle[12pt,alltt]{article}"
"\\pagestyle{myheadings}"
"\\makeatletter"
"\\newcommand{\\singlespacing}{\\let\\CS=\\@currsize\\renewcommand{\\baselinestretch}{0.5}\\small\\CS}"
"\\newcommand{\\normalspacing}{\\singlespacing}"
"\\makeatother"
"\\textheight 720pt"
"\\textwidth 500pt"
"\\topmargin -0.5in"
"\\oddsidemargin -0.5in"
"\\evensidemargin -0.5in"
"\\begin{document}"
"\\singlespacing"
""))

(defvar *latex-file-trailer*
'("\\end{document}"
  ""))

(defun change-page-headings (left right stream)
  (format stream "~%\\markboth{~A}{~A}" left right))

;;;; Fooling around with sizes

;; Ultimately would like to calculate if something will fit.

(defmacro With-Size (size stream &rest body)
  `(progn (format ,stream "~%\\begin{~A}" ,size)
	  ,@ body
	  (format ,stream "~%\\end{~A}" ,size)))

;;; A table is specified in two parts:
;;   A string representing the first argument to the tabular
;;       environment, and
;;   A list of item-lists, each item-list corresponding to the
;;       contents of a row of the table.
;;       (Any strings in this list will be added to the previous line after
;;            everything else, to allow  \hline and \cline commands)
;;   Each thing in an item-list is evaled and placed in a column of that row.

(defun make-latex-table (header item-lists &aux last result)
  (setq result (format nil "~%\\begin{tabular}{~A}" header))
  (dolist (thing item-lists)
    (cond ((stringp thing) ;; print it w/o newline
	   (setq result (concatenate 'string result (format nil "~A" thing))))
	  ((listp thing)
	   (setq result (concatenate 'string result (format nil "~%")
				     (output-latex-tabular-row thing ""))))
	  (t (error "MAKE-LATEX-TABLE: Must be string or item list: ~A" thing))))
  (concatenate 'string result (format nil "~%\\end{tabular}")))

(defun output-latex-tabular-row (item-list so-far)
  (cond ((null item-list) (concatenate 'string so-far " \\\\"))
	(t (output-latex-tabular-row (cdr item-list)
            (concatenate 'string so-far
			 (format nil " ~A" (eval (car item-list)))
			 (if (cdr item-list) (format nil " &") ""))))))


;;;; Test program

(defun test1 ()
  (with-open-file (fout "/u/utils/latex1.tex" :direction :output)
   (start-latex-file fout)
   (with-size "footnotesize" fout
   (format fout "~A"
	   (make-latex-table "|l|c|c|" '(" \\hline\\hline"
				 ("Quantity" "0.3" "1.0") " \\hline\\hline"
				 ("Heat" "-1" "1")" \\hline"
				 ("Light" "-32" "$\\star$") " \\hline\\hline"))))
   (end-latex-file fout)))

(setq *tb1* '(make-latex-table "lcccc" '((" " 0.0 0.3 0.6 0.9) (0.0 0 0 0 0)
				    (0.3 0 0 0 1) (0.6 0 0 1 1) (0.9 0 0 1 1))))
(setq *tb2* '(make-latex-table "lcccc" '((" " 0.0 0.3 0.6 0.9) (0.0 0 0 0 0)
				    (0.3 0 0 0 1) (0.6 0 0 1 1) (0.9 0 0 1 1))))
(setq *tb3* '(make-latex-table "lcccc" '((" " 0.0 0.3 0.6 0.9) (0.0 0 0 0 0)
				    (0.3 0 0 0 1) (0.6 0 0 1 1) (0.9 0 0 1 1))))
(setq *tb4* '(make-latex-table "lcccc" '((" " 0.0 0.3 0.6 0.9) (0.0 0 0 0 0)
				    (0.3 0 0 0 1) (0.6 0 0 1 1) (0.9 0 0 1 1))))

(defun test2 ()
  (with-open-file (out "/u/utils/latex1.tex" :direction :output)
   (start-latex-file out)
   (with-size "footnotesize" out
   (format out "~A"
	   (make-latex-table "|l||c|c|c|c|" `(" \\hline\\hline"
				 (" " "0.0" "0.3" "0.6" "0.9") " \\hline\\hline"
				 (0.0 ,*tb1* ,*tb2* ,*tb3* ,*tb4*) " \\hline"
				 (0.3 ,*tb1* ,*tb2* ,*tb3* ,*tb4*) " \\hline"
				 (0.6 ,*tb1* ,*tb2* ,*tb3* ,*tb4*) " \\hline"
				 (0.9 ,*tb1* ,*tb2* ,*tb3* ,*tb4*) " \\hline"
					  ))))
   (end-latex-file out)))
