;; -*- Lisp -*-

;;; Timing utility

;; Simple version, ignores prospect of wrapping, etc.
;; No check for amount of paging.  But oh-so-pure.

;; Internally a time will be (<run time> , <real time>)

(defun mark-time ()
  (cons (get-internal-run-time) (get-internal-real-time)))

(defun time-difference (time1 time2)
  (values (- (car time1) (car time2)) (- (cdr time1) (cdr time2))))

(defun make-time-difference (time1 time2)
  (cons (- (car time1) (car time2)) (- (cdr time1) (cdr time2))))

(defun time-plus (time1 time2)
  (values (- (car time1) (car time2)) (- (cdr time1) (cdr time2))))

(defun make-time-sum (time1 time2)
  (cons (- (car time1) (car time2)) (- (cdr time1) (cdr time2))))

(defmacro round-to (num digits)
  (let ((mul (expt 10.0 digits)))
    `(/ (round (* ,num ,mul)) ,mul)))

(defun say-time (time &key (header "") (stream *standard-output*))
  (format stream "~%  ~A~D sec. run time, ~D sec. real-time."
	  (if (string= header "") ""
	      (concatenate 'string header ": "))
	  (round-to (/ (car time) internal-time-units-per-second) 3.)
	  (round-to (/ (cdr time) internal-time-units-per-second) 3.)))


