;; -*- LISP -*-

;; Building a LaTeX index file
;; This produces stuff for program listings.
;; Someday it would be nice to make this sort
;; by type of definition and so on.

(defvar *latex-index* nil)

(defun make-index-file (infile outfile)
  (setq *latex-index* nil)
  (read-latex-index-entries infile)
  (sort-latex-index-entries)
  (dump-latex-index-entries outfile)

(defun read-latex-index-entries (infile)
  (with-open-file (fin infile :direction :input)
    (do ((line (read-line fin nil 'foobar)
	       (read-line fin nil 'foobar)))
	((eq line 'foobar))
      (grok-index-entry line)))

(defun grok-index-entry (line)
  (let* ((start1 (+ 15 (search "makeindexentry{" line :test #'string=)))
	 (end1 (search "}" line :start2 start1 :test #'string=))
	 (start2 (search "{" line :start2 end1 :test #'string=))
	 (end2 (search "}" line :start2 start2  :test #'string=)))
    (cons (subseq line start1 end1) (subseq line (1+ start2) end2))))

    
