;;; -*- Syntax: Common-lisp; Mode: LISP; -*-

(in-package qpe::*user-package*)

;;; Three containers example

(assertq (state liquid))
(assertq (substance water))

(assertq (container F))
(assertq (container G))
(assertq (container H))

(assertq (fluid-path P1))
(assertq (fluid-path P2))

(assertq (Aligned P1))
(assertq (Aligned P2))

(assertq (fluid-connection P1 F G))
(assertq (fluid-connection P1 G F))
(assertq (fluid-connection P2 G H))
(assertq (fluid-connection P2 H G))

(assertq (Equal-to (A (bottom-height F)) (A (Max-Height P1))))
(assertq (Equal-to (A (bottom-height H)) (A (Max-Height P2))))

(assertq (Equal-to (A (bottom-height G)) (A (max-height P1))))
(assertq (Equal-to (A (bottom-height G)) (A (max-height P2))))

