;;; -*- Mode: Lisp; Syntax: Common-lisp; Base: 10; -*-


(predicate :name        air)

(term :name        abnormal)

(term :name        (air abnormal)
      :relations   ((((air abnormal) has typical specialization (air mild)) "ee" NIL)
                    (((air abnormal) has typical specialization (air moderate)) "ee" NIL)
                    ((((bone normal) and (air abnormal)) moderately is required by conductive_hl) "ee" NIL)))

(term :name        mild)

(term :name        (air mild)
      :remindings  ((acoustic_neuroma 0.25) ((discontinuity ossicular_chain) 0.25) (meniere_s 0.25))
      :relations   ((((air mild) has typical generalization (air abnormal)) "ee" NIL)
                    ((((air mild) and (bone normal)) definition implies conductive_hl) "ee" NIL)
                    (((air mild) sometimes is required by acoustic_neuroma) "ee" NIL)))

(term :name        moderate)

(term :name        (air moderate)
      :remindings  ((meniere_s 0.25))
      :relations   ((((air moderate) has typical generalization (air abnormal)) "ee" NIL)
                    (((air moderate) sometimes is required by meniere_s) "ee" NIL)))

(term :name        normal)

(term :name        (air normal)
      :remindings  ((normal_ear 0.50))
      :relations   ((((air normal) occasionally is required by facial_nerve_disorder) "ee" NIL)
                    (((air normal) strongly is required by normal_ear) "ee" NIL)))

(term :name        severe)

(term :name        (air severe)
      :remindings  ((malleus_fixation 0.25))
      :relations   ((((air severe) sometimes cooccurs with malleus_fixation) "ee" NIL)))

(predicate :name        bone)

(term :name        (bone mild)
      :remindings  ((acoustic_neuroma 0.25))
      :relations   ((((bone mild) sometimes is required by acoustic_neuroma) "ee" NIL)))

(term :name        (bone normal)
      :remindings  ((conductive_hl 0.25) (normal_ear 0.25))
      :relations   ((((bone normal) requires (ipsi_ar normal)) "ee" NIL)
                    (((bone normal) weakly is required by normal_ear) "ee" NIL)
                    ((((bone normal) and (air abnormal)) moderately is required by conductive_hl) "ee" NIL)
                    ((((air mild) and (bone normal)) definition implies conductive_hl) "ee" NIL)
                    (((bone normal) cooccurs with conductive_hl) "ee" NIL)))

(predicate :name        contra_ar)

(term :name        (contra_ar abnormal)
      :relations   ((((contra_ar abnormal) has typical specialization (contra_ar absent)) "ee" NIL)
                    (((contra_ar abnormal) has typical specialization (contra_ar elevated)) "ee" NIL)))

(term :name        absent)

(term :name        (contra_ar absent)
      :remindings  ((acoustic_neuroma 0.25) (otitis_media 0.25))
      :relations   ((((contra_ar absent) has typical generalization (contra_ar abnormal)) "ee" NIL)
                    (((contra_ar absent) occasionally is required by conductive_hl) "ee" NIL)
                    (((contra_ar absent) sometimes cooccurs with conductive_hl) "ee" NIL)))

(term :name        elevated)

(term :name        (contra_ar elevated)
      :remindings  ((acoustic_neuroma 0.25))
      :relations   ((((contra_ar elevated) has typical generalization (contra_ar abnormal)) "ee" NIL)
                    (((contra_ar elevated) sometimes is required by acoustic_neuroma) "ee" NIL)))

(term :name        (contra_ar normal)
      :remindings  ((facial_nerve_disorder 0.25) (normal_ear 0.25))
      :relations   ((((contra_ar normal) weakly is required by normal_ear) "ee" NIL)
                    ((((other_c_ar absent) and (ipsi_ar absent) and (contra_ar normal) and (other_i_ar normal)) sometimes is required by facial_nerve_disorder) "ee" NIL)))

(predicate :name        ipsi)

(term :name        (ipsi absent)
      :relations   ((((ipsi absent) equivalent (ipsi_ar absent)) "ee" NIL)))

(predicate :name        ipsi_ar)

(term :name        (ipsi_ar abnormal)
      :relations   ((((ipsi_ar abnormal) has typical specialization (ipsi_ar absent)) "ee" NIL)
                    (((ipsi_ar abnormal) has typical specialization (ipsi_ar elevated)) "ee" NIL)))

(term :name        (ipsi_ar absent)
      :remindings  ((otitis_media 0.25))
      :relations   ((((ipsi_ar absent) has typical generalization (ipsi_ar abnormal)) "ee" NIL)
                    (((ipsi_ar absent) moderately is required by otitis_media) "ee" NIL)
                    (((ipsi_ar absent) equivalent (ipsi absent)) "ee" NIL)
                    (((ipsi_ar absent) occasionally is required by (discontinuity ossicular_chain)) "ee" NIL)
                    (((ipsi_ar absent) cooccurs with conductive_hl) "ee" NIL)
                    ((((other_c_ar absent) and (ipsi_ar absent) and (contra_ar normal) and (other_i_ar normal)) sometimes is required by facial_nerve_disorder) "ee" NIL)))

(term :name        (ipsi_ar elevated)
      :remindings  ((meniere_s 0.25) (acoustic_neuroma 0.25))
      :relations   ((((ipsi_ar elevated) has typical generalization (ipsi_ar abnormal)) "ee" NIL)
                    (((ipsi_ar elevated) sometimes is required by acoustic_neuroma) "ee" NIL)
                    (((ipsi_ar elevated) sometimes is required by meniere_s) "ee" NIL)))

(term :name        (ipsi_ar normal)
      :remindings  ((normal_ear 0.25))
      :relations   ((((ipsi_ar normal) usually is required by (bone normal)) "ee" NIL)
                    (((ipsi_ar normal) usually is required by normal_ear) "ee" NIL)))

(predicate :name        other_c_ar)

(term :name        (other_c_ar abnormal)
      :relations   ((((other_c_ar abnormal) has typical specialization (other_c_ar absent)) "ee" NIL)
                    (((other_c_ar abnormal) has typical specialization (other_c_ar elevated)) "ee" NIL)))

(term :name        (other_c_ar absent)
      :remindings  ((acoustic_neuroma 0.25) (conductive_hl 0.25) (facial_nerve_disorder 0.50)
                    (otitis_media 0.25))
      :relations   ((((other_c_ar absent) has typical generalization (other_c_ar abnormal)) "ee" NIL)
                    (((other_c_ar absent) probably is required by prob_in_case_6_2_l) "ee" NIL)
                    (((other_c_ar absent) cooccurs with conductive_hl) "ee" NIL)
                    ((((other_c_ar absent) and (ipsi_ar absent) and (contra_ar normal) and (other_i_ar normal)) sometimes is required by facial_nerve_disorder) "ee" NIL)))

(term :name        (other_c_ar elevated)
      :remindings  (((discontinuity ossicular_chain) 0.25))
      :relations   ((((other_c_ar elevated) occasionally is required by (discontinuity ossicular_chain)) "ee" NIL)
                    (((other_c_ar elevated) has typical generalization (other_c_ar abnormal)) "ee" NIL)))

(term :name        (other_c_ar normal)
      :remindings  ((normal_ear 0.25))
      :relations   ((((other_c_ar normal) moderately is required by normal_ear) "ee" NIL)))

(predicate :name        other_i_ar)

(term :name        abseent)

(term :name        (other_i_ar abseent))

(term :name        (other_i_ar absent))

(term :name        (other_i_ar elevated))

(term :name        (other_i_ar normal)
      :remindings  ((facial_nerve_disorder 0.25) (normal_ear 0.25))
      :relations   ((((other_i_ar normal) weakly is required by normal_ear) "ee" NIL)
                    ((((other_c_ar absent) and (ipsi_ar absent) and (contra_ar normal) and (other_i_ar normal)) sometimes is required by facial_nerve_disorder) "ee" NIL)))

(predicate :name        otoscopy)

(term :name        (otoscopy normal)
      :remindings  ((malleus_fixation 0.50))
      :relations   ((((otoscopy normal) cooccurs with malleus_fixation) "ee" NIL)))

(predicate :name        slope_toward)

(term :name        low)

(term :name        (slope_toward low)
      :remindings  ((meniere_s 0.50))
      :relations   ((((slope_toward low) usually cooccurs with meniere_s) "ee" NIL)))

(predicate :name        speech_intell)

(term :name        (speech_intell abnormal)
      :relations   ((((speech_intell abnormal) usually is required by sensorineural) "ee" NIL)
                    (((speech_intell abnormal) has typical specialization (speech_intell moderate)) "ee" NIL)))

(term :name        (speech_intell mild)
      :remindings  ((meniere_s 0.25))
      :relations   ((((speech_intell mild) sometimes is caused by meniere_s) "ee" NIL)))

(term :name        (speech_intell moderate)
      :remindings  ((sensorineural 0.50))
      :relations   ((((speech_intell moderate) has typical generalization (speech_intell abnormal)) "ee" NIL)
                    (((speech_intell moderate) usually is required by sensorineural) "ee" NIL)))

(term :name        (speech_intell normal)
      :remindings  (((discontinuity ossicular_chain) 0.25) (conductive_hl 0.25) (facial_nerve_disorder 0.25)
                    (normal_ear 0.25))
      :relations   ((((speech_intell normal) weakly is required by facial_nerve_disorder) "ee" NIL)
                    (((speech_intell normal) weakly is required by normal_ear) "ee" NIL)
                    (((speech_intell normal) moderately is required by not_sensorineural_hl) "ee" NIL)
                    (((speech_intell normal) strongly is required by prob_not_sensorineural) "ee" NIL)))

(term :name        rollover)

(term :name        (speech_intell rollover)
      :remindings  ((acoustic_neuroma 1.00))
      :relations   ((((speech_intell rollover) usually cooccurs with acoustic_neuroma) "ee" NIL)))

(predicate :name        tymp_peak)

(term :name        compliant)

(term :name        (tymp_peak compliant)
      :remindings  (((discontinuity ossicular_chain) 1.00))
      :relations   ((((tymp_peak compliant) strongly cooccurs with (discontinuity ossicular_chain)) "ee" NIL)))

(term :name        flat)

(term :name        (tymp_peak flat)
      :remindings  ((malleus_fixation 1.00) (conductive_hl 0.50))
      :relations   ((((tymp_peak flat) is function of non_compliant_middle_ear) "ee" NIL)
                    (((tymp_peak flat) cooccurs with (tymp_pr unknown)) "ee" NIL)
                    (((tymp_peak flat) cooccurs with malleus_fixation) "ee" NIL)))

(term :name        (tymp_peak normal)
      :remindings  ((normal_ear 0.25))
      :relations   ((((tymp_peak normal) weakly is required by normal_ear) "ee" NIL)))

(predicate :name        tymp_pr)

(term :name        negative)

(term :name        (tymp_pr negative)
      :remindings  ((otitis_media 0.50))
      :relations   ((((tymp_pr negative) moderately is required by otitis_media) "ee" NIL)))

(term :name        (tymp_pr normal)
      :remindings  ((normal_ear 0.25))
      :relations   ((((tymp_pr normal) weakly is required by normal_ear) "ee" NIL)
                    (((tymp_pr normal) sometimes is required by not_effusion) "ee" NIL)))

(term :name        unknown)

(term :name        (tymp_pr unknown)
      :relations   ((((tymp_pr unknown) cooccurs with (tymp_peak flat)) "ee" NIL)))

(term :name        cochlear
      :relations   (((cochlear has typical generalization sensorineural) "ee" NIL)
                    ((cochlear has typical specialization meniere_s) "ee" NIL)))

(term :name        conductive_hl
      :relations   (((conductive_hl cooccurs with (bone normal)) "ee" NIL)
                    ((conductive_hl sometimes cooccurs with (contra_ar absent)) "ee" NIL)
                    ((conductive_hl cooccurs with (ipsi_ar absent)) "ee" NIL)
                    ((conductive_hl cooccurs with (other_c_ar absent)) "ee" NIL)
                    ((conductive_hl requires fullness) "ee" NIL)
                    ((conductive_hl requires ((bone normal) and (air abnormal))) "ee" NIL)
                    ((conductive_hl requires (contra_ar absent)) "ee" NIL)
                    ((conductive_hl sometimes definition implies ((air mild) and (bone normal))) "ee" NIL)
                    ((conductive_hl has typical specialization (discontinuity ossicular_chain)) "ee" NIL)
                    ((conductive_hl has typical specialization malleus_fixation) "ee" NIL)
                    ((conductive_hl has typical specialization otitis_media) "ee" NIL)))

(term :name        decay_ar
      :remindings  ((acoustic_neuroma 0.50))
      :relations   (((decay_ar moderately cooccurs with acoustic_neuroma) "ee" NIL)))

(term :name        decay_tone
      :remindings  ((acoustic_neuroma 1.00))
      :relations   (((decay_tone strongly cooccurs with acoustic_neuroma) "ee" NIL)))

(term :name        facial_nerve_weakness
      :remindings  ((facial_nerve_disorder 0.25) (acoustic_neuroma 0.25))
      :relations   (((facial_nerve_weakness occasionally is required by acoustic_neuroma) "ee" NIL)))

(term :name        facial_paralysis
      :remindings  ((facial_nerve_disorder 1.00))
      :relations   (((facial_paralysis sometimes cooccurs with facial_nerve_disorder) "ee" NIL)))

(term :name        fullness
      :remindings  ((acoustic_neuroma 0.25) (meniere_s 0.25))
      :relations   (((fullness sometimes is required by conductive_hl) "ee" NIL)
                    ((fullness weakly is required by meniere_s) "ee" NIL)
                    ((fullness sometimes is required by acoustic_neuroma) "ee" NIL)))

(term :name        nausea
      :remindings  ((meniere_s 0.50))
      :relations   (((nausea sometimes is required by meniere_s) "ee" NIL)))

(term :name        noise_exposure
      :remindings  ((noise_induced 1.00))
      :relations   (((noise_exposure definition implies noise_induced) "ee" NIL)))

(term :name        non_compliant_middle_ear
      :relations   (((non_compliant_middle_ear has function (tymp_peak flat)) "ee" NIL)))

(term :name        not_effusion
      :relations   (((not_effusion requires (tymp_pr normal)) "ee" NIL)))

(term :name        not_sensorineural_hl
      :relations   (((not_sensorineural_hl requires (speech_intell normal)) "ee" NIL)))

(term :name        notch_4k
      :remindings  ((noise_induced 0.50))
      :relations   (((notch_4k sometimes cooccurs with noise_induced) "ee" NIL)))

(term :name        prob_in_case_6_2_l
      :relations   (((prob_in_case_6_2_l requires (other_c_ar absent)) "ee" NIL)))

(term :name        prob_not_sensorineural
      :relations   (((prob_not_sensorineural requires (speech_intell normal)) "ee" NIL)))

(term :name        sensorineural
      :relations   (((sensorineural has typical specialization cochlear) "ee" NIL)
                    ((sensorineural requires (speech_intell abnormal)) "ee" NIL)
                    ((sensorineural requires (speech_intell moderate)) "ee" NIL)))

(term :name        speech_distorted
      :remindings  ((meniere_s 0.50))
      :relations   (((speech_distorted sometimes is caused by meniere_s) "ee" NIL)))

(term :name        tinnitus
      :remindings  ((noise_induced 0.50) (acoustic_neuroma 0.25) (meniere_s 0.50))
      :relations   (((tinnitus usually is required by meniere_s) "ee" NIL)
                    ((tinnitus occasionally cooccurs with acoustic_neuroma) "ee" NIL)
                    ((tinnitus usually cooccurs with noise_induced) "ee" NIL)))

(term :name        vertigo
      :remindings  ((meniere_s 0.50))
      :relations   (((vertigo sometimes is required by meniere_s) "ee" NIL)))

(term :name        vomiting
      :remindings  ((meniere_s 0.25))
      :relations   (((vomiting sometimes is required by meniere_s) "ee" NIL)))

(term :name        case_13_1
      :category    malleus_fixation
      :features    ((air severe) (other_i_ar normal) (bone normal) (speech_intell normal)
                    (tymp_peak flat) (tymp_pr negative) (contra_ar absent) (ipsi_ar absent)
                    (other_c_ar absent) fullness)
      :typicality  1.00)

(term :name        case_14_2a
      :category    meniere_s
      :features    ((air moderate) (other_c_ar normal) (ipsi_ar normal) (contra_ar normal)
                    (other_i_ar normal) (speech_intell moderate) vertigo nausea
                    vomiting tinnitus)
      :typicality  1.00
      :differences ((case_14_2h <-- (fullness))))

(term :name        case_14_2h
      :category    meniere_s
      :features    ((air moderate) (other_c_ar normal) (ipsi_ar normal) (contra_ar normal)
                    (other_i_ar normal) (speech_intell moderate) fullness tinnitus)
      :typicality  1.00
      :differences ((case_14_2a <-- (vomiting nausea vertigo))))

(term :name        case_17_1_r
      :category    otitis_media
      :features    ((air abnormal) (other_i_ar absent) (bone normal) (speech_intell normal)
                    (tymp_peak flat) (tymp_pr negative) (contra_ar absent) (ipsi_ar absent)
                    (other_c_ar absent))
      :typicality  3.00)

(term :name        case_1_1
      :category    acoustic_neuroma
      :features    (facial_nerve_weakness fullness (contra_ar absent) decay_tone
                    (other_c_ar absent) (ipsi_ar absent) (air mild) (bone mild)
                    (tymp_pr normal) (tymp_peak normal) (speech_intell rollover) (other_i_ar normal))
      :typicality  1.00)

(term :name        case_1_2
      :category    acoustic_neuroma
      :features    ((contra_ar abnormal) (ipsi_ar abnormal))
      :typicality  1.00)

(term :name        case_1_2_n
      :category    normal_ear
      :features    ((air normal) (bone normal) (speech_intell normal) (ipsi_ar normal)
                    (contra_ar normal) (other_i_ar elevated) (other_c_ar elevated) (tymp_pr normal)
                    (tymp_peak normal))
      :typicality  1.00
      :differences ((case_6_2_l <-- ((ipsi_ar absent) (air mild)))))

(term :name        case_1_3_m
      :category    acoustic_neuroma
      :features    ((air normal) (other_i_ar normal) (bone normal) (speech_intell rollover)
                    (tymp_peak normal) (tymp_pr normal) (contra_ar elevated) (ipsi_ar elevated)
                    (other_c_ar normal) tinnitus decay_ar)
      :typicality  2.00
      :differences ((case_normal <-- ((contra_ar normal) (speech_intell normal)))))

(term :name        case_6_1_l
      :category    (discontinuity ossicular_chain)
      :features    ((air mild) (bone normal) (speech_intell normal) (contra_ar absent)
                    (tymp_peak compliant) (tymp_pr normal) (ipsi_ar absent) (other_i_ar normal)
                    (other_c_ar elevated))
      :typicality  1.00)

(term :name        case_6_2_l
      :category    (discontinuity ossicular_chain)
      :features    ((other_c_ar abnormal) (air mild) (bone normal) (speech_intell normal)
                    (tymp_peak compliant) (tymp_pr normal) (contra_ar normal) (ipsi_ar absent)
                    (other_i_ar normal))
      :typicality  2.00
      :differences ((case_1_2_n <-- ((ipsi_ar normal)))))

(term :name        case_7_2
      :category    facial_nerve_disorder
      :features    ((air normal) (other_i_ar normal) (bone normal) (speech_intell normal)
                    (tymp_peak normal) (tymp_pr normal) (contra_ar normal) (ipsi_ar absent)
                    (other_c_ar absent) facial_paralysis)
      :typicality  1.00)

(term :name        case_7_2_n
      :category    normal_ear
      :features    ((air normal) (bone normal) (speech_intell normal) (ipsi_ar normal)
                    (contra_ar absent) (other_i_ar absent) (other_c_ar normal) (tymp_pr normal)
                    (tymp_peak normal))
      :typicality  1.00)

(term :name        case_nka
      :category    meniere_s
      :features    ((air mild) (other_i_ar normal) (bone mild) (speech_intell normal)
                    (tymp_peak normal) (tymp_pr normal) (contra_ar normal) (ipsi_ar elevated)
                    (other_c_ar normal) fullness tinnitus)
      :typicality  1.00)

(term :name        case_nka_revised
      :category    meniere_s
      :features    ((air mild) (other_i_ar normal) (bone mild) (speech_intell mild)
                    (tymp_peak normal) (tymp_pr normal) (contra_ar normal) (ipsi_ar elevated)
                    (other_c_ar normal) fullness tinnitus (slope_toward low)
                    speech_distorted)
      :typicality  1.00)

(term :name        case_normal
      :category    normal_ear
      :features    ((air normal) (other_i_ar normal) (bone normal) (speech_intell normal)
                    (tymp_peak normal) (tymp_pr normal) (contra_ar normal) (ipsi_ar normal)
                    (other_c_ar normal))
      :typicality  2.00
      :differences ((noise_induced_1 <-- (notch_4k noise_exposure))                    (case_1_3_m <-- (decay_ar (speech_intell rollover)))))

(term :name        noise_induced_1
      :category    noise_induced
      :features    ((air normal) (bone normal) (speech_intell normal) (tymp_peak normal)
                    (tymp_pr normal) (contra_ar normal) noise_exposure tinnitus
                    notch_4k)
      :typicality  2.00)

(predicate :name        discontinuity)

(term :name        ossicular_chain)

(term :name        (discontinuity ossicular_chain)
      :importances (((other_c_ar abnormal) 0.50) ((contra_ar absent) 0.00) ((other_c_ar elevated) 0.25)
                    ((air mild) 0.25) ((bone normal) 0.50) ((speech_intell normal) 0.50)
                    ((tymp_peak compliant) 0.75) ((tymp_pr normal) 0.25) ((contra_ar normal) 0.00)
                    ((ipsi_ar absent) 0.25) ((other_c_ar absent) 0.25) ((other_i_ar normal) 0.00))
      :exemplars   (case_6_1_l case_6_2_l)
      :relations   ((((discontinuity ossicular_chain) has typical generalization conductive_hl) "ee" NIL)
                    (((discontinuity ossicular_chain) requires (other_c_ar elevated)) "ee" NIL)
                    (((discontinuity ossicular_chain) strongly cooccurs with (tymp_peak compliant)) "ee" NIL)
                    (((discontinuity ossicular_chain) requires (ipsi_ar absent)) "ee" NIL)))

(term :name        acoustic_neuroma
      :importances ((facial_nerve_weakness 0.25) (fullness 0.25) ((contra_ar absent) 0.25)
                    (decay_tone 0.75) ((other_c_ar absent) 0.25) ((ipsi_ar absent) 0.25)
                    ((air mild) 0.25) ((bone mild) 0.25) ((contra_ar abnormal) 0.50)
                    ((ipsi_ar abnormal) 0.50) ((air normal) 0.00) ((other_i_ar normal) 0.00)
                    ((bone normal) 0.00) ((speech_intell rollover) 0.75) ((tymp_peak normal) 0.00)
                    ((tymp_pr normal) 0.00) ((contra_ar elevated) 0.25) ((ipsi_ar elevated) 0.25)
                    ((other_c_ar normal) 0.00) (tinnitus 0.25) (decay_ar 0.75))
      :exemplars   (case_1_2 case_1_1 case_1_3_m)
      :relations   (((acoustic_neuroma requires facial_nerve_weakness) "ee" NIL)
                    ((acoustic_neuroma requires fullness) "ee" NIL)
                    ((acoustic_neuroma strongly cooccurs with decay_tone) "ee" NIL)
                    ((acoustic_neuroma requires (air mild)) "ee" NIL)
                    ((acoustic_neuroma requires (bone mild)) "ee" NIL)
                    ((acoustic_neuroma usually cooccurs with (speech_intell rollover)) "ee" NIL)
                    ((acoustic_neuroma requires (contra_ar elevated)) "ee" NIL)
                    ((acoustic_neuroma requires (ipsi_ar elevated)) "ee" NIL)
                    ((acoustic_neuroma occasionally cooccurs with tinnitus) "ee" NIL)
                    ((acoustic_neuroma moderately cooccurs with decay_ar) "ee" NIL)))

(term :name        facial_nerve_disorder
      :importances (((air normal) 0.50) ((other_i_ar normal) 0.25) ((bone normal) 0.00)
                    ((speech_intell normal) 0.25) ((tymp_peak normal) 0.00) ((tymp_pr normal) 0.00)
                    ((contra_ar normal) 0.50) ((ipsi_ar absent) 0.50) ((other_c_ar absent) 0.50)
                    (facial_paralysis 0.75))
      :exemplars   (case_7_2)
      :relations   (((facial_nerve_disorder requires (air normal)) "ee" NIL)
                    ((facial_nerve_disorder requires (speech_intell normal)) "ee" NIL)
                    ((facial_nerve_disorder requires ((other_c_ar absent) and (ipsi_ar absent) and (contra_ar normal) and (other_i_ar normal))) "ee" NIL)
                    ((facial_nerve_disorder sometimes cooccurs with facial_paralysis) "ee" NIL)))

(term :name        malleus_fixation
      :importances (((air severe) 0.50) ((other_i_ar normal) 0.00) ((bone normal) 0.75)
                    ((speech_intell normal) 0.25) ((tymp_peak flat) 0.75) ((tymp_pr negative) 0.50)
                    ((contra_ar absent) 0.00) ((ipsi_ar absent) 0.50) ((other_c_ar absent) 0.50)
                    (fullness 0.50))
      :exemplars   (case_13_1)
      :relations   (((malleus_fixation cooccurs with (otoscopy normal)) "ee" NIL)
                    ((malleus_fixation sometimes cooccurs with (air severe)) "ee" NIL)
                    ((malleus_fixation cooccurs with (tymp_peak flat)) "ee" NIL)
                    ((malleus_fixation has typical generalization conductive_hl) "ee" NIL)))

(term :name        meniere_s
      :importances (((speech_intell mild) 0.50) ((slope_toward low) 0.75) (speech_distorted 0.50)
                    ((air mild) 0.25) ((bone mild) 0.00) ((speech_intell normal) 0.00)
                    ((tymp_peak normal) 0.00) ((tymp_pr normal) 0.00) ((ipsi_ar elevated) 0.50)
                    (fullness 0.25) ((air moderate) 0.25) ((other_c_ar normal) 0.00)
                    ((ipsi_ar normal) 0.25) ((contra_ar normal) 0.00) ((other_i_ar normal) 0.00)
                    ((speech_intell moderate) 0.75) (vertigo 0.50) (nausea 0.50)
                    (vomiting 0.25) (tinnitus 0.50))
      :exemplars   (case_nka_revised case_nka case_14_2h case_14_2a)
      :relations   (((meniere_s causes (speech_intell mild)) "ee" NIL)
                    ((meniere_s usually cooccurs with (slope_toward low)) "ee" NIL)
                    ((meniere_s causes speech_distorted) "ee" NIL)
                    ((meniere_s requires (ipsi_ar elevated)) "ee" NIL)
                    ((meniere_s requires fullness) "ee" NIL)
                    ((meniere_s requires (air moderate)) "ee" NIL)
                    ((meniere_s has typical generalization cochlear) "ee" NIL)
                    ((meniere_s requires vertigo) "ee" NIL)
                    ((meniere_s requires nausea) "ee" NIL)
                    ((meniere_s requires vomiting) "ee" NIL)
                    ((meniere_s requires tinnitus) "ee" NIL)))

(term :name        noise_induced
      :importances (((air normal) 0.00) ((bone normal) 0.00) ((speech_intell normal) 0.00)
                    ((tymp_peak normal) 0.00) ((tymp_pr normal) 0.00) ((contra_ar normal) 0.00)
                    (noise_exposure 0.75) (tinnitus 0.50) (notch_4k 0.50))
      :exemplars   (noise_induced_1)
      :relations   (((noise_induced sometimes definition implies noise_exposure) "ee" NIL)
                    ((noise_induced usually cooccurs with tinnitus) "ee" NIL)
                    ((noise_induced sometimes cooccurs with notch_4k) "ee" NIL)))

(term :name        normal_ear
      :importances (((contra_ar absent) 0.00) ((other_i_ar absent) 0.00) ((other_i_ar elevated) 0.00)
                    ((other_c_ar elevated) 0.00) ((air normal) 0.50) ((other_i_ar normal) 0.25)
                    ((bone normal) 0.25) ((speech_intell normal) 0.25) ((tymp_peak normal) 0.25)
                    ((tymp_pr normal) 0.25) ((contra_ar normal) 0.25) ((ipsi_ar normal) 0.50)
                    ((other_c_ar normal) 0.50))
      :exemplars   (case_7_2_n case_1_2_n case_normal)
      :relations   (((normal_ear requires (air normal)) "ee" NIL)
                    ((normal_ear requires (other_i_ar normal)) "ee" NIL)
                    ((normal_ear requires (bone normal)) "ee" NIL)
                    ((normal_ear requires (speech_intell normal)) "ee" NIL)
                    ((normal_ear requires (tymp_peak normal)) "ee" NIL)
                    ((normal_ear requires (tymp_pr normal)) "ee" NIL)
                    ((normal_ear requires (contra_ar normal)) "ee" NIL)
                    ((normal_ear requires (ipsi_ar normal)) "ee" NIL)
                    ((normal_ear requires (other_c_ar normal)) "ee" NIL)))

(term :name        otitis_media
      :importances (((air abnormal) 0.25) ((other_i_ar absent) 0.25) ((air mild) 0.25)
                    ((bone normal) 0.50) ((speech_intell normal) 0.50) ((tymp_peak flat) 0.50)
                    ((tymp_pr negative) 0.50) ((contra_ar absent) 0.25) ((ipsi_ar absent) 0.50)
                    ((other_c_ar absent) 0.25) ((other_i_ar abseent) 0.00))
      :exemplars   (case_17_1_r)
      :relations   (((otitis_media has typical generalization conductive_hl) "ee" NIL)
                    ((otitis_media requires (tymp_pr negative)) "ee" NIL)
                    ((otitis_media requires (ipsi_ar absent)) "ee" NIL)))