;;; -*- Syntax: Common-lisp; Package: Common-Lisp-User -*-


;;;-----------------------------------------------------------------------------
;;;  File:     protos-sys.lisp
;;;
;;;  Purpose:  This is the "system declaration file" for the PROTOS System.
;;;            It defines the protos package and describes the compile-time
;;;            and load-time relations among the file of the protos system.
;;;
;;;  Note:     This file is referred to by the file sys:site;protos.system
;;;-----------------------------------------------------------------------------


(defpackage protos
  (:use cl)					; inherit from pure CommonLisp
  (:import send	self defmethod			; use scl:send & scl:self in
                                                ;   device-dependent code.
       protos))					; make (protos) visible to cl-user




(defsystem PROTOS
    (:pretty-name "PROTOS: An Exemplar-Based Learning Apprentice"
     :short-name "PROTOS"
     :default-pathname "PROTOS: protos;"
     :default-package PROTOS
;;;;     :journal-directory "FORSSMAN:>protos>patch>"
     :journal-directory "PROTOS: protos; patch;"
     :patchable nil
     :initializations (progn
			(format t "~%Do:  Set Package PROTOS~
                                   ~%     (protos)~%"))
     :initial-status :experimental
     )
  
  (:module-group global
   (:serial "global"))
  
  (:module-group defs
   (:serial
     "defs"
     "verb"))
  
  (:module-group core
   (:serial
     "kbio"
     "io"
     "example"
     "print"
     "parse"
     "kbpm"
     "heuristics"
     "merging"
     "reminding"
     "explanation"
     "discuss"
     "classify"
     "transform"
     "protos"))

  (:serial global defs core)
)

