structure WorkingMemory = 
struct 

 (* Working memory is used both during creating the abstract graph
    and for search.
      Forward is true if the preferred search direction is forward
               i.e. using the successor links.
      Alternating indicates that the preferred search direction alternates
               between layers, used in alternating opportunism.
      The search type is PO for path opportunism AO for alternating
               opportunism, PM for path marking and NAB for no abstraction
  *)

datatype searchType = PO of int  | AO | PM | CR | AM | NAB
     and workingMemory = WM of
         {searchDirection : bool ref,
	  forward : bool ref, 
          alternating : bool ref,
	  searchType : searchType ref,
	  absDiameter : int ref}

val Wm =
    WM { searchDirection = ref false ,
	 forward = ref false ,
	 alternating = ref false,
	 searchType = ref NAB,
	 absDiameter = ref 0 }

fun reset (WM {searchDirection,forward,alternating,searchType,absDiameter}) = 
	(searchDirection := false;forward := false;
	 alternating := false;absDiameter := 0)


 (* Select the search type. *)



fun setSearchType (WM {searchType,alternating,...}) to =
       searchType := to

end
