(* Toolbox : a set of useful functions. Feel free to add ones you find useful *)




(* FUNCTIONS FOR TESTING AND CHANGING THE PREFERRED SEARCH DIRECTION at all 
   levels of an abstraction hierarchy. These functions should be applied after
   the hierarchy/graph ahs been built but before path testing *)


(* graph -> graphType list : takes a graph and returns a list of the search direction 
   at each level with the head of the list being the direction in the base graph *)

 fun getSearchDirection (Graph {super = ref NONE,graphType,...})   = [!graphType]
   | getSearchDirection (Graph {nodes,super = ref (SOME g),graphType,...})  = 
	(!graphType) ::  getSearchDirection g

(* graphType -> graph -> graphType list  : sets all levels in the graph to "to" which
   is either SearchForward or SearchBackward and returns a list of the search direction 
   at each level for verification *) 

 fun setSearchDirection to (Graph {super = ref NONE,graphType,...})   = (graphType := to ; [to])
   | setSearchDirection to (Graph {nodes,super = ref (SOME g),graphType,...})  = 
	(graphType := to; to :: (setSearchDirection to g))

(* graphType -> graph -> graphType list : sets the base graph to "with" which
   is either SearchForward or SearchBackward and then alternates the more abstract 
   levels. It returns a list of the search direction at each level for verification *)
 
 fun alternateSearchDirection from  (Graph {super = ref NONE,graphType,...})  =
	(graphType := from; [from])
   | alternateSearchDirection from (Graph {nodes,super = ref (SOME g),graphType,...})  = 
	(graphType := from ;  from :: 
	(alternateSearchDirection (case from of 
					SearchForward => SearchBackward 
			        		  | _ => SearchForward) g))

(* graph -> graphType list  : reverses the search direction at each level and returns
   a list of the settings. *)
 fun reverseSearchDirection (Graph {super = ref NONE,graphType,...})   = [reverse graphType]
   | reverseSearchDirection (Graph {nodes,super = ref (SOME g),graphType,...})  = 
	(reverse graphType) :: (reverseSearchDirection g) 
 and reverse t = 
	 case (!t) of SearchForward => (t := SearchBackward ; SearchBackward)
			        | _ => (t := SearchForward ; SearchForward)

 (* FUNCTIONS FOR FINDING OUT THE SIZE OF THE ABSTRACTION HIEARCHY *)

 (* graph -> int list : takes a graph and returns a list of the
    number of NODES at each level of the abstraction hierarchy *)

 fun absSize (Graph {nodes,super = ref NONE,...}) = [(length nodes)]
   | absSize (Graph {nodes,super = ref (SOME g),...}) = 
	(length nodes) :: (absSize g)


 (* graph -> int list : takes a graph and returns a list of the
    number of EDGES at each level of the abstraction hierarchy *)

fun absSizeEdges (Graph {nodes,super = ref NONE,...}) = [edges nodes]
   | absSizeEdges (Graph {nodes,super = ref (SOME g),...}) = 
	(edges nodes) :: (absSizeEdges g)
and edges nodes = fold (fn ((Node{succs,...}),y) => (length (!succs)) + y) nodes 0


