local open System.Timer in

(* timeit returns
        value of (f x)
	non gc user time
	system time
	gc time
	wallclock time *)

fun timeit f x =
let val timeofday = System.Unsafe.CInterface.gettimeofday
    val t  = start_timer()
    val rt = timeofday()
    val z  = f x
    val rt' = sub_time(timeofday(),rt)
    val t'  = check_timer t
    val ts  = check_timer_sys t
    val tg  = check_timer_gc  t
    fun num (TIME{sec,usec}) = real sec + real usec / 1000000.0
in (z,num t',num ts,num tg,num rt') end
end

fun dotimes n f x =
let fun loop 1 =  f x
      | loop i = (f x; loop (i-1))
in loop n end
