signature RANDOM =
sig
   val seed : real ref
   val newrandom : int -> int
   val rlist : int -> int -> int list
end


structure Random : RANDOM =
struct 
(*recommended by Stephen K. Park and Keith W. Miller,
  Random number generators: good ones are hard to find,
  CACM 31 (1988), 1192-1201*)
     
(*real number version for systems with 46-bit mantissas*)
local val a = 16807.0  and  m = 2147483647.0
in  fun nextrandom seed =
          let val t = a*seed
          in  t - m * real(floor(t/m))  end
     
    (*truncate to integer from 1 to k*)
    and truncto k r = 1 + floor((r / m) * (real k))
end;

val seed = ref 1.0

fun newrandom Bound =
	(seed := nextrandom (!seed); truncto Bound (!seed))
     
fun randlist (n,seed,seeds) =
    if n=0  then  (seed,seeds)
    else  randlist(n-1, nextrandom seed, seed::seeds);
     
fun  rlist Bound Number =     
     map (truncto Bound) (#2 (randlist(Number,1.0,[])));

end