(* Toolbox : a set of useful functions.
*)



 (* FUNCTIONS FOR FINDING OUT THE SIZE OF THE ABSTRACTION HIEARCHY *)

 (* graph -> int list : takes a graph and returns a list of the
    number of NODES at each level of the abstraction hierarchy *)

 fun absSize (Graph {nodes,super = ref NONE,...}) = [(length nodes)]
   | absSize (Graph {nodes,super = ref (SOME g),...}) = 
	(length nodes) :: (absSize g)


 (* graph -> int list : takes a graph and returns a list of the
    number of EDGES at each level of the abstraction hierarchy *)

fun absSizeEdges (Graph {nodes,super = ref NONE,...}) = [edges nodes]
   | absSizeEdges (Graph {nodes,super = ref (SOME g),...}) = 
	(edges nodes) :: (absSizeEdges g)
and edges nodes = fold (fn ((Node{succs,...}),y) => (length (!succs)) + y) nodes 0



(* print an individual node *)

fun print_state convert_to_string_fn (Ground x) =
          print (" " ^ (convert_to_string_fn x) ^ " ")
 |  print_state convert_to_string_fn (Abstract x) =
          ( map (print_state convert_to_string_fn)
                (map (fn (Node {state,...}) => state) x) ; () )


fun print_node convert_to_string_fn (Node {state,...}) =
( print ("\n node: ") ;
  print_state convert_to_string_fn state
)

fun print_graph convert_to_string_fn h (Graph {height,nodes,super,...}) =
if height=h
then ( map (print_node convert_to_string_fn) (nodes) ; print "\n" )
else case (!super) of
        SOME x => print_graph convert_to_string_fn h x
     |    _    => print("\nThe highest graph has height "
                        ^ makestring(height) ^ "\n" )


(* the following takes as input a convert_state_to_string function
   and the data structure produced by "mkProblem" and returns
   a function that will print out the corresponding graph at a
   specified height (h).
*)

fun make_graph_print  convert_to_string_fn
                      ({graph=(g,_,_),...}:
                           {decode:internal_state -> external_state,
                            encode:external_state -> internal_state,
                            graph:graph * peektype
                                        * (abstraction_parameter -> unit),
                            randomStatePair:unit ->
                                           external_state * external_state})
                      h =
  print_graph  convert_to_string_fn h g




