
open ThePuzzle;  (* only sometimes necessary for certain of the types *)
structure ThePuzzleGraph = PuzzleGraphFUN(  ThePuzzle  );(* creates mkSearchSpace *)
open ThePuzzleGraph;
structure TheSearch = SearchFUN(Graph);(* creates shortestPath *)
structure TheAbsSearch = AbsSearchFUN(TheSearch); (* creates findPath *)
open TheAbsSearch;
open TheSearch;
open Graph;
open Random;
open AbsFunctions;
open WorkingMemory;
open Priority_Queue;

 val starting_seed =  282475249.0  ;

fun mkProblem method  puzzle_parameter =
   let val _ = seed :=  starting_seed
       val gl as {graph =(gg,lu,absFun),...} = 
		mkSearchSpace puzzle_parameter
       val _ = absFun method
       val _ = clearGraph (SOME gg)
       val _ = seed :=  starting_seed
   in gl end

fun runTrial {randomStatePair,encode,decode,graph=(graph',lookup,absFun)} =
    let 
    fun restoreCount () = 
		(edgeCount := 0; edgeCountList := [];
		 markCost := 0;  markCostList := [];
		 pathLengthList := []; optCount := 0)
    val Graph {nodes,size,...} = graph'
    val (start,goal)  =  randomStatePair ()
    val SOME node1 = lookup (encode start)
    val SOME node2 = lookup (encode goal)
    fun try () = 
       let val _ = restoreCount ()
  	   val path = findPath(node1,node2,graph')
 	   val _ =  clear()
       in path end
    fun test n =
    let val (path,t1,t2,t3,t4) = timeit (dotimes n try) ()
    fun mylength (NONE,_) = 0
      | mylength ((SOME l),_) = length l
    in ( (* 1 *) mylength path,
         (* 2 *) t1,
         (* 3 *) (!pathLengthList),
	 (* 4 *) (!edgeCountList),
         (* 5 *) (!markCostList),
         (* 6 *) (!optCount),
	 (* 7 *) (fold (op +) (!edgeCountList) 0),
         (* 8 *) (fold (op +) (!markCostList) 0)) end
in (graph',test) end;

fun run gl = let val (_,ts) = runTrial gl in ts 1 end;

fun total 0 gl = (0.0,0,0,0,0,[])
  | total count gl =
    let val result = run gl
	val time = #2 result
	val arcs = #7 result
	val cost = #8 result
        val pathlength = #1 result
        val oppcount = #6 result
	val (t,a,p,opp,c,l) = total (count - 1) gl
    in (  time + (t:real),
          arcs + (a:int),
          pathlength + (p:int),
          oppcount + (opp:int),
          cost + (c:int),
          (result :: l))
     end;


infixr \\ ;

setSearchType Wm  AO;

 fun tNAB  n g = (seed := starting_seed ;  setSearchType Wm NAB  ;  total n g)
 fun tAO   n g = (seed := starting_seed ;  setSearchType Wm AO   ;  total n g)
 fun tAM   n g = (seed := starting_seed ;  setSearchType Wm AM   ;  total n g)
 fun tPO w n g = (seed := starting_seed ; setSearchType Wm (PO w);  total n g)
 fun tPM   n g = (seed := starting_seed ;  setSearchType Wm PM   ;  total n g)
 fun tCR   n g = (seed := starting_seed ;  setSearchType Wm CR   ;  total n g)


val INSTRUCTIONS =
[
 "mkProblem (abstraction method) (puzzle parameter) -- returns a graph",
 "        a good choice for abstraction method is given below     ",
 "tNAB (number of trials) (graph) -- returns average path length etc.",
 "tAO, tAM, tPM, tCR -- same as TNAB.",
 "tPO has an extra argument; its first argument is path-width."];

val goodap = (A\\SpM 2\\N) ;
val mp = mkProblem goodap ;

val mptaieb = mkProblem (NA\\SpM 2) ;

fun rat i1 i2 = (real i1)/(real i2);
