functor GraphFUN (type state) : GRAPH =
struct
 type groundState = state

 datatype absInfo =  PostOrder of int | Degree of (int * int)
 and flag =  Stop  | Step of int | Other | Back of (int * node)
		 | Start | Ignore | AbsInfo of absInfo
 and absType = ForeTree | BackTree  | Star | Pair | Another | Bypass
 and howFar  = Dist of int | Far
 and node = Node of
  { state : state,
    succs : node list ref,
    preds : node list ref,
    flag  : flag ref,
    flagP  : flag ref ref,
    absType : absType ref,
    class : node option ref }
 and state = Ground   of groundState
           | Abstract of node list

 datatype graphType = SearchForward | SearchBackward
 and  graph = Graph of
  { size  : int,
    height  : int,
    nodes : node list,
    graphType : graphType ref,
    super : graph option ref }

 fun mkNode state =
 Node { state = state,
        succs = ref [],
        preds = ref [],
        flag  = ref Start,
    	flagP = ref (ref Start),
       	absType = ref Another,
        class = ref NONE }

 fun mkGraph (size,height,nodes) =
 Graph { size  = size,
	 height= height,
         nodes = nodes,
         graphType = ref SearchForward,
         super = ref NONE } 


 fun sameNode (Node{flag=x,...}) (Node{flag=y,...}) = x=y
 val allNodes = ref ([] : node list)
 fun clear () =  (app (fn Node{flag,...} =>flag := Other) (!allNodes) ; 
	allNodes := [])
 fun clearGraph NONE  = ()
   | clearGraph (SOME (Graph{super,nodes,...})) = 
  (app (fn Node{flag,...} => flag := Other ) nodes; clearGraph (!super))


 val pathLengthList = ref ([]:int list)
 val edgeCountList = ref ([]:int list)
 val edgeCount = ref 0
 val markCostList = ref ([]:int list)
 val markCost = ref 0
end
