functor GraphGeneratorFUN
  (structure Graph     : GRAPH
         and HashState : HASH_STATE
   sharing type Graph.state = HashState.state) : GRAPH_GENERATOR =
struct

 structure Graph     = Graph


local open Queue Graph HashState in
 structure Hashtable = HashTable(struct
                                  type hash_key = state
                                  val hashVal   = hashState
                                  val sameKey   = sameState
                                 end)
local open Hashtable in

 exception notFound

 fun graphGenerator generator states =
 let val table = mkTable (1024,notFound)
     val nodes = ref []
     val size  = ref 0

     fun lookup (state,queue) =
     (find table state,queue) handle notFound
     => let val node = mkNode state
        in
           insert table (state,node);
           size  := !size + 1;
           nodes := node :: !nodes;
           (node,enqueue(node,queue))
        end

     fun snd (_,x) = x

     and doQueue queue =
       if isEmpty(queue) then mkGraph(!size,0,!nodes)
       else doNode(dequeue(queue))

     and doNode (thisnode as (Node{state,succs,...}),queue) =
         let fun loop [] queue = doQueue queue
               | loop (state::states) queue =
                 let val(node as (Node{preds,...}),queue') = lookup(state,queue)
                     val Node{flag=flag1,...} = node
                 in
                    if exists (fn (Node{flag,...}) => flag=flag1) (!succs)
                    then () else succs := node :: !succs;
				 preds := thisnode :: !preds;
                    loop states queue'
                 end
         in loop (generator state) queue end
 in
    (doQueue (fold (snd o lookup) states empty),peek table)
 end
end
end
end
