functor BFSPathFUN (structure Graph : GRAPH
		    val incFn : int -> int 
  		    val queueFn : int -> int ):  BFS=  
struct
 structure Graph = Graph
local open Graph WorkingMemory Priority_Queue in

 (*  *)


    fun loop _ [] _ _ = ()
      | loop depth (node::nodes) i f =
 		(markNodes (i-depth) f [(depth,node)];
                loop depth nodes (incFn i) f)

    and markNodes _ _ []  = ()
      | markNodes i f ((depth,(node as (Node{flag,preds,succs,...})))::rest)    =
               let val mark = Step (i + depth)
		   val neighbours = if f then (!preds) else (!succs)
               in if (i + depth) <= 0 then () 
		  else ((markNodes i f  
			(if depth <= 1 then rest 
			 else (rest @ (map (fn n => (depth-1,n)) neighbours))));
		  	 allNodes := node :: (!allNodes); 
			 inc markCost; flag:=mark) end 



     fun init absPath sameDir searchDir = 
		let val depth = case Wm of 
				WM {searchType = ref (PO int),...} => int
							| _        => 1
		in if (sameDir) then loop depth absPath 1 searchDir
			        else loop depth (rev absPath) 1 searchDir  end

    fun bfs neighbours absPathLength start =
       let fun searchFrom start = 
		doQueue (revfold (fn (node,queue) => enqueue((1,node),1,queue)) 
		  start (mkEmpty (1+ (queueFn absPathLength))))

           and  doQueue queue =
              	if isEmpty(queue) then NONE else
       		let val (_,node)  = dequeue(queue)
           	in doSuccs (neighbours node) (Back (1,node)) queue  end

    	 and doSuccs [] _ queue  = doQueue queue 
            | doSuccs ((node as Node{flag,flagP,...})::nodes) back queue =
	 	(inc edgeCount ;
         	(case !flag of
            	  Stop   => (flag:=back; SOME node)
          	| Other  => (flag:=back; allNodes := node :: (!allNodes); inc markCost;
			    case flagP of
			      ref(ref(Step j)) => doSuccs nodes back 
							  (enqueue((1,node),
								  (queueFn j),queue))
                              | _              => doSuccs nodes back 
							  (enqueue((1,node),0,queue))) 
         	| _      => doSuccs nodes back queue))
         in searchFrom start end


end
end
