functor AlternateOpFUN (structure Graph : GRAPH): =  
struct
 structure Graph = Graph
local open Graph Priority_Queue in

 
     fun init forward ()  = () 

     fun bfs neighbours absPathLength  start =
        let fun mark depth node  = case node of
         	Node{state=Abstract children,...} => 
			app (fn Node{flag,...} => flag:= Step depth) children 
         	| _ => ()

    	    fun searchFrom start = 
       		(app (mark 0) start;
		doQueue (revfold (fn (node,queue) => enqueue((1,node),0,queue)) 
			start (mkEmpty (1+absPathLength))))

     	    and  doQueue queue =
           	if isEmpty(queue) then NONE else
           	let val (depth,node)  = dequeue(queue)
           	in doSuccs depth (neighbours node) (Back node) queue  end

     	    and doSuccs _ [] _ queue  = doQueue queue 
              | doSuccs depth ((node as Node{flag,...})::nodes) back queue =
	 	(inc edgeCount ; 
         	(case !flag of
            	Stop   => (mark depth node; flag:=back; SOME node)
          	| Step j => (mark depth node; flag:=back; 
			doSuccs depth nodes back (enqueue(((depth+1),node),(absPathLength-j),queue)))
          	| Other  => (mark depth node; flag:=back; 
			doSuccs depth nodes back (enqueue(((depth+1),node),0,queue)))
          	| _      => doSuccs depth nodes back queue))

         in searchFrom start end
end
