functor BFSAllVisitedFUN (structure Graph : GRAPH
		          val incFn : int -> int 
  		          val queueFn : int -> int ):  BFS=  
struct
 structure Graph = Graph
local open Graph Priority_Queue in

  (* Alternate Opportunism: This function searches a graph and its 
     immediate subgraph in opposite directions by interchanging the 
     start and goal nodes. In each search it marks any nodes it visits
     with the distance from its start point. As search at the next level
     down occurs in the other direction. The start point represents
     the class containing the goal node at this level. As a new node
     is explored this distance from the goal can be used as a heuristic
     measure to guide search. The distance information is obtained
     by looking at the flag of the node's class *)
 

     fun init absPath _ _ = ()

     fun bfs neighbours absPathLength  start =
        let fun searchFrom start = 
		doQueue (revfold (fn (node,queue) => enqueue((1,node),1,queue)) 
			start (mkEmpty (1+absPathLength)))

     	    and  doQueue queue =
           	if isEmpty(queue) then NONE else
           	let val (mark as (depth,node))  = dequeue(queue)
	           	in doSuccs depth (neighbours node) (Back mark) queue  end

     	    and doSuccs _ [] _ queue  = doQueue queue 
              | doSuccs depth ((node as Node{flag,class,flagP,...})::nodes) back queue =
	 	(inc edgeCount ; 
         	(case !flag of
            	  Stop   => (flag:= back; SOME node)
           	| Other  => (flag:=back; allNodes := node :: (!allNodes); inc markCost;
			    case flagP of
			      ref(ref(Back(j,_))) => doSuccs depth nodes back 
							     (enqueue(((incFn depth),node),
								     (queueFn (absPathLength-j)),queue))
                              | _                 => doSuccs depth nodes back 
							      (enqueue(((incFn depth),node),0,queue)))
          	| _      => doSuccs depth nodes back queue))

         in searchFrom start end
end
end