functor AbsGraphGeneratorFUN
  (structure
             Graph                : GRAPH
         and HashState            : HASH_STATE
         and AbstractionGenerator : ABSTRACTION_GENERATOR
   sharing type Graph.groundState = HashState.state
   sharing Graph = AbstractionGenerator.Graph  )
    : ABS_GRAPH_GENERATOR  =
struct

 structure Graph = Graph

local open Graph AbstractionGenerator in


 type abstraction_parameter =  abstraction_parameter

 structure AbsHashState =
 struct
  type state = state
  fun sameState (Ground x,Ground y) = HashState.sameState(x,y)
    | sameState (Abstract(Node{state=x,...}::_),
                 Abstract(Node{state=y,...}::_)) = sameState(x,y)
    | sameState _ = false
  fun hashState (Ground x) = HashState.hashState x
    | hashState (Abstract(Node{state,...}::_)) = hashState state
 end

 structure GraphGenerator =
   GraphGeneratorFUN (structure Graph     = Graph
                            and HashState = AbsHashState)

 fun graphGenerator  generator states =
 let fun absGenerator (Ground s) = map Ground (generator s)
     val (graph,lookup) =
       GraphGenerator.graphGenerator absGenerator (map Ground states)
 in  (graph,lookup o Ground, abstractionGenerator graph)
 end
end
end
