
functor AbsGeneratorTreesFUN (structure Graph : GRAPH) : ABSGEN =

struct

structure Graph = Graph

local open Graph Random WorkingMemory in 


(* TREE ABSTRACTION GENERATOR *)

 fun getSuccs (Node{succs,...}) = (!succs)
 fun getPreds (Node{preds,...}) = (!preds)

 (* Returns nodes that form a tree.
    The tree can be in either direction.
           It can start at the root and include children defined by the
           successor arcs and their children recursively.
           Alternatively it can start at the root and include children defined
           by the predecessor arcs and their children recursively.
    Presently only one type of tree is used at a particular level in the
           graph.  This is determined by  the first argument.
    A tree is formed by starting from a random node and including all
           neighbours that have less than two predecessor or the successor
           arcs as appropriate. This process is repeated recursively.
    Nodes marked with a stop flag are part of a subtree which has
           already been formed into a class, only this subtree's root node
           is required for merging the classes.
  *)

 type ACTIONparameter = bool

 fun  ACTION (test: ACTIONparameter)
      ((thisNode as
           (node as (Node {flag,class = ref (SOME thisClass),...}))) :: rest)= 
	let val getNodes = if test then getSuccs else getPreds
            val testNodes = if test then getPreds else getSuccs
            val absType = if test then ForeTree else BackTree
	    fun loopNode (node' as(Node {flag,class = ref (SOME otherClass),...})) set= 
		  if (length (testNodes node') < 2) 
					andalso not (sameNode otherClass thisClass)
				then (case flag of ref Stop => node' :: set 
						    | _ => (flag := Stop; loopNodes (getNodes node') (node'::set))) 
				else set
            and loopNodes [] set = set
              | loopNodes (n::ns) set = 
                  loopNodes ns (loopNode n set)

	in case (loopNodes (getNodes node) []) of 
                [] => ([thisNode],rest,Another)
           | nodes => (flag := Stop; ((thisNode::nodes),rest,absType)) end 

 (* If the number of nodes with a single predecessor is greater than those with a 
    single successor apply the downard generator and set the search direction 
    for the graph to be backwards *)

 fun doDownTreeGen  (WM {alternating,forward,...}) (graph as Graph{nodes,...}) =
        (case ((hd nodes),alternating) of  
        (Node{state = Abstract _,...}, (ref true)) => not (!forward)
         | _ => 
  	(let val noOfPreds = fold (fn (node,total) => 
			if ((length (getPreds node)) = 1) then 1 + total
							else total) nodes 0
 	    val noOfSuccs = fold (fn (node,total) => 
			if ((length (getSuccs node)) = 1) then 1 + total
							else total) nodes 0
	in if (noOfPreds <=  noOfSuccs)
				 then (forward := false; true)
				 else (forward := true; false)  end))


 (* If the backward generator has not been used apply the forward generator *)

 fun doUpTreeGen (WM {forward,...}) _  = (!forward)

 type CONDITIONparameter = bool * workingMemory ;

 fun CONDITION ((true,wm): CONDITIONparameter)  g  = doDownTreeGen wm g
  |  CONDITION (false, WM {forward,...}) _  = (!forward)  (* doUpTreeGen *)

 
(* END TREE ABSTRACTION GENERATOR *)
end
end
