functor AbsGeneratorStarsFUN (structure Graph : GRAPH) : ABSGEN =

  (* STAR ABSTRACTION GENERATOR *)
  
  (* Combines a node with its neighbours and their neighbours to a depth 
     specified by the diameter argument in the "makeStar" function. The 
     neighbours are either just the successor nodes, just the predecessor
     nodes or the successor and predecessor nodes defined by the test argument.
     The node that is selected as the hub of the star formation can either
     be chosen randomly or by finding the one with the most neighbours not
     already belonging to an abstract class.
     As with the other abstraction methods a triple is returned:
          the set of nodes to be combined,
          the list without the first node of this set, in this case the hub,
      and the abstract type.
  *) 

struct

structure Graph = Graph

local open Queue Graph Random WorkingMemory in

type CONDITIONparameter = (workingMemory option) * bool
type ACTIONparameter    = (string * string * int)



 fun getSuccs (Node{succs,...}) = (!succs)
 fun getPreds (Node{preds,...}) = (!preds)

(* Returns the predecessor and successor nodes if they have not already
    been included in a class to a distance determined by diameter *)

 fun makeStar test diameter (thisNode as (Node{flag,...})) = 
        let  fun decDegree (node as (Node {flag,preds,succs,...})) = 
  		(app (degree true) (!preds); app (degree false) (!succs); node)
             and degree p (Node{flag = (f as (ref (AbsInfo (Degree (ind,outd))))),...}) =
 		f := AbsInfo (Degree (if p then (ind-1,outd) else (ind,outd-1)))
              | degree _ _ = ()

	    val neighbours = case test of "p" => getSuccs |  "s" => getPreds
			     		|  _  => fn ns => (getSuccs ns) @ (getPreds ns)

	    fun doQueue queue list =
           	if isEmpty(queue) then list  else
           	let val ((depth,node),queue)  = dequeue(queue)
	        in doSuccs (depth-1) (neighbours node) queue list end

     	    and doSuccs 0 _ _ list = list
      	      | doSuccs _ [] queue  list = doQueue queue list
              | doSuccs depth ((node as Node{flag,...})::nodes) queue  list=
         	(case !flag of
          	Stop => doSuccs depth nodes queue list 
           	| _  => (flag:= Stop; doSuccs depth nodes 
					(enqueue((depth,node),queue)) ((decDegree node)::list)))
         in (flag := Stop; 
	   case (doQueue (enqueue((diameter,thisNode),empty)) []) of 
                [] => (flag := Other ; [thisNode])
           | nodes => ((decDegree thisNode):: nodes)) end

 (* Return as the head of the list a randomly selected node *)

 fun randomStarNode nodes  = 
   let  fun  randomNode _ _ [] = []
	  |  randomNode count newList ((n as Node{flag = ref Stop,...})::ns) =
		if (count <= 1) andalso (newList <> [])
			then (hd newList) ::((rev (tl newList)) @ ns) 
			else randomNode (count -1) newList ns
   	  | randomNode count newList (n::ns) = 
		if (count <= 1) 
			then n::((rev newList) @ ns) 
			else randomNode (count -1) (n::newList) ns
   in randomNode (newrandom (length nodes)) [] nodes end

 (* Return as the head of the list the node with the maximum number of unabstracted
    neighbours *)

 fun maxStarNode test (node::nodes) = 
        let fun countArcs ((Node {flag = ref Stop,...}),total) = total
              | countArcs (_,total) = 1 + total	

            fun degree (Node{flag = ref (AbsInfo (Degree d)),...}) = d
	      | degree (Node{flag,succs,preds,...}) = 
			let val d = (fold countArcs (!preds) 0,fold countArcs (!succs) 0)
			in flag := (AbsInfo (Degree d)); d end

	    val neighbours = case test of
		                "p" => (fn (x,y) => x) o degree
			     |  "s" => (fn (x,y) => y) o degree
			     |   _  =>  (fn (x,y:int) => x+y) o degree

           fun  maxDegree [] max maxNode newList = maxNode::newList
             |  maxDegree (Node {flag=ref Stop,...}::ns) max maxNode newList = 
			maxDegree ns max maxNode newList
             |  maxDegree (n::ns) max maxNode newList =
		 let val total = neighbours n
		 in if total > max 
			then maxDegree ns total n (maxNode::newList)
			else maxDegree ns max maxNode (n::newList) end   
	in maxDegree nodes (neighbours node) node [] end

  fun ACTION (test,nodeFn,count) nodes =
      let val (n::ns) = case nodeFn of  
			"max" =>  maxStarNode test nodes 
			| _   =>  randomStarNode nodes
      in ((makeStar test count n),ns,Star) end 



 fun CONDITION (NONE,_)  _ = true             (* Always apply this generator *)
  |  CONDITION (SOME (WM {forward,...}), true) _ =
                                     not (!forward)     (* doPStarGen *)
  |  CONDITION (SOME (WM {forward,...}), false) _ = 
                                         (!forward)     (* doSStarGen *)

  (* alternative tests for graph direction -- replaced by the preceding *)


  fun doPStarGen (WM {forward,...}) graph = not (!forward)
  fun doSStarGen (WM {forward,...}) graph = (!forward)

end
end
