functor AbsGeneratorBiasStarsFUN (structure Graph : GRAPH) :  ABSGEN =

  (* STAR ABSTRACTION GENERATOR *)
  
  (* Combines a node with its neighbours and their neighbours to a depth 
     specified by the diameter argument in the "makeStar" function. The 
     neighbours are either just the successor nodes, just the predecessor
     nodes or the successor and predecessor nodes defined by the test argument.
     The node that is selected as the hub of the star formation can either
     be chosen randomly or by finding the one with the most neighbours not
     already belonging to an abstract class.  As with the other abstraction methods
     a triple of the set of nodes to be combined, the list without the first node
     of this set, in this case the hub, and the abstract type is returned. *) 

struct

structure Graph = Graph

local open Graph Random WorkingMemory in

type CONDITIONparameter = unit
type ACTIONparameter    = unit

 fun getSuccs (Node{succs,...}) = (!succs)
 fun getPreds (Node{preds,...}) = (!preds)

(* Returns the predecessor and successor nodes if they have not already
    been included in a class to a distance determined by diameter *)

 fun makeBiasStar (WM {forward,...}) (thisNode as (Node{flag,succs,preds,...})) = 
        let fun getArcs [] = []
	      | getArcs((Node {flag = ref Stop,...}):: nodes) = getArcs nodes
              | getArcs ((node as (Node {flag,...})):: nodes) = 
	 	 (flag := Stop; node :: (getArcs nodes))

	    val neighbours = if (!forward) then getArcs (!succs)
					   else getArcs (!preds)

	in case neighbours of 
                [] => [thisNode]
           | nodes => (flag := Stop; thisNode :: nodes)  end 


 (* Return as the head of the list the node with the maximum number of unabstracted
    neighbours *)

 fun maxBiasStarNode  (WM {forward,...}) (node::nodes) = 
        let fun degreeRatio (Node{class = ref (SOME c),...}) = 
		let  val (Node{flag = ref (AbsInfo (Degree (ind,outd))),...}) = c
		     val p = real (ind+1)
		     val s = real (outd+1)
		in  if (p > s) then p/s else s/p end
	    fun  maxDegree [] max maxNode newList = maxNode::newList
              |  maxDegree (Node {flag=ref Stop,...}::ns) max maxNode newList = 
			maxDegree ns max maxNode newList
              |  maxDegree (n::ns) max maxNode newList =
		 let val ratio = degreeRatio n
		 in if  ratio < max 
			then maxDegree ns ratio n (maxNode::newList)
			else maxDegree ns max maxNode (n::newList) end   
	in maxDegree nodes (degreeRatio node) node [] end

  fun ACTION _  nodes =
      let val (n::ns) =  maxBiasStarNode Wm nodes 
      in ((makeBiasStar Wm n),ns,Star) end 

 

 (* Always apply this generator *)
 fun CONDITION _ _ = true


end
end

