

functor AbsGeneratorAltsFUN (structure Graph : GRAPH) : ABSGEN =

  (* "alternatives" ABSTRACTION GENERATOR *)

(**** Tests if two nodes are alternatives ways of getting the same places
      (the two are merged if this happens).

   This applies only to nodes that have some successors and some predecessors.

   This is a special case of the "Bypass" test, and should always be done
   before the Bypass test.

****)
  

struct

structure Graph = Graph

local open Graph Random in

type CONDITIONparameter = unit
type ACTIONparameter    = unit 

 fun CONDITION _ _ = true           (* Always apply this generator *)


fun remove _ [] = []
 |  remove x (h::t) = if (sameNode x h) then t else (h::(remove x t))

fun remove_all _ [] = []
 |  remove_all x (h::t) = if (sameNode x h)
                          then (remove_all x t)
                          else h::(remove_all x t)

  fun member _ [] = false
   |  member x (h::t) = (sameNode x h) orelse (member x t)

   fun subset [] [] = true
    |  subset _ []  = false
    |  subset [] _  = true
    |  subset (h::t) L = (member h L) andalso (subset t L)

  fun nonstop [] = []
   |  nonstop ((node as (Node {flag,...})) ::others) =
         if   ((!flag) = Stop)
         then (nonstop  others)
         else node::(nonstop others)

   fun check_for_alternatives node nsuccs p =
   let fun all_brothers [] sofar = remove_all node sofar
        |  all_brothers ((h as (Node {succs,...}))::t) sofar =
                all_brothers t ((!succs)@sofar)
       fun return_alt [] = NONE
        |  return_alt ((h as (Node {succs,preds,...}))::t) =
          (case (remove h (!succs), remove h (!preds))
           of ([], _ ) => return_alt t
            | ( _, []) => return_alt t
            | (s0,p0) =>
                      let val s1 = remove h nsuccs
                          val s2 = remove node s0
                          val p1 = remove h p
                          val p2 = remove node p0
                      in if    ((subset s1 s2) orelse (subset s2 s1))
                           andalso ((subset p1 p2) orelse (subset p2 p1))
                          then (SOME h)
                          else return_alt t
                      end
           )
   in return_alt (nonstop (all_brothers p []))
   end
             

  fun ACTION _ ((node as (Node {preds,succs,flag=nflag,...})) ::others) =
  if   (not ((!nflag) = Stop))
  then
  let val p = remove node (!preds)
      val s = remove node (!succs)
  in
     (case (p,s)
     of  ([] , _ ) => ( [node], others, Another )
      |  ( _ , []) => ( [node], others, Another )

      | _ =>
            ( case (check_for_alternatives node s p)
             of
               SOME (altNode as (Node {flag=xflag,...})) =>
                         ( xflag := Stop ; nflag := Stop ;
                         ( [node,altNode], others, Bypass ))
             | _ =>      ( [node], others, Another )
            )
     )
  end
  else  ( [node], others, Another )

end
end
