signature GRAPH =
sig
 type groundState
  datatype absInfo =  PostOrder of int | Degree of (int * int)
  and flag = Stop  | Step of int | Other | Back of (int * node)
		 | Start | Ignore | AbsInfo of absInfo
 and absType =  ForeTree | BackTree | Star | Pair | Another | Bypass
 and howFar  = Dist of int | Far
 and node = Node of
  { state : state,
    succs : node list ref,
    preds : node list ref,
    flag  : flag ref,
    flagP  : flag ref ref,
    absType : absType ref,
    class : node option ref }
 and state = Ground   of groundState
           | Abstract of node list

 datatype graphType = SearchForward | SearchBackward
 and graph = Graph of
  { size  : int,
    height  : int,
    nodes : node list,
    graphType : graphType ref,
    super : graph option ref }

 val clearGraph : graph option -> unit
 val clear : unit -> unit
 val mkNode  : state -> node
 val sameNode :  node -> node -> bool 
 val mkGraph : (int * int * node list) -> graph
 val allNodes : node list ref
 val pathLengthList : int list ref
 val edgeCountList : int list ref
 val edgeCount : int ref
 val markCostList : int list ref
 val markCost : int ref
end
