datatype qsim_external_state =  (* a list of the state names *)
              s048 | s113 | s217 | s594 | s221 | s222 | s485
            | s549 | s487 | s567 | s489 | s570 | s488 | s133


fun  convert_qsim_state s048 = " 48"
  |  convert_qsim_state s113 = "113"
  |  convert_qsim_state s217 = "217"
  |  convert_qsim_state s594 = "594"
  |  convert_qsim_state s221 = "221"
  |  convert_qsim_state s222 = "222"
  |  convert_qsim_state s485 = "485"
  |  convert_qsim_state s549 = "549"
  |  convert_qsim_state s487 = "487"
  |  convert_qsim_state s567 = "567"
  |  convert_qsim_state s489 = "489"
  |  convert_qsim_state s570 = "570"
  |  convert_qsim_state s488 = "488"
  |  convert_qsim_state s133 = "133"



structure Qsim : GENERIC_PUZZLE =
struct
local open Random
in

(*  A state is represented by an atom, "s" followed by the number
   generated by Qsim.

   The legal moves for each state are represented by a list of successors.
*)

 type external_state =  qsim_external_state
 type internal_state = external_state
 type puzzle_parameter =   unit

 fun sameState (x,y) = (x = y)

 fun hashState s048 =  1
  |  hashState s113 =  2
  |  hashState s217 =  3
  |  hashState s594 =  4
  |  hashState s221 =  5
  |  hashState s222 =  6
  |  hashState s485 =  7
  |  hashState s549 =  8
  |  hashState s487 =  9
  |  hashState s567 = 10
  |  hashState s489 = 11
  |  hashState s570 = 12
  |  hashState s488 = 13
  |  hashState s133 = 14


 fun successors s048 = [ s113, s217, s485 ]
  |  successors s113 = [ s133, s217, s485, s549, s594 ]
  |  successors s217 = [ s485, s594, s549, s222, s221 ]
  |  successors s594 = [ s222, s549, s221 ]
  |  successors s221 = [ s222 ]
  |  successors s222 = [ s567 ]
  |  successors s485 = [ s549, s487, s488, s489 ]
  |  successors s549 = [ s487, s488, s489 ]
  |  successors s487 = [ s567 ]
  |  successors s567 = [ s488, s489 ]
  |  successors s489 = [ s570 ]
  |  successors s570 = [ s488 ]
  |  successors s488 = [  ]
  |  successors s133 = [ s549, s594 ]


fun random_element L =
    let val pos = (newrandom (length L))-1
    in  (nth (L,pos))
    end


(* the following takes a state and returns a random successor of that state,
   successors with low outdegree have higher probability of being chosen
   than those with a high outdegree.  The chosen state will be at most
   distance D from the initial state.
   (D is really only needed to rpevent infinite loops in cyclic spaces.
    I have set it large enough here that it will never cause termination)
*)

 fun randState 0 state = state
  |  randState D state =
     let val s = random_element (state::(successors state))
     in  if (s = state)
         then state
         else randState (D-1) s
     end

fun identity x = x

 fun mkInstance _  =
     { decode   = identity ,
       encode   = identity ,
       successor= successors,
       initialStates = [s048] ,
       randomStatePair = (fn () => ( s048, randState 30 s048) )
      }

end
end

