
(*** important note: I have added one extra operator in order to make
     the space strobgly connected (all states reachable from all others).

     The new operator (and its inverse) conects these two states, and applies
     nowhere else:

             1  3  4              2  3  5
             2  5  -              4  1  -

     There is nothing special about these two states except that they are in
     opposite halves of the state space.
     This makes an extremely thin bridge between the two otherwise separate
     half-spaces.  This ought to be an interesting test of the power of
     abstraction.

     The move is called BRIDGE.
*)

structure FivePuzzle : GENERIC_PUZZLE =
struct
local open Random
in

(* state is represented by a list of 6 digits (1,2, or 3) -- the digit in
   the Ith position indicates the position of tile I-1 (tile 0 is the blank)
*)

  type external_state = int list ;
  type internal_state = int list ;
  type puzzle_parameter = unit   ;  (* there is no parameter *)

  fun sameState ([],[])             = true
   |  sameState (h1::t1,h2::t2) = (h1=h2) andalso (sameState (t1,t2))
   |  sameState        _            = false ;

  fun hashState [] = 0
   |  hashState (h::t) = h + 8*(hashState t) ;

  fun encode n = n ;
  val decode   = encode ;


(* the rest of this is to define the successor function *)

datatype movetype = BRIDGE | moveUP | moveDOWN | moveLEFT | moveRIGHT ;

fun swap x y [] = []
 |  swap x y (h::t) = if h=x
                      then (y::(swap x y t))
                      else if h=y
                           then (x::(swap x y t))
                           else (h::(swap x y t))

fun member _ [] = false | member x (h::t) = (x=h) orelse (member x t) ;

val home1 = [6,1,4,2,3,5] ;
val home2 = [6,5,1,2,4,3] ;

fun generator (h::t) moveUP  =
          if h < 4 then NONE else SOME (swap h (h-3) (h::t))
 |  generator (h::t) moveDOWN =
          if h > 3 then NONE else SOME (swap h (h+3) (h::t))
 |  generator (h::t) moveLEFT =
          if (member h [1,4]) then NONE else SOME (swap h (h-1) (h::t))
 |  generator (h::t) moveRIGHT =
          if (member h [3,6]) then NONE else SOME (swap h (h+1) (h::t))
 |  generator s BRIDGE  =
          if s = home1 then SOME home2
                       else if s = home2 then SOME home1
                                         else NONE




fun mkGenerator state =
let fun cleanup (NONE  ::l) =      cleanup l
       | cleanup (SOME s::l) = s :: cleanup l
       | cleanup []          = []
in cleanup (map (generator state) [BRIDGE,moveUP,moveDOWN,moveLEFT,moveRIGHT])
end;

fun randState 0 s = s
 |  randState n s = let val new_s = swap (newrandom 6) (newrandom 6) s
                    in randState (n-1) new_s
                    end

fun mkInstance () =
   { decode = decode,
     encode = encode,
     successor = mkGenerator,
     initialStates = [home1],
     randomStatePair = (fn () => ( randState 12 home1, randState 12 home1 ))
   }

end
end 
