;  This is the loader and compiler for our theorem-prover.  To compile
;  the system, after loading this file into Common Lisp, invoke
;  (COMPILE-THM).  To build the system, assuming that it has been
;  compiled and after loading this file, invoke (LOAD-THM).  -- Boyer
;  and Moore

(DEFUN COMPILE-THM ()
  (LET ((*READTABLE* (COPY-READTABLE NIL)))
    (COMPILE-FILE "iterate.lisp")
    (LOAD "iterate")
    (COMPILE-FILE "basis.lisp")
    (LOAD "basis")
    (COMPILE-FILE "genfact.lisp")
    (LOAD "genfact")
    (COMPILE-FILE "events.lisp")
    (LOAD "events")
    (COMPILE-FILE "code-1-a.lisp")
    (COMPILE-FILE "code-b-d.lisp")
    (COMPILE-FILE "code-e-m.lisp")
    (COMPILE-FILE "code-n-r.lisp")
    (COMPILE-FILE "code-s-z.lisp")
    (COMPILE-FILE "io.lisp")
    (COMPILE-FILE "ppr.lisp")))

(DEFPARAMETER THEOREM-PROVER-ROOTS
  '("basis" "genfact" "events"
    "code-1-a" "code-b-d" "code-e-m" "code-n-r" "code-s-z"
    "io" "ppr"))
  
(DEFUN LOAD-THM ()
  (LET ((*READTABLE* (COPY-READTABLE NIL)))
    (LOAD "iterate")
    (MAPC #'LOAD THEOREM-PROVER-ROOTS)))

