(EVAL-WHEN (LOAD EVAL COMPILE)
	   (CHK-BASE-AND-PACKAGE 10 *PACKAGE*))

(DEFUN BATCH-PROVEALL (FILE)

;   FILE should contain a sequence of forms such as (PROVEALL ...)
;   (PROVEALL ...).  Each is executed.

  (RESTART-BATCH (READ-FILE FILE)))

(DEFUN BOOLEAN (TERM) (LOGSUBSETP (TYPE-SET TERM) TYPE-SET-BOOLEAN))

(DEFUN BOOT-STRAP0 NIL (ADD-SUB-FACT NIL NIL NIL NIL T)
  (COND (*THM-WARNING-FLG*
	 (IPRINC *THM-WARNING* T)))
  (ADD-SUB-FACT NIL NIL NIL NIL T)
  (MAKUNBOUND (QUOTE LIB-FILE)))

(DEFUN BREAK-LEMMA (NAME WHEN) ; ??
  (OR WHEN (SETQ WHEN T))
  (BREAKON (QUOTE RELIEVE-HYPS)
	   '(AND (SETQ TEMP-TEMP (ASSOC-EQ (CADR ARGLIST) BROKEN-LEMMAS))
		 (EVAL (CDR TEMP-TEMP))))
  (PUSH (CONS NAME WHEN) BROKEN-LEMMAS))

(DEFUN BREAK-LEMMAS (NAMES) ; ??
  (ITERATE FOR NAME IN NAMES COLLECT (BREAK-LEMMA NAME T)))

(DEFUN BTM-OBJECT (CONST)

;   If the shell for which CONST is the constructor has a bottom object return
;   the term that is that bottom object.  Else, return NIL.

  (LET (TYPE-SET ANS)
    (SETQ TYPE-SET (ASH 1 (CDR (ASSOC-EQ CONST SHELL-ALIST))))
    (COND ((ITERATE FOR FN IN *1*BTM-OBJECTS
		    THEREIS (= (TYPE-SET (SETQ ANS (CONS-TERM FN NIL)))
			       TYPE-SET))
	   ANS)
	  (T NIL))))

(DEFUN BTM-OBJECT-OF-TYPE-SET (TYPE-SET)

;   Returns the btm object fn symb with the specified type set, or NIL if no
;   such btm object exists.

  (COND ((NULL (CDR *1*BTM-OBJECTS))
	 (COND ((= TYPE-SET TYPE-SET-NUMBERS)
		(QUOTE ZERO))
	       (T NIL)))
	(T (ITERATE FOR X IN *1*BTM-OBJECTS
		    WHEN (= TYPE-SET (CAR (TYPE-PRESCRIPTION X)))
		    DO (RETURN X)))))

(DEFUN BTM-OBJECTP (TERM)
  (COND ((VARIABLEP TERM) NIL)
	((FQUOTEP TERM)
	 (COND ((ATOM (CADR TERM))
		(EQUAL 0 (CADR TERM)))
	       (T (AND (EQ *1*SHELL-QUOTE-MARK (CAR (CADR TERM)))
		       (MEMBER-EQ (CADR (CADR TERM)) *1*BTM-OBJECTS)))))
	(T (MEMBER-EQ (FFN-SYMB TERM) *1*BTM-OBJECTS))))

(DEFUN BUILD-SUM (WINNING-PAIR ALIST)
  (COND ((ATOM ALIST) ZERO)
	((EQUAL WINNING-PAIR (CAR ALIST))
	 (BUILD-SUM WINNING-PAIR (CDR ALIST)))
	(T (CONS-PLUS (COND ((EQUAL 1 (ABS (CDAR ALIST)))
			     (CAAR ALIST))
			    (T (FCONS-TERM* (QUOTE TIMES)
					    (LIST (QUOTE QUOTE)
						  (ABS (CDAR ALIST)))
					    (CAAR ALIST))))
		      (BUILD-SUM WINNING-PAIR (CDR ALIST))))))

(DEFUN CANCEL (EQ1 EQ2)
  (LET (CO1 CO2 POLY)
    (SETQ CO1 (ABS (FIRST-COEFFICIENT EQ1)))
    (SETQ CO2 (ABS (FIRST-COEFFICIENT EQ2)))

;   See ADD-TERMS-TO-POT-LST for an explanation of why we UNION rather than
;   UNION-EQUAL the LITERALS and LEMMAS.

    (SETQ POLY (MAKE POLY (+ (* CO2
				(ACCESS POLY CONSTANT EQ1))
			     (* CO1
				(ACCESS POLY CONSTANT EQ2)))
		     (CANCEL1 CO2 (CDR (ACCESS POLY ALIST EQ1))
			      CO1
			      (CDR (ACCESS POLY ALIST EQ2)))
		     (UNION-EQUAL (ACCESS POLY ASSUMPTIONS EQ1)
				  (ACCESS POLY ASSUMPTIONS EQ2))
		     (UNION-EQ (ACCESS POLY LITERALS EQ1)
			       (ACCESS POLY LITERALS EQ2))
		     (UNION-EQ (ACCESS POLY LEMMAS EQ1)
			       (ACCESS POLY LEMMAS EQ2))))
    (COND ((IMPOSSIBLE-POLYP POLY)
	   (SETQ LINEAR-ASSUMPTIONS (ACCESS POLY ASSUMPTIONS POLY))
	   (SETQ LEMMAS-USED-BY-LINEAR (UNION-EQ (ACCESS POLY LEMMAS POLY)
						 (ACCESS POLY LITERALS
							 POLY)))
	   (THROW (QUOTE ADD-EQUATIONS)
		  (QUOTE CONTRADICTION)))
	  ((TRUE-POLYP POLY) NIL)
	  (T POLY))))

(DEFUN CANCEL-POSITIVE (EQUATION)
  (COND ((> (FIRST-COEFFICIENT EQUATION) 0)
	 (SETQ EQUATION (MAKE POLY (ACCESS POLY CONSTANT EQUATION)
			      (CDR (ACCESS POLY ALIST EQUATION))
			      (ACCESS POLY ASSUMPTIONS EQUATION)
			      (ACCESS POLY LITERALS EQUATION)
			      (ACCESS POLY LEMMAS EQUATION)))
	 (COND ((IMPOSSIBLE-POLYP EQUATION)
		(SETQ LINEAR-ASSUMPTIONS (ACCESS POLY ASSUMPTIONS EQUATION))
		(SETQ LEMMAS-USED-BY-LINEAR
		      (UNION-EQ (ACCESS POLY LEMMAS EQUATION)
				(ACCESS POLY LITERALS EQUATION)))
		(THROW (QUOTE ADD-EQUATIONS)
		       (QUOTE CONTRADICTION)))
	       ((TRUE-POLYP EQUATION) NIL)
	       (T EQUATION)))
	(T NIL)))

(DEFUN CANCEL1 (CO1 AL1 CO2 AL2)
  (LET (TEMP)
    (COND ((NULL AL1)
	   (ITERATE FOR PAIR IN AL2 COLLECT
		    (CONS (CAR PAIR) (* (CDR PAIR) CO2))))
	  ((NULL AL2)
	   (ITERATE FOR PAIR IN AL1 COLLECT
		    (CONS (CAR PAIR)
			  (* (CDR PAIR) CO1))))
	  ((NOT (TERM-ORDER (CAAR AL1) (CAAR AL2)))
	   (CONS (CONS (CAAR AL1)
		       (* (CDAR AL1) CO1))
		 (CANCEL1 CO1 (CDR AL1) CO2 AL2)))
	  ((EQUAL (CAAR AL1) (CAAR AL2))
	   (SETQ TEMP (+ (* CO1 (CDAR AL1))
			 (* CO2 (CDAR AL2))))
	   (COND ((EQUAL TEMP 0)
		  (CANCEL1 CO1 (CDR AL1) CO2 (CDR AL2)))
		 (T (CONS (CONS (CAAR AL1) TEMP)
			  (CANCEL1 CO1 (CDR AL1) CO2 (CDR AL2))))))
	  (T (CONS (CONS (CAAR AL2) (* (CDAR AL2) CO2))
		   (CANCEL1 CO1 AL1 CO2 (CDR AL2)))))))

(DEFUN CAR-CDRP (X)
  (LET ((STR (SYMBOL-NAME X)))
    (COND ((AND (> (LENGTH STR) 2)
		(EQL (AREF STR 0) #\C)
		(EQL (AREF STR (1- (LENGTH STR))) #\R)
		(ITERATE FOR I FROM 1 TO  (- (LENGTH STR) 2)
			 ALWAYS (OR (EQL (AREF STR I) #\A)
				    (EQL (AREF STR I) #\D))))
	   (ITERATE FOR I DOWNFROM (- (LENGTH STR) 2) TO 1 COLLECT
		    (AREF STR I)))
	  (T NIL))))

(DEFUN CDR-ALL (X) (ITERATE FOR X1 IN X COLLECT (CDR X1)))

(DEFUN CHK-ACCEPTABLE-DEFN (NAME ARGS BODY RELATION-MEASURE-LST)
  (LET ((ARITY-ALIST (CONS (CONS NAME (LENGTH-TO-ATOM ARGS)) ARITY-ALIST)))
    (CHK-NEW-NAME NAME NIL)
    (CHK-NEW-*1*NAME NAME)
    (CHK-ARGLIST NAME ARGS)
    (COND ((> (LENGTH ARGS) 32)
	   (ERROR1 (PQUOTE (PROGN |Too| |many| |args| ! |because| |of| |our|
				  |use| |of| |32-bit| |words| |to| |encode|
				  |sets| |of| |recursion| |controllers| |we|
				  |cannot| |accept| |functions| |,| |such| |as|
				  (!PPR NAME NIL)
				  |,| |with| |more| |than| 32 |arguments| |.|))
		   (BINDINGS (QUOTE NAME) NAME)
		   (QUOTE SOFT))))
    (SETQ BODY (TRANSLATE BODY))
    (COND ((NOT IN-BOOT-STRAP-FLG) (CHK-MEANING NAME (ALL-FNNAMES BODY))))
    (FREE-VAR-CHK NAME ARGS BODY)
    (ITERATE FOR X IN RELATION-MEASURE-LST
	     DO (COND ((NOT (AND (CONSP X)
				 (MEMBER-EQ (CAR X) WELL-ORDERING-RELATIONS)
				 (CONSP (CDR X))
				 (NULL (CDDR X))
				 (SUBSETP-EQ (ALL-VARS (TRANSLATE (CADR X))) ARGS)))
		       (ERROR1 (PQUOTE (PROGN |Each| |member| |of| |the| |fourth|
					      |argument| |to| DEFN |must| |be|
					      |of| |the| |form|
					      (!PPR (QUOTE (|rel| |term|)) NIL)
					      |,| |where| |rel| |is| |the| |name|
					      |of| |a| |well-founded| |relation|
					      |and| |term| |is| |a| |term|
					      |all| |of| |whose| |variables|
					      |are| |among| |the| |formals| |of|
					      |the| |function| |being|
					      |defined| |.|))
			       NIL
			       (QUOTE SOFT)))))
    NIL))

(DEFUN CHK-ACCEPTABLE-DCL (NAME ARGS)
  (CHK-ARGLIST NAME ARGS)
  (CHK-NEW-NAME NAME NIL)
  (COND ((> (LENGTH ARGS) 32)
	 (ERROR1 (PQUOTE
		  (PROGN |Too| |many| |args| ! |because| |of|
			 |our| |use| |of| |32-bit| |words| |to|
			 |encode| |sets| |of| |recursion|
			 |controllers| |we| |cannot| |accept|
			 |functions| |,| |such| |as| (!PPR NAME NIL)
			 |,| |with| |more| |than| 32 |arguments| |.|))
		 (BINDINGS (QUOTE NAME) NAME)
		 (QUOTE SOFT)))))

(DEFUN CHK-ACCEPTABLE-ELIM-LEMMA (NAME TYPE TERM)
  TYPE
  (LET (LST ALLVARS LHS RHS DESTS)
    (SETQ LST (UNPRETTYIFY TERM))
    (COND ((NOT (AND LST (NULL (CDR LST))
		     (MATCH (CDAR LST) (EQUAL LHS RHS))
		     (VARIABLEP RHS)
		     (NVARIABLEP LHS)
		     (ITERATE FOR ARG IN (SARGS LHS) THEREIS (NVARIABLEP ARG))))
	   (ERROR1 (PQUOTE (PROGN (!PPR NAME NIL)
				  |is| |an| |unacceptable| ELIM |lemma|
				  |because| |its| |conclusion| |is| |not| |an|
				  |equality| |of| |the| |form| |(EQUAL| |term|
				  |var)| |where| |term| |contains| |some|
				  |non-variable| |arguments|
				  |and| |var| |is| |a| |variable| |.|))
		   (BINDINGS (QUOTE NAME) NAME)
		   (QUOTE SOFT))))
    (SETQ ALLVARS (ALL-VARS TERM))
    (COND ((NOT (SETQ DESTS (DESTRUCTORS (LIST LHS))))
	   (ERROR1 (PQUOTE (PROGN (!PPR NAME NIL)
				  |is| |an| |unacceptable| ELIM |lemma|
				  |because| |the| |left| |hand| |side| |of|
				  |the| |conclusion| |does| |not| |contain|
				  |any| |terms| |of| |the| |form| |(fn|
				  |var1| |var2| |...| |varn)| |where| |fn|
				  |is| |a| |recursive| |function| |and| |the|
				  |vari| |are| |all| |distinct|
				  |variables| |.|))
		   (BINDINGS (QUOTE NAME) NAME)
		   (QUOTE SOFT)))
	  ((NOT (NO-DUPLICATESP (ITERATE FOR X IN DESTS COLLECT (FN-SYMB X))))
	   (ERROR1 (PQUOTE (PROGN (!PPR NAME NIL)
				  |is| |an| |unacceptable| ELIM |lemma|
				  |because| |the| |left| |hand| |side| |of|
				  |the| |conclusion| |contains| |two|
				  |or| |more| |destructor| |terms| |with|
				  |the| |same| |function| |symbol| |.|))
		   NIL
		   (QUOTE SOFT)))
	  ((NOT (ITERATE FOR X IN DESTS ALWAYS (SUBSETP-EQ ALLVARS (SARGS X))))
	   (ERROR1 (PQUOTE (PROGN (!PPR NAME NIL)
				  |is| |not| |an| |acceptable| ELIM |lemma|
				  |because| |some| |of| |the| |destructor|
				  |nests| |do| |not| |mention| |all| |of| |the|
				  |variables| |in| |the| |lemma| |.|))
		   (BINDINGS (QUOTE NAME) NAME)
		   (QUOTE SOFT)))
	  ((OCCUR RHS (SUB-PAIR-EXPR
		       DESTS
		       (ITERATE FOR X IN DESTS COLLECT TRUE)
		       LHS))
	   (ERROR1 (PQUOTE (PROGN (!PPR NAME NIL)
				  |is| |an| |unacceptable| ELIM |lemma|
				  |because| |the| |right-hand| |side| |of|
				  |the| |conclusion| |,| (!PPR RHS NIL) |,|
				  |occurs| |in| |the| |left-hand| |side| |in|
				  |places| |other| |than| |the| |destructor|
				  (PLURAL? DESTS |terms| |term|)
				  (!PPR-LIST DESTS (QUOTE |.|))))
		   (BINDINGS (QUOTE NAME) NAME (QUOTE RHS) RHS
			     (QUOTE DESTS) DESTS)
		   (QUOTE SOFT)))
	  (T (ITERATE FOR X IN DESTS
		      WHEN (GET (CAR X) (QUOTE ELIMINATE-DESTRUCTORS-DESTS))
		      DO (ERROR1 (PQUOTE (PROGN |We| |do| |not| |know| |how| |to|
						|handle| |multiple| |elimination|
						|lemmas| |for| |the| |same|
						|function| |symbol,| |e.g.,|
						(!PPR (CAR X) NIL) |.|))
				 (BINDINGS (QUOTE X) X)
				 (QUOTE SOFT)))))
    NIL))

(DEFUN CHK-ACCEPTABLE-GENERALIZE-LEMMA
  (NAME TYPE TERM) NAME TYPE TERM T)

(DEFUN CHK-ACCEPTABLE-HINTS (HINTS)
  (LET (EVENT)
    (ITERATE FOR X IN HINTS DO
	     (COND
	      ((ATOM X)
	       (ERROR1 (PQUOTE (PROGN |each| |element| |of| |the| HINTS |argument|
				      |to| PROVE-LEMMA |must| |be| |a| |pair|
				      |but| (!PPR X NIL) |is| |not| |.|))
		       (BINDINGS (QUOTE X) X)
		       (QUOTE SOFT)))
	      (T
	       (CASE
		(CAR X)
		(USE
		 (ITERATE FOR PAIR IN (CDR X) DO
			  (OR
			   (AND
			    (CONSP PAIR)
			    (SYMBOLP (CAR PAIR))
			    (SETQ EVENT (GET (CAR PAIR)
					     (QUOTE EVENT)))
			    (MEMBER-EQ (CAR EVENT)
				       (QUOTE (ADD-AXIOM PROVE-LEMMA DEFN REFLECT)))
			    (NULL (CDR (OUR-LAST PAIR)))
			    (ITERATE FOR X IN (CDR PAIR)
				     ALWAYS
				     (AND (VARIABLEP (TRANSLATE (CAR X)))
					  (PROGN (TRANSLATE (CADR X)) T))))
			   (ERROR1
			    (PQUOTE (PROGN |the| USE |hint| |must| |have| |the|
					   |form| (!PPR H NIL) |where| |each| |eventi|
					   |is| |the| |name| |of| |an| ADD-AXIOM |,|
					   PROVE-LEMMA |,| DEFN |,| |or| REFLECT |event|
					   |,| |each| |vi| |is| |a| |variable|
					   |name| |,| |and| |each| |ti| |is| |a|
					   |term| |.| |the| |entry| (!PPR PAIR NIL)
					   |is| |thus| |unacceptable| |.|))
			    (BINDINGS
			     (QUOTE H)
			     (QUOTE (USE (|event1| (|v1| |t1|) |...| (|vn| |tn|))
					 |...| (|eventk| (|vk| |tk|) |...|
							 (|vm| |tm|))))
			     (QUOTE PAIR) PAIR)
			    (QUOTE SOFT)))))
		(EXPAND
		 (ITERATE FOR X IN (CDR X) WITH Y
			  DO (SETQ Y (TRANSLATE X))
			  (OR (AND (NVARIABLEP Y)
				   (NOT (FQUOTEP Y))
				   (GET (FFN-SYMB Y)
					(QUOTE SDEFN)))
			      (ERROR1 (PQUOTE (PROGN |every| |element| |of| |an|
						     EXPAND |hint| |must| |be| |an|
						     |application| |of| |a| |defined|
						     |function| |to| |some|
						     |arguments| |and|(!PPR Y NIL)
						     |is| |not| |.|))
				      (BINDINGS (QUOTE Y) Y)
				      (QUOTE SOFT)))))
		((DISABLE ENABLE)
		 (ITERATE FOR X IN (CDR X) DO (CHK-DISABLEABLE X)))
		(INDUCT
		 (OR (NULL (CADR X))
		     (AND (SETQ HINT (TRANSLATE (CADR X)))
			  (NVARIABLEP HINT)
			  (NOT (FQUOTEP HINT))
			  (GET (FFN-SYMB HINT) (QUOTE INDUCTION-MACHINE))
			  (GET (FFN-SYMB HINT) (QUOTE SDEFN))
			  (ITERATE FOR X IN (FARGS HINT) ALWAYS (VARIABLEP X))
			  (NO-DUPLICATESP (FARGS HINT)))
		     (ERROR1 (PQUOTE (PROGN |The| INDUCT |hint| |must| |have|
					    |either| |the| |form| (!PPR G NIL)
					    |or| |the| |form| (!PPR H NIL) |where|
					    |fn| |is| |a| |recursively| |defined|
					    |function| |and| |the| |vi| |are|
					    |distinct| |variables| |.| |Thus,|
					    (!PPR X NIL) |is| |an| |inappropriate|
					    INDUCT |hint| |.|))
			     (BINDINGS
			      (QUOTE G) (QUOTE (INDUCT NIL))
			      (QUOTE H) (QUOTE (INDUCT
						(|fn| |v1| |...| |vn|)))
			      (QUOTE X) X)
			     (QUOTE SOFT))))
		(OTHERWISE
		 (COND ((ASSOC-EQ (CAR X) HINT-VARIABLE-ALIST)
			(COND ((CADDR (ASSOC-EQ (CAR X) HINT-VARIABLE-ALIST))
			       (ITERATE FOR Y IN (CDR X) DO (TRANSLATE Y)))))
		       (T
			(ERROR1 (PQUOTE (PROGN |each| |entry| |in| |the| HINTS
					       |argument| |of| PROVE-LEMMA |must|
					       |be| |a| |list| |beginning| |with|
					       |one| |of| |the| |atoms| USE |,|
					       EXPAND |,| DISABLE |,| INDUCT |,|
					       |or| TIME |.| |The| |proposed|
					       |hint| (!PPR X NIL) |is| |thus|
					       |inappropriate| |.|))
				(BINDINGS (QUOTE X) X)
				(QUOTE SOFT)))))))))))

(DEFUN CHK-ACCEPTABLE-LEMMA (NAME TYPES TERM)
  (CHK-NEW-NAME NAME NIL)
  (SETQ TERM (TRANSLATE TERM))
  (COND (IN-ADD-AXIOM-FLG (CHK-MEANING NAME (ALL-FNNAMES TERM))))
  (ITERATE FOR TYPE IN TYPES
	   DO (COND ((MEMBER-EQ (COND ((CONSP TYPE) (CAR TYPE))
				      (T TYPE))
				LEMMA-TYPES)
		     (FUNCALL (PACK (LIST (QUOTE CHK-ACCEPTABLE-)
					  (COND ((CONSP TYPE) (CAR TYPE))
						(T TYPE))
					  (QUOTE -)
					  (QUOTE LEMMA)))
			      NAME TYPE TERM))
		    (T (ERROR1 (PQUOTE (PROGN (!PPR TYPE NIL)
					      |is| |not| |among| |the| |legal|
					      |types,| |viz.| |,|
					      (!LIST LEMMA-TYPES) |.|))
			       (BINDINGS (QUOTE TYPE) TYPE
					 (QUOTE LEMMA-TYPES) LEMMA-TYPES)
			       (QUOTE SOFT))))))

(DEFUN CHK-ACCEPTABLE-META-LEMMA (NAME TYPE TERM)
  (LET (FN1 V1 A1 V2 A2 FN2 V3 V4)
    (COND ((AND (NOT IN-ADD-AXIOM-FLG) NONCONSTRUCTIVE-AXIOM-NAMES)
	   (ERROR1 (PQUOTE (PROGN META |lemmas| |must| |be| |proved| |in| |a|
				  |constructive| |history| |.| |The| |current|
				  |history| |contains| |the| |nonconstructive|
				  (PLURAL? LST |axioms| |axiom|) (!LIST LST)
				  |.| |If| |this| |metalemma| |is| |proved|
				  |using| |unsound| |axioms| |you| |may| |get|
				  |wiped| |out| |by| |the| |application| |of|
				  |the| |metafunction| |.|))
		   (BINDINGS (QUOTE LST) NONCONSTRUCTIVE-AXIOM-NAMES)
		   (QUOTE WARNING))))
    (COND ((NOT
	    (AND (MATCH TERM
			(IMPLIES
			 (FORMP V1)
			 (AND (EQUAL (MEANING V2 A1)
				     (MEANING (LIST FN1 V3) A2))
			      (FORMP (LIST FN2 V4)))))
		 (VARIABLEP V1)
		 (VARIABLEP A1)
		 (EQ V1 V2)
		 (EQ V1 V3)
		 (EQ V1 V4)
		 (EQ A1 A2)
		 (NOT (EQ V1 A1))
		 (GET FN1 (QUOTE LISP-CODE))
		 (EQ FN1 FN2)))
	   (ERROR1
	    (PQUOTE (PROGN META |lemmas| |have| |to| |have| |the| |form|
			   (!PPR X NIL) |where| |v| |and| |a| |are| |distinct|
			   |variables| |and| |fn| |is| |an| |explicit| |value|
			   |preserving| |function| |.| (!PPR NAME NIL)
			   |does| |not| |have| |this| |form| |.|))
	    (BINDINGS
	     (QUOTE X)
	     (QUOTE (IMPLIES (FORMP |v|)
			     (AND (EQUAL (MEANING |v| |a|) (MEANING (|fn| |v|)
								    |a|))
				  (FORMP (|fn| |v|)))))
	     (QUOTE NAME) NAME)
	    (QUOTE SOFT)))
	  ((NOT (AND (MATCH TYPE (CONS (QUOTE META) FNS))
		     (ITERATE FOR FN IN FNS
			      ALWAYS (AND (SYMBOLP FN)
					  (GET FN
					       (QUOTE
						TYPE-PRESCRIPTION-LST))))))
	   (ERROR1 (PQUOTE (PROGN META |lemmas| |must| |be| |stored| |under|
				  |one| |or| |more| |functions| |named| |by|
				  |the| |user| |in| |a| |lemma| |type| |of|
				  |the| |form| (!PPR X NIL) |where| |the| |fni|
				  |are| |function| |names| |.| (!PPR TYPE NIL)
				  |is| |not| |of| |this| |form| |.|))
		   (BINDINGS (QUOTE X) (QUOTE (META |fn1| |fn2| |...| |fnn|))
			     (QUOTE TYPE) TYPE)
		   (QUOTE SOFT))))
    T))

(DEFUN CHK-ACCEPTABLE-REFLECT
  (NAME SATISFACTION-LEMMA-NAME RELATION-MEASURE-LST)
  (LET (FN ARGS BODY)
    (CHK-NEW-NAME NAME NIL)
    (CHK-NEW-*1*NAME NAME)
    (COND ((OR (NOT (MATCH (FORMULA-OF SATISFACTION-LEMMA-NAME)
			   (EQUAL (CONS FN ARGS) BODY)))
	       (MEMBER-EQ FN *1*BTM-OBJECTS)
	       (ASSOC-EQ FN SHELL-ALIST))
	   (ERROR1 (PQUOTE (PROGN |the| |second| |argument| |of| REFLECT
				  |must| |be| |the| |name| |of| |a| |lemma|
				  |of| |the| |form|
				  (!PPR (QUOTE (EQUAL
						(|fn| |arg1| |...| |argn|)
						|body|)) NIL)
				  |where| |fn| |is| |not| |a| |shell|
				  |constructor|
				  |or| |bottom| |object| |function| |symbol|
				  |.| (!PPR LEMMA NIL)
				  |is| |not| |of| |this| |form| |.|))
		   (BINDINGS (QUOTE LEMMA) SATISFACTION-LEMMA-NAME)
		   (QUOTE SOFT))))
    (CHK-ARGLIST NAME ARGS)
    (SETQ BODY (TRANSLATE BODY))
    (COND ((NOT IN-BOOT-STRAP-FLG) (CHK-MEANING NAME (ALL-FNNAMES BODY))))
    (FREE-VAR-CHK NAME ARGS BODY)
    (ITERATE FOR X IN RELATION-MEASURE-LST
	     DO (COND ((NOT (AND (CONSP X) (MEMBER-EQ (CAR X) WELL-ORDERING-RELATIONS)
				 (CONSP (CDR X))
				 (NULL (CDDR X))
				 (SUBSETP-EQ (ALL-VARS (TRANSLATE (CADR X))) ARGS)))
		       (ERROR1 (PQUOTE (PROGN |Each| |member| |of| |the| |third|
					      |argument| |to| REFLECT |must| |be|
					      |of| |the| |form|
					      (!PPR (QUOTE (|rel| |term|)) NIL)
					      |,| |where| |rel| |is| |the| |name|
					      |of| |a| |well-founded| |relation|
					      |and| |term| |is| |a| |term| |all|
					      |of| |whose| |variables| |are|
					      |among| |the| |formals| |of| |the|
					      |function| |being| |defined| |.|))
			       NIL
			       (QUOTE SOFT)))))
    NIL))

(DEFUN CHK-ACCEPTABLE-REWRITE-LEMMA (NAME TYPE TERM)
  TYPE
  (ITERATE FOR X IN (UNPRETTYIFY TERM)
	   WITH (TOP-FNNAME-VAR REWRITE-RULE LHS ALL-VARS-HYPS ALL-VARS-CONCL
				MAX-TERMS LST HYPS CONCL)
	   DO
	   (SETQ HYPS (CAR X))
	   (SETQ CONCL (CDR X))
	   (SETQ TOP-FNNAME-VAR (TOP-FNNAME CONCL))
	   (COND ((ACCEPTABLE-TYPE-PRESCRIPTION-LEMMAP HYPS CONCL) T)
		 ((ACCEPTABLE-COMPOUND-RECOGNIZER-LEMMAP HYPS CONCL) T)
		 ((NULL TOP-FNNAME-VAR)
		  (ERROR1 (PQUOTE (PROGN (!PPR NAME NIL)
					 |is| |an| |unacceptable| REWRITE |lemma|
					 |because| |it| |rewrites| |a|
					 |variable| |.|))
			  (BINDINGS (QUOTE NAME) NAME)
			  (QUOTE SOFT)))
		 ((EQ TOP-FNNAME-VAR (QUOTE IF))
		  (ERROR1 (PQUOTE (PROGN (!PPR NAME NIL)
					 |is| |an| |unacceptable| REWRITE |lemma|
					 |because| |it| |rewrites| |an|
					 |IF-expression| |.|))
			  (BINDINGS (QUOTE NAME) NAME)
			  (QUOTE SOFT)))
		 ((FQUOTEP CONCL) NIL)
		 ((AND (NOT NO-BUILT-IN-ARITH-FLG)
		       (OR (MATCH CONCL (NOT (LESSP & &)))
			   (MATCH CONCL (LESSP & &))))
		  (SETQ LST (EXTERNAL-LINEARIZE CONCL T))
		  (COND ((OR (NOT (AND LST (NULL (CDR LST))))
			     (NOT (AND (CAR LST) (NULL (CDAR LST)))))
			 (ERROR1 (PQUOTE (PROGN LINEARIZE |returned| |a| |list|
						|of| |more| |than| |one| |thing|
						|,| |even| |though| |called| |on|
						|a| LESSP |atom| !))
				 NIL
				 (QUOTE HARD))))
		  (SETQ ALL-VARS-HYPS (ALL-VARS-LST HYPS))
		  (SETQ ALL-VARS-CONCL (ALL-VARS CONCL))
		  (SETQ MAX-TERMS
			(ITERATE FOR PAIR IN (ACCESS POLY ALIST (CAR (CAR LST)))
				 WHEN
				 (AND (NVARIABLEP (CAR PAIR))
				      (SUBSETP-EQ ALL-VARS-CONCL
						  (UNION-EQ (ALL-VARS (CAR PAIR))
							    ALL-VARS-HYPS))
				      (ITERATE FOR PAIR2 IN
					       (ACCESS POLY ALIST (CAR (CAR LST)))
					       WHEN (NOT (EQ PAIR2 PAIR))
					       NEVER
					       (AND (< (FORM-COUNT (CAR PAIR))
						       (FORM-COUNT (CAR PAIR2)))
						    (SUBBAGP
						     (ALL-VARS-BAG (CAR PAIR))
						     (ALL-VARS-BAG (CAR PAIR2))))))
				 COLLECT (CAR PAIR)))
		  (COND ((NULL MAX-TERMS)
			 (ERROR1 (PQUOTE (PROGN (!PPR NAME NIL)
						|is| |an| |unacceptable| REWRITE
						|lemma| |because| |the| |atom|
						|of| |its| |conclusion| |is| |a|
						LESSP |and| |it| |cannot| |be|
						|handled| |by| |our| |linear|
						|arithmetic| |package.| |To| |be|
						|acceptable,| |at| |least| |one|
						|nonvariable| |addend| |of| |the|
						|conclusion| |must| |satisfy|
						|two| |properties.| |First,| |it|
						|must| |contain| |all| |the|
						|variables| |of| |the| |lemma|
						|that| |are| |not| |in| |the|
						|hypotheses.| |Second,| |it|
						|must| |not| |be| |the| |case|
						|that| |under| |every|
						|substitution,| |the| |term| |is|
						|smaller| |than| |another|
						|addend| |of| |the| |conclusion.|
						|.|))
				 (BINDINGS (QUOTE NAME) NAME)
				 (QUOTE SOFT))))
		  (ITERATE FOR X IN MAX-TERMS WHEN (NON-RECURSIVE-DEFNP (FFN-SYMB X))
			   DO (ERROR1 (PQUOTE (PROGN
						|Note| |that| |the| |linear| |lemma|
						(!PPR NAME NIL) |is| |being| |stored|
						|under| |the| |term| (!PPR X NIL) |,|
						|which| |is| |unusual| |because| (!PPR
										  FN NIL) |is| |a| |nonrecursive|
						|function| |symbol| |.|))
				      (BINDINGS (QUOTE NAME) NAME
						(QUOTE X) X
						(QUOTE FN) (FFN-SYMB X))
				      (QUOTE WARNING)))
		  (ITERATE FOR X IN MAX-TERMS WHEN (NOT (SUBSETP-EQ ALL-VARS-HYPS
								    (ALL-VARS X)))
			   DO
			   (ERROR1 (PQUOTE (PROGN |When| |the| |linear| |lemma|
						  (!PPR NAME NIL) |is| |stored|
						  |under| (!PPR X NIL) |it|
						  |contains| |the| |free| (PLURAL?
									   VARS |variables| |variable|) (!LIST
									   VARS) |which| |will| |be| |chosen|
						  |by| |instantiating| |the| (PLURAL?
									      LST |hypotheses| |hypothesis|)
						  (!PPR-LIST LST (QUOTE |.|))))
				   (BINDINGS (QUOTE NAME)
					     NAME (QUOTE X)
					     X (QUOTE VARS)
					     (SET-DIFF ALL-VARS-HYPS (ALL-VARS X))
					     (QUOTE LST)
					     (ITERATE FOR HYP IN HYPS
						      WITH VARS = (SET-DIFF ALL-VARS-HYPS
									    (ALL-VARS X))
						      WHEN (INTERSECTP VARS (ALL-VARS HYP))
						      COLLECT
						      (PROGN (SETQ VARS
								   (SET-DIFF VARS
									     (ALL-VARS HYP))) HYP)))
				   (QUOTE WARNING)))
		  T)
		 (T (SETQ REWRITE-RULE (CREATE-REWRITE-RULE NAME HYPS CONCL NIL))
		    (SETQ ALL-VARS-HYPS (ALL-VARS-LST HYPS))
		    (SETQ ALL-VARS-CONCL (ALL-VARS (COND ((MATCH CONCL
								 (EQUAL LHS &))
							  LHS)
							 (T CONCL))))
		    (COND ((NON-RECURSIVE-DEFNP (TOP-FNNAME CONCL))
			   (ERROR1 (PQUOTE (PROGN
					     |Note| |that| |the| |rewrite| |rule|
					     (!PPR NAME NIL) |will| |be| |stored|
					     |so| |as| |to| |apply|
					     |only| |to| |terms| |with| |the|
					     |nonrecursive| |function| |symbol|
					     (!PPR FN NIL)
					     |.|))
				   (BINDINGS (QUOTE NAME) NAME
					     (QUOTE FN) (TOP-FNNAME CONCL))
				   (QUOTE WARNING))))
		    (COND ((NOT (SUBSETP-EQ ALL-VARS-HYPS ALL-VARS-CONCL))
			   (ERROR1 (PQUOTE (PROGN |Note| |that| (!PPR NAME NIL)
						  |contains| |the| |free|
						  (PLURAL? VARS |variables|
							   |variable|)
						  (!LIST VARS)
						  |which| |will| |be| |chosen|
						  |by| |instantiating| |the|
						  (PLURAL? LST |hypotheses|
							   |hypothesis|)
						  (!PPR-LIST LST (QUOTE |.|))))
				   (BINDINGS (QUOTE NAME) NAME
					     (QUOTE VARS)
					     (SET-DIFF ALL-VARS-HYPS
						       ALL-VARS-CONCL)
					     (QUOTE LST)
					     (ITERATE FOR HYP IN HYPS
						      WITH VARS = (SET-DIFF
								   ALL-VARS-HYPS
								   ALL-VARS-CONCL)
						      WHEN (INTERSECTP
							    VARS
							    (ALL-VARS HYP))
						      COLLECT
						      (PROGN (SETQ VARS
								   (SET-DIFF
								    VARS
								    (ALL-VARS HYP)))
							     HYP)))
				   (QUOTE WARNING)))
			  ((AND (ATTEMPT-TO-REWRITE-RECOGNIZER CONCL) HYPS)
			   (ERROR1 (PQUOTE (PROGN (!PPR NAME NIL)
						  |will| |slow| |down| |the|
						  |theorem-prover| |because| |it|
						  |will| |cause| |backward|
						  |chaining| |on| |every|
						  |instance| |of| |a| |primitive|
						  |type| |expression| |.|))
				   (BINDINGS (QUOTE NAME) NAME)
				   (QUOTE WARNING))))
		    (ITERATE FOR OLD-RULE IN (GET (TOP-FNNAME CONCL) (QUOTE LEMMAS))
			     UNLESS (OR (DISABLEDP
					 (ACCESS REWRITE-RULE NAME OLD-RULE))
					(META-LEMMAP OLD-RULE))
			     DO (COND ((SUBSUMES-REWRITE-RULE OLD-RULE REWRITE-RULE)
				       (ERROR1 (PQUOTE (PROGN |the| |previously|
							      |added| |lemma| |,|
							      (!PPR OLDNAME NIL) |,|
							      |could| |be| |applied|
							      |whenever| |the|
							      |newly| |proposed|
							      (!PPR NAME NIL) |could|
							      !))
					       (BINDINGS
						(QUOTE NAME)
						NAME
						(QUOTE OLDNAME)
						(ACCESS REWRITE-RULE NAME OLD-RULE))
					       (QUOTE WARNING)))
				      ((SUBSUMES-REWRITE-RULE REWRITE-RULE OLD-RULE)
				       (ERROR1 (PQUOTE (PROGN |the| |newly|
							      |proposed| |lemma| |,|
							      (!PPR NAME NIL) |,|
							      |could| |be| |applied|
							      |whenever| |the|
							      |previously| |added|
							      |lemma| (!PPR OLDNAME
									    NIL) |could| |.| / /))
					       (BINDINGS (QUOTE NAME) NAME
							 (QUOTE OLDNAME)
							 (ACCESS REWRITE-RULE
								 NAME OLD-RULE))
					       (QUOTE WARNING)))))))))

(DEFUN CHK-ACCEPTABLE-SHELL
  (SHELL-NAME BTM-FN-SYMB RECOGNIZER DESTRUCTOR-TUPLES)
  (LET (DESTRUCTOR-NAMES NAMES AXIOM-NAMES AC DV TR L FLG)

;   Check that there is a type no available.

    (NEXT-AVAILABLE-TYPE-NO)
    (ITERATE FOR TUPLE IN DESTRUCTOR-TUPLES
	     UNLESS (MATCH TUPLE (LIST & & &))
	     DO (ERROR1 (PQUOTE (PROGN |The| DESTRUCTOR-TUPLES |argument|
				       |to| ADD-SHELL |must| |be| |a| |list| |of|
				       |triples| |of| |the| |form|
				       (!PPR (QUOTE (|name|
						     (|flg| |recognizer| |...|)
						     |default-fn-symb|)) NIL)
				       |where| |name|
				       |is| |the| |name| |of| |the| |accessor| |,|
				       |flg| |is| |either| ONE-OF |or| NONE-OF |,|
				       |and|
				       |default-fn-symb| |is| |the| |function|
				       |symbol| |for| |the| |default| |value| |.|))
			(BINDINGS)
			(QUOTE SOFT)))
    (SETQ DESTRUCTOR-NAMES (ITERATE FOR TUPLE IN DESTRUCTOR-TUPLES
				    COLLECT (CAR TUPLE)))
    (SETQ NAMES (CONS SHELL-NAME
		      (CONS RECOGNIZER DESTRUCTOR-NAMES)))
    (COND (BTM-FN-SYMB (SETQ NAMES (CONS BTM-FN-SYMB NAMES))))
    (ITERATE FOR NAME IN NAMES
	     DO (CHK-NEW-NAME NAME NIL)
	     (CHK-NEW-*1*NAME NAME)
	     (COND ((EQL #\- (CHAR (STRING NAME)
				   (1- (LENGTH (STRING NAME)))))
		    (ERROR1 (PQUOTE (PROGN |Hyphen| |,| |as| |in|
					   (!PPR NAME NIL)
					   |,| |is| |not| |allowed| |as| |the|
					   |last| |character| |in| |a| |shell|
					   |name| !))
			    (BINDINGS (QUOTE NAME) NAME)
			    (QUOTE SOFT)))))
    (COND ((NOT (NO-DUPLICATESP NAMES))
	   (ERROR1 (PQUOTE (PROGN |Multiple| |use| |of| |the| |same| |name| !))
		   (BINDINGS)
		   (QUOTE SOFT))))
    (ITERATE FOR TUPLE IN DESTRUCTOR-TUPLES
	     DO
	     (MATCH TUPLE (LIST AC TR DV))
	     (COND ((AND (NOT (EQ DV (QUOTE TRUE)))
			 (NOT (EQ DV (QUOTE FALSE)))
			 (NOT (MEMBER-EQ DV *1*BTM-OBJECTS))
			 (OR (NULL BTM-FN-SYMB)
			     (NOT (EQ DV BTM-FN-SYMB))))
		    (ERROR1 (PQUOTE (PROGN |The| |default| |object| |for| |a|
					   |type-restricted| |shell|
					   |component| |must| |be| |a| |bottom|
					   |object| |function| |symbol|
					   |or| |else| |must| |be| TRUE
					   |or| FALSE !(!PPR DV NIL)
					   |is| |not| |such| |an| |object| |.|))
			    (BINDINGS (QUOTE DV) DV)
			    (QUOTE SOFT))))
	     (COND ((NOT (AND (MATCH TR (CONS FLG L))
			      (OR (EQ FLG (QUOTE ONE-OF))
				  (EQ FLG (QUOTE NONE-OF)))
			      (ITERATE FOR X IN L
				       ALWAYS (ASSOC-EQ X (CONS (CONS RECOGNIZER 0)
								RECOGNIZER-ALIST)))))
		    (ERROR1 (PQUOTE (PROGN |the| |type| |restriction| |term| |for|
					   |a| |shell| |component| |must| |be| |a|
					   |list| |of| |the| |form|
					   (!PPR (QUOTE (ONE-OF |...|)) NIL)
					   |or|
					   (!PPR (QUOTE (NONE-OF |...|)) NIL)
					   |where| |...| |is| |a| |list| |of|
					   |recognizer| |names| |.|))
			    NIL
			    (QUOTE SOFT))))
	     (COND ((NOT
		     (OR (AND (EQ DV BTM-FN-SYMB)
			      (OR (AND (EQ FLG (QUOTE ONE-OF))
				       (MEMBER-EQ RECOGNIZER L))
				  (AND (EQ FLG (QUOTE NONE-OF))
				       (NOT (MEMBER-EQ RECOGNIZER L)))))
			 (AND
			  (NOT (EQ DV BTM-FN-SYMB))
			  (EQUAL (EQUAL FLG (QUOTE ONE-OF))
				 (LOGSUBSETP
				  (CAR (TYPE-PRESCRIPTION DV))
				  (ITERATE FOR X IN L
					   WITH ITERATE-ANS = 0
					   WHEN (NOT (EQ X RECOGNIZER))
					   DO
					   (SETQ
					    ITERATE-ANS
					    (LOGIOR ITERATE-ANS
						    (CDR (ASSOC-EQ X
								   RECOGNIZER-ALIST))))
					   FINALLY (RETURN ITERATE-ANS)))))))
		    (ERROR1 (PQUOTE (PROGN |the| |default| |value| (!PPR DV NIL)
					   |does| |not| |satisfy| |the| |type|
					   |restriction| (!PPR TR NIL)
					   |specified| |for| |the| (!PPR AC NIL)
					   |component| |.|))
			    (BINDINGS (QUOTE TR) TR
				      (QUOTE DV) DV
				      (QUOTE AC) AC)
			    (QUOTE SOFT)))))
    (COND (DESTRUCTOR-NAMES
	   (ITERATE FOR TUPLE IN DESTRUCTOR-TUPLES
		    DO (MATCH TUPLE (LIST AC TR DV))
		    (SETQ AXIOM-NAMES (CONS (PACK (LIST AC (QUOTE -) SHELL-NAME))
					    AXIOM-NAMES))
		    (SETQ AXIOM-NAMES (CONS (PACK (LIST AC (QUOTE -N)
							RECOGNIZER))
					    AXIOM-NAMES))
		    (AND (NOT (EQUAL TR (QUOTE (NONE-OF))))
			 (SETQ AXIOM-NAMES
			       (CONS (PACK (LIST AC (QUOTE -TYPE-RESTRICTION)))
				     AXIOM-NAMES)))
		    (SETQ AXIOM-NAMES (CONS (PACK (LIST AC (QUOTE -LESSP)))
					    AXIOM-NAMES))
		    (SETQ AXIOM-NAMES (CONS (PACK (LIST AC (QUOTE -LESSEQP)))
					    AXIOM-NAMES)))
	   (SETQ AXIOM-NAMES (CONS (PACK (LIST SHELL-NAME (QUOTE -EQUAL)))
				   AXIOM-NAMES))
	   (SETQ AXIOM-NAMES
		 (CONS (PACK (CONS SHELL-NAME
				   (ITERATE FOR AC IN DESTRUCTOR-NAMES
					    NCONC (LIST (QUOTE -)
							AC))))
		       AXIOM-NAMES))
	   (SETQ AXIOM-NAMES
		 (CONS (PACK (NCONC1 (CDR (ITERATE FOR AC IN DESTRUCTOR-NAMES
						   NCONC (LIST (QUOTE -)
							       AC)))
				     (QUOTE -ELIM)))
		       AXIOM-NAMES))
	   (SETQ AXIOM-NAMES (CONS (PACK (LIST (QUOTE COUNT-) SHELL-NAME))
				   AXIOM-NAMES))))
    (COND ((NOT (NO-DUPLICATESP (APPEND NAMES AXIOM-NAMES)))
	   (ERROR1 (PQUOTE (PROGN |The| |addition| |of| |a| |shell|
				  |introduces|
				  |many| |new| |axiom| |names| |.| |The| |new|
				  |names| |are| |created| |from| |the| |shell|
				  |name| |,| |recognizer| |,| |bottom| |object|
				  |,||and| |destructor| |names| |supplied| |in|
				  |the| ADD-SHELL |command| |.| |The| |names|
				  |supplied| |in| |this| |instance| |of| |the|
				  ADD-SHELL |command| |do| |not| |lead| |to|
				  |distinct| |axiom| |names| |.| |the| |axiom|
				  |names| |generated| |are| |:|
				  (!LIST AXIOM-NAMES) |.|))
		   (BINDINGS (QUOTE AXIOM-NAMES) AXIOM-NAMES)
		   (QUOTE SOFT))))
    (ITERATE FOR X IN AXIOM-NAMES DO (CHK-NEW-NAME X NIL))
    T))

(DEFUN CHK-ACCEPTABLE-TOGGLE (NAME OLDNAME FLG)
  (CHK-NEW-NAME NAME NIL)
  (CHK-DISABLEABLE OLDNAME)
  (OR (EQ FLG T)
      (EQ FLG NIL)
      (ERROR1 (PQUOTE (PROGN |The| |third| |argument| |of| TOGGLE |must| |be| T
			     |or| NIL |and| (!PPR FLG NIL) |is| |not| |.|))
	      (BINDINGS (QUOTE FLG) FLG)
	      (QUOTE SOFT))))

(DEFUN CHK-ACCEPTABLE-TOGGLE-DEFINED-FUNCTIONS (NAME FLG)
  (CHK-NEW-NAME NAME NIL)
  (OR (EQ FLG T)
      (EQ FLG NIL)
      (ERROR1 (PQUOTE (PROGN |The| |third| |argument| |of| TOGGLE-DEFINED-FUNCTIONS
			     |must| |be| T
			     |or| NIL |and| (!PPR FLG NIL) |is| |not| |.|))
	      (BINDINGS (QUOTE FLG) FLG)
	      (QUOTE SOFT))))

(DEFUN CHK-ARGLIST (NAME ARGS)
  (COND ((OR (NOT (NO-DUPLICATESP ARGS))
	     (ITERATE FOR ARG IN ARGS
		      THEREIS (OR (ILLEGAL-NAME ARG)
				  (MEMBER-EQ ARG (QUOTE (T F NIL)))))
	     (CDR (OUR-LAST ARGS)))

;   T and F are merely confusing, not illegal.

	 (ERROR1 (PQUOTE (PROGN |The| |argument| |list| |to| (!PPR NAME NIL)
				|,| |i.e.,| (!PPR ARGS NIL)
				|,| |is| |not| |a| |list| |of| |distinct|
				|variables| |names| |.|))
		 (BINDINGS (QUOTE ARGS) ARGS
			   (QUOTE NAME) NAME)
		 (QUOTE SOFT)))))

(DEFUN CHK-DISABLEABLE (NAME) 

;   We permit you to disable or enable events (e.g., REVERSE and APP-IS-ASSOC)
;   satellites (e.g., PLUS and CAR-NLISTP) and *1*-functions (e.g., *1*PLUS and
;   *1*REVERSE.  We do not permit you to disable the *1*-functions for 
;   shell constructors or bottom objects because we want REWRITE to
;   return evgs when possible.

  (OR (AND (SYMBOLP NAME)
           (OR (GET NAME (QUOTE EVENT))
               (GET NAME (QUOTE MAIN-EVENT)))
           (ITERATE FOR X IN *1*BTM-OBJECTS NEVER
                 (EQ NAME (PACK (LIST STRING-WEIRD X))))
           (ITERATE FOR X IN SHELL-ALIST NEVER
                 (EQ NAME (PACK (LIST STRING-WEIRD (CAR X))))))
      (ERROR1 (PQUOTE (PROGN |A| |name| |can| |be| |disabled| |or| |enabled|
                             |only| |if| |it| |is| |the| |name| |of| |an|
                             |event| |or| |the| |name| |of| |a| |satellite|
                             |other| |than| |the| |compiled| |routine| |for|
                             |a| |shell| |constructor| |or| |bottom| |object|
                             |.| |thus| (!PPR NAME NIL) |is| |illegal| |here|
                             |.|))
              (BINDINGS (QUOTE NAME) NAME)
              (QUOTE SOFT))))
 
(DEFUN CHK-INIT ()
  (COND ((NOT (BOUNDP (QUOTE LIB-PROPS)))
         (ERROR1 (PQUOTE (PROGN |The| |theorem-prover's| |database| |has|
                                |not| |been| |initialized| |.| |you| |should|
                                |either| |call| BOOT-STRAP |or| NOTE-LIB |.|))
                 NIL
                 (QUOTE HARD)))))

(DEFUN CHK-MEANING (NAME LST)
  (LET (FNS)
    (SETQ FNS (INTERSECTION LST META-NAMES))
    (COND (FNS (ERROR1 (PQUOTE (PROGN |Use| |of| |the|
				      (PLURAL? FNS |functions| |function|)
				      (!LIST FNS) |in| |an| |axiom|
				      |or| |definition| |may| |render| |the|
				      |theory| |inconsistent| |.|))
		       (BINDINGS (QUOTE FNS) FNS)
		       (QUOTE WARNING))))
    NIL))

(DEFUN CHK-NEW-*1*NAME (NAME)
  (COND ((OR (NOT (SYMBOLP (PACK (LIST STRING-WEIRD NAME))))
	     (AND (NOT IN-BOOT-STRAP-FLG)
		  (OR (FBOUNDP (PACK (LIST STRING-WEIRD NAME)))
		      (HAS-LIB-PROPS (PACK (LIST STRING-WEIRD NAME))))))
	 (ERROR1 (PQUOTE (PROGN |the| |atom| (!PPR FN NIL)
				|,| |which| |is| |derived| |from|
				(!PPR NAME NIL)
				|and| |used| |for| |internal| |purposes| |,|
				|is| |not| |a| |literal| |atom,| |has| |a|
				LISP |function| |definition|
				|or| LIB-PROP |properties| |.| |You| |should|
				|change| |the| |name| |of| |your| |function|
				|to| |avoid| |clashes| |of| |this| |sort| |.|))
		 (BINDINGS (QUOTE NAME) NAME
			   (QUOTE FN) (PACK (LIST STRING-WEIRD NAME)))
		 (QUOTE SOFT)))))

(DEFUN CHK-NEW-NAME (NAME QUIET-FLG)

;   Checks that NAME has the correct syntax for use as a symbol in the theory
;   (and hence as an event name).  Further checks that the name has no
;   properties and is not one of the symbols about which there are syntactic
;   conventions (e.g., LIST, CADR, NIL, QUOTE).  Thus there are no axioms about
;   NAME.

  (COND ((ILLEGAL-NAME NAME)
	 (COND (QUIET-FLG NIL)
	       (T (ERROR1 (PQUOTE (PROGN (!PPR NAME NIL)
					 |is| |an| |illegal| |object| |to|
					 |use| |for| |a| |name| !))
			  (BINDINGS (QUOTE NAME) NAME)
			  (QUOTE SOFT)))))
	((PROPERTYLESS-SYMBOLP NAME)
	 (COND (QUIET-FLG NIL)
	       (T (ERROR1 (PQUOTE (PROGN |The| |name| (!PPR NAME NIL)
					 |is| |a| |reserved| |symbol|
					 |and| |cannot| |be| |used| |as| |a|
					 |user| |name| |.|))
			  (BINDINGS (QUOTE NAME) NAME)
			  (QUOTE SOFT)))))
	((HAS-LIB-PROPS NAME)
	 (COND (QUIET-FLG NIL)
	       (T (ERROR1 (PQUOTE (PROGN |Name| |currently| |in| |use| |:|
					 (!PPR NAME NIL) |.|))
			  (BINDINGS (QUOTE NAME) NAME)
			  (COND (IN-BOOT-STRAP-FLG (QUOTE WARNING))
				(T (QUOTE SOFT)))))))
	(T T)))

(DEFUN CLAUSIFY (TERM)
  (COND ((EQUAL TERM TRUE) NIL)
	((EQUAL TERM FALSE) (LIST NIL))
	((FNNAMEP-IF TERM)
	 (CLEAN-UP-BRANCHES (STRIP-BRANCHES TERM)))
	(T (LIST (LIST TERM)))))

(DEFUN CLAUSIFY-INPUT (TERM)

;   In addition to clausifying TERM, we expand ANDs in the hyps and ORs in the
;   concl, adding entries to ABBREVIATIONS-USED.

  (ITERATE FOR TERM1 IN (CLAUSIFY-INPUT1 TERM FALSE)
	COLLECT (CLAUSIFY-INPUT1 (DUMB-NEGATE-LIT TERM1)
				 TRUE)))

(DEFUN CLAUSIFY-INPUT1 (TERM BOOL)

;   If BOOL is TRUE, returns a list of terms whose disjunction is equivalent to
;   TERM.  IF BOOL is FALSE, returns a list of terms whose disjunction is
;   equivalent to the negation of TERM.  Opens up some nonrec fns and applies
;   some unconditional rewrite rules -- according to BOOL -- and side-effects
;   ABBREVIATIONS-USED.

  (LET (C1 C2 C3)
    (COND ((EQUAL TERM (NEGATE BOOL)) NIL)
	  ((MATCH TERM (IF C1 C2 C3))
	   (COND ((EQUAL BOOL TRUE)
		  (COND ((EQUAL C3 TRUE)
			 (DISJOIN-CLAUSES (CLAUSIFY-INPUT1 C1 FALSE)
					  (CLAUSIFY-INPUT1 C2 TRUE)))
			((EQUAL C2 TRUE)
			 (DISJOIN-CLAUSES (CLAUSIFY-INPUT1 C1 TRUE)
					  (CLAUSIFY-INPUT1 C3 TRUE)))
			(T (LIST TERM))))
		 (T (COND ((EQUAL C3 FALSE)
			   (DISJOIN-CLAUSES (CLAUSIFY-INPUT1 C1 FALSE)
					    (CLAUSIFY-INPUT1 C2 FALSE)))
			  ((EQUAL C2 FALSE)
			   (DISJOIN-CLAUSES (CLAUSIFY-INPUT1 C1 TRUE)
					    (CLAUSIFY-INPUT1 C3 FALSE)))
			  (T (LIST (DUMB-NEGATE-LIT TERM)))))))
	  ((SETQ C1 (EXPAND-AND-ORS TERM BOOL))
	   (CLAUSIFY-INPUT1 C1 BOOL))
	  ((EQUAL BOOL FALSE)
	   (LIST (DUMB-NEGATE-LIT TERM)))
	  (T (LIST TERM)))))

(DEFUN CLEAN-UP-BRANCHES (LST)
  (LET (PARTITIONS)
    (SETQ PARTITIONS (PARTITION-CLAUSES LST))
    (SETQ TEMP-TEMP (ITERATE FOR POCKET IN PARTITIONS
			  NCONC (ALMOST-SUBSUMES-LOOP POCKET)))
    (COND ((NULL (CDR PARTITIONS))
	   TEMP-TEMP)
	  (T (ALMOST-SUBSUMES-LOOP TEMP-TEMP)))))

(DEFUN CNF-DNF (TERM FLG)

;   If FLG is (QUOTE C), returns a list of lists, say:

;   ((p11 p12 ...) (p21 p22  ...) ...  (pn1 pn2 ...))

;   such that TERM is not equal to F iff 

;   (AND (OR p11 p12 ...) (OR p21 p22 ...) ... (OR pn1 pn2 ...))

;   is not equal to F.  The latter term is the "conjunctive normal form" of
;   TERM.  If FLG is (QUOTE D) computes the disjunctive normal form.

  (LET (P Q NF-Q)
    (COND ((OR (AND (EQ FLG (QUOTE C))
		    (MATCH TERM (AND P Q)))
	       (AND (EQ FLG (QUOTE D))
		    (MATCH TERM (OR P Q))))
	   (APPEND (CNF-DNF P FLG)
		   (CNF-DNF Q FLG)))
	  ((OR (AND (EQ FLG (QUOTE C))
		    (MATCH TERM (OR P Q)))
	       (AND (EQ FLG (QUOTE D))
		    (MATCH TERM (AND P Q))))
	   (SETQ NF-Q (CNF-DNF Q FLG))
	   (ITERATE FOR L1 IN (CNF-DNF P FLG)
		 WITH ITERATE-ANS
		 DO (SETQ ITERATE-ANS
			  (UNION-EQUAL (ITERATE FOR L2 IN NF-Q
					     COLLECT (UNION-EQUAL L1 L2))
				       ITERATE-ANS))
		 FINALLY (RETURN ITERATE-ANS)))
	  ((MATCH TERM (NOT P))
	   (ITERATE FOR L1 IN (CNF-DNF P (CASE FLG
					(D (QUOTE C))
					(OTHERWISE (QUOTE D))))
		 COLLECT (ITERATE FOR TERM IN L1
			       COLLECT (DUMB-NEGATE-LIT TERM))))
	  ((MATCH TERM (IMPLIES P Q))
	   (CNF-DNF (FCONS-TERM* (QUOTE OR) (DUMB-NEGATE-LIT P) Q)
		    FLG))
	  (T (LIST (LIST TERM))))))

(DEFUN COMMON-SWEEP (FORM)
  (LET (VAR DECISION)
    (COND ((OR (ATOM FORM) (EQ (CAR FORM) (QUOTE QUOTE))) FORM)
	  ((SETQ DECISION (ASSOC-EQ FORM DECISIONS))
	   (SETQ VAR (CDR (ASSOC-EQUAL FORM VAR-ALIST)))
	   (SUBLIS (LIST (CONS (QUOTE VAR) VAR)
			 (CONS (QUOTE FORM)
			       (CONS
				 (CAR FORM)
				 (ITERATE FOR ARG IN (CDR FORM)
				       COLLECT (COMMON-SWEEP ARG)))))
		   (CASE (CDR DECISION)
		     (TEST-AND-SET
		      (QUOTE (*2*IF (NOT (EQ VAR (QUOTE *1*X))) VAR
				  (SETQ VAR FORM))))
		     (SET (QUOTE (SETQ VAR FORM)))
		     (TEST (QUOTE (*2*IF (NOT (EQ VAR (QUOTE *1*X))) VAR FORM)))
		     (VAR (QUOTE VAR))
		     (OTHERWISE
		      (ERROR "COMMON-SWEEP:  ~A" (CDR DECISION))))))
	  (T (CONS (CAR FORM)
		   (ITERATE FOR ARG IN (CDR FORM)
			 COLLECT (COMMON-SWEEP ARG)))))))

(DEFUN COMMUTE-EQUALITIES (TERM)
  (COND ((VARIABLEP TERM) TERM)
	((FQUOTEP TERM) TERM)
	((EQ (FFN-SYMB TERM) (QUOTE EQUAL))
	 (FCONS-TERM* (QUOTE EQUAL) (FARGN TERM 2) (FARGN TERM 1)))
	(T (CONS-TERM (CAR TERM)
		      (ITERATE FOR ARG IN (FARGS TERM)
			    COLLECT (COMMUTE-EQUALITIES ARG))))))

(DEFUN COMPLEMENTARY-MULTIPLEP (WINNING-PAIR POLY1 POLY2)

;   Return T iff multiplying POLY1 by some negative integer produces POLY2.
;   WINNING-PAIR is a member of POLY1 with coefficient + or -1.

  (PROG (FACTOR)
    (COND ((NULL (SETQ TEMP-TEMP (ASSOC-EQUAL (CAR WINNING-PAIR)
					      (ACCESS POLY ALIST POLY2))))
	   (RETURN NIL)))
    (SETQ FACTOR (COND ((EQUAL (CDR WINNING-PAIR) 1)
			(CDR TEMP-TEMP))
		       (T (- (CDR TEMP-TEMP)))))
    (COND ((NOT (< FACTOR 0))
	   (RETURN NIL)))
    (RETURN (AND (EQUAL (ACCESS POLY CONSTANT POLY2)
			(* FACTOR (ACCESS POLY CONSTANT POLY1)))
		 (= (LENGTH (ACCESS POLY ALIST POLY2))
		    (LENGTH (ACCESS POLY ALIST POLY1)))
		 (ITERATE FOR PAIR1 IN (ACCESS POLY ALIST POLY1) AS PAIR2
		       IN (ACCESS POLY ALIST POLY2)
		       ALWAYS (AND (EQUAL (CAR PAIR1)
					  (CAR PAIR2))
				   (EQUAL (CDR PAIR2)
					  (* FACTOR (CDR PAIR1)))))))))

(DEFUN COMPLEMENTARYP (LIT1 LIT2)
  (OR (AND (NVARIABLEP LIT1)
	   (NOT (FQUOTEP LIT1))
	   (EQ (FFN-SYMB LIT1) (QUOTE NOT))
	   (EQUAL (FARGN LIT1 1) LIT2))
      (AND (NVARIABLEP LIT2)
	   (NOT (FQUOTEP LIT2))
	   (EQ (FFN-SYMB LIT2) (QUOTE NOT))
	   (EQUAL (FARGN LIT2 1) LIT1))))

(DEFUN COMPLEXITY (TERM)
  (COND ((VARIABLEP TERM) 0)
	((FQUOTEP TERM)

;   The level number of all function symbols in evgs is 0, so even if we
;   recursed into them with FN-SYMBs and ARGS we'd compute 0.

	 0)
	(T (+ (GET-LEVEL-NO (FFN-SYMB TERM))
	      (OR (ITERATE FOR ARG IN (FARGS TERM)
			MAXIMIZE (COMPLEXITY ARG))
		  0)))))

(DEFUN COMPRESS-POLY (POLY)
  (COND ((IMPOSSIBLE-POLYP POLY) (CHANGE POLY ALIST POLY NIL))
	((TRUE-POLYP POLY) (CHANGE POLY ALIST POLY NIL))
	(T (CHANGE POLY ALIST POLY (COMPRESS-POLY1 (ACCESS POLY ALIST POLY)))))
  POLY)

(DEFUN COMPRESS-POLY1 (ALIST)
  (COND ((ATOM ALIST) NIL)
	((EQUAL (CDAR ALIST) 0) (COMPRESS-POLY1 (CDR ALIST)))
	(T (RPLACD ALIST (COMPRESS-POLY1 (CDR ALIST))))))

(DEFUN COMPUTE-VETOES (CANDLST)

;   This function weeds out "unclean" induction candidates.  The intuition
;   behind the notion "clean" is that an induction is clean if nobody is
;   competing with it for instantiation of its variables.  What we actually do
;   is throw out any candidate whose changing induction variables -- that is
;   the induction variables as computed by INDUCT-VARS intersected with the
;   changed vars of candidate -- intersect the changed or unchanged variables
;   of another candidate.  The reason we do not care about the first candidates
;   unchanging vars is as follows.  The reason you want a candidate clean is so
;   that the terms riding on that cand will reoccur in both the hypothesis and
;   conclusion of an induction.  There are two ways to assure (or at least make
;   likely) this, change the variables in the terms as specified or leave them
;   constant.  Thus, if the first cands changing vars are clean but its
;   unchanging vars intersect another cand it means that the first cand is
;   keeping those other terms constant which is fine. (Note that the first cand
;   would be clean here.  The second might be clean or dirty depending on
;   whether its changed vars or unchanged vars intersected the first cands
;   vars.)  The reason we check only the induction vars and not all of the
;   changed vars is if cand1's changed vars include some induction vars and
;   some accumulators and the accumulators are claimed by another cand2 we
;   believe that cand1 is still clean.  The motivating example was 

;   (IMPLIES (MEMBER A C) (MEMBER A (UNION: B C)))

;   where the induction on C is dirty because the induction on B and C claims
;   C, but the induction on B and C is clean because the B does not occur in
;   the C induction.  We do not even bother to check the C from the (B C)
;   induction because since it is necessarily an accumulator it is probably
;   being constructed and thus, if it occurs in somebody elses ind vars it is
;   probably being eaten so it will be ok.  In formulating this heuristic we
;   did not consider the possibility that the accums of one candidate occur as
;   constants in the other.  Oh well.

;   JULY 20, 1978.  We have added an additional heuristic, to be applied if the
;   above one eliminates all cands.  We consider a cand flawed if it changes
;   anyone elses constants.  The motivating example was GREATEST-FACTOR-LESSP
;   -- which was previously proved only by virtue of a very ugly use of the
;   no-op fn ID to make a certain induction flawed.

  (OR (ITERATE FOR CAND1 IN CANDLST WITH CHANGING-INDVARS
	    UNLESS (PROGN (SETQ CHANGING-INDVARS
				(INTERSECTION-EQ (ACCESS CANDIDATE CHANGED-VARS
						      CAND1)
					      (INDUCT-VARS CAND1)))
			  (ITERATE FOR CAND2 IN CANDLST WHEN (NOT (EQ CAND1 CAND2))
				THEREIS (OR (INTERSECTP CHANGING-INDVARS
							(ACCESS CANDIDATE
								CHANGED-VARS
								CAND2))
					    (INTERSECTP
					     CHANGING-INDVARS
					     (ACCESS CANDIDATE
						     UNCHANGEABLE-VARS
								CAND2)))))
	    COLLECT CAND1)
      (ITERATE FOR CAND1 IN CANDLST WITH CHANGING-VARS
	    UNLESS (PROGN (SETQ CHANGING-VARS
				(ACCESS CANDIDATE CHANGED-VARS CAND1))
			  (ITERATE FOR CAND2 IN CANDLST WHEN (NOT (EQ CAND1 CAND2))
				THEREIS (INTERSECTP CHANGING-VARS
						    (ACCESS CANDIDATE
							    UNCHANGEABLE-VARS
							    CAND2))))
	    COLLECT CAND1)
      CANDLST))

(DEFUN COMSUBT1 (T1)

;   We add to GENRLTLIST every common subterm t of T1 and T2 such that t has
;   property p, and no subterm of t has property p.  Property (p x) is x is not
;   a variable and the function symbol of x is not a btm object, constructor,
;   or destructor.  We return T iff T1 is a common subterm of T2, but neither
;   T1 nor any subterm of T1 has property p.

  (PROG (FAILED)
    (COND ((OR (VARIABLEP T1) (FQUOTEP T1))
	   (RETURN (OCCUR T1 T2))))

;   After the following FOR, FAILED is set to T iff COMSUBT1 returned NIL on at
;   least one of the arguments of T1.  GENRLTLIST now contains all of proper
;   subterms of T1 that occur in T2, have property p, and have no subterms with
;   property p, by inductive hypothesis.

    (ITERATE FOR ARG IN (FARGS T1) WHEN (NOT (COMSUBT1 ARG)) DO (SETQ FAILED T))
    (COND (FAILED

;   One of T1's arguments returned NIL.  So either the argument is not a
;   subterm of T2, in which case neither is T1, or the argument or one of its
;   subterms has property p, in which case one of T1's subterms also has
;   property p.  So we return NIL and do not add T1 to GENRLTLIST.

	   (RETURN NIL))
	  ((NOT (OCCUR T1 T2))

;   If T1 does not occur in T2, then its not a common subterm -- regardless of
;   what properties its args have -- and so we return NIL and do not add T1 to
;   GENRLTLIST.

	   (RETURN NIL))
	  ((AND (NOT (SHELLP T1))
		(NOT (AND (SETQ TEMP-TEMP
				(GET (FFN-SYMB T1)
				      (QUOTE ELIMINATE-DESTRUCTORS-SEQ)))
			  (NOT (DISABLEDP (ACCESS REWRITE-RULE NAME
						  TEMP-TEMP))))))

;   The test above checks that T1 has property p.  We know that T1 occurs in
;   T2.  We also know that every argument of T1 recursively returned T and so
;   no argument nor any subterm has property p.  Therefore we add T1 to
;   GENRLTLIST.  We return NIL because T1 has property p.

	   (SETQ GENRLTLIST (ADD-TO-SET T1 GENRLTLIST))
	   (RETURN NIL))
	  (T

;   T1 does not have property p.  It is a subterm of T2, and no subterm of it
;   has property p.

	   (RETURN T)))))

(DEFUN COMSUBTERMS (T1 T2)

;   We add to GENRLTLIST every common subterm t of T1 and T2 such that t has
;   property p, and no subterm of t has property p.  Property (p x) is x is not
;   a variable and the function symbol of x is not a btm object, constructor,
;   or destructor.

  (COND ((> (CONS-COUNT T1) (CONS-COUNT T2))
	 (SWAP T1 T2)))
  (COMSUBT1 T1))

(DEFUN CONJOIN (LST IF-FLG)
  (COND ((NULL LST) TRUE)
	(T (CONJOIN2 (CAR LST)
		     (CONJOIN (CDR LST)
			      IF-FLG)
		     IF-FLG))))

(DEFUN CONJOIN-CLAUSE-SETS (LST1 LST2)
  (LET (ANS)
    (ITERATE FOR CL IN LST1 WHEN (AND (NOT (EQUAL CL TRUE-CLAUSE))
				   (NOT (MEMBER-EQUAL CL ANS)))
	  DO (SETQ ANS (CONS CL ANS)))
    (ITERATE FOR CL IN LST2 WHEN (AND (NOT (EQUAL CL TRUE-CLAUSE))
				   (NOT (MEMBER-EQUAL CL ANS)))
	  DO (SETQ ANS (CONS CL ANS)))
    ANS))

(DEFUN CONJOIN2 (P Q IF-FLG)
  (COND ((FALSE-NONFALSEP P)
	 (COND (DEFINITELY-FALSE FALSE)
	       ((FALSE-NONFALSEP Q)
		(COND (DEFINITELY-FALSE FALSE)
		      (T TRUE)))
	       ((NOT (BOOLEAN Q))
		(FCONS-TERM* (QUOTE IF)
			     Q TRUE FALSE))
	       (T Q)))
	((FALSE-NONFALSEP Q)
	 (COND (DEFINITELY-FALSE FALSE)
	       ((BOOLEAN P) P)
	       (T (FCONS-TERM* (QUOTE IF) P TRUE FALSE))))
	(IF-FLG (FCONS-TERM* (QUOTE IF)
			     P
			     (COND ((BOOLEAN Q) Q)
				   (T (FCONS-TERM* (QUOTE IF) Q TRUE FALSE)))
			     FALSE))
	(T (FCONS-TERM* (QUOTE AND) P Q))))

(DEFUN CONS-PLUS (X Y)
  (COND ((EQUAL X ZERO) Y)
	((EQUAL Y ZERO) X)
	(T (FCONS-TERM* (QUOTE PLUS) X Y))))

(DEFUN CONS-TERM (FN ARGS)

;   After great deliberation, we have decided to guarantee throughout the
;   theorem-prover that every explicit value term should be represented as an
;   evg.  Unless the function symbol of a term being constructed is known not
;   to be a constructor or bottom object, the term should be constructed using
;   CONS-TERM rather than with FCONS-TERM or FCONS-TERM*.

  (COND ((AND (ITERATE FOR ARG IN ARGS ALWAYS (QUOTEP ARG))
	      (OR (MEMBER-EQ FN *1*BTM-OBJECTS)
		  (ASSOC-EQ FN SHELL-ALIST)))

;   We wish to apply the LISP-CODE for this shell constructor or btm object to
;   the guts of each arg and QUOTE the result.  To avoid having to cons up the
;   list of guts, we will consider the common cases separately.

	 (COND ((NULL ARGS)
		(LIST (QUOTE QUOTE)
		      (FUNCALL (GET FN (QUOTE LISP-CODE)))))
	       ((NULL (CDR ARGS))
		(LIST (QUOTE QUOTE)
		      (FUNCALL (GET FN (QUOTE LISP-CODE))
			       (CADR (CAR ARGS)))))
	       ((NULL (CDDR ARGS))
		(LIST (QUOTE QUOTE)
		      (FUNCALL (GET FN (QUOTE LISP-CODE))
			       (CADR (CAR ARGS))
			       (CADR (CADR ARGS)))))
	       ((NULL (CDDDR ARGS))
		(LIST (QUOTE QUOTE)
		      (FUNCALL (GET FN (QUOTE LISP-CODE))
			       (CADR (CAR ARGS))
			       (CADR (CADR ARGS))
			       (CADR (CADDR ARGS)))))
	       (T (LIST (QUOTE QUOTE)
			(APPLY (GET FN (QUOTE LISP-CODE))
			       (ITERATE FOR ARG IN ARGS COLLECT (CADR ARG)))))))
	(T (CONS FN ARGS))))

(DEFUN CONSJOIN (LST)
  (COND ((ATOM (CDR LST)) (CAR LST))
	(T (CONS-TERM (QUOTE CONS)
		      (LIST (CAR LST)
			    (CONSJOIN (CDR LST)))))))

(DEFUN CONTAINS-REWRITEABLE-CALLP (NAME TERM)

;   This function scans the nonQUOTE part of TERM and determines whether it
;   contains a call of NAME not on TERMS-TO-BE-IGNORED-BY-REWRITE.

  (COND ((VARIABLEP TERM) NIL)
	((FQUOTEP TERM) NIL)
	((AND (EQ (FFN-SYMB TERM) NAME)
	      (NOT (MEMBER-EQUAL TERM TERMS-TO-BE-IGNORED-BY-REWRITE)))
	 T)
	(T (ITERATE FOR X IN (FARGS TERM) THEREIS (CONTAINS-REWRITEABLE-CALLP
						NAME X)))))

(DEFUN CONVERT-CAR-CDR (X)
  (LET (ANS (GUTS X))
    (ITERATE WHILE (OR (MATCH GUTS (CAR &)) (MATCH GUTS (CDR &)))
	  DO (SETQ ANS (CONS (CHAR (STRING (CAR GUTS)) 1) ANS))
	  (SETQ GUTS (CADR GUTS)))
    (COND ((> (LENGTH ANS) 1)
	   (LIST (PACK (CONS (QUOTE C)
			     (NREVERSE (CONS (QUOTE R) ANS))))
		 GUTS))
	  (T X))))

(DEFUN CONVERT-CONS (X)
  (COND ((SETQ TEMP-TEMP (LISTABLE X))
	 (APPEND (QUOTE (LIST)) TEMP-TEMP))
	(T X)))

(DEFUN CONVERT-NOT (X)
  (LET (U V)
    (COND ((MATCH X (NOT (LESSP U V)))
	   (LIST (QUOTE LEQ) V U))
	  (T X))))

(DEFUN CONVERT-QUOTE (X) 
 
;   We set PPR-MACRO-LST to NIL to prevent the pretty printer from 
;   messing up such quoted constants as '(CAR (CDR X)).  The macro 
;   list is bound in the pretty printer so we are safe here. 
 
;   CONVERT-QUOTE eliminates UGLYP evgs by printing T and F in place 
;   of *1*T and *1*F and (const 'a1 ... 'an) in place of (*1*SQM const ...). 
;   This means digging into the evg to see if ugly things are hidden inside
;   the CONS structure.  If so, we introduce CONS or LIST to expose the 
;   the ugly terms. 
 
   (SETQ PPR-MACRO-LST NIL) 
   (CONVERT-QUOTE1 (CADR X))) 
 
(DEFUN CONVERT-QUOTE1 (EVG) 
   (COND ((ATOM EVG) 
          (COND ((EQ EVG *1*T) T) 
                ((EQ EVG *1*F) (QUOTE F)) 
                ((EQ EVG NIL) NIL) 
                ((INTEGERP EVG) EVG) 
                (T (LIST (QUOTE QUOTE) EVG)))) 
         ((EQ (CAR EVG) *1*SHELL-QUOTE-MARK) 
 
;   We have to call CONVERT-QUOTE1 recursively on the arguments since 
;   this term will be printed with the macro list off. 

          (CONS (CADR EVG) 
                (ITERATE FOR ARG IN (CDDR EVG) 
                      COLLECT (CONVERT-QUOTE1 ARG)))) 
         ((UGLYP EVG) 
          (COND ((SETQ TEMP-TEMP (LISTABLE-EVG-PAIRS EVG)) 
                 (CONS (QUOTE LIST)
                       (ITERATE FOR X IN TEMP-TEMP
                             COLLECT (CONVERT-QUOTE1 X))))
                (T (LIST (QUOTE CONS)
                         (CONVERT-QUOTE1 (CAR EVG))
                         (CONVERT-QUOTE1 (CDR EVG))))))
         (T (LIST (QUOTE QUOTE) EVG))))
 
(DEFUN CONVERT-TYPE-NO-TO-RECOGNIZER-TERM (TYPE-NO ARG)
  (LET (TYPE-SET)
    (SETQ TYPE-SET (LOGBIT TYPE-NO))
    (COND ((SETQ TEMP-TEMP
		 (ITERATE FOR PAIR IN RECOGNIZER-ALIST
		       WHEN (= TYPE-SET (CDR PAIR))
		       DO (RETURN PAIR)))
	   (FCONS-TERM* (CAR TEMP-TEMP)
			ARG))
	  (T (ERROR1 (PQUOTE (PROGN
			      CONVERT-TYPE-NO-TO-RECOGNIZER-TERM
			      |called| |with| |a| |number| |not|
			      |assigned| |as| |a| |type| |no| !))
		     (BINDINGS)
		     (QUOTE HARD))))))

(DEFUN CONS-COUNT (X)
  (COND ((ATOM X) 0)
	(T (+ 1 (CONS-COUNT (CAR X)) (CONS-COUNT (CDR X))))))

;   Because terms can conceivably share subexpressions, one should not
;   count on FIXNUM arithmetic in COUNT and COUNT-IFS.

(DEFUN COUNT-IFS (TERM)
  (COND ((VARIABLEP TERM) 0)
	((FQUOTEP TERM) 0)
	((EQ (FFN-SYMB TERM) (QUOTE IF))
	 (1+ (ITERATE FOR ARG IN (FARGS TERM) SUM (COUNT-IFS ARG))))
	(T (ITERATE FOR ARG IN (FARGS TERM) SUM (COUNT-IFS ARG)))))

(DEFUN CREATE-REWRITE-RULE (NAME HYPS CONCL LOOP-STOPPER-ARG)
  (MAKE REWRITE-RULE NAME (PREPROCESS-HYPS HYPS)
	CONCL
	(OR LOOP-STOPPER-ARG (LOOP-STOPPER CONCL))))

(DEFUN DCL0 (NAME ARGS)
  (ADD-FACT NAME (QUOTE TYPE-PRESCRIPTION-LST)
	    (CONS NAME (CONS TYPE-SET-UNKNOWN
			     (ITERATE FOR X IN ARGS COLLECT NIL))))
  (ADD-FACT NAME (QUOTE LEVEL-NO) 0))

(DEFUN DECODE-IDATE (N) (POWER-REP N 100.))

(DEFUN DEFN-ASSUME-TRUE-FALSE (TERM)
  (LET (TYPE-ARG1 TYPE-ARG2 TRUE-SEG FALSE-SEG PAIR ARG1 ARG2
		  INTERSECTION LOCAL-MUST-BE-TRUE
		  LOCAL-MUST-BE-FALSE)
    (COND ((AND (NVARIABLEP TERM)
		(NOT (FQUOTEP TERM))
		(SETQ PAIR (ASSOC-EQ (FFN-SYMB TERM)
				 RECOGNIZER-ALIST)))
	   (SETQ TYPE-ARG1 (DEFN-TYPE-SET (FARGN TERM 1)))
	   (COND ((AND (NULL (CDR TYPE-ARG1))
		       (= 0 (LOGAND (CAR TYPE-ARG1)
				    (CDR PAIR))))
		  (SETQ LOCAL-MUST-BE-FALSE T))
		 ((AND (NULL (CDR TYPE-ARG1))
		       (LOGSUBSETP (CAR TYPE-ARG1)
				   (CDR PAIR)))
		  (SETQ LOCAL-MUST-BE-TRUE T))
		 (T (SETQ TRUE-SEG (LIST (CONS (FARGN TERM 1)
					       (CONS (CDR PAIR)
						     NIL))))
		    (SETQ FALSE-SEG
			  (LIST (CONS (FARGN TERM 1)
				      (CONS (LOGDIFF (CAR TYPE-ARG1)
						     (CDR PAIR))
					    (CDR TYPE-ARG1))))))))
	  ((MATCH TERM (EQUAL ARG1 ARG2))
	   (SETQ TYPE-ARG1 (DEFN-TYPE-SET ARG1))
	   (SETQ TYPE-ARG2 (DEFN-TYPE-SET ARG2))
	   (SETQ INTERSECTION (LOGAND (CAR TYPE-ARG1) (CAR TYPE-ARG2)))
	   (COND ((AND (= 0 INTERSECTION)
		       (NULL (CDR TYPE-ARG1))
		       (NULL (CDR TYPE-ARG2)))
		  (SETQ LOCAL-MUST-BE-FALSE T))
		 ((AND (NULL (CDR TYPE-ARG1))
		       (NULL (CDR TYPE-ARG2))
		       (= (CAR TYPE-ARG1) (CAR TYPE-ARG2))
		       (MEMBER-EQUAL (CAR TYPE-ARG1) SINGLETON-TYPE-SETS))
		  (SETQ LOCAL-MUST-BE-TRUE T))
		 ((AND (EQUAL TYPE-ARG1 TYPE-ARG2)
		       (= 0 (CAR TYPE-ARG1))
		       (= (LENGTH (CDR TYPE-ARG1)) 1))
		  (SETQ LOCAL-MUST-BE-TRUE T))
		 (T (SETQ TRUE-SEG
			  (LIST (CONS TERM (CONS TYPE-SET-TRUE NIL))))
		    (COND ((NOT (= (CAR TYPE-ARG1) INTERSECTION))
			   (SETQ TRUE-SEG
				 (CONS (CONS ARG1 (CONS INTERSECTION
							(UNION-EQ
							  (CDR TYPE-ARG1)
							  (CDR TYPE-ARG2))))
				       TRUE-SEG))))
		    (COND ((NOT (= (CAR TYPE-ARG2) INTERSECTION))
			   (SETQ TRUE-SEG
				 (CONS (CONS ARG2 (CONS INTERSECTION
							(UNION-EQ
							  (CDR TYPE-ARG1)
							  (CDR TYPE-ARG2))))
				       TRUE-SEG))))
		    (SETQ FALSE-SEG
			  (LIST (CONS TERM (CONS TYPE-SET-FALSE NIL))))
		    (COND ((AND (MEMBER-EQUAL (CAR TYPE-ARG2)
					SINGLETON-TYPE-SETS)
				(NULL (CDR TYPE-ARG2)))
			   (SETQ FALSE-SEG
				 (CONS (CONS ARG1
					     (CONS (LOGDIFF (CAR TYPE-ARG1)
							    (CAR TYPE-ARG2))
						   (CDR TYPE-ARG1)))
				       FALSE-SEG))))
		    (COND ((AND (MEMBER-EQUAL (CAR TYPE-ARG1)
					SINGLETON-TYPE-SETS)
				(NULL (CDR TYPE-ARG1)))
			   (SETQ FALSE-SEG
				 (CONS (CONS ARG2
					     (CONS (LOGDIFF (CAR TYPE-ARG2)
							    (CAR TYPE-ARG1))
						   (CDR TYPE-ARG2)))
				       FALSE-SEG))))
		    (COND ((AND (= 0 (CAR TYPE-ARG2))
				(= (LENGTH (CDR TYPE-ARG2)) 1)
				(MEMBER-EQ (CADR TYPE-ARG2) (CDR TYPE-ARG1)))
			   (SETQ FALSE-SEG
				 (CONS (CONS ARG1
					     (CONS (CAR TYPE-ARG1)
						   (REMOVE (CADR TYPE-ARG2)
							   (CDR TYPE-ARG1) :TEST #'EQUAL)))
				       FALSE-SEG))))
		    (COND ((AND (= 0 (CAR TYPE-ARG1))
				(= (LENGTH (CDR TYPE-ARG1)) 1)
				(MEMBER-EQ (CADR TYPE-ARG1) (CDR TYPE-ARG2)))
			   (SETQ FALSE-SEG
				 (CONS (CONS ARG2
					     (CONS (CAR TYPE-ARG2)
						   (REMOVE (CADR TYPE-ARG1)
							   (CDR TYPE-ARG2) :TEST #'EQUAL)))
				       FALSE-SEG)))))))
	  (T (SETQ TYPE-ARG1 (DEFN-TYPE-SET TERM))
	     (COND ((AND (= (CAR TYPE-ARG1) TYPE-SET-FALSE)
			 (NULL (CDR TYPE-ARG1)))
		    (SETQ LOCAL-MUST-BE-FALSE T))
		   ((AND (NULL (CDR TYPE-ARG1))
			 (= 0 (LOGAND (CAR TYPE-ARG1) TYPE-SET-FALSE)))
		    (SETQ LOCAL-MUST-BE-TRUE T))
		   (T (SETQ TRUE-SEG
			    (LIST (CONS TERM (CONS (LOGAND (CAR TYPE-ARG1)
							   (LOGNOT
							    TYPE-SET-FALSE))
						   (CDR TYPE-ARG1)))))
		      (SETQ FALSE-SEG
			    (LIST (CONS TERM (CONS TYPE-SET-FALSE NIL))))))))
    (SETQ TRUE-TYPE-ALIST (NCONC TRUE-SEG TYPE-ALIST))
    (SETQ FALSE-TYPE-ALIST (NCONC FALSE-SEG TYPE-ALIST))
    (SETQ MUST-BE-TRUE LOCAL-MUST-BE-TRUE)
    (SETQ MUST-BE-FALSE LOCAL-MUST-BE-FALSE)
    NIL))

(DEFUN DEFN-LOGIOR (X Y)
  (CONS (LOGIOR (CAR X) (CAR Y))
	(UNION-EQ (CDR X) (CDR Y))))

(DEFUN DEFN-SETUP (EVENT)
  (SETQ ORIGEVENT EVENT)
  (SETQ LAST-PROCESS (QUOTE SETUP))
  (SETQ EXPAND-LST HINTED-EXPANSIONS)
  (SETQ TERMS-TO-BE-IGNORED-BY-REWRITE NIL)
  (SETQ INDUCTION-HYP-TERMS NIL)
  (SETQ INDUCTION-CONCL-TERMS NIL)
  (SETQ STACK NIL)
  (SETQ FNSTACK NIL)
  (SETQ TYPE-ALIST NIL)
  (SETQ LITS-THAT-MAY-BE-ASSUMED-FALSE NIL)
  (SETQ CURRENT-LIT 0)
  (SETQ CURRENT-ATM 0)
  (SETQ ANCESTORS NIL)
  (INIT-LEMMA-STACK)
  (INIT-LINEARIZE-ASSUMPTIONS-STACK)
  (SETQ LAST-PRINEVAL-CHAR (QUOTE |.|))
  (RANDOM-INITIALIZATION ORIGEVENT)
  EVENT)

(DEFUN DEFN-TYPE-SET (TERM)
  (COND ((QUOTEP TERM)
	 (CONS (CAR (TYPE-PRESCRIPTION (FN-SYMB TERM))) NIL))
	((SETQ TEMP-TEMP (ASSOC-EQUAL TERM TYPE-ALIST))
	 (CDR TEMP-TEMP))
	((VARIABLEP TERM)
	 (ERROR1 (PQUOTE (PROGN DEFN-TYPE-SET |has| |found| |an| |unbound|
				|variable| |in| |the| |term| (!PPR TERM NIL)
				|.|))
		 (BINDINGS (QUOTE TERM) TERM)
		 (QUOTE HARD)))
	((EQ (FN-SYMB TERM) (QUOTE IF))
	 (DEFN-ASSUME-TRUE-FALSE (FARGN TERM 1))
	 (COND (MUST-BE-TRUE (DEFN-TYPE-SET (FARGN TERM 2)))
	       (MUST-BE-FALSE (DEFN-TYPE-SET (FARGN TERM 3)))
	       (T (DEFN-LOGIOR (DEFN-TYPE-SET2 (FARGN TERM 2)
					       TRUE-TYPE-ALIST)
			       (DEFN-TYPE-SET2 (FARGN TERM 3)
					       FALSE-TYPE-ALIST)))))
	((SETQ TEMP-TEMP (TYPE-PRESCRIPTION (FN-SYMB TERM)))
	 (DEFN-LOGIOR (CONS (CAR TEMP-TEMP) NIL)
	   (COND ((CDR TEMP-TEMP)
		  (ITERATE FOR ARG IN (SARGS TERM) AS FLG
			IN (CDR TEMP-TEMP) WITH ANS
			INITIALLY (SETQ ANS (CONS 0 NIL))
			WHEN FLG
			DO (SETQ ANS (DEFN-LOGIOR (DEFN-TYPE-SET ARG) ANS))
			FINALLY (RETURN ANS)))
		 (T (CONS 0 NIL)))))
	(T (CONS TYPE-SET-UNKNOWN NIL))))

(DEFUN DEFN-TYPE-SET2 (TERM TYPE-ALIST)
  (LET (FALSE-TYPE-ALIST) (DEFN-TYPE-SET TERM)))

(DEFUN DEFN-WRAPUP (WON-FLG)
  (SETQ WON-FLG (COND (WON-FLG (QUOTE DEFN-OK))
		      (T NIL)))
  (COND ((NOT (EQ LEMMA-STACK ORIG-LEMMA-STACK))
	 (ITERPRI T)
	 (ERROR1 (PQUOTE (PROGN DEFN-WRAPUP |found| |a| |non-trivial|
				LEMMA-STACK !))
		 (BINDINGS)
		 (QUOTE WARNING))))
  (COND ((NOT (EQ LINEARIZE-ASSUMPTIONS-STACK
	      ORIG-LINEARIZE-ASSUMPTIONS-STACK))
	 (ITERPRI T)
	 (ERROR1 (PQUOTE (PROGN DEFN-WRAPUP |found| |a| |non-trivial|
				LINEARIZE-ASSUMPTIONS-STACK !))
		 (BINDINGS)
		 (QUOTE WARNING))))
  (IO (QUOTE FINISHED)
      NIL NIL NIL (LIST WON-FLG)))

(DEFUN DEFN0 (NAME ARGS BODY RELATION-MEASURE-LST FLG)
  (LET (TRANSLATED-BODY
	CONTROL-VARS
	(ARITY-ALIST (CONS (CONS NAME (LENGTH ARGS)) ARITY-ALIST))
	(META-NAMES (CONS NAME META-NAMES)))

;   The list of comments on this function do not necessarily describe the code
;   below.  They have been left around in reverse chronology order to remind us
;   of the various combinations of preprocessing we have tried.

;   If we ever get blown out of the water while normalizing IFs in a large
;   defn, read the following comment before abandoning normalization.

;   18 August 1982.  Here we go again!  At the time of this writing the
;   preprocessing of defns is as follows, we compute the induction and type
;   info on the translated body and store under sdefn the translated body.
;   This seems to slow down the system a lot and we are going to change it so
;   that we store under sdefn the result of expanding boot strap nonrec fns and
;   normalizing IFs.  As nearly as we can tell from the comments below, we have
;   not previously tried this.  According to the record, we have tried
;   expanding all nonrec fns, and we have tried expanding boot strap fns and
;   doing a little normalization.  The data that suggests this will speed
;   things up is as follows.  Consider the first call of SIMPLIFY-CLAUSE in the
;   proof of PRIME-LIST-TIMES-LIST.  The first three literals are trivial but
;   the fourth call of SIMPLIFY-CLAUSE1 is on (NOT (PRIME1 C (SUB1 C))).  With
;   SDEFNs not expanded and normalized -- i.e., under the processing as it was
;   immediately before the current change -- there are 2478 calls of REWRITE
;   and 273 calls of RELIEVE-HYPS for this literal.  With all defns
;   preprocessed as described here those counts drop to 1218 and 174.  On a
;   sample of four theorems, PRIME-LIST-TIMES-LIST, PRIME-LIST-PRIME-FACTORS,
;   FALSIFY1-FALSIFIES, and ORDERED-SORT, the use of normalized and expanded
;   sdefns saves us 16% of the conses over the use of untouched sdefns,
;   reducing the cons counts for those theorems from 880K to 745K.  It seems
;   unlikely that this preprocessing will blow us out of the water on large
;   defns.  For the EV used in UNSOLV and for the 386L M with subroutine call
;   this new preprocessing only marginally increases the size of the sdefn.  It
;   would be interesting to see a function that blows us out of the water.
;   When one is found perhaps the right thing to do is to so preprocess small
;   defns and leave big ones alone.

;   17 December 1981.  Henceforth we will assume that the very body the user
;   supplies (modulo translation) is the body that the theorem-prover uses to
;   establish that there is one and only one function satisfying the definition
;   equation by determining that the given body provides a method for computing
;   just that function.  This prohibits our "improving" the body of definitions
;   such as (f x) = (if (f x) a a) to (f x) = a.

;   18 November 1981.  We are sick of having to disable nonrec fns in order to
;   get large fns processed, e.g., the interpreter for our 386L class.  Thus,
;   we have decided to adopt the policy of not touching the user's typein
;   except to TRANSLATE it.  The induction and type analysis as well as the
;   final SDEFN are based on the translated typein.

;   Before settling with the preprocessing used below we tried several
;   different combinations and did provealls.  The main issue was whether we
;   should normalize sdefns.  Unfortunately, the incorporation of META0-LEMMAS
;   was also being experimented with, and so we do not have a precise breakdown
;   of who is responsible for what.  However, below we give the total stats for
;   three separate provealls.  The first, called 1PROVEALL, contained exactly
;   the code below -- except that the ADD-DCELL was given the SDEFN with all
;   the fn names replaced by 1fns instead of a fancy TRANSLATE-TO-INTERLISP
;   call.  Here are the 1PROVEALL stats.  Elapsed time = 9532.957, CPU time =
;   4513.88, GC time = 1423.261, IO time = 499.894, CONSes consumed = 6331517.

;   We then incorporated META0-LEMMAS.  Simultaneously, we tried running the
;   RUN fns through DEFN and found that we exploded.  The expansion of nonrec
;   fns and the normalization of IFs before the induction analysis transformed
;   functions of COUNT 300 to functions of COUNT exceeding 18K.  We therefore
;   decided to expand only BOOT-STRAP fns -- and not NORMALIZE-IFS for the
;   purposes of induction analysis.  After the induction and type analyses were
;   done, we put down an SDEFN with some trivial IF simplification performed --
;   e.g., IF X Y Y => Y and IF bool T F => bool -- but not a NORMALIZE-IFs
;   version.  We then ran a proveall with CANCEL around as a META0-LEMMA.  The
;   result was about 20% slower than the 1PROVEALL and used 15% more CONSes.
;   At first this was attributed to CANCEL.  However, we then ran two
;   simultaneous provealls, one with META0-LEMMAS set to NIL and one with it
;   set to ((1CANCEL . CORRECTNESS-OF-CANCEL)).  The result was that the
;   version with CANCEL available used slightly fewer CONSes than the other one
;   -- 7303311 to 7312505 That was surprising because the implementation of
;   META0-LEMMAS uses no CONSes if no META0-LEMMAS are available, so the entire
;   15% more CONSes had to be attributed to the difference in the defn
;   processing.  This simultaneous run was interesting for two other reasons.
;   The times -- while still 20% worse than 1PROVEALL -- were one half of one
;   percent different, with CANCEL being the slower.  That means having CANCEL
;   around does not cost much at all -- and the figures are significant despite
;   the slop in the operating system's timing due to thrashing because the two
;   jobs really were running simultaneously.  The second interesting fact is
;   that CANCEL can be expected to save us a few CONSes rather than cost us.

;   We therefore decided to return the DEFN0 processing to its original state.
;   Only we did it in two steps.  First, we put NORMALIZE-IFs into the
;   pre-induction processing and into the final SDEFN processing.  Here are the
;   stats on the resulting proveall, which was called
;   PROVEALL-WITH-NORM-AND-CANCEL but not saved.  Elapsed time = 14594.01, CPU
;   time = 5024.387, GC time = 1519.932, IO time = 593.625, CONSes consumed
;   = 6762620.

;   While an improvement, we were still 6% worse than 1PROVEALL on CONSes.  But
;   the only difference between 1PROVEALL and PROVEALL-WITH-NORM-AND-CANCEL --
;   if you discount CANCEL which we rightly believed was paying for itself --
;   was that in the former induction analyses and type prescriptions were being
;   computed from fully expanded bodies while in the latter they were computed
;   from only BOOT-STRAP-expanded bodies.  We did not believe that would make a
;   difference of over 400,000 CONSes, but had nothing else to believe.  So we
;   went to the current state, where we do the induction and type analyses on
;   the fully expanded and normalized bodies -- bodies that blow us out of the
;   water on some of the RUN fns.  Here are the stats for
;   PROVEALL-PROOFS.79101, which was the proveall for that version. Elapsed
;   time = 21589.84, CPU time = 4870.231, GC time = 1512.813, IO time
;   = 554.292, CONSes consumed= 6356282.

;   Note that we are within 25K of the number of CONSes used by 1PROVEALL.  But
;   to TRANSLATE-TO-INTERLISP all of the defns in question costs 45K.  So -- as
;   expected -- CANCEL actually saved us a few CONSes by shortening proofs.  It
;   takes only 18 seconds to TRANSLATE-TO-INTERLISP the defns, so a similar
;   argument does not explain why the latter proveall is 360 seconds slower
;   than 1PROVEALL.  But since the elapsed time is over twice as long, we
;   believe it is fair to chalk that time up to the usual slop involved in
;   measuring cpu time on a time sharing system.

;   We now explain the formal justification of the processing we do on the body
;   before testing it for admissibility.

;   We do not work with the body that is typed in by the user but with an
;   equivalent body' produced by normalization and the expansion of
;   nonrecursive function calls in body.  We now prove that if (under no
;   assumptions about NAME except that it is a function symbol of the correct
;   arity) (a) body is equivalent to body' and (b) (name . args) = body' is
;   accepted under our principle of definition, then there exists exactly one
;   function satisfying the original equation (name . args) = body.

;   First observe that since the definition (name . args) = body' is accepted
;   by our principle of definition, there exists a function satisfying that
;   equation.  But the accepted equation is equivalent to the equation (name .
;   args) = body by the hypothesis that body is equivalent to body'.

;   We prove that there is only one such function by induction.  Assume that
;   the definition (name . args) = body has been accepted under the principle
;   of definition.  Suppose that f is a new name and that (f . args) = bodyf,
;   where bodyf results from replacing every use of name as a function symbol
;   in body with f.  It follows that (f . args) = bodyf', where bodyf' results
;   from replacing every use of name as a function symbol in body' with f.  We
;   can now easily prove that (f . args) = (name . args) by induction according
;   to the definition of name. Q.E.D.

;   One might be tempted to think that if the defn with body' is accepted under
;   the principle of definition then so would be the defn with body and that
;   the use of body' was merely to make the implementation of the defn
;   principle more powerful.  This is not the case.  For example 

;        (R X) = (IF (R X) T T)

;   is not accepted by the definitional principle, but we would accept the
;   body'-version (R X) = T, and by our proof, that function uniquely satisfies
;   the equation the user typed in.

;   One might be further tempted to think that if we changed normalize so that
;   (IF X Y Y) = Y was not applied, then the two versions were inter-acceptable
;   under the defn principle.  This is not the case either.  The function

;        (F X) = (IF (IF (X.ne.0) (F X-1) F) (F X-1) T)

;   is not accepted under the principle of defn.  Consider its normalized body.

    (DEFN-SETUP (LIST (QUOTE DEFN) NAME ARGS BODY RELATION-MEASURE-LST))
    (SETQ TRANSLATED-BODY (TRANSLATE BODY))
    (SETQ RELATION-MEASURE-LST
	  (ITERATE FOR TEMP IN RELATION-MEASURE-LST
		COLLECT (LIST (CAR TEMP) (TRANSLATE (CADR TEMP)))))
    (PUT-INDUCTION-INFO NAME ARGS TRANSLATED-BODY RELATION-MEASURE-LST NIL)
    (ADD-FACT NAME (QUOTE SDEFN)
	      (LIST (QUOTE LAMBDA)
		    ARGS
		    (NORMALIZE-IFS (EXPAND-BOOT-STRAP-NON-REC-FNS
				    TRANSLATED-BODY)
				   NIL NIL NIL)))
    (PUT-TYPE-PRESCRIPTION NAME)
    (PUT-LEVEL-NO NAME)
    (AND (GET NAME (QUOTE JUSTIFICATIONS))
	 (ADD-FACT NAME (QUOTE CONTROLLER-POCKETS)
		   (SCRUNCH (ITERATE FOR TEMP
				  IN (GET NAME (QUOTE JUSTIFICATIONS))
				  COLLECT
				  (PROGN
				    (SETQ CONTROL-VARS
					  (ACCESS JUSTIFICATION SUBSET
						  TEMP))
				    (ITERATE FOR FORMAL IN ARGS
					  AS I FROM 0 WITH ITERATE-ANS = 0
					  WHEN (MEMBER-EQ FORMAL CONTROL-VARS)
					  DO
					  (SETQ ITERATE-ANS
						(LOGIOR ITERATE-ANS
							(ASH 1 I)))
					  FINALLY (RETURN
						    ITERATE-ANS)))))))
    (COND (FLG (ADD-FACT NAME (QUOTE LISP-CODE)
			 (PACK (LIST STRING-WEIRD NAME)))
               (GUARANTEE-CITIZENSHIP (PACK (LIST STRING-WEIRD NAME))))
	  ((ITERATE FOR FN IN (ALL-FNNAMES TRANSLATED-BODY)
		 ALWAYS (OR (EQ FN NAME)
			    (GET FN (QUOTE LISP-CODE))))
	   (ADD-DCELL NAME (PACK (LIST STRING-WEIRD NAME))
		      (LIST (QUOTE LAMBDA)
			    (SETQ TEMP-TEMP
				  (ITERATE FOR ARG IN ARGS
					COLLECT (PACK
						 (LIST STRING-WEIRD3 ARG))))
			    (TRANSLATE-TO-LISP
			      (SUB-PAIR-VAR ARGS
					    TEMP-TEMP
					    TRANSLATED-BODY))))))
    (COND ((NOT (TOTAL-FUNCTIONP NAME))
	   (ERROR1 (PQUOTE (PROGN |The| |recursion| |in| (!PPR NAME NIL)
				  |is| |unjustified| |.|))
		   (BINDINGS (QUOTE NAME) NAME)
		   (QUOTE WARNING))))
    NIL))

(DEFUN DELETE1 (X L)
  (COND ((ATOM L) NIL)
	((EQUAL X (CAR L)) (CDR L))
	(T (CONS (CAR L) (DELETE1 X (CDR L))))))

(DEFUN DELETE-TAUTOLOGIES (CLAUSE-SET)
  (ITERATE FOR CL IN CLAUSE-SET
	UNLESS (ITERATE FOR TAIL ON CL
		     THEREIS (OR (AND (FALSE-NONFALSEP (CAR TAIL))
				      (NOT DEFINITELY-FALSE))
				 (MEMBER-EQUAL (NEGATE-LIT (CAR TAIL))
					 (CDR TAIL))))
	COLLECT CL))

(DEFUN DELETE-TOGGLES (XXX)
  (ITERATE FOR X IN XXX WITH N COLLECT (COND ((MATCH X (TOGGLE & N (QUOTE T)))
					   (LIST (QUOTE DISABLE)
						 N))
					  ((OR (MATCH X (TOGGLE & N
								(QUOTE NIL)))
					       (MATCH X (TOGGLE & N)))
					   (LIST (QUOTE ENABLE)
						 N))
					  (T X))))

(DEFUN DEPEND (DEPENDENT SUPPORTERS)
  (COND ((NOT (GET DEPENDENT (QUOTE EVENT)))
	 (ERROR1 (PQUOTE (PROGN DEPEND |should| |not| |be| |called| |on| |a|
				|nonevent| |such| |as| (!PPR DEPENDENT NIL)
				|.|))
		 (BINDINGS (QUOTE DEPENDENT) DEPENDENT)
		 (QUOTE HARD))))
  (SETQ SUPPORTERS (REMOVE (QUOTE GROUND-ZERO)
			   (ITERATE FOR X IN SUPPORTERS
				 WITH ITERATE-ANS
				 DO
				 (SETQ ITERATE-ANS
				       (ADD-TO-SET (MAIN-EVENT-OF X)
						   ITERATE-ANS))
				 FINALLY (RETURN ITERATE-ANS))))
  (COND ((MEMBER-EQ DEPENDENT SUPPORTERS)
	 (ERROR1 (PQUOTE (PROGN |Attempt| |to| |make| (!PPR DEPENDENT NIL)
				|depend| |upon| |itself| !))
		 (BINDINGS (QUOTE DEPENDENT) DEPENDENT)
		 (QUOTE HARD))))
  (ITERATE FOR X IN SUPPORTERS DO (ADD-FACT X (QUOTE IMMEDIATE-DEPENDENTS0)
					 DEPENDENT)))

(DEFUN DEPENDENT-EVENTS (EVENT)
  (ITERATE FOR X IN (DEPENDENTS-OF EVENT) COLLECT (GET X (QUOTE EVENT))))

(DEFUN DEPENDENTS-OF (NAME)
  (COND ((EQ NAME (QUOTE GROUND-ZERO))
	 (REVERSE CHRONOLOGY))
	((OR (NOT (SYMBOLP NAME))
	     (NOT (GET NAME (QUOTE EVENT))))
	 (ERROR1 (PQUOTE (PROGN DEPENDENTS-OF |must| |be| |given| |an| |event|
				|and| (!PPR NAME NIL) |is| |not| |one| |.|))
		 (BINDINGS (QUOTE NAME) NAME)
		 (QUOTE HARD)))
	(T (UNSTABLE-SORT (DEPENDENTS-OF1 NAME)
		 (FUNCTION
		   (LAMBDA (X Y)
		     (EVENT1-OCCURRED-BEFORE-EVENT2 X Y CHRONOLOGY)))))))

(DEFUN DEPENDENTS-OF1 (NAME)
  (COND ((EQ NAME (QUOTE GROUND-ZERO))

;   We never expect this fn to be called on GROUND-ZERO because its silly, but
;   we make it behave correctly anyway.

	 (COPY-LIST CHRONOLOGY))
	(T (CONS NAME
		 (SCRUNCH (ITERATE FOR X IN (IMMEDIATE-DEPENDENTS-OF NAME)
				NCONC (DEPENDENTS-OF1 X)))))))

(DEFUN DESTRUCTORS (CL)

;   This function returns the set of subterms of CL such that every member is
;   the application of a function to one or more distinct variables.

  (LET (ANS) (ITERATE FOR LIT IN CL DO (DESTRUCTORS1 LIT)) ANS))

(DEFUN DESTRUCTORS1 (TERM)
  (COND ((OR (VARIABLEP TERM) (FQUOTEP TERM)) NIL)
	(T (ITERATE FOR ARG IN (FARGS TERM) DO (DESTRUCTORS1 ARG))
	   (COND ((AND (FARGS TERM)
		       (ITERATE FOR ARG IN (FARGS TERM) ALWAYS (VARIABLEP ARG))
		       (NO-DUPLICATESP (FARGS TERM)))
		  (SETQ ANS (ADD-TO-SET TERM ANS)))))))

(DEFUN DISJOIN (LST IF-FLG)
  (COND ((NULL LST) FALSE)
	(T (DISJOIN2 (CAR LST) (DISJOIN (CDR LST) IF-FLG) IF-FLG))))

(DEFUN DISJOIN-CLAUSES (CL1 CL2)
  (COND ((OR (EQUAL CL1 TRUE-CLAUSE) (EQUAL CL2 TRUE-CLAUSE))
	 TRUE-CLAUSE)
	((ITERATE FOR LIT1 IN CL1 THEREIS
	       (ITERATE FOR LIT2 IN CL2
		     THEREIS (COMPLEMENTARYP LIT1 LIT2)))
	 TRUE-CLAUSE)
	(T (APPEND CL1 (SET-DIFF CL2 CL1)))))

(DEFUN DISJOIN2 (P Q IF-FLG)
  (COND ((FALSE-NONFALSEP P)
	 (COND (DEFINITELY-FALSE (COND ((FALSE-NONFALSEP Q)
					(COND (DEFINITELY-FALSE FALSE)
					      (T TRUE)))
				       ((NOT (BOOLEAN Q))
					(FCONS-TERM* (QUOTE IF)
						     Q TRUE FALSE))
				       (T Q)))
	       (T TRUE)))
	((FALSE-NONFALSEP Q)
	 (COND (DEFINITELY-FALSE (COND ((BOOLEAN P) P)
				       (T (FCONS-TERM* (QUOTE IF)
						       P TRUE FALSE))))
	       (T TRUE)))
	(IF-FLG (FCONS-TERM* (QUOTE IF)
			     P TRUE (COND ((BOOLEAN Q) Q)
					  (T (FCONS-TERM* (QUOTE IF)
							  Q TRUE FALSE)))))
	(T (FCONS-TERM* (QUOTE OR) P Q))))

(DEFUN DTACK-0-ON-END (X)
  (RPLACD (OUR-LAST X) 0) X)

(DEFUN DUMB-CONVERT-TYPE-SET-TO-TYPE-RESTRICTION-TERM
  (TYPE-SET ARG)

;   WARNING:  This function does not return a legal term.  In particular, it
;   might return (AND a b c ...).  It should be used only for io purposes.

  (LET (LST)
    (COND ((= TYPE-SET TYPE-SET-UNKNOWN) TRUE)
	  ((= TYPE-SET 0) FALSE)
	  ((= 0 (ASH TYPE-SET -31))
	   (SETQ LST (ITERATE FOR I FROM 0 TO 30
			   WHEN (NOT (= (LOGAND TYPE-SET (LOGBIT I)) 0))
			   COLLECT (CONVERT-TYPE-NO-TO-RECOGNIZER-TERM
				    I ARG)))
	   (COND ((NULL LST) FALSE)
		 ((NULL (CDR LST)) (CAR LST))
		 (T (CONS (QUOTE OR) LST))))
	  (T (SETQ LST (ITERATE FOR I FROM 0 TO 30
			     WHEN (= 0 (LOGAND TYPE-SET (LOGBIT I)))
			     COLLECT
			     (DUMB-NEGATE-LIT
			      (CONVERT-TYPE-NO-TO-RECOGNIZER-TERM I ARG))))
	     (COND ((NULL LST) TRUE)
		   ((NULL (CDR LST)) (CAR LST))
		   (T (CONS (QUOTE AND) LST)))))))

(DEFUN DUMB-IMPLICATE-LITS (L1 L2)

;   Like DUMB-NEGATE-LIT, this function may be called when TYPE-ALIST is not
;   valid.  Hence this function should not be modified to use TYPE-SET.

  (COND ((QUOTEP L1)
	 (COND ((EQUAL L1 FALSE) TRUE)
	       (T L2)))
	(T (FCONS-TERM* (QUOTE IF) L1 L2 TRUE))))

(DEFUN DUMB-NEGATE-LIT (TERM)

;   Like DUMB-IMPLICATE-LITS, this function may be called when TYPE-ALIST is
;   not valid.  Hence this function should not be modified to use TYPE-SET.

  (COND ((VARIABLEP TERM)
	 (FCONS-TERM* (QUOTE NOT) TERM))
	((FQUOTEP TERM)
	 (COND ((EQUAL TERM FALSE) TRUE)
	       (T FALSE)))
	((EQ (FN-SYMB TERM) (QUOTE NOT)) (FARGN TERM 1))
	(T (FCONS-TERM* (QUOTE NOT) TERM))))

(DEFUN DUMB-OCCUR (X Y)
  (COND ((EQUAL X Y) T)
	((VARIABLEP Y) NIL)
	((FQUOTEP Y) NIL)
	(T (ITERATE FOR ARG IN (FARGS Y) THEREIS (DUMB-OCCUR X ARG)))))

(DEFUN DUMB-OCCUR-LST (X LST)
  (ITERATE FOR TERM IN LST THEREIS (DUMB-OCCUR X TERM)))

(DEFUN DUMP (LST FILE INDENT WIDTH INDEX-FLG SCRIBE-FLG)
  (LET (PAIRS)
    (OR INDENT (SETQ INDENT 5))
    (OR WIDTH (SETQ WIDTH 68))
    (OR (NULL FILE) (EQ FILE T)
	(SETQ FILE (OPEN FILE :DIRECTION :OUTPUT)))
    (OUR-LINEL FILE WIDTH)
    (SETQ PAIRS
	  (ITERATE FOR L IN LST AS I FROM 1 COLLECT
		(PROGN
		 (COND ((SYMBOLP L) (SETQ L (GET L (QUOTE EVENT)))))
		 (CASE (CAR L)
		   (DEFN (DUMP-DEFN (NTH 1 L)
				    (NTH 2 L)
				    (NTH 3 L)
				    (NTH 4 L)
				    (AND INDEX-FLG I)))
		   (PROVE-LEMMA
		    (DUMP-PROVE-LEMMA (NTH 1 L)
				      (NTH 2 L)
				      (NTH 3 L)
				      (NTH 4 L)
				      (AND INDEX-FLG I)))
		   (ADD-AXIOM
		    (DUMP-ADD-AXIOM (NTH 1 L)
				    (NTH 2 L)
				    (NTH 3 L)
				    (AND INDEX-FLG I)))
		   (ADD-SHELL
		    (DUMP-ADD-SHELL (NTH 1 L)
				    (NTH 2 L)
				    (NTH 3 L)
				    (NTH 4 L)
				    (AND INDEX-FLG I)))
		   (DCL (DUMP-DCL (NTH 1 L)
				  (NTH 2 L)
				  (AND INDEX-FLG I)))
		   (TOGGLE (DUMP-TOGGLE (NTH 1 L)
					(NTH 2 L)
					(NTH 3 L)
					(AND INDEX-FLG I)))
		   (DISABLE (DUMP-TOGGLE NIL (NTH 1 L) NIL
					 (AND INDEX-FLG I)))
		   (ENABLE (DUMP-TOGGLE NIL (NTH 1 L) T
					(AND INDEX-FLG I)))
		   (OTHERWISE
		    (DUMP-OTHER L (AND INDEX-FLG I))))
		 (CONS (NTH 1 L) I))))
    (OR (NULL FILE) (EQ FILE T) (CLOSE FILE))
    FILE))

(DEFUN DUMP-ADD-AXIOM (NAME TYPES THM INDEX)
  (DUMP-BEGIN-GROUP FILE)
  (COND (INDEX (IPRINC INDEX FILE)
	       (IPRINC (QUOTE |.|) FILE)
	       (ISPACES (- INDENT (IPOSITION FILE NIL NIL))
			FILE))
	(T (ISPACES INDENT FILE)))
  (IPRINC (QUOTE |Axiom.  |) FILE)
  (IPRINC NAME FILE)
  (COND (TYPES (SPACES 1 FILE) (DUMP-LEMMA-TYPES TYPES)))
  (IPRINC (QUOTE |:|) FILE)
  (ITERPRI FILE)
  (ISPACES INDENT FILE)
  (PPRINDENT THM INDENT 0 FILE)
  (ITERPRI FILE)
  (DUMP-END-GROUP FILE))

(DEFUN DUMP-ADD-SHELL (CONSTRUCTOR BTM RECOG ACCESSORS INDEX)
  (DUMP-BEGIN-GROUP FILE)
  (COND (INDEX (IPRINC INDEX FILE)
	       (IPRINC (QUOTE |.|) FILE)
	       (ISPACES (- INDENT (IPOSITION FILE NIL NIL)) FILE))
	(T (ISPACES INDENT FILE)))
  (IPRINC (QUOTE |Shell Definition.|) FILE)
  (PRINEVAL (PQUOTE (PROGN / |Add| |the| |shell|
			   (!PPR CONSTRUCTOR NIL) |of| (@ N)
			   (PLURAL? ACCESSORS |arguments| |argument|)
			   |with| / (COND (BTM |bottom| |object|
						(!PPR BTM (QUOTE |,|))
						/))
			   |recognizer| (!PPR RECOG NIL)
			   |,| / (PLURAL? ACCESSORS |accessors| |accessor|)
			   (!PPR-LIST NAMES (QUOTE |,|)) /
			   (COND (FLG |type|
				      (PLURAL? ACCESSORS |restrictions|
					       |restriction|)
				      (!PPR-LIST RESTRICTIONS
						 (QUOTE  |,|)) /))
			   |and| |default| (PLURAL? ACCESSORS |values| |value|)
			   (!PPR-LIST DEFAULTS (QUOTE  |.|))))
	    (BINDINGS (QUOTE RECOG) RECOG
		      (QUOTE BTM) BTM
		      (QUOTE ACCESSORS) ACCESSORS
		      (QUOTE CONSTRUCTOR) CONSTRUCTOR
		      (QUOTE N) (LENGTH ACCESSORS)
		      (QUOTE NAMES) (ITERATE FOR X IN ACCESSORS COLLECT (CAR X))
		      (QUOTE FLG)
		      (ITERATE FOR X IN ACCESSORS
			    THEREIS (AND (NOT (EQ (CADR X) T))
					 (NOT (EQUAL (CADR X) TRUE))))
		      (QUOTE RESTRICTIONS)
		      (ITERATE FOR X IN ACCESSORS COLLECT (CADR X))
		      (QUOTE DEFAULTS)
		      (ITERATE FOR X IN ACCESSORS COLLECT (CADDR X)))
	    INDENT FILE)
  (ITERPRI FILE)
  (DUMP-END-GROUP FILE))

(DEFUN DUMP-BEGIN-GROUP (FILE)
  (COND (SCRIBE-FLG (PRINC (QUOTE |@BEGIN(GROUP)|) FILE)
		    (ITERPRI FILE)
		    (PRINC (QUOTE |@BEGIN(VERBATIM)|) FILE)
		    (ITERPRI FILE))))

(DEFUN DUMP-DCL (FN ARGS INDEX)
  (DUMP-BEGIN-GROUP FILE)
  (COND (INDEX (IPRINC INDEX FILE)
	       (IPRINC (QUOTE |.|) FILE)
	       (ISPACES (- INDENT (IPOSITION FILE NIL NIL)) FILE))
	(T (ISPACES INDENT FILE)))
  (IPRINC (QUOTE |Undefined Function.|) FILE)
  (ITERPRI FILE)
  (ISPACES INDENT FILE)
  (IPRINC (CONS FN ARGS) FILE)
  (ITERPRI FILE)
  (DUMP-END-GROUP FILE))

(DEFUN DUMP-DEFN (FN ARGS BODY HINT INDEX)
  (DUMP-BEGIN-GROUP FILE)
  (COND (INDEX (IPRINC INDEX FILE)
	       (IPRINC (QUOTE |.|) FILE)
	       (ISPACES (- INDENT (IPOSITION FILE NIL NIL)) FILE))
	(T (ISPACES INDENT FILE)))
  (IPRINC (QUOTE |Definition.|) FILE)
  (ITERPRI FILE)
  (ISPACES INDENT FILE)
  (IPRINC (CONS FN ARGS) FILE)
  (ITERPRI FILE)
  (ISPACES (+ INDENT 3) FILE)
  (IPRINC (QUOTE =) FILE)
  (ITERPRI FILE)
  (ISPACES INDENT FILE)
  (PPRINDENT BODY INDENT 0 FILE)
  (ITERPRI FILE)
  (COND (HINT (ISPACES INDENT FILE) (IPRINC (QUOTE |Hint:  |) FILE)
	      (COND ((NULL (CDR HINT))
		     (IPRINC (QUOTE |Consider the well-founded relation |)
			     FILE)
		     (IPRINC (CAR (CAR HINT)) FILE)
		     (ITERPRI FILE)
		     (ISPACES (+ 7 INDENT) FILE)
		     (IPRINC (QUOTE |and the measure |) FILE)
		     (IPRINC (CADR (CAR HINT)) FILE)
		     (ITERPRI FILE))
		    (T (PPRINDENT HINT (+ 7 INDENT) 0 FILE)
		       (ITERPRI FILE)))))
  (DUMP-END-GROUP FILE))

(DEFUN DUMP-END-GROUP (FILE)
  (COND (SCRIBE-FLG (PRINC (QUOTE |@END(VERBATIM)|) FILE)
		    (ITERPRI FILE)
		    (PRINC (QUOTE |@END(GROUP)|) FILE)
		    (ITERPRI FILE)
		    (ITERPRI FILE))))

(DEFUN DUMP-HINTS (HINT)
  (LET (USED DISABLED ENABLED (INDENT INDENT))
    (SETQ USED (CDR (ASSOC-EQ (QUOTE USE) HINT)))
    (SETQ DISABLED (CDR (ASSOC-EQ (QUOTE DISABLE) HINT)))
    (SETQ ENABLED (ITERATE FOR X IN USED WHEN (NOT (MEMBER-EQ (CAR X) DISABLED))
			COLLECT (CAR X)))
    (SETQ DISABLED (ITERATE FOR X IN DISABLED WHEN (NOT (ASSOC-EQ X USED))
			 COLLECT X))
    (SETQ HINT
	  (ITERATE FOR X IN HINT
		NCONC (CASE (CAR X)
			(USE (COND ((NULL ENABLED)
				    (LIST (CONS (QUOTE USE) USED)))
				   (T (LIST (CONS (QUOTE USE) USED)
					    (CONS (QUOTE ENABLE) ENABLED)))))
			(DISABLE
			 (COND ((NULL DISABLED) NIL)
			       (T (LIST (CONS (QUOTE DISABLE) DISABLED)))))
			(OTHERWISE (LIST X)))))
    (ISPACES INDENT FILE)
    (COND ((OR (CONSP (CDR HINT)) (AND USED (CONSP (CDR USED))))
	   (IPRINC (QUOTE |Hints:  |) FILE)
	   (SETQ INDENT (+ INDENT 8)))
	  (T (IPRINC (QUOTE |Hint:  |) FILE)
	     (SETQ INDENT (+ INDENT 7))))
    (ITERATE FOR X IN HINT DO
	  (PROGN
	   (ISPACES (- INDENT (IPOSITION FILE NIL NIL)) FILE)
	   (CASE
	    (CAR X)
	    (INDUCT (IPRINC (QUOTE |Induct as for |) FILE)
		    (IPRINC (CADR X) FILE)
		    (IPRINC (QUOTE |.|) FILE)
		    (ITERPRI FILE))
	    (USE (IPRINC (QUOTE |Consider:|) FILE)
		 (ITERPRI FILE)
		 (ITERATE FOR PAIR IN (CDR X) DO
		       (PROGN
			(ISPACES (1+ INDENT) FILE)
			(IPRINC (CAR PAIR) FILE)
			(COND ((CDR PAIR)
			       (IPRINC (QUOTE | with {|) FILE)
			       (ITERATE FOR TL ON (CDR PAIR) DO
				     (PROGN
				      (IPRINC (CAAR TL) FILE)
				      (IPRINC (QUOTE <-) FILE)
				      (IPRINC (CADR (CAR TL)) FILE)
				      (COND ((CDR TL)
					     (IPRINC (QUOTE |, |) FILE)))))
			       (IPRINC (QUOTE |}|) FILE))))
		       (ITERPRI FILE)))
	    (ENABLE (IPRINC (QUOTE |Enable|) FILE)
		    (PRINEVAL (PQUOTE (!LIST X))
			      (BINDINGS (QUOTE X) (CDR X))
			      (IPOSITION FILE NIL NIL)
			      FILE)
		    (ITERPRI FILE))
	    (DISABLE (IPRINC (QUOTE |Disable|) FILE)
		     (PRINEVAL (PQUOTE (!LIST X))
			       (BINDINGS (QUOTE X) (CDR X))
			       (IPOSITION FILE NIL NIL)
			       FILE)
		     (ITERPRI FILE))
	    (OTHERWISE
	     (PROGN (PPRIND X (IPOSITION FILE NIL NIL) 0
			    PPR-MACRO-LST FILE)
		    (ITERPRI FILE))))))))

(DEFUN DUMP-LEMMA-TYPES (TYPES)
  (IPRINC (QUOTE |(|) FILE)
  (ITERATE FOR TAIL ON TYPES DO (IPRINC (COND ((EQ (CAR TAIL)
						(QUOTE ELIM))
					    (QUOTE |elimination|))
					   ((NOT (ATOM (CAR TAIL)))
					    (CAR TAIL))
					   (T (STRING-DOWNCASE (CAR TAIL))))
				     FILE)
	(COND ((NULL (CDR TAIL)) NIL)
	      ((NULL (CDDR TAIL))
	       (IPRINC (QUOTE | and |) FILE))
	      (T (IPRINC (QUOTE |,|) FILE)
		 (ISPACES 1 FILE))))
  (IPRINC (QUOTE |)|) FILE))

(DEFUN DUMP-OTHER (X INDEX)
  (DUMP-BEGIN-GROUP FILE)
  (COND (INDEX (IPRINC INDEX FILE)
	       (IPRINC (QUOTE |.|) FILE)
	       (ISPACES (- INDENT (IPOSITION FILE NIL NIL)) FILE))
	(T (ISPACES INDENT FILE)))
  (PPRIND X (IPOSITION FILE NIL NIL) 0 PPR-MACRO-LST FILE)
  (ITERPRI FILE)
  (DUMP-END-GROUP FILE))

(DEFUN DUMP-PROVE-LEMMA (NAME TYPES THM HINT INDEX)
  (DUMP-BEGIN-GROUP FILE)
  (COND (INDEX (IPRINC INDEX FILE)
	       (IPRINC (QUOTE |.|) FILE)
	       (ISPACES (- INDENT (IPOSITION FILE NIL NIL)) FILE))
	(T (ISPACES INDENT FILE)))
  (IPRINC (QUOTE |Theorem.  |) FILE)
  (IPRINC NAME FILE)
  (COND (TYPES (ISPACES 1 FILE) (DUMP-LEMMA-TYPES TYPES)))
  (IPRINC (QUOTE |:|) FILE)
  (ITERPRI FILE)
  (ISPACES INDENT FILE)
  (PPRINDENT THM INDENT 0 FILE)
  (ITERPRI FILE)
  (COND (HINT (DUMP-HINTS HINT)))
  (DUMP-END-GROUP FILE))

(DEFUN DUMP-TOGGLE (NAME OLDNAME FLG INDEX)
  (DUMP-BEGIN-GROUP FILE)
  (COND (INDEX (IPRINC INDEX FILE)
	       (IPRINC (QUOTE |.|) FILE)
	       (ISPACES (- INDENT (IPOSITION FILE NIL NIL))
			FILE))
	(T (ISPACES INDENT FILE)))
  (COND (FLG (IPRINC (QUOTE |Disable |) FILE))
	(T (IPRINC (QUOTE |Enable |) FILE)))
  (IPRINC OLDNAME FILE)
  (IPRINC (QUOTE |.|) FILE)
  (ITERPRI FILE)
  (DUMP-END-GROUP FILE))
