#+franz (include "datamacs.l")
#-franz (in-package "USER")

(defvar $cursor nil)
(defvar $x_hint nil)
(defvar $x_restart_eqn nil)
(defvar $x_restart_seqno nil)
(defvar $x_fail nil)
(defvar $x_state nil)
(defvar $x_sub_root nil)   ; the root of sub-proof-tree generated by
                           ; x_manual_induc
(defvar $x_sub_node nil)   ; the node of sub-proof-tree
(defvar $x_lemmas   nil)   ; save lemmas
(defvar $x_rule     nil)   ; save the rule used in one-rule-rewriting
(defvar $x_rule_save nil)  ; save the rule-set
(defvar $x_op_save   nil)  ; save the $op_rules

#|
=====================================================================
  File: x_prover.lsp

  Index
    1.  x_prover                    ()
    2.  move_cursor                 ()
    3.  prove_eqn                   ()
    4.  menu_at_top                 ()
    5.  menu_for_cursor             ()
    6.  disp_strings                (string_list)
    7.  print_str                   (str)
    8.  clearscreen                 ()
    9.  disp_tree                   ()
   10.  wait-return                 ()
   11.  list_tree                   ()
   12.  list_node                   ()
   13.  cover-proof-process               (eqn step &optional num norm) 
   14.  x_auto_induc                (eqn step &optional num norm)
   15.  check_and_add               (eqn num)
   16.  x_failure_handler           (eqn num)
   17.  menu_for_failure_handler    (eqn num)
   18.  x_manual_induc              (eqn step num old_step)
   19.  menu_for_manual_induc       (eqn num)
   20.  resume_auto                 ()

=====================================================================
|#


; 1/27/92  -------------------------------------------------------------------

(defun x_prover (&aux option)
  (head_of_FRI )
  (sloop while t do
   (when  (eq option 'quit) (return nil))
   (xin-menu 
    (nodes "    list nodes of proof tree" (list_tree))
    (one-node " list one node"            (list_node))
    (tree "     display proof tree"       (disp_tree))
    (cursor "   move cursor"              (move_cursor))
    (prove  "   prove equation(s)"        (prove_eqn))
    (exit "      quit FRI" (setf option 'quit))
   )
 )
)



(defun head_of_FRI ()
  (terpri)
  (terpri)
  (disp_strings '(
"      ######################################################################"
"      #                                                                    #"
"      #             FRI: Failure-Resistant Induction Manager               #"
"      #                                                                    #"
"      ######################################################################"
))
)

; -------------------------------------------------------------------




(defun move_cursor (&aux option n)
#|
---------------------------------------------------------------------

  Parameters:  option -- user's choice on commands 
               n -- the nth child in children list

  Function: proof tree control 

  Return:  nil

  Callees: 
           

---------------------------------------------------------------------
|#
  (setf option (menu_for_cursor))
  (sloop while t do
   (when  (eq option 'quit) (return nil))
   (cond 
         ((eq option 'up) (cursor_up))
	 ((eq option 'down) 
                          (terpri)
                          (princ "  Down to which child? ")
                          (setf n (read-atom 'end))
                          (cursor_down n))
         ((eq option 'id) 
	                  (princ "  Input id : ")
                          (terpri)
                          (setf n (read-atom 'end))
                          (setf $cursor (search_by_id n (list $root)))) 
	 ((eq option 'back) (setf $cursor $root))
	 ((eq option 'cut) (cuttree $cursor))
	 ((eq option 'show) 
                           (clearscreen)
                           (show-tree $cursor)
                          ;; (wait-return)
         )
	 ( t   (terpri)
	       (princ "  Which option?  Try it again, please. "))
   )
   (terpri)
   (setf option (menu_for_cursor))
  )
)


(defun prove_eqn (&aux eqn userin lemmas)
  (prove)
  (setf lemmas $x_lemmas)
  (sloop while t do 
    (when (null lemmas) (return nil))
    (setf eqn (first lemmas))
    (setf lemmas (rest lemmas))
    (terpri)
    (princ " This lemma has not proven yet: ")
    (write-eqn eqn)
    (terpri)
    (princ " Would you like to prove above lemma? (y or n)")
    (setf userin (read-atom 'end))
    (if* (equal userin 'y) then
          (setf eqn (first-process-eqn eqn))
          (x_initial eqn)
          (setf $prove-eqn eqn)
          (setf $eqn-set (list eqn))
          (setf $induc  eqn)
          (setf $rule-set (my-copylist $x_rule_save))
          (setf $op_rules (my-copylist $x_op_save))
          (cover-induc-prove eqn))
  )
)





(defun menu_for_cursor (&aux option)
#|
---------------------------------------------------------------------

  Parameters:  option -- user's choice on commands

  Function:  display menu and get user's option number,
             then transfer number to option symbols.  

  Return:  option symbols

  Callee: disp_strings 

---------------------------------------------------------------------
|#
 (setf option 'none)
 (sloop while t do 
  (when (not (eq option 'none)) (return option))
  (clearscreen)
  (terpri)
  (disp_strings '(
"                                                       "
"    Induction proof manager in x_prover                "
"    -- move cursor around proof tree --                "
"                                                       "
"                                                       "
"       1. cursor up                                    "
"       2. cursor down                                  "
"       3. to the node with given id                    "
"       4. cursor back to root                          "
"       5. cut the children of cursor off               "
"       6. display proof tree from cursor               "
"                                                       "
"       9. quit                                         "
"                                                       "))
  (terpri)
  (terpri)
  (terpri)
  (terpri)
  (princ "    Your option number is (1-6,9) ")
  (setf option (read-atom 'end))
  (cond 
         ((eq option '1) (setf option 'up))
         ((eq option '2) (setf option 'down))
         ((eq option '3) (setf option 'id))
         ((eq option '4) (setf option 'back))
         ((eq option '5) (setf option 'cut))
         ((eq option '6) (setf option 'show))     

         ((eq option '9) (setf option 'quit))     

         ( t   (setf option 'none)
	       (setq $in-port nil)
	       (terpri)
	       (princ " Which option?  Try it again, please. "))
  )
 )   
)

(defun disp_strings (string_list)
  (dolist (str string_list nil)
    (print_str str))
)

(defun print_str (str)
  (princ str)
  (terpri)
)

(defun clearscreen (&aux n)
  (setf n '1)
  (sloop while t do
    (when (eq n '5) (return nil))
    (setf n (+ n 1))
    (princ "")
    (terpri))
)

(defun disp_tree ()
;  (clearscreen)
  (terpri)
  (show-tree $cursor)
  (terpri) (terpri)
; (wait-return)
)

(defun wait-return ()
  (terpri)
  (terpri)
  (disp_strings '(""))
  (princ "     Press <return> to continue ......    ")

;  (clear-input)
;  (read-char)
;  (read-char)
)

(defun list_tree ()
;  (clearscreen)
  (terpri)
  (show-tree-info $cursor)
; (wait-return)
)

 
(defun list_node ()
  (terpri)
  (princ "The current node is : ") (terpri) (terpri)
  (print-node $cursor)
  (format t "~&Source:~a  State:~a  Status:~a "
               (node-source $cursor) (node-state $cursor) (node-status $cursor))
  (terpri)
  (write-eqn (node-info $cursor))
;  (wait-return)
)


; -- new1.lsp --
; -- 10/04/90
; -- 10/09/90
; -- 10/11/90

(defun x_auto_induc (eqn step &optional num norm  &aux l2 x-result )
  ; This is basically the same as old cover-proof-process.
  ; Return t iff "eqn" is a theorem.

  (if* (and norm (null eqn ))
      then (setf x-result t); eqn is normalized to nil.
      elseif (falsep (lhs eqn)) ;  (variablep (lhs eqn))
      then (if* (> $trace_flag 1) then 
	       (terpri) (princ "Fail on") (write-seq-eqn num eqn))
           (setf $x_fail 'false) ; record the reason of failure
	   (if* (endp num) (setf $xnode (search_by_eqn eqn (list $root)))
                          (setf $xnode (search-tree num $root)))
           (setf (node-status $xnode) 'fail)
	   (setf (node-source $xnode) $x_fail)
           (setf x-result nil)
;      elseif (and (eq (op-of (lhs eqn)) 'and) (truep (rhs eqn))) 
;      then (setf x-result (prove-split-bool 'lhs-and eqn step num))
;      elseif (and (nonvarp (rhs eqn)) (eq (op-of (rhs eqn)) 'and))
;      then (setf x-result (prove-split-bool 'rhs-and eqn step num))
;      elseif (and (eq (op-of (lhs eqn)) 'or) (truep (rhs eqn))) 
;      then (setf x-result (prove-split-bool 'lhs-or eqn step num))
;      elseif (and (nonvarp (rhs eqn)) (eq (op-of (rhs eqn)) 'or))
;      then (setf x-result (prove-split-bool 'rhs-or eqn step num))
      elseif (is-previous-induc-eqn eqn $induc-eqns num) then (setf x-result t)
      elseif (is-failed-induc-eqn eqn $failed-eqns num) then
                (setf $x_fail 'failed)
		(if* (endp num) (setf $xnode (search_by_eqn eqn (list $root)))
		               (setf $xnode (search-tree num $root)))
		(setf (node-status $xnode) 'fail)
		(setf (node-source $xnode) $x_fail)
                (setf x-result nil)
      elseif (and num 
		  (setq l2 (ctx eqn))
		  (setq l2 (remove-irrelevant2 eqn (ctx eqn)))
		  (eq (car l2) 'fail))                        
      then (terpri) (princ "The induction hypotheses are not applicable in: ")
           (terpri) (princ "   ") (write-seq-eqn num eqn)
	   (setq eqn (cdr l2))
	   (if*  (and $case-cond 
		      (setq l2 (build-premises-from-cond-term eqn)))
		 then (setq x-result (proof-under-new-premises l2 eqn num step))
		 elseif (and $case-bool 
			     (setq l2 (build-premises-from-bool-term eqn)))
		 then (setq x-result (proof-under-new-premises l2 eqn num step t))
		 elseif (setq l2 (induc-subsumed-by eqn $induc-eqns))
		 then
		 (if* (> $trace_flag 1) then 
		      (terpri) 
		      (princ "The above equation is subsumed by the conjecture:")
		      (terpri) (princ "    ") (write-eqn l2)
		      (princ "    so we consider it as a failure.") (terpri))
		 (push eqn $failed-eqns)
		 (setf x-result (abstract-proof eqn num step))
;-- try to fix bugs ------------------------------------------------------
               (if* (null x-result) then
                    (setf $x_fail 'subsumed)
		    (if* (endp num)
			  (setf $xnode (search_by_eqn eqn (list $root)))
		          (setf $xnode (search-tree num $root)))
		    (setf (node-status $xnode) 'fail)
		    (setf (node-source $xnode) $x_fail))
                x-result 
;--------------------------------------------------------------------------
	       elseif (< step 1) 
	       then (if* (> $trace_flag 1) then 
			(terpri) 
			(princ (uconcat "The last proof failed at step "
					$step-deep "."))
			(terpri))
                    (setf $x_fail 'too-deep)
		    (if* (endp num)
			  (setf $xnode (search_by_eqn eqn (list $root)))
		          (setf $xnode (search-tree num $root)))
		    (setf (node-status $xnode) 'fail)
		    (setf (node-source $xnode) $x_fail)
	            (setf x-result nil)
	       else 
                    (setf x-result (x_cover-proof-process2 eqn num (- step 2))))
      else
      (if* l2 then (setq eqn l2))
      (setf x-result (x_cover-proof-process2 eqn num step))))



   

(defun check_and_add (eqn num &aux result)
#|
---------------------------------------------------------------------

  Parameters: eqn -- the given equation
              num -- the label of eqn

  Function:   check whether eqn is in proof tree; if not, add it in;

  Return:  t -- eqn was added in the proof tree sucessfully;
           nil -- eqn was in there, adding is not necessary.

---------------------------------------------------------------------
|#
  (setf $xnode (search_by_eqn eqn (list $root)))
  (if* (equal $xnode '(not find)) then
         (cond ((endp num) (add_child $leaf nil nil $seq-no $x_state 
                                            nil eqn )
		           (setf $leaf $xnode) ;new node is in $xnode
			   (setf $seq-no (+ 1 $seq-no)))
	       ( t   (setf $peek (search-tree (butlast num) $root))
		     (add_child $peek num nil $seq-no $x_state
                                      nil eqn )
		     (setf $seq-no (+ 1 $seq-no)))
         )
         (setf result t)
      else
         (setf result nil)
  )
)


; -- new2.lsp

(defmacro xin-menu (&rest options)
  (let ((option-list (list* 'help (mapcar 'car options)))
        (choice (gensym)))
    `(let ((,choice nil))
       (do ((failed nil nil)
	    (ans nil))
	   (nil)
	 (setq ,choice (progn () (print-head ',option-list)
			      (choose-str (read-atom 'none) ',option-list)))
	 (if* (numberp ,choice) 
	   then (setq ans ,choice) 
	   else (setq ans (caseq ,choice
				 ,@(sloop for xa in options 
					 collect `(,(car xa) . ,(cddr xa)))
			    (t (setq failed t)
			       (if* (eq ,choice 'help) 
				   then 
				   (terpri)
				   (princ "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~") (terpri)
				   (princ "HELP         print this message.") (terpri)
				   ,@(sloop for xa in options
					   collect `(princ ',(car xa))
					   collect `(princ "    ")
					   collect `(princ ',(cadr xa)) 
					   collect '(terpri))
				   (princ "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
				   (terpri)
				   (terpri)
				   elseif (eq ,choice 'quit)
				   then (setq failed nil)
				   else (princ "Please select an option from the list.") (terpri))
			       ))))
	 (if (not failed) (return ans)) ))))

(defun x_failure_handler (eqn num &aux result id eqn-id back)
  ;; return variable result, modify global variable $x_hint
  ;;     result,     $x_hint
  ;;       nil         nil       not used
  ;;       nil         t         restart from eqn
  ;;       t           nil       no restart eqn
  ;;       t           t         restart from equation other than eqn
  (setq eqn-id (node-seqno $xnode)) ; save id # of current eqn
  (head_of_failure_handler eqn num)
  (setf result t
        $x_hint nil)
  (setf back nil) (terpri)
  (sloop while t do
	 (xin-menu (nodes "    list nodes of proof tree" (list_tree))
		   (one-node " list one node"            (list_node))
		   (tree "     display proof tree"       (disp_tree))
		   (cursor "   move cursor"              (move_cursor))
		   (restart "  restart the proof "        
                      (princ " Please indicate the id #: ")
                      (setf id (read-atom 'end))
                      (setf $xnode (search_by_id id (list $root)))
		      (if* (equal $xnode '(not find)) then
			   (princ " Invalid id, try again.") (terpri)
			 else
                           (setf $x_restart_eqn   (node-info  $xnode))
                           (setf $x_restart_seqno (node-seqno $xnode))
                           (setf $x_hint t)
                           (if* (eq eqn-id id) then (setf result nil)
                                               else (setf result t))
			   (setf back t))
                   )
		   (exit "     return to auto-prove"    (setf back t))
		   (abort "    abort the proof"  (terpri)
				(*throw 'prove '*abort*))
         )
	 (if* back then (return result))
  )
)



(defun head_of_failure_handler(eqn num)
  (terpri)
  (princ "    The proof failed at node #")
  (princ (node-seqno $xnode))
  (princ " : ")
  (terpri)
  (write-seq-eqn num eqn)
  (terpri)
  (cond ((equal $x_fail 'false) 
                   (princ " Because it is disproved."))
	((equal $x_fail 'failed) 
                   (princ " Because it has been previously disproved."))
        ((equal $x_fail 'too-deep)
	           (princ " Because this proof step is too deep."))
        ((equal $x_fail 'ctx-size)
                   (princ " Because the ctx has too many premises."))
        ((equal $x_fail 'no-scheme)
                   (princ " Because no proper induction scheme."))
        ((equal $x_fail 'gen-lemma)
                   (princ " Because generated lemmas do not work."))
	( t        nil))
  (terpri)
  (terpri)
  (disp_strings '(
"      ********************************************"
"      *         Failure Handler Of FRI           *"
"      ********************************************"
))
)


; -- new4.lsp --


; -- 10/07/90 --
; -- 8/21/91 --

(defun x_manual_induc (eqn step num old_step &aux option result)
  (setf $step-deep old_step) ; recover the step-deep
  (setf $xnode (search_by_id $x_restart_seqno (list $root)))
  (setf $x_hint nil)
  (setf $x_fail 'none)
  (setf $x_rule_save (my-copylist $rule-set))
  (setf $x_op_save   (my-copylist $op_rules))

;;  (debug-msg "In manual_induc: ")

  (cuttree $xnode)

  (head_of_manual_induc eqn num)
  (setf result eqn)
  (setf $x_sub_root $xnode) 

  (sloop while t do
   (when  (eq option 'quit) (return result))
   (xin-menu
    (hypothesis "reduction by induction hypothesis" 
                         (setf result (x_one_rule 'hypothesis result num)))
    (new-rule "  reduction by a new rule"
                         (setf result (x_one_rule 'new_rule result num)))
    (old-rule "  reduction by an old rule"
                         (setf result (x_one_rule 'old_rule result num)))
    (reverse "   reduction by a reversed old rule"
                         (setf result (x_one_rule 'old_rev result num)))
    (continue "  resume automatic proof" (resume_auto)
                                       (setq option 'quit))
    (assumed "   assume true" 
	                       (setf $xnode (search-tree num $root))
                               (setf (node-source $xnode) 'assumed)
	                       (setf (node-status $xnode) 'lemma)
                               (setf result nil)
			       (setf option 'quit))
    (induction " induction on terms chosen by user"
	                       (setf result (x_induc eqn step num))
			       (setf option 'quit))
    (abort "     abort the proof"  (terpri)
				(*throw 'prove '*abort*))
    (exit "      quit manual reduction" (setf option 'quit))
   )
 )
)



(defun head_of_manual_induc (eqn num)
  (terpri)
  (princ "    The equation to prove is :")
  (terpri)
  (write-seq-eqn num eqn)
  (terpri)
  (terpri)
  (disp_strings '(
"      +--------------------------------------------------------------------+"
"      |                   Manual Induction Proof Manager                   |"
"      +--------------------------------------------------------------------+"
))
)


; -- 10/08/90 --


(defun resume_auto ()
  (setf $x_hint nil)
  (setf $failed-eqns nil)
  (setf $x_fail 'none))



; -- 10/22/90 --


; (defun cload (file)  (compile-file file)  (load file))
