/*
 *              Otter 3.0 -- Automated Deduction System
 *
 *                   Argonne National Laboratory
 *
 */

#define IN_MAIN  /* so that global vars in header.h will not be external */
#include "header.h"

 int main(argc, argv)
     int argc;
     char **argv;
{
    struct clause *giv_cl;
    int errors, status, level, first_of_next_level;
    char *str;
    
    non_portable_init();
    print_banner(argc, argv);
    init();

    read_all_input(argc, argv);
    errors = Stats[INPUT_ERRORS];
    if (errors != 0) {
	fprintf(stderr, "\n%d input errors were found.\007\n\n", errors);
	printf("%d input errors were found.\n", errors);
	exit(INPUT_ERROR_EXIT);
	}
    else {
#if 0
	if (Flags[BUILD_PROOF_OBJECT].val) {
	    match_clauses(Passive->first_cl, Passive->first_cl->next_cl);
	    exit(5);
	    }
#endif
	status = check_stop();
	giv_cl = extract_given_clause();
	level = 0;
	first_of_next_level = 0;

/* --------------------- MAIN LOOP STARTS HERE --------------------- */

	printf("\n=========== start of search ===========\n"); fflush(stdout);

	while (giv_cl != NULL && status == KEEP_SEARCHING) {

	    if (Flags[SOS_QUEUE].val && giv_cl->id >= first_of_next_level) {
		level++;
		first_of_next_level = next_cl_num();
		printf("\nStarting on level %d, last kept clause of level %d is %d.\n\n", level, level-1, first_of_next_level-1);
		fprintf(stderr, "\nStarting on level %d, last kept clause of level %d is %d.\007\n\n", level, level-1, first_of_next_level-1);
		}

	    Stats[CL_GIVEN]++;

	    if (Flags[PRINT_GIVEN].val) {
		printf("\ngiven clause #%ld: ", Stats[CL_GIVEN]);
		printf("(wt=%d) ", giv_cl->weight);
		print_clause(stdout, giv_cl); fflush(stdout);
		}
#if defined(DOS_GCC) || defined(TURBO_C) || defined(THINK_C)
	    /* if DOS or Macintosh, so user knows something is happening */
            fprintf(stderr, ".");
            if (Stats[CL_GIVEN] % 50 == 0)
		fprintf(stderr, " %ld clauses given.\n", Stats[CL_GIVEN]);
#endif
	    index_lits_clash(giv_cl);
	    append_cl(Usable, giv_cl);
	    infer_and_process(giv_cl);

	    if (Parms[INTERRUPT_GIVEN].val > 0 &&
		Stats[CL_GIVEN] % Parms[INTERRUPT_GIVEN].val == 0) {
		fprintf(stderr, "\007\n%d clauses have been given.\n", Stats[CL_GIVEN]);
		interact();
		}

	    status = check_stop();
	    if (status == KEEP_SEARCHING) {
		if (Parms[CHANGE_LIMIT_AFTER].val == Stats[CL_GIVEN]) {
		    int new_limit;
		    new_limit = Parms[NEW_MAX_WEIGHT].val;
		    Parms[MAX_WEIGHT].val = new_limit;
		    printf("\nreducing weight limit to %d.\n", new_limit);
		    }
		giv_cl = extract_given_clause();
		}

	    if (status == KEEP_SEARCHING && giv_cl && Parms[REPORT].val > 0)
		report();

	    }  /* end of main loop */

/* --------------------- MAIN LOOP ENDS HERE --------------------- */

	/* print the reason the search ended */

	if (status == KEEP_SEARCHING) {
	    status = SOS_EMPTY_EXIT;
	    fprintf(stderr, "\nSearch stopped because sos empty.\007\n\n");
	    printf("\nSearch stopped because sos empty.\n");
	    }
	else {
	    switch (status) {
	      case MAX_GIVEN_EXIT: str = "max_given"; break;
	      case MAX_GEN_EXIT: str = "max_gen"; break;
	      case MAX_KEPT_EXIT: str = "max_kept"; break;
	      case MAX_SECONDS_EXIT: str = "max_seconds"; break;
	      default: str = "???"; break;
		}

	    fprintf(stderr, "\nSearch stopped by %s option.\007\n\n", str);
	    printf("\nSearch stopped by %s option.\n", str);
	    }

	cleanup();
	exit(status);
	}

}  /* main */

/*************
 *
 *    void print_banner(argc, argv)
 *
 *************/

void print_banner(argc, argv)
     int argc;
     char **argv;
{
    int i;
    printf("----- Otter 3.0.2, June 1994 -----\n");
    printf("The job was started by %s on %s, %s",
	   username(), hostname(), get_time());

    printf("The command was \"");
    for(i = 0; i < argc; i++)
        printf("%s%s", argv[i], (i < argc-1 ? " " : ""));
    printf("\".\n\n");
}  /* print_banner */

