/*
 *  dp_util.c -- 
 *
 */

#include "header.h"

#define FUNCTION 0
#define RELATION 1

 struct {
     int type;
     char *name;
     int arity;
     char *properties;
     } Syms[100];

 int Num_syms;

 int Dp_sn, Eq_sn, Lt_sn;

/*************
 *
 *   first_nonvar_arg_term()
 *
 *************/

static struct term *first_nonvar_arg_term(t, check)
struct term *t;
int check;
{
    struct rel *r;
    struct term *t1;
    int check_args;

    check_args = (t->sym_num != Dp_sn);

    if (check && t->type != VARIABLE)
	return(t);
    else {
	for (r = t->farg; r; r = r->narg) {
	    if (t1 = first_nonvar_arg_term(r->argval, check_args))
		return(t1);
	    }
	return((struct term *) NULL);
	}
}  /* first_nonvar_arg_term */

/*************
 *
 *   first_nonvar_arg()
 *
 *************/

static struct term *first_nonvar_arg(c)
struct clause *c;
{
    struct literal *lit;
    struct term *t;

    for (lit = c->first_lit; lit; lit = lit->next_lit) {
	if (t = first_nonvar_arg_term(lit->atom, 0))
	    return(t);
	}
    return((struct term *) NULL);
}  /* first_nonvar_arg */

/*************
 *
 *    build_binary_term
 *
 *************/

static struct term *build_binary_term(sn, t1, t2)
int sn;
struct term *t1, *t2;
{
    struct term *t;
    struct rel *r1, *r2;

    t = get_term(); t->type = COMPLEX; t->sym_num = sn;
    r1 = get_rel(); r1->argval = t1;
    r2 = get_rel(); r2->argval = t2;
    t->farg = r1; r1->narg = r2;
    return(t);
}  /* build_binary_term */

/*************
 *
 *   replace_term()
 *
 *************/

static struct term *replace_term(t, ct, vt)
struct term *t, *ct, *vt;
{
    if (term_ident(t, ct))
	return(copy_term(vt));
    else {
	struct rel *r;
	for (r = t->farg; r; r= r->narg)
	    r->argval = replace_term(r->argval, ct, vt);
	return(t);
	}
}  /* replace_term */

/*************
 *
 *   dp_clause()
 *
 *************/

static void dp_p_clause(c)
struct clause *c;    
{
    struct literal *lit;
    struct term *atom, *t1;
    struct rel *r;

    for (lit = c->first_lit; lit; lit = lit->next_lit) {
	if (lit != c->first_lit)
	    printf("   ");
	if (!lit->sign)
	    printf("-");
	atom = lit->atom;
	if (atom->sym_num == Dp_sn) {
	    t1 = atom->farg->argval;
	    printf("%s", sn_to_str(t1->sym_num));
	    for (r = t1->farg; r; r = r->narg) {
		printf(" v%d", r->argval->varnum);
		}
	    printf(" v%d", atom->farg->narg->argval->varnum);
	    }
	else {
	    printf("%s", sn_to_str(atom->sym_num));
	    for (r = atom->farg; r; r = r->narg) {
		printf(" v%d", r->argval->varnum);
		}
	    }
	}
    printf(" .\n");
}  /* dp_p_clause */

/*************
 *
 *   collect_symbols()
 *
 *************/

static void collect_symbols(t, type)
struct term *t;
int type;
{
    int i;
    struct rel *r;

    if (t->type == VARIABLE)
	return;

    for (i = 0; i < Num_syms; i++) {
	if (str_ident(Syms[i].name, sn_to_str(t->sym_num)))
	    break;
	}
    if (i < Num_syms) {
	if (Syms[i].arity != sn_to_arity(t->sym_num))
	    abend("collect_symbols, multiple arity");
	}
    else {
	Syms[i].arity = sn_to_arity(t->sym_num);
	Syms[i].type = type;
	Syms[i].name = sn_to_str(t->sym_num);

	if (str_ident(Syms[i].name, "=") && Syms[i].arity == 2)
	    Syms[i].properties = "equality";
	else if (str_ident(Syms[i].name, "<") && Syms[i].arity == 2)	
	    Syms[i].properties = "order";
	else
	    Syms[i].properties = "-----";

	Num_syms++;
	}
    for (r = t->farg; r; r = r->narg)
	collect_symbols(r->argval, FUNCTION);
}  /* collect_symbols */

/*************
 *
 *   occurrences_cl()
 *
 *************/

static int occurrences_cl(t, c)
struct term *t;
struct clause *c;
{
    struct literal *l;
    int n = 0;

    for (l = c->first_lit; l; l = l->next_lit)
	n += occurrences(t, l->atom);
    return(n);
}  /* occurrences_cl */

/*************
 *
 *   operate()
 *
 *************/

int operate(c, dp, ep)
struct clause *c, **dp, **ep;
{
    struct clause *d, *e;
    struct literal *curr, *prev;
    struct term *t;
    int lits[MAX_VARS];  /* lits[i] is index of Dp_eq literal with right side var i */
    int v, v1, v2, l1, l2, i;

    for (i = 0; i < MAX_VARS; i++)
	lits[i] = -1;

    /* Assume all Dp_eq lits first, and in Dp_lit, var is second arg. */

    for (curr = c->first_lit, i = 0; curr; prev = curr, curr = curr->next_lit, i++) {
	if (curr->atom->sym_num == Dp_sn) {
	    t = curr->atom->farg->narg->argval;
	    if (occurrences_cl(t, c) == 2)
		lits[t->varnum] = i;
	    }
	else if (curr->atom->sym_num == Eq_sn && curr->sign) {
	    v1 = curr->atom->farg->argval->varnum;
	    v2 = curr->atom->farg->narg->argval->varnum;
	    if (lits[v1] >= 0 && lits[v2] >= 0) {
		l1 = lits[v1]; l2 = lits[v2];
		prev->next_lit = curr->next_lit;

		for (curr = c->first_lit, i = 0; i < l1; curr = curr->next_lit, i++);
		curr->atom->farg->narg->argval->varnum = v1;
		for (curr = c->first_lit, i = 0; i < l2; curr = curr->next_lit, i++);
		curr->atom->farg->narg->argval->varnum = v1;

		d = cl_copy(c);
		e = cl_copy(c);
		for (curr = d->first_lit, i = 0; i < l1; curr = curr->next_lit, i++);
		curr->sign = 1;
		for (curr = e->first_lit, i = 0; i < l2; curr = curr->next_lit, i++);
		curr->sign = 1;
		*dp = d; *ep = e;
		return(1);
		}
	    }
	}

    return(0);
}  /* operate */

/*************
 *
 *   clause_to_clauses()
 *
 *************/

static struct list *clause_to_clauses(c)
struct clause *c;
{
    struct list *l;
    struct clause *d, *e, *f;
    l = get_list();
    append_cl(l, c);
    d = l->first_cl;
    while (d) {
	if (operate(d, &e, &f)) {
	    insert_after_cl(d, e);
	    insert_after_cl(e, f);
	    rem_from_list(d);
	    d = e;
	    }
	else
	    d = d->next_cl;
	}
    return(l);
}  /* clause_to_clauses */

/*************
 *
 *   process_negative_equalities()
 *
 *************/

static void process_negative_equalities(c)
struct clause *c;
{
    struct literal *curr, *prev, *l;
    struct term *t1, *t2, *v, *t;

    curr = c->first_lit;
    prev = NULL;
    while (curr) {
	if (curr->atom->sym_num == Eq_sn && !curr->sign) {
	    t1 = curr->atom->farg->argval;
	    t2 = curr->atom->farg->narg->argval;
	    v = NULL;
	    if (t1->type == VARIABLE && !occurs_in(t1, t2)) {
		v = t1; t = t2;
		}
	    else if (t2->type == VARIABLE && !occurs_in(t2, t1)) {
		v = t2; t = t1;
		}

	    if (v) {
		if (prev)
		    prev->next_lit = curr->next_lit;
		else
		    c->first_lit = curr->next_lit;
		for (l = c->first_lit; l; l = l->next_lit)
		    l->atom = replace_term(l->atom, v, t);
		}
	    else
		prev = curr;
	    }
	else
	    prev = curr; 

	curr = curr->next_lit;
	}
}  /* process_negative_equalities */

/*************
 *
 *   check_transformed_clause()
 *
 *************/

static void check_transformed_clause(c)
struct clause *c;     
{
    struct clause *d;
    struct literal *l;

    d = cl_copy(c);
    for (l = d->first_lit; l; l = l->next_lit) {
	if (l->atom->sym_num == Dp_sn)
	    l->atom->sym_num = Eq_sn;
	}
    process_negative_equalities(d);
    renumber_vars(d);
    printf("%% Check: ");
    p_clause(d);
}  /* check_transformed_clause */

/*************
 *
 *   questionable_process()
 *
 *************/

static void questionable_process(c)
struct clause *c;
{
    struct literal *l1, *l2;
    struct term *v;
    int ok;

    /* If a pos eq has a var on the right that does not occur in
     * another literal, and the left is not a variable,
     * then replace Eq_sn with Dp_sn.  This
     * simplifies the result, and I think it is complete.
     */
    for (l1 = c->first_lit; l1; l1 = l1->next_lit) {
	if (l1->sign && l1->atom->sym_num == Eq_sn &&
	    l1->atom->farg->narg->argval->type == VARIABLE &&
	    l1->atom->farg->argval->type != VARIABLE) {
	    v = l1->atom->farg->narg->argval;
	    ok = 1;
	    for (l2 = c->first_lit, ok = 1; l2 && ok; l2 = l2->next_lit)
		ok = (l1 == l2 || !occurs_in(v, l2->atom));
	    if (ok)
		l1->atom->sym_num = Dp_sn;
	    }
	}
}  /* questionable_process */

/*************
 *
 *   dp_transform()
 *
 *************/

void dp_transform()
{
    struct clause *c, *d, *e;
    struct term *t, *a, *t1, *t2;
    struct rel *r;
    struct literal *lit, *l2;
    struct list *l;
    int i, j, k;
    char *s;
    int vnum = MAX_VARS;

    Parms[STATS_LEVEL].val = 0;

    Dp_sn = str_to_sn("DP_EQUALITY", 2);
    Eq_sn = str_to_sn("=", 2);
    Lt_sn = str_to_sn("<", 2);

    printf("%% =======START OF DP INPUT=======.\n\n");

    for (c = Usable->first_cl; c; c = c->next_cl) {
	for (lit = c->first_lit; lit; lit = lit->next_lit) {
	    collect_symbols(lit->atom, RELATION);
	    }
	}

    for (c = Passive->first_cl; c; c = c->next_cl) {
	a = c->first_lit->atom;
	if (sn_to_arity(a->sym_num) != 2)
	    abend("dp_transform, wrong arity in passive list.");

	for (i = 0; i < Num_syms; i++) {
	    if (str_ident(Syms[i].name, sn_to_str(a->farg->argval->sym_num)))
		break;
	    }

	if (i == Num_syms)
	    abend("dp_transform, symbol not found");

	if (is_symbol(a, "properties", 2))
	    Syms[i].properties = sn_to_str(a->farg->narg->argval->sym_num);
	else if (!is_symbol(a, "assign", 2))  /* handle assigns below */
	    abend("dp_transform, passive command not understood");
	}

    for (i = 0; i < Num_syms; i++) {
	if (Syms[i].type == RELATION)
	    { s = "relation"; j = Syms[i].arity; }
	else
	    { s = "function"; j = Syms[i].arity + 1; }
	printf("%s %s %d %s\n", s, Syms[i].name, j, Syms[i].properties);
	}

    printf("end_of_symbols\n\n");
	       
    for (c = Usable->first_cl; c; c = c->next_cl) {
	printf("\n%% "); p_clause(c);
	d = cl_copy(c);

	questionable_process(d);

	t = first_nonvar_arg(d);
	while (t) {
	    lit = get_literal();
	    lit->next_lit = d->first_lit;
	    d->first_lit = lit;
	    lit->sign = 0;
	    t1 = copy_term(t);
	    t2 = get_term();
	    t2->type = VARIABLE;
	    t2->varnum = ++vnum;
	    lit->atom = build_binary_term(Dp_sn, t1, t2);
	    for (lit = lit->next_lit; lit; lit = lit->next_lit)
		lit->atom = replace_term(lit->atom, t, t2);
	    t = first_nonvar_arg(d);
	    }


	process_negative_equalities(d);

	if (renumber_vars(d) == 0)
	    abend("dp_transform, too many variables");

	l = clause_to_clauses(cl_copy(d));

	if (l->first_cl->next_cl) {
	    printf("%% ");
	    dp_p_clause(d);
	    }

	for (e = l->first_cl; e; e = e->next_cl) {
	    renumber_vars(e);
	    check_transformed_clause(e);
	    dp_p_clause(e);
	    }
	}
    printf("end_of_clauses\n\n");

    for (c = Passive->first_cl; c; c = c->next_cl) {
	a = c->first_lit->atom;

	if (is_symbol(a, "assign", 2)) {

	    for (i = 0; i < Num_syms; i++) {
		if (str_ident(Syms[i].name, sn_to_str(a->farg->argval->sym_num)))
		    break;
		}

	    if (Syms[i].type == FUNCTION) {
		if (!str_int(sn_to_str(a->farg->narg->argval->sym_num), &j))
		    abend("dp_transform, bad integer in passive assignment");
		}
	    else {
		s = sn_to_str(a->farg->narg->argval->sym_num);
		if (!str_ident(s, "T") && !str_ident(s, "F"))
		    abend("dp_transform, bad truth value in passive assignment");
		}
	    printf("%s%s",
		   (Syms[i].type == RELATION && str_ident(s, "F") ? "-" : ""),
		   Syms[i].name);
	    for (r = a->farg->argval->farg; r; r = r->narg) {
		if (!str_int(sn_to_str(r->argval->sym_num), &k))
		    abend("dp_transform, bad integer in passive assignment");
		printf(" %d", k);
		}
	    if (Syms[i].type == FUNCTION)
		printf(" %d\n", j);
	    else
		printf("\n");
	    }
	}

    printf("end_of_assignments\n");
    printf("\n%% =======END OF DP INPUT=======.\n");

    exit(0);
}  /* dp_transform */

