/*
 *  cos.h -- preprocessor definitions of indices for arrays of
 *  flags, parameters, statistics, clocks, and internal flags.
 *
 */

/*************
 *
 *    Flags are boolean valued options.  To install a new flag, append
 *    a new name and index to the end of this list, then insert code to
 *    initialize it in the routine `init_options'.
 *    Example access:  if (Flags[PARA_FROM_LEFT].val) {
 *    See routine `init_options' for defaults.
 *
 *************/

#define MAX_FLAGS           100  /* increase if necessary */

#define SOS_QUEUE 1 /* first clause on sos is given clause */
#define SOS_STACK 2 /* pick last sos clause as given clause */
#define INPUT_SOS_FIRST 3 /* use input sos before generated sos */
#define INTERACTIVE_GIVEN 4 /* user selects given cls interactively */
#define PRINT_GIVEN 5 /* print given clauses */
#define PRINT_LISTS_AT_END 6 /* print clause lists at end of run */

#define BINARY_RES 7 /* binary resolution */
#define HYPER_RES 8 /* hyperresolution */
#define NEG_HYPER_RES 9 /* negatve hyperresolution inf rule */
#define UR_RES 10 /* UR-resolution */
#define PARA_INTO 11 /* `into' paramodulation inference rule */
#define PARA_FROM 12 /* `from' paramodulation inference rule */
#define DEMOD_INF 13 /* apply demodulation as an inference rule */

#define PARA_FROM_LEFT 14 /* allow paramodulation from left sides */
#define PARA_FROM_RIGHT 15 /* allow paramodulation from right sides */
#define PARA_INTO_LEFT 16 /* allow paramodulation into left args of = */
#define PARA_INTO_RIGHT 17 /* allow paramodulation into right args of = */
#define PARA_FROM_VARS 18 /* allow paramodulation from variables */
#define PARA_INTO_VARS 19 /* allow paramodulation into variables */
#define PARA_FROM_UNITS_ONLY 20 /* from clause must be unit */
#define PARA_INTO_UNITS_ONLY 21 /* into clause must be unit */
#define PARA_SKIP_SKOLEM 22 /* Skolem function restriction strategy */
#define PARA_ONES_RULE 23 /* paramod only into first args of terms */
#define PARA_ALL 24 /* paramodulate all occurrences of into term */

#define DETAILED_HISTORY 25 /* store literal numbers and position vectors */
#define ORDER_HISTORY 26 /* Nucleus number first for hyper, UR. */
#define UNIT_DELETION 28 /* unit deletion processing */
#define DELETE_IDENTICAL_NESTED_SKOLEM 29 /* delete clauses containing */
#define SORT_LITERALS 30 /* sort literals in pre_process */
#define FOR_SUB 31 /* forward subsumption */
#define BACK_SUB 35 /* back subsumption */
#define FACTOR 38 /* factor during post_process */

#define DEMOD_HISTORY 39 /* build history in demodulation */
#define ORDER_EQ 40 /* flip equalities (+ and -) if right arg heavier */
#define EQ_UNITS_BOTH_WAYS 41 /* nonoriented eq units both ways */
#define DEMOD_LINEAR 42 /* use linear search instead of index tree */
#define DEMOD_OUT_IN 43 /* demodulate outside-in, (leftmost) */
#define DYNAMIC_DEMOD 44 /* dynamic addition of demodulators */
#define DYNAMIC_DEMOD_ALL 45 /* try to make all equalities into demodulators */
#define DYNAMIC_DEMOD_LEX_DEP 46 /* allow lex-dep dynamic demodulators */
#define BACK_DEMOD 47 /* back demodulation */
#define KNUTH_BENDIX 48 /* Attempt Knuth-Bendix completion */
#define LRPO 49 /* lexicographic recursive path ordering */
#define LEX_ORDER_VARS 50 /* consider variables when lex_checking terms */
#define SYMBOL_ELIM 51 /* orient equalities to eliminate symbols */

#define CHECK_ARITY 55 /* require symbols to have fixed arities */
#define PROLOG_STYLE_VARIABLES 57 /* vars start with A-Z */
#define ECHO_INCLUDED_FILES 60 /* Echo input from included files */
#define SIMPLIFY_FOL 59 /* attempt to simplify during cnf translation */
#define PROCESS_INPUT 58 /* process input usable and sos */

#define VERY_VERBOSE 27 /* print generated clauses */
#define PRINT_KEPT 32 /* print kept clauses */
#define PRINT_PROOFS 33 /* print all proofs found */
#define PRINT_NEW_DEMOD 34 /* print new demodultors */
#define PRINT_BACK_DEMOD 37 /* print back demodulated clauses */
#define PRINT_BACK_SUB 36 /* print back subsumed clauses */
#define DISPLAY_TERMS 56 /* print terms in internal format */
#define PRETTY_PRINT 61 /* Pretty print requested by Boyle */

#define INDEX_FOR_BACK_DEMOD 79 /* index (FPA) all terms for back demod */
#define FOR_SUB_FPA 52 /* forward subsump with FPA, not index tree */
#define NO_FAPL 53 /* don't FPA index all positive literals */
#define NO_FANL 54 /* don't FPA index all negative literals */

#define CONTROL_MEMORY 62 /* automatically adjust max_weight */
#define ORDER_HYPER 63 /* ordered hyperresolution (satellites) */
#define PROPOSITIONAL 64 /* some propositional optimizations */
#define REALLY_DELETE_CLAUSES 65 /* delete back demod and back_subed cls */
#define ATOM_WT_MAX_ARGS 66 /* weight of atom is max of weights of arguments */
#define TERM_WT_MAX_ARGS 67 /* weight of term is max of weights of arguments */
#define FREE_ALL_MEM 68 /* free all memory to avail lists at end of run */

/* Fringe */

#define AUTO                 69  /* otter picks the strategy */
#define ANCESTOR_SUBSUME     70  /* ancestor subsumption */
#define INPUT_SEQUENT        71  /* input clauses in sequent notation */
#define OUTPUT_SEQUENT       72  /* output clauses in sequent notation */
#define GEOMETRIC_RULE       73  /* RP's inference rule, with unification */
#define GEOMETRIC_REWRITE    74  /* RP's inference rule as a rewrite */
#define LINKED_UR_RES        75  /* linked UR resolution inference rule */

#define LINKED_UR_TRACE 76 /* trace linked UR res inference rule */
#define LINKED_SUB_UNIT_USABLE 77 /* use Usable list to subsume subsumable */
                            /* intermediate unit clauses or target   */
                            /* during linked UR resolution.          */
#define LINKED_SUB_UNIT_SOS 78 /* use Sos list to subsume subsumable */
                            /* intermediate unit clauses or target   */
                            /* during linked UR resolution.          */
#define LINKED_UNIT_DEL 80 /* use Unit Deletion during linked UR resolution. */
                           /* Any unit cl in Usable or Sos list that resolves*/
                           /* a non-target literal without instantiating it */
                           /* will be the only resolver against that literal.*/
#define LINKED_TARGET_ALL 81 /* If set, all literals are targets. */

#define LINKED_HYPER_RES  82  /* Linked hyper inference rule */

#define PROG_SYNTHESIS    83  /* program synthesis mode */

/* others */

#define PROG_SYNTHESIS    83  /* program synthesis mode */
#define BIRD_PRINT        84  /* output a(_,_) terms in CL notation */

/* end of Flags */

/*************
 *
 *    Parms are integer valued options.  To install a new parm, append
 *    a new name and index to the end of this list, then insert code to
 *    initialize it in the routine `init_options'.
 *    Example access:  if (Parms[FPA_LITERALS].val == 4) {
 *    See routine `init_options' for defaults.
 *
 *************/

#define MAX_PARMS       30  /* increase if necessary */

#define REPORT           1  /* output stats and times every n seconds */

#define MAX_SECONDS      2  /* stop search after this many seconds */
#define MAX_GEN          3  /* stop search after this many generated clauses */
#define MAX_KEPT         4  /* stop search after this many kept clauses */
#define MAX_GIVEN        5  /* stop search after this many given clauses */
#define MAX_MEM          6  /* stop search after this many K bytes allocated */

#define MAX_LITERALS     7  /* max # of lits in kept clause (0 -> no limit) */
#define MAX_WEIGHT       8  /* maximum weight of kept clauses */
#define MAX_DISTINCT_VARS 9  /* max # of variables in kept clause */

#define FPA_LITERALS     10  /* FPA indexing depth for literals */
#define FPA_TERMS        11  /* FPA indexing depth for terms */

#define PICK_GIVEN_RATIO 12  /* pick lightest n times, then pick first */
#define INTERRUPT_GIVEN  13  /* call interact after this many given cls */
#define DEMOD_LIMIT      14  /* Limit on number of rewrites per clause */
#define MAX_PROOFS       15  /* stop search after this many empty clauses */
#define MIN_BIT_WIDTH    16  /* minimum field for bit strings */
#define NEG_WEIGHT       17  /* add this value to wight of negative literals */
#define PRETTY_PRINT_INDENT 22 /* indent for pretty print */
#define STATS_LEVEL      18  /* higher stats_level -> output more statistics */

/* fringe */

#define CHANGE_LIMIT_AFTER  19 /* replace reduce_weight_limit */
#define NEW_MAX_WEIGHT      20 /* replace reduce_weight_limit */
#define GEO_GIVEN_RATIO     21 /* like pick_given_ratio, for geo children */

#define MAX_UR_DEPTH        23 /* max depth for linked UR (normal depth = 0) */
#define MAX_UR_DED_SIZE     24 /* max resolutions in a single linked UR */

#define HEAT                26 /* maximum heat level */
#define DYNAMIC_HEAT_WEIGHT 27 /* max weigth of dynamic hot clause */

/* end of Parms */

/*************
 *
 *    Statistics.  To install a new statistic, append a new name and index
 *    to the end of this list, then insert the code to output it in the
 *    routine `print_stats'.
 *    Example access:  Stats[INPUT_ERRORS]++;
 *
 *************/

#define MAX_STATS        50

#define INPUT_ERRORS      0
#define CL_INPUT          1
#define CL_GENERATED      2
#define CL_KEPT           3
#define CL_FOR_SUB        4
#define CL_BACK_SUB       5
#define CL_TAUTOLOGY      6
#define CL_GIVEN          7
#define CL_WT_DELETE      8
#define REWRITES          9
#define UNIT_DELETES      11
#define EMPTY_CLAUSES     12
#define FPA_OVERLOADS     13  /* not output if 0 */
#define FPA_UNDERLOADS    14  /* not output if 0 */
#define CL_VAR_DELETES    15  /* not output if 0 */
#define FOR_SUB_SOS       16
#define NEW_DEMODS        17
#define CL_BACK_DEMOD     18
#define LINKED_UR_DEPTH_HITS 19
#define LINKED_UR_DED_HITS   20
#define SOS_SIZE             21
#define K_MALLOCED           22
#define CL_NOT_ANC_SUBSUMED  23

/* end of Otter 2.2 Stats */

#define USABLE_SIZE          24
#define DEMODULATORS_SIZE    25
#define DEMOD_LIMITS         26  /* not output if 0 */
#define INIT_WALL_SECONDS    27
#define BINARY_RES_GEN       28
#define HYPER_RES_GEN        29
#define NEG_HYPER_RES_GEN    30
#define UR_RES_GEN           31
#define PARA_INTO_GEN        32
#define PARA_FROM_GEN        33
#define LINKED_UR_RES_GEN    34
#define GEO_GEN              35
#define DEMOD_INF_GEN        36
#define FACTOR_GEN           37
#define HOT_GENERATED        38
#define HOT_KEPT             39
#define FACTOR_SIMPLIFICATIONS 40

#ifdef ROO
#define ROO_B_PRIME_HELP      (MAX_STATS-2)
#define ROO_ALMOST_KEPT       (MAX_STATS-1)
#endif

/* end of Stats */

/*************
 *
 *    Clocks.  To install a new clock, append a new name and index
 *    to the end of this list, then insert the code to output it in the
 *    routine `print_times'.  Example of use: CLOCK_START(INPUT_TIME),
 *    CLOCK_STOP(INPUT_TIME),  micro_sec = clock_val(INPUT_TIME);.
 *    See files macros.h and clocks.c.
 *
 *************/

#define MAX_CLOCKS          50
 
#define INPUT_TIME           0
#define CLAUSIFY_TIME        1
#define PROCESS_INPUT_TIME   2

#define BINARY_TIME          3
#define HYPER_TIME           4
#define NEG_HYPER_TIME       5
#define UR_TIME              6
#define PARA_INTO_TIME       7
#define PARA_FROM_TIME       8
#define LINKED_UR_TIME       9

#define PRE_PROC_TIME       10
#define RENUMBER_TIME       11
#define DEMOD_TIME          12
#define ORDER_EQ_TIME       13
#define UNIT_DEL_TIME       14
#define WEIGH_CL_TIME       15
#define SORT_LITS_TIME      27
#define FOR_SUB_TIME        16
#define DEL_CL_TIME         17
#define KEEP_CL_TIME        18
#define PRINT_CL_TIME       19
#define CONFLICT_TIME       20
#define NEW_DEMOD_TIME      21

#define POST_PROC_TIME      22
#define BACK_DEMOD_TIME     23
#define BACK_SUB_TIME       24
#define FACTOR_TIME         25

#define UN_INDEX_TIME       26
#define HOT_TIME            28
#define FACTOR_SIMP_TIME    29


#ifdef ROO
#define TASK_BP_TIME                 (MAX_CLOCKS-7)
#define PROCESS_TIME_NODE_LIST       (MAX_CLOCKS-6)
#define MASTER_WORK_TIME             (MAX_CLOCKS-5)
#define TASK_A_TIME                  (MAX_CLOCKS-4)
#define TASK_B_TIME                  (MAX_CLOCKS-3)
#define TASK_C_TIME                  (MAX_CLOCKS-2)
#define TASK_D_TIME                  (MAX_CLOCKS-1)
#endif

/* end of Otter 2.2 Clocks */


/* end of Clocks */

/*************
 *
 *    internal flags--invisible to users
 *
 *************/

#define MAX_INTERNAL_FLAGS   10

#define SPECIAL_UNARY_PRESENT 0
#define DOLLAR_PRESENT        1
#define LEX_VALS_SET          2
#define REALLY_CHECK_ARITY    3

