#
#  makefile for building FormEd.
#
#  DFLAGS controls conditional compilation:
#    -DTP_UNIX specifies basic UNIX compliation.
#    -DTP_SUN enables something cute, but it seems to work only on Suns.
#    -DTP_NO_STDLIB is necessary on some UNIXes, because stdlib.h is missing.
#    (-DTURBO_C is for PC.)
#    (-DTHINK_C is for Macintosh.)
#    (-DROO is for ROO, the shared-memory parallel version.)

DFLAGS = -DTP_UNIX -DTP_SUN

#LIBRARIES = -lc 
LFLAGS = -g

LIBS = -lXaw -lXmu -lXext -lXt -lX11 -lm
INCLUDES = -I/usr/X11/mit

# GNU C Ccompiler
# CC = gcc

# optimized
CFLAGS = -O $(DFLAGS) -I/usr/X11/mit

# save symbols for dbx
#CFLAGS = -g $(DFLAGS) -I/usr/X11/mit

# gprof profiling
#CFLAGS = -pg -O $(DFLAGS) -I/usr/X11/mit

FILES =   av.c io.c share.c fpa.c clocks.c unify.c demod.c weight.c imd.c is.c clause.c options.c resolve.c index.c paramod.c formula.c process.c misc.c lrpo.c linkur.c linkhyp.c display.c callbacks.c

OBJECTS = av.o io.o share.o fpa.o clocks.o unify.o demod.o weight.o imd.o is.o clause.o options.o resolve.o index.o paramod.o formula.o process.o misc.o lrpo.o linkur.o linkhyp.o display.o callbacks.o

formed : formed.o $(OBJECTS)
	$(CC) $(CFLAGS) formed.o $(OBJECTS) $(LIBRARIES) $(LIBS) -o formed

lint:
	lint $(DFLAGS) formed.c $(FILES)

#proto:
#	csh make_proto formed.c $(FILES)

main.o $(OBJECTS): header.h
main.o $(OBJECTS): types.h
main.o $(OBJECTS): macros.h
# main.o $(OBJECTS): cos.h
# main.o $(OBJECTS): proto.h
display.o callbacks.o formed.o: formed.h
