#include "Options.h"

 struct flag Flags[MAX_FLAGS];
 struct parm Parms[MAX_PARMS];

/*************
 *
 *    init_options()
 *
 *************/

void init_options(void)
{
    int i;
    struct flag *f;
    struct parm *p;

    for (i = 0; i < MAX_FLAGS; i++)
	Flags[i].name = "";
    for (i = 0; i < MAX_PARMS; i++)
	Parms[i].name = "";

    /* Flags are Boolean-valued options */

    f = &(Flags[PRINT_MODELS]);
    f->name = "print_models";
    f->val = 0;

    f = &(Flags[SUBSUME]);
    f->name = "subsume";
    f->val = 0;

    /* Parms are integer-valued options */

    p = &(Parms[MAX_MEM]);
    p->name = "max_mem";
    p->min = 0;
    p->max = INT_MAX;
    p->val = 16000;

    p = &(Parms[MAX_SECONDS]);
    p->name = "max_seconds";
    p->min = 0;
    p->max = INT_MAX;
    p->val = INT_MAX;

    p = &(Parms[MAX_MODELS]);
    p->name = "max_models";
    p->min = 1;
    p->max = INT_MAX;
    p->val = INT_MAX;

}  /* init_options */

/*************
 *
 *    print_options(fp)
 *
 *************/

void print_options(FILE *fp)
{
    int i, j;

    fprintf(fp, "\n--------------- options ---------------\n");

    j = 0;
    for (i = 0; i < MAX_FLAGS; i++)  /* print set flags */
	if (Flags[i].name[0] != '\0') {
            fprintf(fp, "%s", Flags[i].val ? "set(" : "clear(");
	    fflush(stdout);
	    fprintf(fp, "%s). ", Flags[i].name);
	    fflush(stdout);
	    j++;
	    if (j % 3 == 0)
	        fprintf(fp, "\n");
	    fflush(stdout);
            }

    fprintf(fp, "\n\n");

    j = 0;
    for (i = 0; i < MAX_PARMS; i++)  /* print parms */
	if (Parms[i].name[0] != '\0') {
	    fprintf(fp, "assign(");
	    fprintf(fp, "%s, %d). ", Parms[i].name, Parms[i].val);
	    j++;
	    if (j % 3 == 0)
		fprintf(fp, "\n");
	    }
    fprintf(fp, "\n");

}  /* print_options */

/*************
 *
 *    p_options()
 *
 *************/

void p_options(void)
{
    print_options(stdout);
}  /* p_options */

/*************
 *
 *   auto_change_flag()
 *
 *************/

void auto_change_flag(FILE *fp, int index, int val)
{
    if (Flags[index].val != val) {
	fprintf(fp, "   dependent: %s(%s).\n",
		val ? "set" : "clear", Flags[index].name);
	Flags[index].val = val;
	dependent_flags(fp, index);
	}
}  /* auto_change_flag */

/*************
 *
 *   void dependent_flags(FILE *fp, int index)
 *
 *   Flag[index] has just been changed.  Change any flags or parms that
 *   depend on it.  Write actions to *fp.
 *
 *   Mutually recursive with auto_change_flag and auto_change_parm.
 *
 *************/

void dependent_flags(FILE *fp, int index)
{
    /* This part handles flags that have just been set. */

    if (Flags[index].val) {

	switch (index) {
	    }
	}

    /* This part handles flags that have just been cleared. */

    if (Flags[index].val) {
	switch (index) {
	    }
	}
}  /* dependent_flags */

/*************
 *
 *   auto_change_parm()
 *
 *************/

void auto_change_parm(FILE *fp, int index, int val)
{
    if (Parms[index].val != val) {
	fprintf(fp, "   dependent: assign(%s, %d).\n",
		Parms[index].name, val);
		
	Parms[index].val = val;
	dependent_parms(fp, index);
	}
}  /* auto_change_parm */

/*************
 *
 *   void dependent_parms(FILE *fp, int index)
 *
 *   Parms[index] has just been changed.  Change any flags or parms that
 *   depend on it.  Write actions to *fp.
 *
 *   Mutually recursive with auto_change_flag and auto_change_parm.
 *
 *************/

void dependent_parms(FILE *fp, int index)
{
    switch (index) {
	}
}  /* dependent_parms */

/*************
 *
 *    int change_flag(fp, flag_name, set)
 *
 *    If success, return index of flag, if fail, return -1.
 *    Warning and error messages go to file fp.
 *
 *************/

int change_flag(FILE *fp, char *flag_name, int set)
{
    int index, found;

    found = 0;
    index = 0;
    while (index < MAX_FLAGS && !found)
	if (strcmp(flag_name, Flags[index].name) == 0)
	    found = 1;
	else
	    index++;
    if (!found) {
	fprintf(fp, "ERROR: flag `%s' not found.\n", flag_name);
	return(-1);
	}
    else if (Flags[index].val == set) {
	fprintf(fp, "WARNING: ");
	if (set)
	    fprintf(fp, " flag `%s' already set.\n", flag_name);
	else
	    fprintf(fp, " flag `%s' already clear.\n", flag_name);
	return(index);
	}
    else {
	Flags[index].val = set;
	return(index);
	}
}  /* change_flag */

/*************
 *
 *    int change_parm(fp, parm_name, val)
 *
 *    If success, return index of parm, if fail, return -1.
 *    Warning and error messages go to file fp.
 *
 *************/

int change_parm(FILE *fp, char *parm_name, int val)
{
    int index, found;

    found = 0;
    index = 0;
    while (index < MAX_PARMS && !found)
	if (strcmp(parm_name, Parms[index].name) == 0)
	    found = 1;
	else
	    index++;
    if (!found) {
	fprintf(fp, "ERROR: parameter `%s' not found.\n", parm_name);
	return(-1);
	}
    else if (val < Parms[index].min || val > Parms[index].max) {
	fprintf(fp, "ERROR: assign(%s, %d),", parm_name, val);
	fprintf(fp, " integer must be in range [%d,%d].\n",
		Parms[index].min, Parms[index].max);
	return(-1);
	}
    else if (val == Parms[index].val) {
	fprintf(fp, "WARNING: assign(%s, %d),", parm_name, val);
	fprintf(fp, " already has that value.\n");
	return(index);
	}
    else {
	Parms[index].val = val;
	return(index);
	}
}  /* change_parm */

/*************
 *
 *    check_options(fp)  --  check for inconsistent or odd settings
 *
 *    If a bad combination of settings is found, either a warning
 *    message is printed, or an ABEND occurs.
 *
 *************/

void check_options(FILE *fp)
{
    fprintf(fp, "Called check_options.\n");
}  /* check_options */

