#define IN_MAIN  /* so that global vars in header.h will not be external */
#include "Header.h"
#include "Dp.h"

#include <unistd.h>  /* for gethostname() and getopt() */

#define VERSION "1.0.0"

 int First_order;
 int Domain_size;
 void read_gen_clauses_sorted(FILE *fp, int n, int x);
 int Backup_interval;
 FILE *Backup_file;
 FILE *Restore_file;
 int Search_depth = INT_MAX;
 int Experiment;
 int Sorted_input;

/*************
 *
 *    void print_banner(argc, argv)
 *
 *************/

static void print_banner(int argc, char **argv)
{
    int i;
    char host[64];

    if (gethostname(host, 64) != 0)
	strcpy(host, "???");

    printf("----- ANLDP %s, June 1994 -----\n", VERSION);
    printf("The job began on %s, %s", host, get_time());
    printf("The command was \"");
    for(i = 0; i < argc; i++)
        printf("%s%s", argv[i], (i < argc-1 ? " " : ""));
    printf("\".\n\n");
    
}  /* print_banner */

/*************
 *
 *   usage_message()
 *
 *************/

void usage_message()
{
    printf("\nDP %s -- Davis-Putnam procedure for propositional logic.\n\n", VERSION);
    printf("\nInput clauses are taken from standard input.\n");
    printf("\ncommand-line options:\n");
    printf("   -s      | Perform unit subsumption. (Always done on input.)\n");
    printf("   -p      | Print models as they are found.\n");
    printf("   -z      | Sorted first_order input.\n");
    printf("   -m n    | Stop when the n-th model is found.\n");
    printf("   -t n    | Stop after n seconds.\n");
    printf("   -k n    | Tp_allocate at most n K bytes.\n");
    printf("   -n n    | Read general clauses and use domain size n.\n");
    printf("   -x 1    | Quasigroup constraint on last column of f/2.\n");
    printf("   -x n    | Experiment n.\n");
    /* printf("   -d n    | Maximum depth of search.\n"); */
    printf("   -b n    | Backup assignments every n seconds.\n");
    printf("   -B file | Backup assignments to file.\n");
    printf("   -R file | Restore assignments from file (must also give\n"
           "             ordinary input, exactly as in the original search).\n");
    printf("   -h      | Print this message.\n");
    printf("\n");
}  /* usage_message */

/*************
 *
 *   process_command_line_args()
 *
 *************/

int process_command_line_args(int argc, char **argv)
{
    extern char *optarg;

    int c, n;
    int error = 0;

    while ((c = getopt(argc, argv, "sphzm:t:k:n:b:B:R:d:x:")) != EOF) {
	switch (c) {
	  case 's':
	    change_flag(stderr, "subsume", 1);
	    break;
	  case 'p':
	    change_flag(stderr, "print_models", 1);
	    break;
	  case 'z':
	    Sorted_input = 1;
	    First_order = 1;
	    break;
	  case 'x':
	    n = atoi(optarg);
	    Experiment = n;
	    break;
	  case 'm':
	    n = atoi(optarg);
	    if (change_parm(stderr, "max_models", n) == -1)
		error++;
	    break;
	  case 't':
	    n = atoi(optarg);
	    if (change_parm(stderr, "max_seconds", n) == -1)
		error++;
	    break;
	  case 'k':
	    n = atoi(optarg);
	    if (change_parm(stderr, "max_mem", n) == -1)
		error++;
	    break;
	  case 'n':
	    n = atoi(optarg);
	    if (n < 1) {
		fprintf(stderr, "Domain size must be > 0.\n");
		error++;
		}
	    else {
		First_order = 1;
		Domain_size = n;
		}
	    break;
	  case 'd':
	    n = atoi(optarg);
	    Search_depth = n;
	    break;
	  case 'b':
	    n = atoi(optarg);
	    Backup_interval = n;
	    break;
	  case 'B':
	    Backup_file = fopen(optarg, "w");
	    break;
	  case 'R':
	    Restore_file = fopen(optarg, "r");
	    if (!Restore_file) {
		fprintf(stderr, "File %s not found.\n", optarg);
		error++;
		}
	    break;
	  case 'h':
	  case '?':
	  default:
	    error = 1;
	    break;
	    }
	}

    /* Check for inconsistent options. */

    if (Backup_interval == 0 && Backup_file != NULL) {
	fprintf(stderr, "\nNeed backup interval (-b seconds).\n");
	error++;
	}
    else if (Backup_interval > 0 && Backup_file == NULL) {
	fprintf(stderr, "\nNeed backup file (-B file).\n");
	error++;
	}
	
    return(error == 0);
}  /* process_command_line_args */

/*************
 *
 *    main
 *
 *************/

int main(int argc, char **argv)
{
    int rc;

    init_dp();
    rc = process_command_line_args(argc, argv);
    if (!rc) {
	usage_message();
	exit(0);
	}

    print_banner(argc, argv);

    CLOCK_START(INPUT_TIME)
    if (Domain_size > 0) {
	if (Parms[MAX_SECONDS].val < INT_MAX)
	    fprintf(stderr, "Time limit ignored during clause generation.\n");
	read_gen_clauses_sorted(stdin, Domain_size, Experiment);
	}
    else if (Sorted_input)
	read_gen_clauses_sorted(stdin, 0, Experiment);
    else
	rc = read_all_clauses(stdin);
    rc = more_setup();
    CLOCK_STOP(INPUT_TIME)

    CLOCK_START(DECIDE_TIME)
    rc = dp_prover(Search_depth);
    CLOCK_STOP(DECIDE_TIME)

    output_stats(stdout);

    exit(rc);

}  /* main */





