#ifndef TP_STATS_H
#define TP_STATS_H

/* This file does not depend on header.h */

#include "Clocks.h"

/*************
 *
 *    Statistics.  To install a new statistic, append a new name and
 *    index to this list, then insert the code to output it in the
 *    routine `print_stats'.
 *    Example access:  Stats[INPUT_ERRORS]++;
 *
 *************/

#define MAX_STATS        40  /* increase if necessary */

#define INIT_WALL_SECONDS   1
#define MODELS              2
#define FAILED_PATHS        3
#define UNIT_ASSIGNS        4
#define BRANCHES            5
#define PREPROCESS_UNIT_ASSIGNS   6
#define CLAUSES_AFTER_SUB         7
#define INPUT_CLAUSES       8
#define GREATEST_ATOM       9
#define LIT_OCC_INPUT      10
#define LIT_OCC_AFTER_SUB  11
#define MEM_MALLOCED       12
#define SELECTABLE_CLAUSES 13
#define DEPTH_PRUNES       14

/* end of Stats */

#define MAX_INTERNAL_FLAGS  10

extern long Stats[MAX_STATS];
extern int Internal_flags[MAX_INTERNAL_FLAGS];

/* function prototypes from stats.c */

void init_stats();

void output_stats(FILE *fp);

void print_stats(FILE *fp);

void p_stats(void);

void print_times(FILE *fp);

void p_times(void);

#endif  /* ! TP_STATS_H */
