#ifndef TP_DP_H
#define TP_DP_H

#define UNSATISFIABLE  0
#define SATISFIABLE    1
#define NOT_DETERMINED 2

#define ATOM_FALSE         0
#define ATOM_TRUE          1
#define ATOM_NOT_ASSIGNED  2

#define MAX_DOMAIN     20
#define MAX_LITERALS  100

#if 0
#  define DP_INT int
#  define DP_INT_MAX INT_MAX
#else
#  define DP_INT unsigned short
#  define DP_INT_MAX USHRT_MAX
#endif

struct clause {
    DP_INT num_pos;      /* number of positive literals */
    DP_INT num_neg;      /* number of negative literals */
    DP_INT active_pos;   /* number of active (unassigned) positive literals */
    DP_INT active_neg;   /* number of active (unassigned) negative literals */
    DP_INT *pos;         /* array of positive literals */
    DP_INT *neg;         /* array of negative literals (stored positively) */
    int subsumer;        /* 0 if not subsumed; else index of subsuming clause */
    struct clause *next;
    };

typedef struct clause *Clause_ptr;

struct atom {
    DP_INT value;            /* ATOM_TRUE, ATOM_FALSE, ATOM_NOT_ASSIGNED */
    DP_INT enqueued_value;   /* ATOM_TRUE, ATOM_FALSE, ATOM_NOT_ASSIGNED */
    DP_INT num_pos_occ;      /* number of positive occurrences */
    DP_INT num_neg_occ;      /* number of negative occurrences */
    Clause_ptr *pos_occ;  /* array of pos occurrences (pointers to clauses) */
    Clause_ptr *neg_occ;  /* array of neg occurrences (pointers to clauses) */
    };

typedef struct atom *Atom_ptr;

struct gen_ptr {      /* for constructing lists of pointers or integers */
    struct gen_ptr *next;
    union {
        void *v;
	int i;
	} u;
    };

typedef struct gen_ptr *Gen_ptr_ptr;

/* function prototypes from dp.c */

void init_dp();

void exit_if_over_time_limit();

int subsumed(Clause_ptr c);

void p_clause(Clause_ptr c);

void p_atom(int i);

int read_all_clauses(FILE *fp);

void insert_gen_clause(int c[], int n);

int more_setup();

int dp_prover();

#endif  /* ! TP_DP_H */
