;;; -*- Mode: LISP; Syntax: Common-lisp; Package: MVL; Base: 10 -*-

(in-package "MVL")

;; constructs bilattice for first-order logic by working from the
;; two-point lattice.

(defparameter f-lattice
    (make-lattice :max t :min nil
		  :stash-val #'(lambda (x) (declare (ignore x)) t)
		  :and #'(lambda (x y) (and x y))
		  :or #'(lambda (x y) (or x y)) :eq #'eq 
		  :leq #'(lambda (x y) (or y (null x)))
		  :dws #'(lambda (x y) (unless y x))
		  :long-desc "Two point lattice"
		  :short-desc "2-pt"))

(defparameter *first-order-bilattice*
    (lattice-to-bilattice f-lattice))

(describe-bilattice *first-order-bilattice* "First-order logic."
		    "First-order" #\f)

;; Two other modal ops are L and M (the dual of L).  For L, if the car
;; is T, we have a proof.  For M, if the cdr is T, we have a proof of the
;; negation.

(defun L-fol (x)
  (if (car x) (bilattice-true *first-order-bilattice*)
    (bilattice-false *first-order-bilattice*)))

(defparameter L-fol (make-modal-op :name 'L :fn #'L-fol :args '(t)))

(defun M-fol (x)
  (if (cdr x) (bilattice-false *first-order-bilattice*)
    (bilattice-true *first-order-bilattice*)))

(defparameter M-fol (make-modal-op :name 'M :fn #'M-fol :args '(nil)))

(bilattice-has-modal-op *first-order-bilattice* L-fol)
(bilattice-has-modal-op *first-order-bilattice* M-fol)

;; this adds the bilattice to the list of bilattices about which the
;; system knows

(bilattice *first-order-bilattice*)
