;;; -*- Mode: LISP; Syntax: Common-lisp; Package: MVL; Base: 10 -*-

(in-package "MVL")

;; pick a task to work on.  Pick the one with the smallest depth.

(defun choose-proof (&aux best (best-depth most-positive-fixnum) depth)
  (dolist (p (analysis-proofs analysis) best)
    (when (and (not (completed-proof p))
	       (< (setq depth (proof-min-depth p)) best-depth)
	       (possible-impact p))
      (setq best p best-depth depth))))

;; Here we determine whether a proof might affect the overall answer.
;; If there are active nodes, we see if a successful proof might matter;
;; otherwise, we see if some pending answer might matter.  Since the
;; pending answers are of the form (answer . known-irrelevant?), we don't
;; have to check them all.

(defun possible-impact (proof &optional (test #'relevance-affects))
  (if (proof-fotp proof)
      (delete-if test (relevant-answer (make-answer) proof))
    (some #'(lambda (p) (unless (cdr p)
			  (delete-if test (relevant-answer (car p) proof))))
	  (proof-pending-answers proof))))
