;;; -*- Syntax: Common-Lisp; Package: USER; Base: 10; Mode: LISP -*-

(UNLESS (FIND-PACKAGE "MKRP")
  (MAKE-PACKAGE "MARKGRAF-KARL" :USE '("CL") :NICKNAMES '("MKRP")))
(unless (find-package "TH-AC-MKRP") (make-package "TH-AC-MKRP"))

(DEFSYSTEM MKRP (:PRETTY-NAME "MARKGRAF KARL REFUTATION PROCEDURE"
		 :DEFAULT-PATHNAME "MKRP:PROG;"
		 :JOURNAL-DIRECTORY "MKRP:PATCHES;"
		 :BUG-REPORTS ("MKRP" "REPORT PROBLEM WITH MKRP")
		 :INITIAL-STATUS :EXPERIMENTAL
		 :before-patches-INITIALIZATIONS (LET ((*PACKAGE* (FIND-PACKAGE "MKRP")))
						   (mkrp::mkrp-init)))
  (:module init (";init;init")
	   (:in-order-to :compile (:load memory edit) (:read init))
	   (:in-order-to :load (:load memory edit))
	   (:in-order-to :read (:load memory edit)))
  (:module SERVICE (";serv;service" ";serv;serviceqlists" ";serv;servicefiles" ";serv;atpservice")
	   (:in-order-to :compile (:read SERVICE) (:load fonts))
	   (:in-order-to :load (:load fonts))
	   (:in-order-to :read (:load fonts)))
  (:module OPTIONS (";opt;options")
	   (:in-order-to :compile (:load SERVICE) (:read OPTIONS))
	   (:in-order-to :load (:load SERVICE))
	   (:in-order-to :read (:load SERVICE)))
  (:module MEMORY (";ds;memory" ";ds;mem-assist")
	   (:in-order-to :compile (:load SERVICE) (:read MEMORY))
	   (:in-order-to :load (:load SERVICE))
	   (:in-order-to :read (:load SERVICE))
	   (:uses-definitions-from SERVICE))
  (:MODULE DATATERM (";ds;DATATERM" ";ds;DT-TERM" ";ds;DT-ASSIST")
	   (:IN-ORDER-TO :COMPILE (:LOAD MEMORY OPTIONS) (:READ DATATERM))
	   (:IN-ORDER-TO :LOAD (:LOAD MEMORY OPTIONS))
	   (:IN-ORDER-TO :READ (:LOAD MEMORY OPTIONS))
	   (:USES-DEFINITIONS-FROM MEMORY OPTIONS))
  (:MODULE HADES (";hd;HADES" ";hd;denz")
	   (:IN-ORDER-TO :COMPILE (:LOAD DATATERM) (:READ HADES))
	   (:IN-ORDER-TO :LOAD (:LOAD DATATERM))
	   (:IN-ORDER-TO :READ (:LOAD DATATERM))
	   (:USES-DEFINITIONS-FROM DATATERM))
  (:MODULE ORDERINGS (";ord;ORD-POLY" ";ord;ORDERINGS")
	   (:IN-ORDER-TO :COMPILE (:LOAD DATATERM OPTIONS) (:READ ORDERINGS))
	   (:IN-ORDER-TO :LOAD (:LOAD DATATERM OPTIONS))
	   (:IN-ORDER-TO :READ (:LOAD DATATERM OPTIONS))
	   (:USES-DEFINITIONS-FROM DATATERM OPTIONS))
  (:MODULE PPRINT (";pp;PPRINT")
	   (:IN-ORDER-TO :COMPILE (:LOAD DATATERM OPTIONS) (:READ PPRINT))
	   (:IN-ORDER-TO :LOAD (:LOAD DATATERM OPTIONS))
	   (:IN-ORDER-TO :READ (:LOAD DATATERM OPTIONS))
	   (:USES-DEFINITIONS-FROM OPTIONS DATATERM))
  (:MODULE EDIT (";edt;EDIT" ";edt;FORMULATABLE" ";edt;SYMBOLTABLE" ";edt;COMPILE" ";edt;COM-ASSIST" ";edt;EDITORWINDOW")
	   (:IN-ORDER-TO :COMPILE (:LOAD PPRINT) (:READ EDIT))
	   (:IN-ORDER-TO :LOAD (:LOAD PPRINT))
	   (:IN-ORDER-TO :READ (:LOAD PPRINT))
	   (:USES-DEFINITIONS-FROM OPTIONS DATATERM))
  (:MODULE DATASTRUCTURE (";ds;DATASTRUCTURE" ";ds;DS-ASSIST")
	   (:IN-ORDER-TO :COMPILE (:LOAD SERVICE DATATERM) (:READ DATASTRUCTURE))
	   (:IN-ORDER-TO :LOAD (:LOAD SERVICE DATATERM))
	   (:IN-ORDER-TO :READ (:LOAD SERVICE DATATERM))
	   (:USES-DEFINITIONS-FROM ORDERINGS OPTIONS))
  (:MODULE CONNECTIONGRAPH (";cg;CONNECTIONGRAPH" ";cg;CG-ASSIST")
	   (:IN-ORDER-TO :COMPILE (:LOAD DATASTRUCTURE PPRINT) (:READ CONNECTIONGRAPH))
	   (:IN-ORDER-TO :LOAD (:LOAD DATASTRUCTURE PPRINT))
	   (:IN-ORDER-TO :READ (:LOAD DATASTRUCTURE PPRINT))
	   (:USES-DEFINITIONS-FROM DATASTRUCTURE OPTIONS))
  (:MODULE OPERATINGSYSTEM (";os;OS-EXPLANATION" ";os;OPERATINGSYSTEM")
	   (:IN-ORDER-TO :COMPILE (:LOAD EDIT PREPARATION CONTROL PROTOCOL fonts) (:READ OPERATINGSYSTEM))
	   (:IN-ORDER-TO :LOAD (:LOAD fonts EDIT PREPARATION CONTROL PROTOCOL))
	   (:IN-ORDER-TO :READ (:LOAD fonts EDIT PREPARATION CONTROL PROTOCOL))
	   (:USES-DEFINITIONS-FROM OPTIONS))  
  (:MODULE fonts ("s35ger")
  	   (:type :font))
  (:MODULE PROTOCOL (";prot;interface" ";prot;post" ";prot;PROTOCOL" ";prot;PROT-DATASTRUCTURE" ";prot;PROT-PRINT"
		     ";prot;PROT-PREPARE" ";prot;PROT-EXECUTE")
	   (:IN-ORDER-TO :COMPILE (:LOAD DATASTRUCTURE PPRINT) (:READ PROTOCOL))
	   (:USES-DEFINITIONS-FROM DATASTRUCTURE OPTIONS))
  (:MODULE PREPARATION (";ctl;PREPARATION" ";e;preparation" ";c;preparation")
	   (:IN-ORDER-TO :COMPILE (:LOAD REDUCTION SIMPLIFICATION SELECTION) (:READ PREPARATION))
	   (:IN-ORDER-TO :load (:LOAD REDUCTION SIMPLIFICATION SELECTION))
	   (:IN-ORDER-TO :read (:LOAD REDUCTION SIMPLIFICATION SELECTION))
	   (:USES-DEFINITIONS-FROM CONNECTIONGRAPH))
  (:MODULE REDUCTION (";red;TWO" ";red;TWO-ASSIST" ";red;RED-SERVICE" ";red;RED-DATASTRUCTURE" ";red;RED-RW" ";red;RED-CRR"
		      ";red;NARROW" ";red;REDUCTION" ";red;RED-LINKCONDITION" ";red;RED-ASSIST")
	   (:IN-ORDER-TO :COMPILE (:LOAD OPERATION) (:READ REDUCTION))
	   (:IN-ORDER-TO :LOAD (:LOAD OPERATION))
	   (:IN-ORDER-TO :READ (:LOAD OPERATION))
	   (:USES-DEFINITIONS-FROM CONNECTIONGRAPH UNIFICATION OPTIONS))
  (:MODULE OPERATION (";op;CONSTRUCT" ";op;op-service" ";op;op-inherit" ";op;op-create" ";op;OPERATION")
	   (:IN-ORDER-TO :COMPILE (:LOAD CONNECTIONGRAPH UNIFICATION) (:READ OPERATION))
	   (:IN-ORDER-TO :LOAD (:LOAD CONNECTIONGRAPH UNIFICATION))
	   (:IN-ORDER-TO :READ (:LOAD CONNECTIONGRAPH UNIFICATION))
	   (:USES-DEFINITIONS-FROM CONNECTIONGRAPH UNIFICATION))
  (:MODULE SIMPLIFICATION (";norm;NORMALIZATION" ";norm;NORM-ASSIST" ";norm;PRESIMPLIFICATION")
	   (:IN-ORDER-TO :COMPILE (:LOAD DATATERM) (:READ SIMPLIFICATION))
	   (:IN-ORDER-TO :load (:LOAD DATATERM))
	   (:IN-ORDER-TO :read (:LOAD DATATERM))
	   (:USES-DEFINITIONS-FROM DATATERM OPTIONS))
  (:MODULE SORT (";sort;uds" ";sort;upp" ";sort;upr")
	   (:IN-ORDER-TO :COMPILE (:LOAD DATATERM) (:READ SORT))
	   (:IN-ORDER-TO :load (:LOAD DATATERM))
	   (:IN-ORDER-TO :read (:LOAD DATATERM))
	   (:USES-DEFINITIONS-FROM DATATERM HADES))
  (:MODULE UNIFICATION (";uni;UNI-COMMUTATIVE" ";uni;ac-match" ";uni;UNI-THU" ";uni;UNIFICATION")
	   (:IN-ORDER-TO :COMPILE (:LOAD SORT HADES) (:READ UNIFICATION))
	   (:IN-ORDER-TO :load (:LOAD SORT HADES))
	   (:IN-ORDER-TO :read (:LOAD SORT HADES))
	   (:USES-DEFINITIONS-FROM SORT HADES))
  (:MODULE CONTROL (";ctl;CONTROL")
	   (:IN-ORDER-TO :COMPILE (:LOAD REDUCTION SELECTION) (:READ CONTROL))
	   (:IN-ORDER-TO :load (:LOAD REDUCTION SELECTION))
	   (:IN-ORDER-TO :read (:LOAD REDUCTION SELECTION))
	   (:USES-DEFINITIONS-FROM CONNECTIONGRAPH))
  (:MODULE SELECTION (";sel;SELECTION" ";sel;SEL-MARK" ";sel;SEL-MANUAL" ";sel;SEL-ASSIST")
	   (:IN-ORDER-TO :COMPILE (:LOAD TERMINATOR CONNECTIONGRAPH) (:READ SELECTION))
	   (:IN-ORDER-TO :load (:LOAD TERMINATOR CONNECTIONGRAPH))
	   (:IN-ORDER-TO :read (:LOAD TERMINATOR CONNECTIONGRAPH))
	   (:USES-DEFINITIONS-FROM CONNECTIONGRAPH))
  (:MODULE TERMINATOR (";term;MERGEINST" ";term;TERMINATOR" ";term;TERM-ASSIST")
	   (:IN-ORDER-TO :COMPILE (:LOAD CONNECTIONGRAPH) (:READ TERMINATOR))
	   (:USES-DEFINITIONS-FROM CONNECTIONGRAPH UNIFICATION OPTIONS)))