;;; -*- Package: MKRP; Syntax: Common-lisp; Mode: lisp -*-

(IN-PACKAGE "MKRP" :use '("CL"))

					

(DEFUN ASS=UNIFY (TERM1 TERM2)
  ;; EDITED: " 9-SEP-80 16:50:24")
  ;; INPUT:  TWO ARBITRARY TERMS
  ;; VALUE:  LIST OF SUBSTITUTIONS S, SUCH THAT
  ;;         S(TERM1) = S(TERM2) UNDER THE GIVEN THEORY
  ;;         ELSE NIL
  ;; EFFECT: THE TERMS ARE CHANGED DURING COMPUTATION
  (let (UNIFIERLIST NEWVARIABLES (FUNCTIONSYMBOL (CAR TERM1)) LAST.T1 LAST.T2)	
    (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
    (SETQ TERM1 (ASS=MAKESTRING TERM1))
    (SETQ TERM2 (ASS=MAKESTRING TERM2)) (SETQ LAST.T1 (CAR (LAST TERM1))) (SETQ LAST.T2 (CAR (LAST TERM2)))
    (COND ((EQUAL TERM1 TERM2)
	   (LIST NIL))
	  ((AND (DT-CONSTANT.IS LAST.T1) (DT-CONSTANT.IS LAST.T2) (NEQ LAST.T1 LAST.T2))
	   NIL)
	  (T (ASS=EQUATE (CDR TERM1) (CDR TERM2) NIL)
	     UNIFIERLIST))))

(DEFUN ASS=EQUATE (TERM1 TERM2 UNIFIER)
  (DECLARE (special UNIFIER))
  ;; EDITED: "10-SEP-80 20:03:58")
    ;; INPUT:  TWO LISTS OF ARGUMENTS OF THE ASSOCIATIVE
    ;;         TERMS TO BE UNIFIED AND THE COMPONENTS OF A
    ;;         UNIFIER SO FAR GENERATED
    ;; VALUE:  A LIST OF UNIFIERS S SUCH THAT
    ;;         S(TERM1) = S(TERM2) UNDER THE GIVEN THEORY
  (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
    (PROG (THEORY UNILIST (CAR.TERM1 (CAR TERM1)) (CAR.TERM2 (CAR TERM2)) SORT1 SORT2)
      (COND (CAR.TERM1 (SETQ SORT1 (DT-TERM.SORT CAR.TERM1)))) (COND (CAR.TERM2 (SETQ SORT2 (DT-TERM.SORT CAR.TERM2))))
      (COND
        ((EQUAL TERM1 TERM2) (SETQ UNIFIERLIST (NCONC1 UNIFIERLIST (ASS=UNIFIER.NORMALFORM UNIFIER))) (RETURN UNIFIERLIST))
        ((OR (NULL TERM1) (NULL TERM2))) ((EQUAL CAR.TERM1 CAR.TERM2) (ASS=EQUATE (CDR TERM1) (CDR TERM2) UNIFIER))
        ((AND (UNI=VARIABLE.IS CAR.TERM1) (UNI=VARIABLE.IS CAR.TERM2))
          (COND ((DT-SORT.IS.SUBSORT SORT1 SORT2) (ASS=SIMPLE.MATCH TERM2 TERM1))
            ((DT-SORT.IS.SUBSORT SORT2 SORT1) (ASS=SIMPLE.MATCH TERM1 TERM2))
            (T
              (PROG (XNEW UNI UNIF T1 T2)
                (MAPC
                  (FUNCTION
                    (LAMBDA (SORT) (SETQ XNEW (DT-VARIABLE.CREATE SORT))
                      (SETQ UNI (LIST CAR.TERM1 XNEW CAR.TERM2 XNEW))
                      (SETQ UNIF (ASS=UNION.OF.SUBSTITUTIONS UNIFIER UNI))
                      (SETQ T1 (ASS=APPLY.SUBSTITUTION UNI TERM1)) (SETQ T2 (ASS=APPLY.SUBSTITUTION UNI TERM2))
                      (ASS=EQUATE T1 T2 UNIF)))
                  (DT-SORT.GREATEST.COMMON.SUBSORTS SORT1 SORT2)))))
          (COND
            ((AND (NEQ (LIST-LENGTH UNIFIERLIST) ASS*LIMIT)
               (NEQ (DT-GETPROP CAR.TERM1 ASS*SPLITDEPTH) ASS*SPLITDEPTH) (> (LIST-LENGTH TERM2) 1)
               (EQL SORT1 (DT-FUNCTION.SORT FUNCTIONSYMBOL)))
              (ASS=MATCH.WITH.SPLITTING TERM1 TERM2)))
          (COND
            ((AND (NEQ (LIST-LENGTH UNIFIERLIST) ASS*LIMIT)
               (NEQ (DT-GETPROP CAR.TERM2 ASS*SPLITDEPTH) ASS*SPLITDEPTH) (> (LIST-LENGTH TERM1) 1)
               (EQL SORT2 (DT-FUNCTION.SORT FUNCTIONSYMBOL)))
              (ASS=MATCH.WITH.SPLITTING TERM2 TERM1))))
        ((AND (UNI=VARIABLE.IS CAR.TERM1) (NOT (INSIDE CAR.TERM1 CAR.TERM2)) (DT-SORT.IS.SUBSORT SORT2 SORT1))
          (ASS=SIMPLE.MATCH TERM1 TERM2)
          (COND
            ((AND (NEQ (LIST-LENGTH UNIFIERLIST) ASS*LIMIT)
               (NEQ (DT-GETPROP CAR.TERM1 ASS*SPLITDEPTH) ASS*SPLITDEPTH) (> (LIST-LENGTH TERM2) 1)
               (EQL SORT1 (DT-FUNCTION.SORT FUNCTIONSYMBOL)))
              (ASS=MATCH.WITH.SPLITTING TERM1 TERM2))))
        ((AND (UNI=VARIABLE.IS CAR.TERM2) (NOT (INSIDE CAR.TERM2 CAR.TERM1)) (DT-SORT.IS.SUBSORT SORT1 SORT2))
          (ASS=SIMPLE.MATCH TERM2 TERM1)
          (COND
            ((AND (NEQ (LIST-LENGTH UNIFIERLIST) ASS*LIMIT)
               (NEQ (DT-GETPROP CAR.TERM2 ASS*SPLITDEPTH) ASS*SPLITDEPTH) (> (LIST-LENGTH TERM1) 1)
               (EQL SORT2 (DT-FUNCTION.SORT FUNCTIONSYMBOL)))
              (ASS=MATCH.WITH.SPLITTING TERM2 TERM1)))))
      (COND ((AND (DT-ABBREVIATION.IS CAR.TERM1) (DT-ABBREVIATION.IS CAR.TERM2)))
        ((DT-ABBREVIATION.IS CAR.TERM1) (SETQ CAR.TERM1 (DT-ABBREVIATION.TERM CAR.TERM1)))
        ((DT-ABBREVIATION.IS CAR.TERM2) (SETQ CAR.TERM2 (DT-ABBREVIATION.TERM CAR.TERM2))))
      (COND
        ((AND (CONSP CAR.TERM1) (CONSP CAR.TERM2) (EQL (CAR CAR.TERM1) (CAR CAR.TERM2)))
          (SETQ THEORY (DT-FUNCTION.ATTRIBUTES (CAR CAR.TERM1)))
          (COND ((MEMBER 'ASSOCIATIVE THEORY) (SETQ UNILIST (ASS=UNIFY CAR.TERM1 CAR.TERM2)))
            (T (SETQ UNILIST (UNI-UNIFY.TERMS CAR.TERM1 CAR.TERM2))))
          (MAPC
            (FUNCTION
              (LAMBDA (UNI)
                (PROG ((UNIF (ASS=UNION.OF.SUBSTITUTIONS UNIFIER UNI)) T1 T2)
                  (COND
                    ((AND (> (LIST-LENGTH TERM1) 1) (> (LIST-LENGTH TERM2) 1))
                      (SETQ T1 (ASS=APPLY.SUBSTITUTION UNI (CDR TERM1)))
                      (SETQ T2 (ASS=APPLY.SUBSTITUTION UNI (CDR TERM2))) (ASS=EQUATE T1 T2 UNIF))
                    ((OR (> (LIST-LENGTH TERM1) 1) (> (LIST-LENGTH TERM2) 1)))
                    (T (SETQ UNIFIERLIST (NCONC1 UNIFIERLIST (ASS=UNIFIER.NORMALFORM UNIF))))))))
            UNILIST)))
      (RETURN UNIFIERLIST)))

(DEFUN ASS=SIMPLE.MATCH (TERM1 TERM2)
  (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
  ;; EDITED: "18-SEP-80 14:50:54")
    ;; INPUT:  TWO LISTS OF ARGUMENTS OF TWO TERMS TO BE
    ;;         UNIFIED
    ;; EFFECT: GENERATION OF ONE SUBSTITUTION-COMPONENT
    ;;         OF A UNIFIER
    (PROG (T1 T2 (UNI (LIST (CAR TERM1) (CAR TERM2))) UNIF) (SETQ UNIF (ASS=UNION.OF.SUBSTITUTIONS (COPY-TREE UNIFIER) UNI))
      (COND
        ((AND (> (LIST-LENGTH TERM1) 1) (> (LIST-LENGTH TERM2) 1)) (SETQ T1 (ASS=APPLY.SUBSTITUTION UNI (CDR TERM1)))
          (SETQ T2 (ASS=APPLY.SUBSTITUTION UNI (CDR TERM2))) (ASS=EQUATE T1 T2 UNIF))
        ((OR (> (LIST-LENGTH TERM1) 1) (> (LIST-LENGTH TERM2) 1)))
        (T (SETQ UNIFIERLIST (NCONC1 UNIFIERLIST (ASS=UNIFIER.NORMALFORM UNIF)))
          ;; FLENGTH(TERM1) = FLENGTH(TERM2) = 1
   ))))

(DEFUN ASS=MATCH.WITH.SPLITTING (TERM1 TERM2)
  (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
  ;; EDITED: "18-SEP-80 15:01:17")
    ;; INPUT:  TWO LISTS OF ARGUMENTS OF TWO TERMS TO BE
    ;;         UNIFIED
    ;; EFFECT: GENERATION OF ONE SUBSTITUTION-COMPONENT
    ;;         OF A UNIFIER
    (PROG (T1 T2 UNI UNIF (NEWVARIABLE (DT-VARIABLE.CREATE (DT-VARIABLE.SORT (CAR TERM1)))))
      (DT-PUTPROP NEWVARIABLE ASS*SPLITDEPTH
        (1+
          (COND ((NOT (DT-GETPROP (CAR TERM1) ASS*SPLITDEPTH)) 0) (T (DT-GETPROP (CAR TERM1) ASS*SPLITDEPTH)))))
      (SETQ NEWVARIABLES (NCONC1 NEWVARIABLES NEWVARIABLE))
      (SETQ UNI (LIST (CAR TERM1) (LIST FUNCTIONSYMBOL (CAR TERM2) NEWVARIABLE)))
      (SETQ UNIF (ASS=UNION.OF.SUBSTITUTIONS (COPY-TREE UNIFIER) UNI))
      (COND ((> (LIST-LENGTH TERM1) 1) (SETQ T1 (CDR (ASS=APPLY.SUBSTITUTION UNI TERM1)))) (T (SETQ T1 (LIST NEWVARIABLE))))
      (SETQ T2 (ASS=APPLY.SUBSTITUTION UNI (CDR TERM2))) (ASS=EQUATE T1 T2 UNIF)))

(DEFUN ASS=MAKESTRING (TERM &optional MARKE)
  (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
  ;; EDITED: "10-SEP-80 20:12:15"
  ;; INPUT:  A TERM THE FIRST SYMBOL OF WHICH IS AN
  ;;         ASSOCIATIVE FUNCTION SYMBOL F
  ;; VALUE:  THE TERM IN ASSOCIATIVE NORMALFORM WITH
  ;;         RESPECT TO F
  (SETQ TERM (MAPCAN #'(LAMBDA (ARG)
			 (COND ((ATOM ARG) (list ARG))
			       ((EQL (CAR ARG) FUNCTIONSYMBOL) (ASS=MAKESTRING ARG T))
			       (T (list ARG))))
		     (CDR TERM)))
  (if MARKE TERM
      (CONS FUNCTIONSYMBOL TERM)))

(DEFUN ASS=MAKESTRINGTOTAL (TERM &optional MARKE)
  (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
  ;; EDITED: "10-SEP-80 20:15:26")
  ;; INPUT:  A TERM THE FIRST SYMBOL OF WHICH IS AN
  ;;         ASSOCIATIVE FUNCTION SYMBOL F
  ;; VALUE:  THE TERM IN ASSOCIATIVE NORMALFORM WITH
  ;;         RESPECT TO ALL SUBTERMS
  (let ((FS (CAR TERM)))
    (SETQ TERM (MAPCAN #'(LAMBDA (ARG)
			   (COND ((ATOM ARG) (list ARG))
				 ((AND (MEMBER 'ASSOCIATIVE (DT-FUNCTION.ATTRIBUTES (CAR ARG)))
				       (EQL (CAR ARG) FS))
				  (ASS=MAKESTRINGTOTAL ARG T))
				 ((CONSP ARG) (LIST (ASS=MAKESTRINGTOTAL ARG)))
				 (T (list ARG))))
		       (CDR TERM)))
    (if MARKE TERM (CONS FS TERM))))


(DEFUN ASS=MAKETERM (STRING)
  (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
  ;; INPUT:  AN ARBITRARY STRING
    ;; VALUE:  THE STRING TRANSFORMED IN ITS
  ;;         RIGHT-ASSOCIATIVE TERM-REPRESENTATION
    (PROG (F S#1 S#1...S#K S#2...S#K) (COND ((ATOM STRING) (RETURN STRING))) (SETQ F (CAR STRING)) (SETQ S#1 (SECOND STRING))
      (SETQ S#1...S#K (CDR STRING)) (SETQ S#2...S#K (CDDR STRING))
      (COND
        ((AND (> (LIST-LENGTH S#1...S#K) 2) (MEMBER 'ASSOCIATIVE (DT-FUNCTION.ATTRIBUTES F)))
          (RETURN (LIST F (ASS=MAKETERM S#1) (ASS=MAKETERM (CONS F S#2...S#K))))))
      (RETURN (CONS F (MAPCAR (FUNCTION ASS=MAKETERM) S#1...S#K)))))

(DEFUN ASS=TERM.NORMALFORM (TERM)
  (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
  ;; EDITED: "27-FEB-81 18:31:27")
    ;; INPUT:  AN ARBITRARY TERM
    ;; EFFECT: RETURNS VALUE
    ;; VALUE:  THE TERM IN RIGHT-ASSOCIATIVE NORMALFORM
    (COND ((ATOM TERM) TERM) (T (ASS=MAKETERM (ASS=MAKESTRINGTOTAL TERM)))))

(DEFUN ASS=UNIFIER.NORMALFORM (UNIFIER)
    (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
  ;; EDITED: "27-FEB-81 18:28:01")
    ;; INPUT:  AN ARBITRARY UNIFIER
    ;; EFFECT: RETURNS VALUE
    ;; VALUE:  THE UNIFIER IN NORMALFORM WHERE THE RHS'S OF
    ;;         THE SUBSTITUTION COMPONENTS ARE IN
    ;;         RIGHT-ASSOCIATIVE NORMALFORM
    (SMAPCON
      (FUNCTION
        (LAMBDA (UNI) (PROG ((TERM (SECOND UNI))) (RETURN (LIST (CAR UNI) (ASS=TERM.NORMALFORM TERM))))))
      (FUNCTION CDDR) UNIFIER))

(DEFUN ASS=APPLY.SUBSTITUTION (SUBSTITUTION TERM)
  (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
  ;; EDITED: " 9-SEP-80 15:55:24")
    ;; INPUT:  A SUBSTITUTION S AND A TERM
    ;; VALUE:  NIL IF TERM = NIL
    ;;         S(TERM) OTHERWISE
    (PROG ((ARGS (COPY-TREE TERM)))
      (SMAPL
        (FUNCTION
          (LAMBDA (SUBSTITUTES)
            (PROG (NEWTERM)
              (MAPC
                (FUNCTION
                  (LAMBDA (SUBTERM)
                    (COND
                      ((AND (ATOM SUBTERM) (EQL SUBTERM (CAR SUBSTITUTES)))
                        (COND
                          ((AND (CONSP (SECOND SUBSTITUTES)) (EQL (CAADR SUBSTITUTES) FUNCTIONSYMBOL))
                            (SETQ NEWTERM (NCONC NEWTERM (COPY-TREE (CDADR SUBSTITUTES)))))
                          (T (SETQ NEWTERM (NCONC1 NEWTERM (COPY-TREE (SECOND SUBSTITUTES)))))))
                      (T
                        (SETQ NEWTERM (NCONC1 NEWTERM (NSUBST (SECOND SUBSTITUTES) (CAR SUBSTITUTES) SUBTERM)))))))
                ARGS)
              (SETQ ARGS NEWTERM))))
        (FUNCTION CDDR) SUBSTITUTION)
      (RETURN ARGS)))

(DEFUN ASS=APPLY.SUBSTITUTION.TO.SUBSTITUTION (SUBST1 SUBST2)
  (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
  ;; EDITED: " 9-SEP-80 16:04:13")
    ;; INPUT:  TWO SUBSTITUTIONS
    ;; VALUE:  A SUBSTITUTION OBTAINED FROM SUBST2 BY
    ;;         APPLYING SUBST1 TO THE RIGHTHANDSIDE OF THE
    ;;         COMPONENTS OF SUBST2
    (PROG (SUBSTITUTION TERM)
      (SMAPL
        (FUNCTION
          (LAMBDA (S) (SETQ TERM (UNI-APPLY.SUBSTITUTION SUBST1 (SECOND S)))
            (COND ((ATOM TERM) (SETQ SUBSTITUTION (NCONC SUBSTITUTION (LIST (CAR S) TERM))))
              (T (SETQ SUBSTITUTION (NCONC SUBSTITUTION (LIST (CAR S) (ASS=MAKESTRINGTOTAL TERM))))))))
        (FUNCTION CDDR) SUBST2)
      (RETURN SUBSTITUTION)))

(DEFUN ASS=UNION.OF.SUBSTITUTIONS (SUBST1 SUBST2)
    (DECLARE (SPECIAL FUNCTIONSYMBOL NEWVARIABLES UNIFIER UNIFIERLIST))
  ;; EDITED: " 9-SEP-80 16:12:12")
    ;; INPUT:  TWO SUBSTITUTIONS
    ;; VALUE:  A SUBSTITUTION OBTAINED BY CONCATENATING
    ;;         SUBST1 AND SUBST2 AND APPLYING SUBST2 TO THE
    ;;         RIGHTHANDSIDE OF THE COMPONENTS OF SUBST1
    (PROG NIL
      (COND ((OR (NULL SUBST1) (EQUAL SUBST1 (LIST NIL))) (RETURN SUBST2))
        ((MEMBER (CAR SUBST2) NEWVARIABLES) (RETURN (ASS=APPLY.SUBSTITUTION.TO.SUBSTITUTION SUBST2 SUBST1)))
        (T (RETURN (NCONC (ASS=APPLY.SUBSTITUTION.TO.SUBSTITUTION SUBST2 SUBST1) SUBST2))))))

#| Not used
(DEFUN ASS=SET.LIMIT.AND.SPLITDEPTH (L D)
  ;; EDITED: "10-SEP-80 20:28:16")
  ;; INPUT:  TWO INTEGERS
  ;; EFFECT: EACH VARIABLE CAN BE SPLITTED INTO D
  ;;         SUBVARIABLES AT MOST AND L UNIFIERS ARE
  ;;         GENERATED AT MOST
   (SETQ ASS*LIMIT L) (SETQ ASS*SPLITDEPTH D))|#

(DEFVAR ASS*LIMIT 1)

(DEFVAR ASS*SPLITDEPTH 1)

