;;; -*- Package: MKRP; Syntax: Common-lisp; Mode: Lisp -*-


(DEFUN TERM=SIMPLIFIER.STATUS (STREAM)
  (let (SIMPLIFIER)
    (TERPRI STREAM) (PRINC "direct.simplifiers: " STREAM) (TERPRI STREAM)
    (MAPC
      #'(LAMBDA (CLAUSE)
	  (DODOWN (RPTN (DS-CLAUSE.NOLIT CLAUSE))
		  (COND
		    ((SETQ SIMPLIFIER (DS-CLAUSE.LIT.GETPROP CLAUSE (1+ RPTN) 'DIRECT.SIMPLIFIERS))
		     (PRINC
		       (CONCATENATE 'STRING "   clause: " (PRINC-TO-STRING (DS-PNAME CLAUSE)) " litno: "
				    (PRINC-TO-STRING (1+ RPTN)))
		       STREAM)
		     (TERPRI STREAM)
		     (MAPC
		       #'(LAMBDA (SIMPLIFIER)
			   (PRINC
			     (CONCATENATE 'STRING "     clause: "
					  (PRINC-TO-STRING (DS-PNAME (DIRECT.SIMPL-CLAUSE SIMPLIFIER))) "  from.litno: "
					  (PRINC-TO-STRING (DIRECT.SIMPL-FROM.LITNO SIMPLIFIER)) "  to.litno: "
					  (PRINC-TO-STRING (DIRECT.SIMPL-TO.LITNO SIMPLIFIER)) "  rest.litnos: "
					  (PRINC-TO-STRING (DIRECT.SIMPL-REST.LITNOS SIMPLIFIER)) "  accessors: "
					  (PRINC-TO-STRING (DIRECT.SIMPL-ACCESSORS SIMPLIFIER)) "  link: "
					  (PRINC-TO-STRING (DIRECT.SIMPL-LINK SIMPLIFIER)))
			     STREAM)
			   (TERPRI STREAM))
		       SIMPLIFIER)))))
      (CG-CLAUSES ALL))
    (TERPRI STREAM) (PRINC "indirect.simplifier.clauses: " STREAM) (TERPRI STREAM)
    (MAPC
      #'(LAMBDA (CLAUSE)
	  (DODOWN (RPTN (DS-CLAUSE.NOLIT CLAUSE))
		  (COND
		    ((SETQ SIMPLIFIER (DS-CLAUSE.LIT.GETPROP CLAUSE (1+ RPTN) 'INDIRECT.SIMPLIFIER.CLAUSES))
		     (PRINC
		       (CONCATENATE 'STRING "   clause: " (PRINC-TO-STRING (DS-PNAME CLAUSE)) " litno: "
				    (PRINC-TO-STRING (1+ RPTN)))
		       STREAM)
		     (TERPRI STREAM)
		     (MAPC
		       #'(LAMBDA (SIMPLIFIER)
			   (PRINC
			     (CONCATENATE 'STRING "     clause: "
					  (PRINC-TO-STRING (DS-PNAME (IND.SIMPL-CLAUSE SIMPLIFIER))) "  from.litno: "
					  (PRINC-TO-STRING (IND.SIMPL-FROM.LITNO SIMPLIFIER)) "  from.accessors: "
					  (PRINC-TO-STRING (IND.SIMPL-FROM.ACCESSORS SIMPLIFIER)) "  to.litno: "
					  (PRINC-TO-STRING (IND.SIMPL-TO.LITNO SIMPLIFIER)) "  to.accessors: "
					  (PRINC-TO-STRING (IND.SIMPL-TO.ACCESSORS SIMPLIFIER)) "  simp.litno: "
					  (PRINC-TO-STRING (IND.SIMPL-SIMP.LITNO SIMPLIFIER)) "  rest.litnos: "
					  (PRINC-TO-STRING (IND.SIMPL-REST.LITNOS SIMPLIFIER)) "  link: "
					  (PRINC-TO-STRING (IND.SIMPL-LINK SIMPLIFIER)))
			     STREAM)
			   (TERPRI STREAM))
		       SIMPLIFIER)))))
      (CG-CLAUSES ALL))
    (TERPRI STREAM) (PRINC "indirect.simplifier.units: " STREAM) (TERPRI STREAM)
    (MAPC
      #'(LAMBDA (CLAUSE)
	  (DODOWN (RPTN (DS-CLAUSE.NOLIT CLAUSE))
		  (COND
		    ((SETQ SIMPLIFIER (DS-CLAUSE.LIT.GETPROP CLAUSE (1+ RPTN) 'INDIRECT.SIMPLIFIER.UNITS))
		     (PRINC
		       (CONCATENATE 'STRING "   clause: " (PRINC-TO-STRING (DS-PNAME CLAUSE)) " litno: "
				    (PRINC-TO-STRING (1+ RPTN)))
		       STREAM)
		     (TERPRI STREAM)
		     (MAPC
		       #'(LAMBDA (SIMPLIFIER) (PRINC "     unit:       " STREAM)
				 (PRINC (DS-PNAME (TERM=UNIT.MAKE.TERMLIST (IND.SIMPL.UNIT-UNIT SIMPLIFIER))) STREAM) (TERPRI STREAM)
				 (PRINC "     simplified: " STREAM)
				 (PRINC (DS-PNAME (IND.SIMPL.UNIT-SIMP.TERMLIST SIMPLIFIER)) STREAM)
				 (PRINC "     accessors:    " STREAM)
				 (PROGN (PRINC (IND.SIMPL.UNIT-ACCESSORS SIMPLIFIER) STREAM) (TERPRI STREAM)))
		       SIMPLIFIER)))))
      (CG-CLAUSES ALL))
    (TERPRI STREAM)))


#+symbolics
(defmacro term-trace (switch)
  `(term==trace ',switch))

#+symbolics
(DEFUN TERM==TRACE (SWITCH)
  ;; INPUT:  T, ON OR OFF.
  ;; EFFECT: TERMINATOR TRACE IS SWITHCHED ON RESP. OFF.
  ;; VALUE:  A MESSAGED ABOUT THE PERFORMED ACTION.
  (CASE SWITCH
    ((T ON)
     (tagbody
       ERROR
       (TERPRI) (PRINC "PRINT UNITS TOO? (Y N) ")
       (SETQ TERM*PRINT.UNITS (READ T))
       (CASE TERM*PRINT.UNITS
	 (Y)
	 (N (SETQ TERM*PRINT.UNITS NIL))
	 (OTHERWISE (PROGN (TERPRI) (PRINC "INVALID INPUT! ") (GO ERROR)))))
     (global:advise TERM-TERMINATOR :BEFORE term 0 (TERM=TRACE.ENTER (first scl:arglist) (second scl:arglist) (third scl:arglist)
								     (fourth scl:arglist)))
     (GLOBAL:ADVISE TERM-TERMINATOR :AFTER term 0 (TERM=TRACE.LEAVE (first scl:values)))
     (GLOBAL:ADVISE TERM-1_TERMINATOR :BEFORE term 0 (TERM=TRACE.1_ENTER (first scl:arglist) (second scl:arglist) (third scl:arglist)
									 (fourth scl:arglist)))
     (GLOBAL:ADVISE TERM-1_TERMINATOR :AFTER term 0 (TERM=TRACE.LEAVE (first scl:values)))
     (GLOBAL:ADVISE TERM-2_TERMINATOR :BEFORE term 0
       (TERM=TRACE.2_ENTER (first scl:arglist) (second scl:arglist) (third scl:arglist)
			   (fourth scl:arglist) (fifth scl:arglist)))
     (GLOBAL:ADVISE TERM-2_TERMINATOR :AFTER term 0 (TERM=TRACE.LEAVE (first scl:values)))
     (GLOBAL:ADVISE TERM=CREATE.INITIAL.UNITS :AFTER term 0 (SETQ TERM*UNITCOUNTER (LIST-LENGTH (first scl:values))))
     (GLOBAL:ADVISE TERM=CREATE.NEW.HINTS :BEFORE term 0
       (TERM=TRACE.NEW.UNITS (first scl:arglist) (second scl:arglist) (third scl:arglist)))
     (GLOBAL:ADVISE TERM=EXAMINE.CLAUSE :BEFORE term 0
       (format TERM*FILE "~%COMPATIBILITY TEST FOR CLAUSE ~D = ~A.  ~D. iteration~%"
	       (first scl:arglist) (DS-PNAME (first scl:arglist)) (1+ COUNTER)))
     (GLOBAL:ADVISE TERM=1_EXAMINE.CLAUSE :BEFORE term 0
       (format TERM*FILE "~%COMPATIBILITY TEST FOR CLAUSE ~D = ~A.  ~D. iteration~%"
	       (first scl:arglist) (DS-PNAME (first scl:arglist)) (1+ COUNTER)))
     (GLOBAL:ADVISE TERM=MERGE BEFORE term 0 (TERM=TRACE.MERGE (first scl:arglist) (second scl:arglist) (sixth scl:arglist)))
     (GLOBAL:ADVISE TERM=MERGE AFTER term 0
       (format TERM*FILE "~D are compatible.~%" (LIST-LENGTH (MI-TERMSTRUCTURE.TERMLISTS (first scl:values)))))
     (GLOBAL:ADVISE TERM=CREATE.UNITS :BEFORE term 0
       (PROGN (SETQ TERM*UNITCOUNTER.PARTIAL 0)
	      (SETQ TERM*UNIFIERCOUNTER.PARTIAL (LIST-LENGTH (MI-TERMSTRUCTURE.TERMLISTS (fourth scl:arglist))))
	      (SETQ TERM*UNIFIERCOUNTER.TOTAL (+ TERM*UNIFIERCOUNTER.TOTAL TERM*UNIFIERCOUNTER.PARTIAL))))
     (GLOBAL:ADVISE TERM=CREATE.UNITS AFTER term 0 (TERM=TRACE.STATISTICS))
     '(TERM-TRACE SWITCHED ON. OUTPUT WILL GO TO TERMINAL.)
     (CASE SWITCH
       ((T) (SETQ TERM*TERMINAL T) '(TERM-TRACE SWITCHED ON. OUTPUT WILL GO TO TERMINAL.))
       (ON (SETQ TERM*TERMINAL NIL) '(TERM-TRACE SWITCHED ON. OUTPUT WILL GO TO PROTOCOL FILE.))
       (OTHERWISE NIL)))
    (OFF
      (mapc #'(lambda (fun) (eval `(global:UNADVISE ,fun)))
	    '(TERM-TERMINATOR TERM-1_TERMINATOR TERM-2_TERMINATOR TERM=CREATE.NEW.HINTS
			      TERM=EXAMINE.CLAUSE TERM=1_EXAMINE.CLAUSE TERM=MERGE TERM=CREATE.UNITS TERM=CREATE.INITIAL.UNITS))
      '(TERM-TRACE SWITCHED OFF))
    (OTHERWISE '(INVALID ARGUMENT! TRY (TERM-TRACE ON) (TERM-TRACE T) OR (TERM-TRACE OFF)))))

(DEFUN TERM=TRACE.ENTER (OLDCLAUSES NEWCLAUSES SUPPORTED.CLAUSES FASTFLAG)
  ;; EDITED: 25-OCT-82 12:09:31
  ;; EFFECT: PRINTS A MESSAGE WHILE ENTERING THE
  ;;         TERMINATOR AND SETS TERM*FILE.
  (SETQ TERM*FILE (OR TERM*TERMINAL (OPT-GET.OPTION TR_TRACE.FILE))) (PRINC "ENTERING THE TERMINATOR." TERM*FILE)
  (TERPRI TERM*FILE) (PRINC "OLD CLAUSES:       " TERM*FILE) (PRINC (DS-PNAME OLDCLAUSES) TERM*FILE) (TERPRI TERM*FILE)
  (PRINC "NEW CLAUSES:       " TERM*FILE) (PRINC (DS-PNAME NEWCLAUSES) TERM*FILE) (TERPRI TERM*FILE)
  (PRINC "SUPPORTED CLAUSES: " TERM*FILE) (PRINC (DS-PNAME SUPPORTED.CLAUSES) TERM*FILE) (TERPRI TERM*FILE)
  (PRINC (CONCATENATE 'STRING "FASTFLAG:          " (PRINC-TO-STRING FASTFLAG)) TERM*FILE) (TERPRI TERM*FILE)
  (TERPRI TERM*FILE) (SETQ TERM*UNITCOUNTER.TOTAL 0) (SETQ TERM*UNIFIERCOUNTER.TOTAL 0))

(DEFUN TERM=TRACE.1_ENTER (OLDCLAUSES NEWCLAUSES CILS ITERATIONS)
  ;; EDITED: 25-OCT-82 12:09:31
  ;; EFFECT: PRINTS A MESSAGE WHILE ENTERING THE
  ;;         TERMINATOR AND SETS TERM*FILE.
  (SETQ TERM*FILE (OR TERM*TERMINAL (OPT-GET.OPTION TR_TRACE.FILE))) (PRINC "ENTERING  TERMINATOR:1." TERM*FILE)
  (TERPRI TERM*FILE) (PRINC "OLD CLAUSES:       " TERM*FILE) (PRINC (DS-PNAME OLDCLAUSES) TERM*FILE) (TERPRI TERM*FILE)
  (PRINC "NEW CLAUSES:       " TERM*FILE) (PRINC (DS-PNAME NEWCLAUSES) TERM*FILE) (TERPRI TERM*FILE)
  (PRINC "CILS:              " TERM*FILE)
  (PRINC
    (MAPCAR
      #'(LAMBDA (CILS) (NCONC (LIST (DS-PNAME (CAR CILS)) (SECOND CILS)) (DS-PNAME (CDDR CILS)))) CILS)
    TERM*FILE)
  (TERPRI TERM*FILE) (PRINC (CONCATENATE 'STRING "ITERATIONS:        " (PRINC-TO-STRING ITERATIONS)) TERM*FILE)
  (TERPRI TERM*FILE) (TERPRI TERM*FILE) (SETQ TERM*UNITCOUNTER.TOTAL 0) (SETQ TERM*UNIFIERCOUNTER.TOTAL 0))

(DEFUN TERM=TRACE.2_ENTER (OLDCLAUSES NEWCLAUSES SUPPORTED.CLAUSES &optional CONDITION ITERATIONS)
  (declare (ignore condition))
  ;; EDITED: 25-OCT-82 12:09:31
  ;; EFFECT: PRINTS A MESSAGE WHILE ENTERING THE
  ;;         TERMINATOR AND SETS TERM*FILE.
  (SETQ TERM*FILE (OR TERM*TERMINAL (OPT-GET.OPTION TR_TRACE.FILE))) (PRINC "ENTERING TERMINATOR-2. " TERM*FILE)
  (TERPRI TERM*FILE) (PRINC "OLD CLAUSES:       " TERM*FILE) (PRINC (DS-PNAME OLDCLAUSES) TERM*FILE) (TERPRI TERM*FILE)
  (PRINC "NEW CLAUSES:       " TERM*FILE) (PRINC (DS-PNAME NEWCLAUSES) TERM*FILE) (TERPRI TERM*FILE)
  (PRINC "SUPPORTED CLAUSES: " TERM*FILE) (PRINC (DS-PNAME SUPPORTED.CLAUSES) TERM*FILE) (TERPRI TERM*FILE)
  (PRINC (CONCATENATE 'STRING "ITERATIONS         " (PRINC-TO-STRING ITERATIONS)) TERM*FILE) (TERPRI TERM*FILE)
  (TERPRI TERM*FILE) (SETQ TERM*UNITCOUNTER.TOTAL 0) (SETQ TERM*UNIFIERCOUNTER.TOTAL 0))

(DEFUN TERM=TRACE.LEAVE (RESULTVALUE)
  ;; EDITED: 25-OCT-82 12:24:01
  ;; EFFECT: PRINTS STATISTICS WHEN LEAVING THE
  ;;         TERMINATOR.
  (COND
    ((EQL (CAR RESULTVALUE) 'PROVED) (TERPRI TERM*FILE)
     (PRINC
       (CONCATENATE 'STRING "NUMBER OF DERIVED UNITS IN PROOF: "
		    (PRINC-TO-STRING (LIST-LENGTH (CDR RESULTVALUE))) "  PENETRANCE: "
		    (PRINC-TO-STRING
		      (* 100 (/ (LIST-LENGTH (CDR RESULTVALUE)) (+ TERM*UNITCOUNTER.TOTAL TERM*UNITCOUNTER))))
		    " %")
       TERM*FILE)
     (TERPRI TERM*FILE) (TERPRI TERM*FILE) (PRINC "REFUTATION CHAIN:" TERM*FILE) (TERPRI TERM*FILE)
     (PROGN (PRINC RESULTVALUE TERM*FILE) (TERPRI TERM*FILE)) (TERPRI TERM*FILE))))

(DEFUN TERM=TRACE.MERGE (TRACE.UNIFIERS1 TRACE.UNIFIERS2 TULISTS)
  (PRINC
    (CONCATENATE 'STRING "  MERGING UNIFIERS FROM LITERALS "
		 (PRINC-TO-STRING (TERM=TULIST.LITNOS (CAR TULISTS))) " AND "
		 (PRINC-TO-STRING (TERM=TULIST.LITNOS (SECOND TULISTS))) "  "
		 (PRINC-TO-STRING (LIST-LENGTH (MI-TERMSTRUCTURE.TERMLISTS TRACE.UNIFIERS1))) " WITH "
		 (PRINC-TO-STRING (LIST-LENGTH (MI-TERMSTRUCTURE.TERMLISTS TRACE.UNIFIERS2))) " : ")
    TERM*FILE))

(DEFUN TERM=TRACE.NEW.UNITS (CLAUSE LITNO UNITS)
  ;; EDITED: 25-OCT-82 12:30:56
  ;; EFFECT: UPDATES STATISTICAL VALUES AND PRINTS
  ;;         THE NEW UNITS.
  (MAPC
    #'(LAMBDA (UNIT) (SETQ TERM*UNITCOUNTER.TOTAL (1+ TERM*UNITCOUNTER.TOTAL))
	      (SETQ TERM*UNITCOUNTER.PARTIAL (1+ TERM*UNITCOUNTER.PARTIAL))
	      (COND
		(TERM*PRINT.UNITS
		 (PRINC
		   (CONCATENATE 'STRING (PRINC-TO-STRING TERM*UNITCOUNTER.TOTAL) "  LITNO: " (PRINC-TO-STRING LITNO)
				"  LITERAL:  ")
		   TERM*FILE)
		 (PRINC
		   (DS-PNAME
		     (LIST (DS-CLAUSE.SIGN CLAUSE LITNO) (DS-CLAUSE.PREDICATE CLAUSE LITNO) (TERM=UNIT.MAKE.TERMLIST UNIT)))
		   TERM*FILE)
		 (TERPRI TERM*FILE))))
    UNITS))

(DEFUN TERM=TRACE.STATISTICS NIL
  ;; EDITED: 25-OCT-82 12:47:12
  ;; EFFECT: PRINTS STATISTICAL VALUES.
  (COND
    ((NOT (ZEROP TERM*UNITCOUNTER.PARTIAL)) (TERPRI TERM*FILE)
     (PRINC
       (CONCATENATE 'STRING "NUMBER OF MERGED UNIFIERS FOR THIS LITERAL: "
		    (PRINC-TO-STRING TERM*UNIFIERCOUNTER.PARTIAL))
       TERM*FILE)
     (TERPRI TERM*FILE)
     (PRINC
       (CONCATENATE 'STRING "NUMBER OF NEW UNITS:                        "
		    (PRINC-TO-STRING TERM*UNITCOUNTER.PARTIAL) "  "
		    (PRINC-TO-STRING (* 100 (/ TERM*UNITCOUNTER.PARTIAL TERM*UNIFIERCOUNTER.PARTIAL))) " %")
       TERM*FILE)
     (TERPRI TERM*FILE)
     (PRINC
       (CONCATENATE 'STRING "TOTAL NUMBER OF MERGED UNIFIERS:            "
		    (PRINC-TO-STRING TERM*UNIFIERCOUNTER.TOTAL))
       TERM*FILE)
     (TERPRI TERM*FILE)
     (PRINC
       (CONCATENATE 'STRING "TOTAL NUMBER OF UNITS:                      "
		    (PRINC-TO-STRING TERM*UNITCOUNTER.TOTAL) "  "
		    (PRINC-TO-STRING (* 100 (/ TERM*UNITCOUNTER.TOTAL TERM*UNIFIERCOUNTER.TOTAL))) " %")
       TERM*FILE)
     (TERPRI TERM*FILE) (TERPRI TERM*FILE))))

(DEFUN TERM=PNAME (TERM)
  (DS-PNAME
    (SUBPAIR '(X Y Z U V W P Q R S T X1 Y1 X2 Y2 X3 Y3 X4 Y4 X5 Y5 X6 Y6) (DT-TERMLIST.VARIABLES TERM) TERM)))

(DEFUN TERM=SHOW.UNINODES (CLAUSE LITNO STREAM)
  (MAPC #'(LAMBDA (UNINODE)
	    (TERPRI STREAM)
	    (PRINC (TERM=PNAME (TERM=UNIT.MAKE.TERMLIST (TERM=UNINODE.UNIT UNINODE))) STREAM))
	(CAR (DS-CLAUSE.LIT.GETPROP CLAUSE LITNO 'UNINODE))))