;;; -*- Package: MKRP; Syntax: Common-lisp; Mode: Lisp -*-

(IN-PACKAGE "MKRP" :use '("CL"))

(DEFVAR MI*INFORMATION NIL)

(DEFVAR MI*FULL.UNIFICATION T)

(DEFMACRO MI-CREATE.EMPTY.TERMSTRUCTURE (PATTERN)
  ;; EDITED: 26-OCT-82 18:05:24
  ;; INPUT:  PATTERN IS A LIST WITH ELEMENTS T OR NIL
  ;;         OR A LIST OF VARIABLES.
  ;;         FOR EVERY POSITION REPRESENTED BY T, A
  ;;         TERM CAN BE INSERTED INTO THE NEW
  ;;         TERMSTRUCTURE. (PATTERN MAY BE NIL).
  ;;         IF PATTERN IS A LIST OF VARIABLES,
  ;;         SUBSTITUTIONS CAN BE TRANSFORMED INTO
  ;;         T-REPRESENTATION ACCORDING TO THIS VARIABLES
  ;;         AND INSERTED INTO THIS TERMSTRUCTURE.
  ;; VALUE:  THE NEW EMPTY TERMSTRUCTURE
  `(MI=TERMSTRUCTURE_INITIALIZE ,PATTERN))

(DEFUN MI-INSERT.TERMLIST.INTO.TERMSTRUCTURE (TERMSTRUCTURE TERMLIST PROPERTY TRANSFORMATIONS INSTANCETEST)
  ;; EDITED: 11-NOV-82 14:12:58
  ;; INPUT:  AN MI-TERMSTRUCTURE, A TERMLIST IN
  ;;         STANDARD REPRESENTATION, AN ARBITRARY
  ;;         S-EXPRESSION.
  ;;         TRANSFORMATIONS IS A LIST WITH ELEMENTS
  ;;         (TERMSTRUCTURE . TERMLIST-TRANSFORMATION)
  ;;         WHERE TERMSTRUCTURE IS AN ARBITRARY
  ;;         MI-TERMSTRUCTURE AND TERMLIST-TRANSFORMATION
  ;;         IS A FUNCTION FOR MANIPULATING TERMLISTS>
  ;;         INSTANCETEST IS A BOOLEAN VALUE
  ;; EFFECT: IF INSTANCETEST = NIL OR THE TERMLIST IS
  ;;         NOT SUBSUMED EITHER BY ANOTHER TERMLIST IN
  ;;         THE SAME TERMSTRUCTURE OR AFTER APPLYING A
  ;;         TRANSFORMATION DEFINED IN TRANSFORMATIONS.
  ;; VALUE:  THE NEW MI-TERMLIST.
  (COND
    (INSTANCETEST
     (COND
       ((ZEROP (MI=TERMSTRUCTURE_ARITY TERMSTRUCTURE))
	(COND
	  ((NULL (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE))
	   (MI=TERMSTRUCTURE_INSERT.TERMLIST.1 TERMSTRUCTURE TERMLIST PROPERTY))))
       (T
	(PROG ((DESCRIPTORS (MI=INSTANCE.TEST TERMLIST TERMSTRUCTURE TRANSFORMATIONS)))
	      (COND
		((NEQ T DESCRIPTORS)
		 (RETURN (MI=TERMSTRUCTURE_INSERT.TERMLIST.2 TERMSTRUCTURE TERMLIST PROPERTY DESCRIPTORS))))))))
    (T (MI=TERMSTRUCTURE_INSERT.TERMLIST.1 TERMSTRUCTURE TERMLIST PROPERTY))))

(DEFUN MI-INSERT.SUBSTITUTION.INTO.TERMSTRUCTURE (TERMSTRUCTURE SUBSTITUTION PROPERTY INSTANCETEST)
  ;; EDITED: 10-OCT-83 16:31:18
  ;; INPUT:  A TERMSTRUCTURE, A SUBSTITUTION IN
  ;;         STANDARD REPRESENTATION, AN S-EXPRESSION
  ;;         AND A FLAG.
  ;; EFFECT: THE SUBSTITUTION IS TRANSFORMED INTO
  ;;         THE T-REPRESENTATION ACCORDING
  ;;         TO TERMSTRUCTURE'S VARIABLE PATTERN.
  ;;         IF INSTANCETEST = NIL OR
  ;;         (INSTANCETEST = T AND IT IS NO INSTANCE
  ;;         OF AN ALREADY INSERTED SUBSTITUTION) IT
  ;;         IS INSERTED INTO TERMSTRUCTURE.
  ;; VALUE:  A POINTER TO THE NEW MI-TERMLIST
  (MI-INSERT.TERMLIST.INTO.TERMSTRUCTURE TERMSTRUCTURE
					 (MI=SUBSTITUTION.TO.TERMLIST SUBSTITUTION (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE)) PROPERTY NIL INSTANCETEST))

(DEFUN MI-MERGE.TERMSTRUCTURES (TERMSTRUCTURE1 TERMSTRUCTURE2 TARGETPATTERN CONNECTION CONDITION1 CONDITION2
				PROPERTY.CONNECTION INSTANCETEST ABBREVIATION.SCHEME)
						; edited:  8-feb-83 12:37:09
						; input:   two mi-termstructures;
						;          the patterns of both termstructures and the
						;          targetpattern must be of the same length]
						;          connection, condition1 and condition2
						;          are truth value functions which
						;          when applied to the properties of a pair
						;          of termlists allow resp. forbid merging
						;          of these pair of termlists.
						;          property.connection is a function which
						;          combines the property values of two
						;          merged termlists.
						;          instancetest is a boolean value.
						;          abbreviation.scheme is either nil or
						;          a scheme created by
						;          ds-abbreviation.create.new.scheme.
						; value:   a new mi-termstructure representing
						;          the unified pairs of termlists of
						;          termstructure1 termstructure2
						;          if instancetest = t, no merged termlists
						;          which are instances of earlier created ones
						;          are inserted into the new termstructure.
  (catch 'MI-MERGE.TERMSTRUCTURES
    (when (AND TERMSTRUCTURE1 TERMSTRUCTURE2)
    (when (> (LIST-LENGTH (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE1))
	     (LIST-LENGTH (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE2)))
      (let ((DUMMY TERMSTRUCTURE1))
	(SETQ TERMSTRUCTURE1 TERMSTRUCTURE2) (SETQ TERMSTRUCTURE2 DUMMY)
	(SETQ DUMMY CONDITION1) (SETQ CONDITION1 CONDITION2) (SETQ CONDITION2 DUMMY)))
    (SETQ TARGETPATTERN (MI=CUT.TARGETPATTERN TERMSTRUCTURE1 TERMSTRUCTURE2 TARGETPATTERN))
    (PROG ((NEW.TERMSTRUCTURE (MI-CREATE.EMPTY.TERMSTRUCTURE TARGETPATTERN))
	   (TERM.PATTERN (MI=INTERSECT.POSITIONLISTS TERMSTRUCTURE1 TERMSTRUCTURE2))
	   (RETURNFLAG (AND INSTANCETEST (NOTANY #'identity TARGETPATTERN))) (DEPTH (OPT-GET.OPTION STR_TERM.DEPTH)) POSITIONLIST1
	   POSITIONLIST2 ARITY CONDITION CANDIDATES CANDIDATES.END FIRST TERMS TERMS2 CANDIDATES.NO (TML.NO 1))
	  (SETQ POSITIONLIST1 (CAR TERM.PATTERN)) (SETQ POSITIONLIST2 (SECOND TERM.PATTERN))
	  (SETQ TERM.PATTERN (CDDR TERM.PATTERN))
	  (COND
	    ((NOTANY #'identity TERM.PATTERN)
	     (RETURN
	       (MI=MERGE.DISJOINT.TERMSTRUCTURES TERMSTRUCTURE1 TERMSTRUCTURE2 NEW.TERMSTRUCTURE CONNECTION
						 CONDITION1 CONDITION2 PROPERTY.CONNECTION INSTANCETEST))))
	  (SETQ CANDIDATES (copy-list (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE2)))
	  (SETQ ARITY (LIST-LENGTH POSITIONLIST1)) (MI=CREATE.TLINKS POSITIONLIST1 POSITIONLIST2)
	  (COND
	    (MI*INFORMATION (SETQ CANDIDATES.NO (LIST-LENGTH CANDIDATES)) (TERPRI) (PRINC "max.candidates ")
			    (PROGN (PRINC CANDIDATES.NO) (TERPRI))))
	  (MAPC #'(LAMBDA (TERMLIST1) (COND (MI*INFORMATION (PRINC " no ") (PRINC TML.NO) (SETQ TML.NO (1+ TML.NO))))
			  (SETQ CONDITION (FUNCALL (OR CONDITION1 #'identity) (MI=EXPRESSION_PROPERTY TERMLIST1)))
			  (SETQ FIRST T)
			  (SETQ CANDIDATES.END CANDIDATES) (SETQ CANDIDATES.NO 0)
			  (MAPC #'(LAMBDA (SINGLETERM PAT)
				    (COND (PAT (sMAPC #'(LAMBDA (OTHERSIDE) 
							 (COND (FIRST
								(MAPC #'(LAMBDA (TERMLIST)
									  (COND ((FUNCALL CONNECTION CONDITION
											  (FUNCALL (OR CONDITION2 #'identity)
												   (MI=EXPRESSION_PROPERTY TERMLIST)))
										 (MI=EXPRESSION_PUT.AUXILIARY TERMLIST 1)
										 (RPLACA CANDIDATES.END TERMLIST)
										 (SETQ CANDIDATES.NO (1+ CANDIDATES.NO))
										 (SETQ CANDIDATES.END (CDR CANDIDATES.END)))))
								      (MI=EXPRESSION_SUPERTERMS OTHERSIDE)))
							       (T (MI=EXPRESSION_INCREMENT.SUPERTERMS OTHERSIDE))))
						      #'(lambda (tail) (when (consp (cdr tail)) (cdr tail)))
						     (when (consp (MI=EXPRESSION_TLINKS SINGLETERM))
						       (MI=EXPRESSION_TLINKS SINGLETERM))) 
					       (SETQ FIRST NIL))))
				(MI=EXPRESSION_SUBTERMS TERMLIST1)  TERM.PATTERN)
			  (COND
			    ((NEQ CANDIDATES CANDIDATES.END)
			     (COND (MI*INFORMATION (PRINC " cnd ") (PRINC CANDIDATES.NO) (SETQ CANDIDATES.NO 0)))
			     (SETQ TERMS (MI=EXPRESSION_STANDARDTERM TERMLIST1))
			     (SMAPC #'(LAMBDA (TERMLIST2)
					(COND ((EQL ARITY (MI=EXPRESSION_AUXILIARY TERMLIST2))
					       (MAPC #'(LAMBDA (UNIFIER) (SETQ TERMS2 (UNI-APPLY.SUBSTITUTION UNIFIER TERMS T))
							 (COND
							   ((MI=TERMLIST.IS.NOT.TOO.DEEP TERMS2 TARGETPATTERN DEPTH)
							    (COND
							      (ABBREVIATION.SCHEME
							       (SETQ TERMS2 (CAR (DT-ABBREVIATION.COMPRESS.TERMLIST TERMS2)))))
							    (SETQ CANDIDATES.NO (1+ CANDIDATES.NO))
							    (MI-INSERT.TERMLIST.INTO.TERMSTRUCTURE
							      NEW.TERMSTRUCTURE TERMS2						   
							      (FUNCALL PROPERTY.CONNECTION (MI=EXPRESSION_PROPERTY TERMLIST1)
								       (MI=EXPRESSION_PROPERTY TERMLIST2) TERMLIST1 TERMLIST2)
							      NIL INSTANCETEST)
							    (COND
							      (RETURNFLAG (MI=MERGE.CLEAR.AUXILIARY TERMSTRUCTURE1 TERMSTRUCTURE2)
									  (RETURN-FROM MI-MERGE.TERMSTRUCTURES NEW.TERMSTRUCTURE))))))
						     (UNI-UNIFY.TERMLISTS TERMS (MI=EXPRESSION_STANDARDTERM TERMLIST2))))))
				    (FUNCTION (LAMBDA (TAIL) (COND ((NEQ CANDIDATES.END (CDR TAIL)) (CDR TAIL))))) CANDIDATES)
			     (COND (MI*INFORMATION (PRINC " act ") (PRINC CANDIDATES.NO))))))
		(MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE1))
	  (MI=MERGE.CLEAR.AUXILIARY TERMSTRUCTURE1 TERMSTRUCTURE2)
	  (COND ((MI=TERMSTRUCTURE_EXPRESSIONS NEW.TERMSTRUCTURE) (RETURN NEW.TERMSTRUCTURE)))))))

(DEFMACRO MI=TERMLIST.IS.NOT.TOO.DEEP (TERMLIST PATTERN DEPTH)
  `(let ((flag t))
     (cond (,depth (mapc #'(lambda (term pat)
			     (cond ((and pat (> (dt-termlist.maxdepth term) ,depth))
				    (setq flag nil)
				    (return nil))))
			 ,termlist ,pattern)))
     flag))

(DEFUN MI-MERGE (TERMSTRUCTURE1 TERMSTRUCTURE2 TARGETPATTERN PRECONNECTION PRECONDITION1 PRECONDITION2 POSTCONDITION
		 PROPERTY.CONNECTION INSTANCETEST ABBREVIATION.SCHEME)
  ;; EDITED: 10-NOV-83 16:39:43
  ;; INPUT: TWO TERMSTRUCTURES WITH VARIABLE PATTERNS.
  ;;        TARGETPATTERN IS A LIST OF VARIABLES FOR
  ;;        WHICH THE SUBSTITUTIONCOMPONENTS OF THE
  ;;        MERGES SHALL BE STORED.
  ;;        PRECONDITION1 AND PRECONDITION2 ARE FUNCTIONS
  ;;        WHICH WILL BE APPLIED TO THE PROPERTIES
  ;;        OF THE TERMLISTS OF TERMSTRUCTURE1
  ;;        AND TERMSTRUCTURE2.
  ;;        PRECONNECTION IS A TRUTH VALUE FUNCTION
  ;;        WHICH WILL BE APLIED TO THE RESULTS OF
  ;;        THE APLICATION OF PRECONDITION1 AND
  ;;        PRECONDITION2. ONLY WHEN
  ;;        (APPLY* PRECONNECTION
  ;;                (APPLY* PRECONDITION1 PROPERTY1)
  ;;                (APPLY* PRECONDITION2 PROPERTY2))
  ;;        =//= NIL, THIS PAIR OF TERMLISTS IS
  ;;        MERGED.
  ;;        POSTCONDITION IS A TRUTH VALUE FUNCTION
  ;;        WHICH WILL BE APLIED TO (PROPERTY TERMLIST)
  ;;        THE NEW TERMLIST WILL BE INSERTED, ONLY IF
  ;;        ITS APPLICATION IS =//= NIL.
  ;;        PROPERTY.CONNECTION IS A FUNCTION WHICH WILL
  ;;        BE APPLIED TO
  ;;        (PROPERTY1 PROPERTY2 TERMLIST1 TERMLIST2)
  ;;        AND DETERMINES THE PROPERTY FOR THE MERGED
  ;;        TERMLIST.
  ;;        INSTANCETEST IS A FLAG FOR ACTIVATING A
  ;;        FOREWARD SUBSUMPTION TEST BEFORE THE MERGED
  ;;        TERMLISTS ARE INSERTED INTO THE NEW
  ;;        TERMSTRUCTURE.
  ;;        ABBREVIATION.SCHEME IS EITHER NIL OR AN
  ;;        ABBREVIATION.SCHEME.
  ;; VALUE: A NEW TERMSTRUCTURE WITH THE MERGED PAIRS
  ;;        OF SUBSTITUTIONS OF THE GIVEN TERMSTRUCTURES
  ;;
  ;; WARNING: THE ORDER OF THE TERMSTRUCTURES MAY BE
  ;;          CHANGED INTERNALLY, THEREFORE THE FUNCTIONS
  ;;          HAVE TO BE SYMMETRIC IN THE TWO
  ;;          TERMSTRUCTURES.
  (COND
    ((AND TERMSTRUCTURE1 TERMSTRUCTURE2)
     (COND
       ((> (LIST-LENGTH (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE1))
           (LIST-LENGTH (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE2)))
	(PROG ((DUMMY TERMSTRUCTURE1)) (SETQ TERMSTRUCTURE1 TERMSTRUCTURE2) (SETQ TERMSTRUCTURE2 DUMMY)
	      (SETQ DUMMY PRECONDITION1) (SETQ PRECONDITION1 PRECONDITION2) (SETQ PRECONDITION2 DUMMY))))
     (PROG
       ((PATTERN1 (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE1)) TERM.PATTERN POSITIONLIST1 POSITIONLIST2
	(PATTERN2 (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE2))
	(NEW.TERMSTRUCTURE (MI-CREATE.EMPTY.TERMSTRUCTURE TARGETPATTERN))
	(RETURNFLAG (AND INSTANCETEST (NOTANY #'identity TARGETPATTERN))) ARITY CONDITION CANDIDATES CANDIDATES.END FIRST
	TERMS TERMS1 TERMS2)
       (DECLARE (SPECIAL TERM.PATTERN POSITIONLIST1 POSITIONLIST2))
       (MI=INTERSECT TERMSTRUCTURE1 TERMSTRUCTURE2)
       (COND
	 ((NULL POSITIONLIST1)
	  (RETURN
	    (MI=MERGE.DISJOINT TERMSTRUCTURE1 TERMSTRUCTURE2 NEW.TERMSTRUCTURE PRECONNECTION PRECONDITION1
			       PRECONDITION2 POSTCONDITION PROPERTY.CONNECTION INSTANCETEST))))
       (SETQ CANDIDATES (MAPCAR #'(lambda (x) (declare (ignore x)) nil)
				(MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE2)))
       (SETQ ARITY (LIST-LENGTH POSITIONLIST1)) (MI=CREATE.TLINKS POSITIONLIST1 POSITIONLIST2)
       (MAPC
	 (FUNCTION
	   (LAMBDA (TERMLIST1) (SETQ CONDITION (FUNCALL PRECONDITION1 (MI=EXPRESSION_PROPERTY TERMLIST1)))
		   (SETQ FIRST T) (SETQ CANDIDATES.END CANDIDATES)
		   (MAPC
		     (FUNCTION
		       (LAMBDA (SINGLETERM PAT)
			 (COND
			   (PAT
			    (MAPC
			      (FUNCTION
				(LAMBDA (OTHERSIDE)
				  (COND
				    (FIRST
				     (MAPC
				       (FUNCTION
					 (LAMBDA (TERMLIST)
					   (COND
					     ((FUNCALL PRECONNECTION CONDITION
						       (FUNCALL PRECONDITION2 (MI=EXPRESSION_PROPERTY TERMLIST)))
                                              (MI=EXPRESSION_PUT.AUXILIARY TERMLIST 1)
                                              (RPLACA CANDIDATES.END TERMLIST)
                                              (SETQ CANDIDATES.END (CDR CANDIDATES.END))))))
				       (MI=EXPRESSION_SUPERTERMS OTHERSIDE)))
				    (T (MI=EXPRESSION_INCREMENT.SUPERTERMS OTHERSIDE)))))
			      (MI=EXPRESSION_TLINKS SINGLETERM))
			    (SETQ FIRST NIL)))))
		     (MI=EXPRESSION_SUBTERMS TERMLIST1) TERM.PATTERN)
		   (COND
		     ((NEQ CANDIDATES CANDIDATES.END) (SETQ TERMS1 (MI=EXPRESSION_STANDARDTERM TERMLIST1))
		      (SETQ TERMS (SUBPAIR TERMS1 PATTERN1 PATTERN2))
		      (SMAPC
			(FUNCTION
			  (LAMBDA (TERMLIST2)
			    (COND
			      ((EQL ARITY (MI=EXPRESSION_AUXILIARY TERMLIST2))
			       (MAPC
				 (FUNCTION
				   (LAMBDA (UNIFIER)
				     (SETQ TERMS2
					   (UNI-APPLY.SUBSTITUTION UNIFIER (SUBPAIR TERMS1 PATTERN1 TARGETPATTERN) T))
				     (SETQ UNIFIER
					   (FUNCALL PROPERTY.CONNECTION (MI=EXPRESSION_PROPERTY TERMLIST1)
						    (MI=EXPRESSION_PROPERTY TERMLIST2) TERMLIST1 TERMLIST2))
				     (C UNIFIER IS USED AS DUMMY VARIABLE *)
				     (COND
				       ((OR (NULL POSTCONDITION) (FUNCALL POSTCONDITION UNIFIER TERMS2))
                                        (COND
                                          (ABBREVIATION.SCHEME
					   (SETQ TERMS2 (CAR (DT-ABBREVIATION.COMPRESS.TERMLIST TERMS2)))))
                                        (MI-INSERT.TERMLIST.INTO.TERMSTRUCTURE NEW.TERMSTRUCTURE TERMS2
									       UNIFIER NIL INSTANCETEST)))
				     (COND
				       (RETURNFLAG (MI=MERGE.CLEAR.AUXILIARY TERMSTRUCTURE1 TERMSTRUCTURE2)
						   (throw 'MI-MERGE.TERMSTRUCTURES NEW.TERMSTRUCTURE)))))
				 (UNI-UNIFY.TERMLISTS TERMS
						      (SUBPAIR TERMS1 PATTERN1 (MI=EXPRESSION_STANDARDTERM TERMLIST2))))))))
			(FUNCTION (LAMBDA (TAIL) (COND ((NEQ CANDIDATES.END (CDR TAIL)) (CDR TAIL))))) CANDIDATES)))))
	 (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE1))
       (MI=MERGE.CLEAR.AUXILIARY TERMSTRUCTURE1 TERMSTRUCTURE2)
       (COND ((MI=TERMSTRUCTURE_EXPRESSIONS NEW.TERMSTRUCTURE) (RETURN NEW.TERMSTRUCTURE)))))))

(DEFMACRO MI-TERMLIST.INSTANCE (TERMLIST TERMSTRUCTURE TRANSFORMATIONS)
  ;; EDITED: 10-OCT-83 17:02:54
  ;; INPUT:  A STANDARD TERMLIST AND A TERMSTRUCTURE
  ;;         TRANSFORMATIONS IS A LIST WITH ELEMENTS
  ;;         (TERMSTRUCTURE . TERMLIST-TRANSFORMATION)
  ;;         WHERE TERMSTRUCTURE IS ANOTHER TERMSTRUCTURE
  ;;         AND TERMLIST-TRANSFORMATIONS IS A FUNCTION
  ;;         FOR MANIPULATING TERMLISTS.
  ;; VALUE:  T IF THE TERMLIST IS AN INSTANCE OF
  ;;         ANOTHER TERMLIST OF THIS TERMSTRUCTURE
  ;;         OR (TERMLIST-TRANSFORMATIONS TERMLIST) IS
  ;;         AN INSTANCE OF A TERMLIST IN THE
  ;;         CORRESPONDING TERMSTRUCTURE.
  `(EQL T (MI=INSTANCE.TEST ,TERMLIST ,TERMSTRUCTURE ,TRANSFORMATIONS)))

(DEFMACRO MI-SUBSTITUTION.INSTANCE (SUBSTITUTION TERMSTRUCTURE)
  ;; EDITED: 10-OCT-83 17:10:12
  ;; INPUT:  A SUBSTITUTION IN STANDARD REPRESENTATION
  ;;         AND A TERMSTRUCTURE WITH A VARIABLE PATTERN
  ;; VALUE:  T IF THE SUBSTITUTION IS AN INSTANCE OF
  ;;         ANOTHER ONE IN TERMSTRUCTURE.
  `(EQL T
	(MI=INSTANCE.TEST (MI=SUBSTITUTION.TO.TERMLIST ,SUBSTITUTION (MI=TERMSTRUCTURE_PATTERN ,TERMSTRUCTURE))
			  TERMSTRUCTURE NIL)))

(DEFMACRO MI-TERMLIST.STANDARD (TERMLIST)
  ;; EDITED: 28-FEB-83 12:10:21
  ;; INPUT:  AN MI-TERMLIST
  ;; VALUE:  THE TERMLIST IN STANDARD REPRESENTATION
  `(MI=EXPRESSION_STANDARDTERM ,TERMLIST))

(DEFMACRO MI-TERMLIST.STANDARD.FULL (TERMLIST)
  ;; EDITED: 28-FEB-83 12:10:21
  ;; INPUT:  AN MI-TERMLIST
  ;; VALUE:  THE TERMLIST IN STANDARD REPRESENTATION
  `(MI=EXPRESSION_STANDARDTERM ,TERMLIST))

(DEFMACRO MI-TERMLIST.PROPERTY (TERMLIST)
  ;; INPUT:  AN MI-TERMLIST
  ;; VALUE:  IT'S PROPERTY VALUE
  `(MI=EXPRESSION_PROPERTY ,TERMLIST))

(DEFMACRO MI-TERMLIST.AUXILIARY (TERMLIST)
  ;; EDITED:  8-MAR-83 17:10:03
  ;; INPUT:   AN MI-TERMLIST
  ;; VALUE:   THE AUXILIARY CELL.
  `(MI=EXPRESSION_AUXILIARY ,TERMLIST))

(DEFMACRO MI-TERMLIST.PUT.AUXILIARY (TERMLIST VALUE)
  ;; EDITED:  8-MAR-83 17:10:03
  ;; INPUT:   AN MI-TERMLIST AND AN S-EXPRESSION
  ;; EFFECT:  THE AUXILIARY CELL IS CHANGED.
  ;; VALUE:   UNDEFINED.
  `(MI=EXPRESSION_PUT.AUXILIARY ,TERMLIST ,VALUE))

(DEFMACRO MI-TERMSTRUCTURE.TERMLISTS (TERMSTRUCTURE)
  ;; EDITED:  8-MAR-83 17:12:24
  ;; INPUT:   AN MI-TERMSTRUCTURE
  ;; VALUE:   THE MI-TERMLISTS BELONGING TO TERMSTRUCTURE
  `(MI=TERMSTRUCTURE_EXPRESSIONS ,TERMSTRUCTURE))

(DEFUN MI=TERMSTRUCTURE_INSERT.TERMLIST.1 (TERMSTRUCTURE STANDARDTERMLIST PROPERTY)
  ;; EDITED:  3-SEP-83 11:28:40
  ;; INPUT:   A TERMSTRUCTURE, A STANDARDTERMLIST
  ;;          AND ITS PROPERTY.
  ;; EFFECT:  THE POSITION OF THE NEW TERMLIST IN
  ;;          TERMSTRUCTURE IS DETERMINED AND THE
  ;;          TERMLIST IS INSERTED.
  ;; VALUE:   THE NEW MI-TERMLIST.
  (PROG
    ((POSITIONLIST (MI=TERMSTRUCTURE_POSITIONLIST TERMSTRUCTURE))
     (SINGLETERMLIST (MI=EXPRESSION_CREATE.EMPTY.SINGLETERMS (MI=TERMSTRUCTURE_ARITY TERMSTRUCTURE))) TERMLIST
     SINGLETERMS SINGLETERM)
    (SETQ TERMLIST (MI=EXPRESSION_INITIALIZE STANDARDTERMLIST PROPERTY))
    (MI=EXPRESSION_PUT.SUBTERMS TERMLIST SINGLETERMLIST)
    (MI=TERMSTRUCTURE_ADD.EXPRESSION TERMSTRUCTURE TERMLIST)
    (MAPC
      (FUNCTION
        (LAMBDA (PAT STANDARDTERM)
          (COND
            (PAT (SETQ SINGLETERMS (POP POSITIONLIST))
		 (CASE (MI=TYPE STANDARDTERM)
		   (CONSTANT
		     (COND
		       ((SETQ SINGLETERM
			      (CAR
				(MEMBER-IF
				  (FUNCTION
				    (LAMBDA (SINGLETERM) (EQL STANDARDTERM (MI=EXPRESSION_STANDARDTERM SINGLETERM))))
				  (MI=SINGLETERMS_CONSTANTS SINGLETERMS))))
			(MI=EXPRESSION_ADD.SUPERTERM SINGLETERM TERMLIST))
		       (T (SETQ SINGLETERM (MI=EXPRESSION_INITIALIZE STANDARDTERM (LIST TERMLIST)))
			  (MI=SINGLETERMS_ADD.EXPRESSION SINGLETERMS SINGLETERM 'CONSTANT))))
		   (VARIABLE (SETQ STANDARDTERM (DT-VARIABLE.SORT STANDARDTERM))
			     (COND
			       ((SETQ SINGLETERM
				      (CAR
					(MEMBER-IF
					  (FUNCTION
					    (LAMBDA (SINGLETERM) (EQL STANDARDTERM (MI=EXPRESSION_STANDARDTERM SINGLETERM))))
					  (MI=SINGLETERMS_VARIABLES SINGLETERMS))))
				(MI=EXPRESSION_ADD.SUPERTERM SINGLETERM TERMLIST))
			       (T (SETQ SINGLETERM (MI=EXPRESSION_INITIALIZE STANDARDTERM (LIST TERMLIST)))
				  (MI=SINGLETERMS_ADD.EXPRESSION SINGLETERMS SINGLETERM 'VARIABLE))))
		   (ABBREVIATION
		     (COND
		       ((SETQ SINGLETERM
			      (CAR
				(MEMBER-IF
				  (FUNCTION
				    (LAMBDA (SINGLETERM) (EQL STANDARDTERM (MI=EXPRESSION_STANDARDTERM SINGLETERM))))
				  (MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS))))
			(MI=EXPRESSION_ADD.SUPERTERM SINGLETERM TERMLIST))
		       (T (SETQ SINGLETERM (MI=EXPRESSION_INITIALIZE STANDARDTERM (LIST TERMLIST)))
			  (MI=SINGLETERMS_ADD.EXPRESSION SINGLETERMS SINGLETERM 'ABBREVIATION))))
		   (THEORYTERM
		     (COND
		       ((SETQ SINGLETERM
			      (CAR
				(MEMBER-IF
				  (FUNCTION
				    (LAMBDA (SINGLETERM)
				      (AND
					(SETQ SINGLETERM
					      (UNI-UNIFY.TERMS STANDARDTERM (MI=EXPRESSION_STANDARDTERM SINGLETERM)))
					(MI=UNIFIER.IS.VARIABLE.RENAMING (CAR SINGLETERM)))))
				  (MI=SINGLETERMS_THEORYTERMS SINGLETERMS))))
			(MI=EXPRESSION_ADD.SUPERTERM SINGLETERM TERMLIST))
		       (T (SETQ SINGLETERM (MI=EXPRESSION_INITIALIZE STANDARDTERM (LIST TERMLIST)))
			  (MI=SINGLETERMS_ADD.EXPRESSION SINGLETERMS SINGLETERM 'THEORYTERM))))
		   (COMPOSEDTERM (SETQ SINGLETERM (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS))
				 (SETQ SINGLETERM
				       (MI=SUBTERMSTRUCTURE_INSERT.TERM
					 SINGLETERM STANDARDTERM TERMLIST
					 (MI=OCCURRENCE.TREE SINGLETERM (COPY-TREE STANDARDTERM) STANDARDTERM NIL))))
		   (OTHERWISE (ERROR "ILLEGAL TYPE IN MI=TERMSTRUCTURE_INSERT.TERM.1: ~A" (MI=TYPE STANDARDTERM))))
		 (RPLACA SINGLETERMLIST SINGLETERM) (SETQ SINGLETERMLIST (CDR SINGLETERMLIST))))))
      (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE) STANDARDTERMLIST)
    (RETURN TERMLIST)))
;(setq *print-level* nil)
(DEFUN MI=TERMSTRUCTURE_INSERT.TERMLIST.2 (TERMSTRUCTURE STANDARDTERM PROPERTY DESCRIPTORS)
  ;; EDITED:  3-SEP-83 13:36:28
  ;; INPUT:   A TERMSTRUCTURE, A STANDARDTERMLIST AND
  ;;          THE DESCRIPTION WHERE THE SUBTERMS OCCUR
  ;;          IN STANDARDTERMLIST. DESCRIPTORS HAS
  ;;          COMPONENTS LIKE:
  ;;          (SINGLETERM NIL OCCURRENCE.TREE ...)
  ;; EFFECT:  STANDARDTERMLIST IS INSERTED INTO
  ;;          TERMSTRUCTURE ACCORDING TO THE INFORMATION
  ;;          GIVEN BY DESCRIPTORS.
  ;; VALUE:   THE NEW TERMLIST.
  (PROG
    ((POSITIONLIST (MI=TERMSTRUCTURE_POSITIONLIST TERMSTRUCTURE))
     (SINGLETERMLIST (MI=EXPRESSION_CREATE.EMPTY.SINGLETERMS (MI=TERMSTRUCTURE_ARITY TERMSTRUCTURE))) TERMLIST
     SINGLETERM SINGLETERMS TYPE DESCRIPTOR)
    (SETQ TERMLIST (MI=EXPRESSION_INITIALIZE STANDARDTERM PROPERTY))
    (MI=EXPRESSION_PUT.SUBTERMS TERMLIST SINGLETERMLIST)
    (MI=TERMSTRUCTURE_ADD.EXPRESSION TERMSTRUCTURE TERMLIST)
    (MAPC
      (FUNCTION
        (LAMBDA (PAT STANDARDTERM)
          (COND
            (PAT (SETQ DESCRIPTOR (CAR DESCRIPTORS)) (SETQ SINGLETERMS (CAR POSITIONLIST))
		 (SETQ DESCRIPTORS (CDR DESCRIPTORS)) (SETQ POSITIONLIST (CDR POSITIONLIST)) (SETQ TYPE (MI=TYPE STANDARDTERM))
		 (COND
		   (DESCRIPTOR
		    (COND
		      ((EQL TYPE 'COMPOSEDTERM)
		       (SETQ SINGLETERM
			     (MI=SUBTERMSTRUCTURE_INSERT.TERM (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS)
							      STANDARDTERM TERMLIST DESCRIPTOR)))
		      (T (SETQ SINGLETERM DESCRIPTOR) (MI=EXPRESSION_ADD.SUPERTERM SINGLETERM TERMLIST))))
		   (T (COND ((EQL TYPE 'VARIABLE) (SETQ STANDARDTERM (DT-VARIABLE.SORT STANDARDTERM))))
		      (SETQ SINGLETERM (MI=EXPRESSION_INITIALIZE STANDARDTERM (LIST TERMLIST)))
		      (MI=SINGLETERMS_ADD.EXPRESSION SINGLETERMS SINGLETERM TYPE)))
		 (RPLACA SINGLETERMLIST SINGLETERM) (SETQ SINGLETERMLIST (CDR SINGLETERMLIST))))))
      (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE) STANDARDTERM)
    (RETURN TERMLIST)))

(DEFUN MI=SUBTERMSTRUCTURE_INSERT.TERM (SUBTERMSTRUCTURE COMPOSEDTERM TOPTERMLIST OCCURRENCE.TREE)
  ;; EDITED: 25-AUG-83 15:03:04
  ;; INPUT:  A SUBTERMSTRUCTURE, A STANDARDTERM (NO ATOM)
  ;;         THE MI-TERMLIST IN WHICH COMPOSEDTERM OCCURS
  ;;         AND THE OCCURRENCE TREE FOR THIS TERM.
  ;; EFFECT: COMPOSEDTERM IS INSERTED INTO
  ;;         SUBTERMSTRUCTURE
  ;; VALUE:  THE NEW (OR OLD) SUBTERM
  (PROG (SUBTERM SINGLETERMS TYPE OCCURRENCE)
	(COND ((CONSP (SETQ SUBTERM (CAR OCCURRENCE.TREE))) (MI=EXPRESSION_ADD.SUPERTERM SUBTERM TOPTERMLIST))
	      (T (SETQ SUBTERM (MI=EXPRESSION_INITIALIZE COMPOSEDTERM (LIST TOPTERMLIST))) (SETQ SINGLETERMS NIL)
		 (SETQ OCCURRENCE.TREE (CDR OCCURRENCE.TREE))
		 (MAPC
		   (FUNCTION
		     (LAMBDA (STANDARDTERM SUB.SINGLETERMS) (SETQ TYPE (MI=TYPE STANDARDTERM)) 
			     (COND
			       ((EQL TYPE 'COMPOSEDTERM)
				(SETQ SINGLETERMS
				      (NCONC1 SINGLETERMS
					      (MI=SUBTERMSTRUCTURE_INSERT.TERM (MI=SINGLETERMS_COMPOSEDTERMS SUB.SINGLETERMS)
									       STANDARDTERM SUBTERM (CAR OCCURRENCE.TREE)))))
			       ((CONSP (CAR OCCURRENCE.TREE)) (MI=EXPRESSION_ADD.SUPERTERM (CAR OCCURRENCE.TREE) SUBTERM)
				(SETQ SINGLETERMS (NCONC1 SINGLETERMS (CAR OCCURRENCE.TREE))))
			       (T
				(SETQ OCCURRENCE
				      (MI=EXPRESSION_INITIALIZE
					(COND ((EQL TYPE 'VARIABLE) (DT-VARIABLE.SORT STANDARDTERM)) (T STANDARDTERM))
					(LIST SUBTERM)))
				(SETQ SINGLETERMS (NCONC1 SINGLETERMS OCCURRENCE))
				(MI=SINGLETERMS_ADD.EXPRESSION SUB.SINGLETERMS OCCURRENCE TYPE)))
			     (SETQ OCCURRENCE.TREE (CDR OCCURRENCE.TREE))))
		   (CDR COMPOSEDTERM)
		   (OR (CDR (ASSOC (CAR COMPOSEDTERM) (MI=SUBTERMSTRUCTURE_FUNCTIONLIST SUBTERMSTRUCTURE)))
		       (MI=SUBTERMSTRUCTURE_CREATE.EMPTY.FUNCTIONLIST SUBTERMSTRUCTURE (CAR COMPOSEDTERM)
								      (LIST-LENGTH (CDR COMPOSEDTERM)))))
		 (MI=EXPRESSION_PUT.SUBTERMS SUBTERM SINGLETERMS) 
		 (MI=SUBTERMSTRUCTURE_ADD.EXPRESSION SUBTERMSTRUCTURE SUBTERM)))
	(RETURN SUBTERM)))

(DEFUN MI=SUBTERMSTRUCTURE_INSTANCETEST (SUBTERMSTRUCTURE TERM ORIGINALTERM)
  ;; EDITED:  1-SEP-83 15:13:32
  ;; INPUT:   A SUBTERMSTRUCTURE AND A STANDARDTERM
  ;;          (NO ATOM])
  ;;          TERM IS A COPY OF ORIGINALTERM.
  ;; EFFECT:  THE AUXILIARY CELLS OF THE MI-TERMLISTS
  ;;          OF WHICH TERM IS AN INSTANCE ARE
  ;;          INCREMENTED BY 1.
  ;;          TERM IS TRANSFORMED TO THE OCCURRENCE TREE.
  ;; VALUE:   UNDEFINED
  (PROG
    ((FUNCTION (CAR TERM)) (TERMLIST (CDR TERM)) (ORIGINAL ORIGINALTERM) DUMMY ARITY STANDARDTERM SINGLETERMS
     SINGLETERMS.LIST UNIFIERS FOUND)
    (SETQ ARITY (DT-FUNCTION.ARITY FUNCTION))
    (COND
      ((SETQ SINGLETERMS.LIST (CDR (ASSOC FUNCTION (MI=SUBTERMSTRUCTURE_FUNCTIONLIST SUBTERMSTRUCTURE))))
       (WHILE TERMLIST (SETQ SINGLETERMS (CAR SINGLETERMS.LIST)) (SETQ ORIGINAL (CDR ORIGINAL))
	      (SETQ STANDARDTERM (CAR TERMLIST))
	      (CASE (MI=TYPE STANDARDTERM)
		(CONSTANT ;; SUBSUMED BY: VARIABLES, CONSTANTS
		  (SETQ DUMMY (DT-CONSTANT.SORT STANDARDTERM))
		  (MAPC
		    (FUNCTION
		      (LAMBDA (SINGLETERM)
			(COND
			  ((DT-SORT.IS.SUBSORT DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)))))
		    (MI=SINGLETERMS_VARIABLES SINGLETERMS))
		  (MEMBER-IF
		    (FUNCTION
		      (LAMBDA (SINGLETERM)
			(COND
			  ((EQL STANDARDTERM (MI=EXPRESSION_STANDARDTERM SINGLETERM))
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM) (RPLACA TERMLIST SINGLETERM) T))))
		    (MI=SINGLETERMS_CONSTANTS SINGLETERMS)))
		(VARIABLE ;; SUBSUMED BY: VARIABLES
		  (SETQ DUMMY (DT-VARIABLE.SORT STANDARDTERM))
		  (MAPC
		    (FUNCTION
		      (LAMBDA (SINGLETERM)
			(COND
			  ((EQL DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM) (RPLACA TERMLIST SINGLETERM))
			  ((DT-SORT.IS.SUBSORT DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)))))
		    (MI=SINGLETERMS_VARIABLES SINGLETERMS)))
		(ABBREVIATION ;; SUBSUMED BY: VARIABLES, ABBREVIATIONS,
		  ;;              COMPOSEDTERMS AND THEORYTERMS
		  (SETQ DUMMY (DT-ABBREVIATION.SORT STANDARDTERM))
		  (MAPC
		    (FUNCTION
		      (LAMBDA (SINGLETERM)
			(COND
			  ((DT-SORT.IS.SUBSORT DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)))))
		    (MI=SINGLETERMS_VARIABLES SINGLETERMS))
		  (MEMBER-IF
		    (FUNCTION
		      (LAMBDA (SINGLETERM)
			(COND
			  ((EQL STANDARDTERM (MI=EXPRESSION_STANDARDTERM SINGLETERM))
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM) (RPLACA TERMLIST SINGLETERM) T))))
		    (MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS))
		  (MAPC
		    (FUNCTION
		      (LAMBDA (SUBTERM)
			(COND
			  ((UNI-UNIFY1.TERMS (MI=EXPRESSION_STANDARDTERM SUBTERM) STANDARDTERM NIL T)
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SUBTERM)))))
		    (MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS)))
		  (MAPC
		    (FUNCTION
		      (LAMBDA (SUBTERM)
			(COND
			  ((UNI-UNIFY1.TERMS (MI=EXPRESSION_STANDARDTERM SUBTERM) STANDARDTERM NIL T)
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SUBTERM)))))
		    (MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_THEORYTERMS SINGLETERMS))))
		(THEORYTERM ;; SUBSUMED BY: VARIABLES, THEORYTERMS
		  (SETQ DUMMY (DT-TERM.SORT STANDARDTERM))
		  (MAPC
		    (FUNCTION
		      (LAMBDA (SINGLETERM)
			(COND
			  ((DT-SORT.IS.SUBSORT DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)))))
		    (MI=SINGLETERMS_VARIABLES SINGLETERMS))
		  (SETQ FOUND NIL)
		  (MAPC
		    (FUNCTION
		      (LAMBDA (SINGLETERM)
			(COND
			  ((SETQ UNIFIERS
				 (UNI-UNIFY1.TERMS (MI=EXPRESSION_STANDARDTERM SINGLETERM) STANDARDTERM T NIL))
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)
			   (COND
			     ((MI=UNIFIER.IS.VARIABLE.RENAMING (CAR UNIFIERS)) (RPLACA TERMLIST SINGLETERM) (SETQ FOUND T)))))))
		    (MI=SINGLETERMS_THEORYTERMS SINGLETERMS))
		  (COND ((NOT FOUND) (RPLACA TERMLIST NIL))))
		(COMPOSEDTERM ;; SUBSUMED BY: VARIABLES, COMPOSEDTERMS
		  (SETQ DUMMY (DT-FUNCTION.SORT (CAR STANDARDTERM)))
		  (MAPC
		    (FUNCTION
		      (LAMBDA (SINGLETERM)
			(COND
			  ((DT-SORT.IS.SUBSORT DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)))))
		    (MI=SINGLETERMS_VARIABLES SINGLETERMS))
		  (MI=SUBTERMSTRUCTURE_INSTANCETEST (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS) STANDARDTERM
						    (CAR ORIGINAL)))
		(OTHERWISE (ERROR "ILLEGAL TYPE IN MI=SUBTERMSTRUCTURE_INSTANCETEST: ~A" (MI=TYPE STANDARDTERM))))
	      (SETQ TERMLIST (CDR TERMLIST)) (SETQ SINGLETERMS.LIST (CDR SINGLETERMS.LIST)))
       (SETQ FOUND T)
       (COND
	 ((EQL 1 ARITY)
	  (MAPC
	    (FUNCTION
	      (LAMBDA (SUBTERM)
		(COND
		  ((EQL 1 (MI=EXPRESSION_AUXILIARY SUBTERM)) (MI=EXPRESSION_INCREMENT.SUPERTERMS SUBTERM)
		   (COND
		     ((AND FOUND (EQL (SECOND TERM) (CAR (MI=EXPRESSION_SUBTERMS SUBTERM)))) (SETQ FOUND NIL)
		      (RPLACA TERM SUBTERM)))))
		(MI=EXPRESSION_RESET.AUXILIARY SUBTERM)))
	    (MI=SUBTERMSTRUCTURE_EXPRESSIONS SUBTERMSTRUCTURE)))
	 (T
	  (MAPC
	    (FUNCTION
	      (LAMBDA (SUBTERM)
		(COND
		  ((AND (EQL ARITY (MI=EXPRESSION_AUXILIARY SUBTERM))
			(SETQ UNIFIERS
			      (UNI-UNIFY1.TERMLISTS (CDR (MI=EXPRESSION_STANDARDTERM SUBTERM)) (CDR ORIGINALTERM) T NIL)))
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SUBTERM)
		   (COND
		     ((AND FOUND (MI=UNIFIER.IS.VARIABLE.RENAMING (CAR UNIFIERS))) (SETQ FOUND NIL) (RPLACA TERM SUBTERM)))))
		(MI=EXPRESSION_RESET.AUXILIARY SUBTERM)))
	    (MI=SUBTERMSTRUCTURE_EXPRESSIONS SUBTERMSTRUCTURE)))))
      (T (MI=SUBTERMSTRUCTURE_CREATE.EMPTY.FUNCTIONLIST SUBTERMSTRUCTURE FUNCTION ARITY)
	 (MAPL #'(lambda (term.rest) (setf (first term.rest) nil)) TERMLIST)))))

(DEFUN MI=OCCURRENCE.TREE (SUBTERMSTRUCTURE TERM ORIGINALTERM ACTUALIZE.SUPERTERM)
  ;; EDITED: 25-AUG-83 12:57:11
  ;; INPUT:  A SUBTERMSTRUCTURE, A TERM AND A BOOLEAN
  ;;         VALUE.
  ;;         TERM IS A COPY OF ORIGINALTERM.
  ;; EFFECT: THE SUBTERMS OCCURRING IN TERM ARE REPLACED
  ;;         BY THEIR CORRESPONDING SUBTERMS IN
  ;;         SUBTERMSTRUCTURE.
  ;;         IF ACTUALIZE.SUPERTERM = T, THE AUXILIARY
  ;;         CELLS OF THE SUPERTERMS IN WHICH TERM
  ;;         OCCURS ARE INCREMENTED.
  ;;         A NEW SUB.FUNCTIONLIST IS CREATED, IF
  ;;         NECESSARY.
  ;; VALUE:  THE TRANSFORMED TERM (OCCURRENCE.TREE)
  (PROG
    ((FUNCTION (CAR TERM)) (TERMLIST (CDR TERM)) (ORIGINAL ORIGINALTERM) DUMMY ARITY STANDARDTERM SINGLETERMS
     SINGLETERMS.LIST)
    (SETQ ARITY (DT-FUNCTION.ARITY FUNCTION))
    (COND
      ((SETQ SINGLETERMS.LIST (CDR (ASSOC FUNCTION (MI=SUBTERMSTRUCTURE_FUNCTIONLIST SUBTERMSTRUCTURE))))
       (WHILE TERMLIST (SETQ ORIGINAL (CDR ORIGINAL)) (SETQ SINGLETERMS (CAR SINGLETERMS.LIST))
	      (SETQ STANDARDTERM (CAR TERMLIST))
	      (CASE (MI=TYPE STANDARDTERM)
		(CONSTANT
		  (MEMBER-IF
		    (FUNCTION
		      (LAMBDA (SINGLETERM)
			(COND
			  ((EQL STANDARDTERM (MI=EXPRESSION_STANDARDTERM SINGLETERM))
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM) (RPLACA TERMLIST SINGLETERM) T))))
		    (MI=SINGLETERMS_CONSTANTS SINGLETERMS)))
		(VARIABLE (SETQ DUMMY (DT-VARIABLE.SORT STANDARDTERM))
			  (MEMBER-IF
			    (FUNCTION
			      (LAMBDA (SINGLETERM)
				(COND
				  ((EQL DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
				   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM) (RPLACA TERMLIST SINGLETERM) T))))
			    (MI=SINGLETERMS_VARIABLES SINGLETERMS)))
		(ABBREVIATION
		  (MEMBER-IF
		    (FUNCTION
		      (LAMBDA (SINGLETERM)
			(COND
			  ((EQL STANDARDTERM (MI=EXPRESSION_STANDARDTERM SINGLETERM))
			   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM) (RPLACA TERMLIST SINGLETERM) T))))
		    (MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS)))
		(THEORYTERM
		  (COND
		    ((NOTANY
		       (FUNCTION
			 (LAMBDA (SINGLETERM)
			   (COND
			     ((AND
				(SETQ DUMMY
				      (UNI-UNIFY.TERMS STANDARDTERM (MI=EXPRESSION_STANDARDTERM SINGLETERM)))
				(MI=UNIFIER.IS.VARIABLE.RENAMING (CAR DUMMY)))
			      (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM) (RPLACA TERMLIST SINGLETERM) T))))
		       (MI=SINGLETERMS_THEORYTERMS SINGLETERMS))
		     (RPLACA TERMLIST NIL))))
		(COMPOSEDTERM
		  (MI=OCCURRENCE.TREE (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS) STANDARDTERM (CAR ORIGINAL) T))
		(OTHERWISE (ERROR "ILLEGAL TYPE IN MI=OCCURRENCE.TREE: ~A" (MI=TYPE STANDARDTERM))))
	      (SETQ TERMLIST (CDR TERMLIST)) (SETQ SINGLETERMS.LIST (CDR SINGLETERMS.LIST)))
       (SETQ DUMMY T)
       (MAPC
	 (FUNCTION
	   (LAMBDA (SUBTERM)
	     (COND
	       ((AND DUMMY (EQL ARITY (MI=EXPRESSION_AUXILIARY SUBTERM))
		     (MI=TERMS.ARE.RENAMED ORIGINALTERM (MI=EXPRESSION_STANDARDTERM SUBTERM)))
		(SETQ DUMMY NIL) (RPLACA TERM SUBTERM)
		(COND (ACTUALIZE.SUPERTERM (MI=EXPRESSION_INCREMENT.SUPERTERMS SUBTERM)))))
	     (MI=EXPRESSION_RESET.AUXILIARY SUBTERM)))
	 (MI=SUBTERMSTRUCTURE_EXPRESSIONS SUBTERMSTRUCTURE)))
      (T (MI=SUBTERMSTRUCTURE_CREATE.EMPTY.FUNCTIONLIST SUBTERMSTRUCTURE FUNCTION ARITY)
	 (MAPL #'(lambda (terms.rest) (setf (first terms.rest) nil)) TERMLIST))))
  TERM)

(defvar mi*dummy.buffer (list NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL
			      NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL
			      NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL
			      NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL
			      NIL NIL NIL NIL NIL NIL NIL))

(DEFUN MI=TERMS.ARE.RENAMED (TERM1 TERM2)
  ;; EDITED: 24-AUG-83 11:00:48
  ;; INPUT:  TWO COMPOSED TERMS WITH THE SAME STRUCTURE
  ;;         BUT DIFFERENT VARIABLES.
  ;; VALUE:  T IF THEY ARE EQUAL UP TO VARIABLE RENAMING.
  ;; EXAMPLES:
  ;;         F(X Y) AND F(U V) ARE RENAMED,
  ;;         F(X X) AND F(U V) ARE NOT RENAMED.
  (COND
    ((DT-FUNCTION.ATTRIBUTES (CAR TERM1))
     (MI=UNIFIER.IS.VARIABLE.RENAMING (CAR (UNI-UNIFY.TERMLISTS (CDR TERM1) (CDR TERM2)))))
    (T
     (let (FAIL POINTER
	   (VARIABLES mi*dummy.buffer))
       (DECLARE (SPECIAL POINTER))
       (SETQ POINTER VARIABLES)
       (SMAPC (FUNCTION (LAMBDA (SUBTERM1 SUBTERM2) (SETQ FAIL (MI=RENAMING.FAILURE SUBTERM1 SUBTERM2))))
	      (FUNCTION (LAMBDA (TAIL) (COND (FAIL NIL) (T (CDR TAIL))))) (CDR TERM1) (CDR TERM2))
       (WHILE (NEQ VARIABLES POINTER) (DT-VARIABLE.DELETE.BINDING (CAR VARIABLES)) (SETQ VARIABLES (CDR VARIABLES)))
       (NOT FAIL)))))

(DEFUN MI=RENAMING.FAILURE (TERM1 TERM2)
  ;; EDITED: 24-AUG-83 11:09:47
  ;; INPUT:  TWO TERMS
  ;; VALUE:  T IF THE TERMS ARE RENAMED VARIANTS WITH
  ;;         RESPECT TO VARIABLE BINDINGS
  ;; EFFECT: NEW VARIABLE BINDINGS
  (DECLARE (SPECIAL POINTER))
  (COND
    ((DT-TERM.IS.VARIABLE TERM1)
     (COND
       ((EQL TERM1 TERM2)
	(COND ((SETQ TERM2 (DT-VARIABLE.GET.BINDING TERM1)) (NEQ TERM1 TERM2))
              (T (RPLACA POINTER TERM1) (SETQ POINTER (CDR POINTER)) (DT-VARIABLE.PUT.BINDING TERM1 TERM1) NIL)))
       ((EQL (DT-VARIABLE.SORT TERM1) (DT-VARIABLE.SORT TERM2))
	(PROG ((BINDING1 (DT-VARIABLE.GET.BINDING TERM1)) (BINDING2 (DT-VARIABLE.GET.BINDING TERM2)))
              (COND (BINDING1 (COND (BINDING2 (RETURN (NEQ TERM1 BINDING2))) (T (RETURN T)))) (BINDING2 (RETURN T))
		    (T (RPLACA POINTER TERM1) (SETQ POINTER (CDR POINTER)) (RPLACA POINTER TERM2) (SETQ POINTER (CDR POINTER))
		       (DT-VARIABLE.PUT.BINDING TERM1 TERM2) (DT-VARIABLE.PUT.BINDING TERM2 TERM1)))))
       (T)))
    ((CONSP TERM1)
     (COND
       ((DT-FUNCTION.ATTRIBUTES (CAR TERM1))
	(NOT (MI=UNIFIER.IS.VARIABLE.RENAMING (CAR (UNI-UNIFY.TERMLISTS (CDR TERM1) (CDR TERM2))))))
       (T
	(MAPC
	  (FUNCTION
	    (LAMBDA (SUBTERM1 SUBTERM2)
	      (COND ((MI=RENAMING.FAILURE SUBTERM1 SUBTERM2) (RETURN-FROM MI=RENAMING.FAILURE T)))))
	  (CDR TERM1) (CDR TERM2)))))))


(DEFUN MI=SUBTERMSTRUCTURE_CREATE.TLINKS (SUBTERMSTRUCTURE1 SUBTERMSTRUCTURE2)
  ;; EDITED: 20-OCT-83 08:52:08
  ;; INPUT:  TWO SUBTERMSTRUCTURES
  ;; EFFECT: ALL T-LINKS BETWEEN THE SUBTERMS OF
  ;;         SUBTERMSTRUCTURE1 AND SUBTERMSTRUCTURE2
  ;;         ARE CREATED.
  ;; VALUE:  UNDEFINED.
  (let (DUMMY ARITY)
    (MAPC #'(LAMBDA (FCT.SINGLETERMS1)
	      (COND ((SETQ DUMMY (CDR (ASSOC (CAR FCT.SINGLETERMS1) (MI=SUBTERMSTRUCTURE_FUNCTIONLIST SUBTERMSTRUCTURE2))))
		     (MI=CREATE.TLINKS (CDR FCT.SINGLETERMS1) DUMMY))))
	  (MI=SUBTERMSTRUCTURE_FUNCTIONLIST SUBTERMSTRUCTURE1))
    (MAPC #'(LAMBDA (SUBTERM1)
	      (SETQ ARITY (DT-FUNCTION.ARITY (MI=EXPRESSION_FUNCTION SUBTERM1)))
	      (MAPC #'(LAMBDA (SINGLETERM)
			(SMAPC #'(lambda (expr) (MI=EXPRESSION_INCREMENT.SUPERTERMS expr))
			       #'(lambda(tail) (if (consp (cdr tail)) (cdr tail)))
			      (if (consp (MI=EXPRESSION_TLINKS SINGLETERM))(MI=EXPRESSION_TLINKS SINGLETERM) )))
		    (MI=EXPRESSION_SUBTERMS SUBTERM1))
	      (MAPC #'(LAMBDA (SUBTERM2)
			(COND 
			  ((AND (EQL ARITY (MI=EXPRESSION_AUXILIARY SUBTERM2))
				(COND (MI*FULL.UNIFICATION
				       (UNI-UNIFY.TERMS (MI=EXPRESSION_STANDARDTERM SUBTERM1)
							(MI=EXPRESSION_STANDARDTERM SUBTERM2) T))
				      (T)))
			   (MI=EXPRESSION_INSERT.TLINK SUBTERM1 SUBTERM2)))
			(MI=EXPRESSION_RESET.AUXILIARY SUBTERM2))
		    (MI=SUBTERMSTRUCTURE_EXPRESSIONS SUBTERMSTRUCTURE2)))
	  (MI=SUBTERMSTRUCTURE_EXPRESSIONS SUBTERMSTRUCTURE1)) 
    (MI=FUNCTIONLIST_RESET.AUXILIARY (MI=SUBTERMSTRUCTURE_FUNCTIONLIST SUBTERMSTRUCTURE1))))

(DEFUN MI=FUNCTIONLIST_RESET.AUXILIARY (SUB.FUNCTIONLIST)
  ;; EDITED: 20-OCT-83 09:34:23
  ;; INPUT:  A FUNCTIONLIST
  ;; EFFECT: ALL AUXILIARY CELLS OF FUNCTIONLIST
  ;;         ARE RESET TO 0
  ;; VALUE:  UNDEFINED
  (MAPC #'(LAMBDA (FCT.SINGLETERMS)
	    (MAPC #'(LAMBDA (SINGLETERMS)
		      (MAPC #'(lambda (expr) (MI=EXPRESSION_RESET.AUXILIARY expr)) (MI=SINGLETERMS_CONSTANTS SINGLETERMS))
		      (MAPC #'(lambda (expr) (MI=EXPRESSION_RESET.AUXILIARY expr)) (MI=SINGLETERMS_VARIABLES SINGLETERMS))
		      (MAPC #'(lambda (expr) (MI=EXPRESSION_RESET.AUXILIARY expr)) (MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS))
		      (MAPC #'(lambda (expr) (MI=EXPRESSION_RESET.AUXILIARY expr)) (MI=SINGLETERMS_THEORYTERMS SINGLETERMS))
		      (MAPC #'(lambda (expr) (MI=EXPRESSION_RESET.AUXILIARY expr))
			    (MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS))))
		  (CDR FCT.SINGLETERMS)))
	SUB.FUNCTIONLIST))

(DEFMACRO MI=TYPE (TERM)
  ;; EDITED: 25-AUG-83 12:47:21
  ;; INPUT:  A STANDARD TERM
  ;; VALUE:  ONE OF THE ATOMS:
  ;;         CONSTANT, VARIABLE, ABBREVIATION,
  ;;         THEORYTERM, COMPOSEDTERM
  `(let ((term ,term))
     (COND
       ((CONSP TERM)
	(COND ((AND (DT-FUNCTION.THEORIES) (DT-FUNCTION.ATTRIBUTES (CAR TERM))) 'THEORYTERM) (T 'COMPOSEDTERM)))
       (T (DS-GET.TYPE TERM)))))

(DEFUN MI=UNIFIER.IS.VARIABLE.RENAMING (UNIFIER)
  ;; EDITED:  1-SEP-83 17:03:53
  ;; INPUT:   A UNIFIER
  ;; VALUE:   T IF THE UNIFIER IS A RENAMING SUBSTITUTION
  ;;          ELSE NIL.
  ;; EFFECT:  UNIFIER IS DESTROYED.
  (COND
    (UNIFIER
     (PROG ((SORT (DT-VARIABLE.SORT (CAR UNIFIER))))
	   (sMAPL
	     (FUNCTION
	       (LAMBDA (TAIL) 
		 (COND
		   ((AND (DT-VARIABLE.IS (CAR TAIL)) (EQL SORT (DT-VARIABLE.SORT (CAR TAIL))))
		    (COND ((CDR TAIL) (SETQ SORT (DT-VARIABLE.SORT (SECOND TAIL)))))
		    (RPLACD TAIL (CDDR TAIL)))
		   (T (RETURN-FROM MI=UNIFIER.IS.VARIABLE.RENAMING NIL)))))
	     #'cdr        ;Warning!! Don't optimize this function!!
	     (CDR UNIFIER)))
     (MAPL
       (FUNCTION
	 (LAMBDA (TAIL)
	   (COND ((MEMBER (CAR TAIL) (CDR TAIL)) (RETURN-FROM MI=UNIFIER.IS.VARIABLE.RENAMING NIL)))))
       (CDR UNIFIER))
     T)
    (T)))

(DEFUN MI=SUBSTITUTION.TO.TERMLIST (SUBSTITUTION VARIABLES)
  ;; EDITED: 10-OCT-83 16:40:20
  ;; INPUT:  A SUBSTITUTION IN STANDARD REPRESENTATION
  ;;         AND A LIST OF VARIABLES
  ;; EFFECT: THE SUBSTITUTION IS TRANSFORMED INTO
  ;;         T-REPRESENTATION
  ;; EXAMPLE:SUBSTITUTION = (Y A X B Z (F A) U C)
  ;;         VARIABLES = (X Y Z V)
  ;;         VALUE: (B A (F A) V)
  ;; VALUE:  THE T-REPRESENTATION
  (MAPCAR #'(LAMBDA (VARIABLE)
	      (OR (do ((restsubst substitution (cddr restsubst)))
		      ((or (null restsubst) (eql (first restsubst) variable)) (second restsubst)))
		  VARIABLE))
	  VARIABLES))

(DEFUN MI-DUMP (TERMSTRUCTURE FILE MESSAGE)
  ;; EDITED:  8-FEB-83 09:15:27
  ;; INPUT:   AN MI-TERMSTRUCTURE, NIL OR A FILENAME
  ;;          AND AN ARBITRARY S-EXPRESSION
  ;; EFFECT:  PRINTS MESSAGE AND TERMSTRUCTURE IN A
  ;;          SYMBOLIC WAY ONTO FILE.
  ;; VALUE:   UNDEFINED.
  (COND
    (FILE (SETQ FILE (mkrp-OPENOUT (mkrp-make.pathname nil nil "text" file) nil))
	  (LINELENGTH 120 FILE)
	  (PRINC MESSAGE FILE)
	  (TERPRI FILE) (TERPRI FILE)))
  (Princ "PATTERN: " FILE) (PRINC (DS-PNAME (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE)) FILE)
  (PRINC
    (CONCATENATE 'STRING "   PATTERN LENGTH: "
		 (PRINC-TO-STRING (MI=TERMSTRUCTURE_PATTERN.LENGTH TERMSTRUCTURE)) "   NUMBER OF T'S: "
		 (PRINC-TO-STRING (MI=TERMSTRUCTURE_T.LENGTH TERMSTRUCTURE)))
    FILE)
  (TERPRI FILE) (TERPRI FILE)
  (PRINC
    (CONCATENATE 'STRING (PRINC-TO-STRING (LIST-LENGTH (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE))) " TERMLISTS:")
    FILE)
  (TERPRI FILE) (TERPRI FILE)
  (PROG
    ((COUNTER 1) (TYPES '(CONSTANTS VARIABLES ABBREVIATIONS THEORY TERMS)) (PCOUNTER 1)
     (TERMLISTS (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE)))
    (MAPC
      (FUNCTION
        (LAMBDA (TERMLIST) (PRINC (CONCATENATE 'STRING (PRINC-TO-STRING COUNTER) ". TERMLIST_") FILE) (FORMAT FILE "~T" 16)
		(PRINC (DS-PNAME (MI=EXPRESSION_STANDARDTERM TERMLIST)) FILE) (TERPRI FILE)
		(COND
		  ((MI=EXPRESSION_PROPERTY TERMLIST)
		   (COND
		     ((ATOM (MI=EXPRESSION_PROPERTY TERMLIST)) (PRINC "PROPERTY:" FILE) (FORMAT FILE "~T" 16)
		      (PRINC (DS-PNAME (MI=EXPRESSION_PROPERTY TERMLIST)) FILE) (TERPRI FILE))
		     (T (PRINC "PROPERTY IS NOT EMPTY" FILE) (TERPRI FILE)))))
		(TERPRI FILE) (SETQ COUNTER (1+ COUNTER))))
      TERMLISTS)
    (MAPC
      (FUNCTION
        (LAMBDA (SINGLETERMS) (TERPRI FILE)
		(PRINC (CONCATENATE 'STRING (PRINC-TO-STRING PCOUNTER) ". POSITIONLIST") FILE) (TERPRI FILE)
		(MAPC
		  (FUNCTION
		    (LAMBDA (TYPE LIST)
		      (COND
			(LIST (PRINC TYPE FILE) (TERPRI FILE) (SETQ COUNTER 1)
			      (MAPC
				(FUNCTION
				  (LAMBDA (SINGLETERM)
				    (PRINC (CONCATENATE 'STRING (PRINC-TO-STRING COUNTER) ". TERM") FILE) (FORMAT FILE "~T" 16)
				    (PRINC (DS-PNAME (MI=EXPRESSION_STANDARDTERM SINGLETERM)) FILE) (PRINC " OCCURS IN: " FILE)
				    (MAPPRINT (LISTPOSITIONS (MI=EXPRESSION_SUPERTERMS SINGLETERM) TERMLISTS) NIL NIL " "
					      'PRINC FILE)
				    (PRINC " TERMLISTS" FILE) (TERPRI FILE) (SETQ COUNTER (1+ COUNTER))))
				LIST)))))
		  TYPES SINGLETERMS)
		(COND
		  ((MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS))
		   (PRINC "COMPOSED TERMS" FILE) (TERPRI FILE)
		   (MI=DUMP.SUBTERMSTRUCTURE (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS) TERMLISTS 2 FILE)))
		(SETQ PCOUNTER (1+ PCOUNTER))))
      (MI=TERMSTRUCTURE_POSITIONLIST TERMSTRUCTURE)))
  (COND (FILE (CLOSEFILE FILE))))

(DEFUN MI=DUMP.SUBTERMSTRUCTURE (SUBTERMSTRUCTURE SUPERTERMS LEFTMARGIN FILE)
  ;; EDITED:  5-SEP-83 09:32:41
  ;; INPUT:   A SUBTERMSTRUCTURE, THE TERMLIST IN WHICH
  ;;          THE SUBTERMS OCCUR, AN INTEGER AND AN OPEN
  ;;          FILE.
  ;; EFFECT:  THE SUBTERMSTRUCTURE IS PRINTED TO THE
  ;;          FILE.
  ;; VALUE:   UNDEFINED.
  (PROG
    ((COUNTER 1) (TYPES '(CONSTANTS VARIABLES ABBREVIATIONS THEORY TERMS))
     (SUBTERMLIST (MI=SUBTERMSTRUCTURE_EXPRESSIONS SUBTERMSTRUCTURE)) PCOUNTER)
    (FORMAT FILE "~T" LEFTMARGIN) (PRINC "SUBTERMS_" FILE) (TERPRI FILE) (TERPRI FILE)
    (MAPC
      (FUNCTION
        (LAMBDA (SUBTERM) (FORMAT FILE "~T" LEFTMARGIN)
		(PRINC (CONCATENATE 'STRING (PRINC-TO-STRING COUNTER) ". SUBTERM  ") FILE) (SETQ COUNTER (1+ COUNTER))
		(FORMAT FILE "~T" (+ 16 LEFTMARGIN)) (PRINC (DS-PNAME (MI=EXPRESSION_STANDARDTERM SUBTERM)) FILE)
		(PRINC "  OCCURS IN " FILE)
		(MAPPRINT (LISTPOSITIONS (MI=EXPRESSION_SUPERTERMS SUBTERM) SUPERTERMS) NIL NIL " " 'PRINC FILE)
		(PRINC ". SUPERTERMS" FILE) (TERPRI FILE)))
      SUBTERMLIST)
    (TERPRI FILE) (FORMAT FILE "~T" LEFTMARGIN) (PRINC "SUB FUNCTIONLISTS" FILE) (TERPRI FILE)
    (MAPC
      (FUNCTION
        (LAMBDA (FUNCTIONLIST) (FORMAT FILE "~T" LEFTMARGIN)
		(PRINC (CONCATENATE 'STRING "FUNCTION: " (PRINC-TO-STRING (DT-FUNCTION.PNAME (CAR FUNCTIONLIST)))) FILE)
		(TERPRI FILE) (SETQ PCOUNTER 1)
		(MAPC
		  (FUNCTION
		    (LAMBDA (SINGLETERMS) (FORMAT FILE "~T" LEFTMARGIN)
			    (PRINC (CONCATENATE 'STRING (PRINC-TO-STRING PCOUNTER) ". POSITION") FILE) (TERPRI FILE)
			    (SETQ PCOUNTER (1+ PCOUNTER))
			    (MAPC
			      (FUNCTION
				(LAMBDA (TYPE LIST)
				  (COND
				    (LIST (FORMAT FILE "~T" LEFTMARGIN) (PRINC TYPE FILE) (TERPRI FILE) (SETQ COUNTER 1)
					  (MAPC
					    (FUNCTION
					      (LAMBDA (SINGLETERM) (FORMAT FILE "~T" LEFTMARGIN)
						      (PRINC (CONCATENATE 'STRING (PRINC-TO-STRING COUNTER) ". SINGLETERM:") FILE)
						      (FORMAT FILE "~T" (+ LEFTMARGIN 16))
						      (PRINC (DS-PNAME (MI=EXPRESSION_STANDARDTERM SINGLETERM)) FILE)
						      (PRINC "  OCCURS IN " FILE)
						      (MAPPRINT (LISTPOSITIONS (MI=EXPRESSION_SUPERTERMS SINGLETERM) SUBTERMLIST) NIL NIL
								" " 'PRINC FILE)
						      (PRINC ". SUPERTERMS" FILE) (TERPRI FILE) (SETQ COUNTER (1+ COUNTER))))
					    LIST)))))
			      TYPES SINGLETERMS)
			    (COND
			      ((MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS))
			       (FORMAT FILE "~T" LEFTMARGIN) (PRINC "COMPOSED TERMS" FILE) (TERPRI FILE)
			       (MI=DUMP.SUBTERMSTRUCTURE (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS) SUBTERMLIST
							 (+ LEFTMARGIN 2) FILE)))))
		  (CDR FUNCTIONLIST))))
      (MI=SUBTERMSTRUCTURE_FUNCTIONLIST SUBTERMSTRUCTURE))))

(DEFUN MI=INTERSECT.POSITIONLISTS (TERMSTRUCTURE1 TERMSTRUCTURE2)
  ;; EDITED: 12-NOV-82 08:57:17
  ;; INPUT:  TWO MI-TERMSTRUCTURES
  ;; VALUE:  (POSITIONLIST1 POSITIONLIST2 . TERM.PATTERN)
  ;; EXAMPLE: PATTERN1 = (NIL T  T )
  ;;          PATTERN2 = ( T  T NIL)
  ;;          POSITIONLIST1 IS NOW THE LIST WITH
  ;;          SINGLETERMS BELONGING TO THE FIRST T IN
  ;;          PATTERN1, AND POSITIONLIST2 IS SECOND
  ;;          SINGLETERMS-LIST IN TERMSTRUCTURE2
  ;;          BELONGING TO THE SECOND T IN PATTERN2.
  ;;          TERM.PATTERN THEN IS (AND PATTERN1 PATTERN2
  (PROG
    ((POSITIONLIST1 (MI=TERMSTRUCTURE_POSITIONLIST TERMSTRUCTURE1))
     (POSITIONLIST2 (MI=TERMSTRUCTURE_POSITIONLIST TERMSTRUCTURE2)) INTERSECT.POSITIONLIST1
     INTERSECT.POSITIONLIST2 TERM.PATTERN)
    (MAPC
      (FUNCTION
        (LAMBDA (ELEMENT1 ELEMENT2)
          (COND
            ((AND ELEMENT1 ELEMENT2) (SETQ INTERSECT.POSITIONLIST1 (cons (CAR POSITIONLIST1) INTERSECT.POSITIONLIST1))
	     (SETQ INTERSECT.POSITIONLIST2 (CONS (CAR POSITIONLIST2) INTERSECT.POSITIONLIST2))))
          (COND (ELEMENT1 (SETQ POSITIONLIST1 (CDR POSITIONLIST1)) (SETQ TERM.PATTERN (cons ELEMENT2 TERM.PATTERN))))
          (COND (ELEMENT2 (SETQ POSITIONLIST2 (CDR POSITIONLIST2))))))
      (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE1) (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE2))
    (RETURN (CONS (NREVERSE INTERSECT.POSITIONLIST1)
		  (CONS (NREVERSE INTERSECT.POSITIONLIST2) (NREVERSE TERM.PATTERN))))))

(DEFUN MI=CUT.TARGETPATTERN (TERMSTRUCTURE1 TERMSTRUCTURE2 TARGETPATTERN)
  ;; EDITED: 12-NOV-82 09:19:23
  ;; INPUT:  TWO TERMSTRUCTURES AND AN MI-PATTERN
  ;; VALUE:  A NEW PATTERN:
  ;;            (AND TARGETPATTERN
  ;;                 (OR PATTERN1 PATTERN2)
  (PROG
    ((NEW.TARGETPATTERN (LIST NIL)) (PATTERN1 (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE1))
     (PATTERN2 (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE2)))
    (WHILE TARGETPATTERN
      (COND ((AND (CAR TARGETPATTERN) (OR (CAR PATTERN1) (CAR PATTERN2))) (QCONC1 NEW.TARGETPATTERN T))
	    (T (QCONC1 NEW.TARGETPATTERN NIL)))
      (SETQ PATTERN1 (CDR PATTERN1)) (SETQ PATTERN2 (CDR PATTERN2)) (SETQ TARGETPATTERN (CDR TARGETPATTERN)))
    (RETURN (CAR NEW.TARGETPATTERN))))

(DEFUN MI=INSTANCE.TEST (STANDARDTERMLIST TERMSTRUCTURE TRANSFORMATIONS)
  ;; EDITED: 22-SEP-82 17:25:45
  ;; INPUT:  A TERMLIST IN STANDARD FORM,
  ;;         AN MI-TERMSTRUCTURE;
  ;;         TRANSFORMATIONS: SEE
  ;;         MI=INSERT.TERMLIST.INTO.TERMSTRUCTURE
  ;; VALUE:  T, IF THE TERMLIST IS AN INSTANCE OF AN
  ;;         ALREADY EXISTING ONE, ELSE A DESCRIPTION
  ;;         WHERE THE SUBTERMS OF NEW.TERMLIST OCCUR
  ;;         IN TERMSTRUCTURE WITH ELEMENTS LIKE
  ;;         (SINGLETERM NIL OCCURRENCE.TREE ... )
  (PROG
    ((POSITIONLIST (MI=TERMSTRUCTURE_POSITIONLIST TERMSTRUCTURE)) (ARITY (MI=TERMSTRUCTURE_ARITY TERMSTRUCTURE))
     (PATTERN (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE)) (STD.TERMLIST STANDARDTERMLIST) (FIRST T)
     (DESCRIPTORS (LIST NIL)) VARIABLES STANDARDTERM UNIFIERS EQUAL.TERM TRANSFORMATION DUMMY SINGLETERMS FULL)
    (SETQ VARIABLES (MI=TERMLIST.VARIABLES STD.TERMLIST PATTERN)) START (SETQ FULL (EVERY #'identity PATTERN))
    (UNI-DECLARE.VARIABLES.AS.CONSTANTS VARIABLES)
    (WHILE
      (PROGN
        (WHILE (AND PATTERN (NULL (CAR PATTERN))) (SETQ PATTERN (CDR PATTERN)) (SETQ STD.TERMLIST (CDR STD.TERMLIST)))
        STD.TERMLIST)
      (SETQ EQUAL.TERM NIL) (SETQ STANDARDTERM (CAR STD.TERMLIST)) (SETQ STD.TERMLIST (CDR STD.TERMLIST))
      (SETQ PATTERN (CDR PATTERN)) (SETQ SINGLETERMS (CAR POSITIONLIST)) (SETQ POSITIONLIST (CDR POSITIONLIST))
      (CASE (MI=TYPE STANDARDTERM)
        (CONSTANT ;; SUBSUMED BY:  VARIABLES, CONSTANTS
          (SETQ DUMMY (DT-CONSTANT.SORT STANDARDTERM))
          (MAPC
            (FUNCTION
              (LAMBDA (SINGLETERM)
                (COND
                  ((DT-SORT.IS.SUBSORT DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)))))
            (MI=SINGLETERMS_VARIABLES SINGLETERMS))
          (MEMBER-IF
            (FUNCTION
              (LAMBDA (SINGLETERM)
                (COND
                  ((EQL STANDARDTERM (MI=EXPRESSION_STANDARDTERM SINGLETERM))
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM) (SETQ EQUAL.TERM SINGLETERM)))))
            (MI=SINGLETERMS_CONSTANTS SINGLETERMS)))
        (VARIABLE ;; SUBSUMED BY:  VARIABLES
          (SETQ DUMMY (DT-VARIABLE.SORT STANDARDTERM))
          (MAPC
            (FUNCTION
              (LAMBDA (SINGLETERM)
                (COND
                  ((EQL DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM) (SETQ EQUAL.TERM SINGLETERM))
                  ((DT-SORT.IS.SUBSORT DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)))))
            (MI=SINGLETERMS_VARIABLES SINGLETERMS)))
        (ABBREVIATION ;; SUBSUMED BY:  VARIABLES, ABBREVIATIONS,
          ;;               COMPOSEDTERMS AND THEORYTERMS.
          (SETQ DUMMY (DT-ABBREVIATION.SORT STANDARDTERM))
          (MAPC
            (FUNCTION
              (LAMBDA (SINGLETERM)
                (COND
                  ((DT-SORT.IS.SUBSORT DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)))))
            (MI=SINGLETERMS_VARIABLES SINGLETERMS))
          (MEMBER-IF
            (FUNCTION
              (LAMBDA (SINGLETERM)
                (COND
                  ((EQL STANDARDTERM (MI=EXPRESSION_STANDARDTERM SINGLETERM))
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM) (SETQ EQUAL.TERM SINGLETERM)))))
            (MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS))
          (MAPC
            (FUNCTION
              (LAMBDA (SUBTERM)
                (COND
                  ((UNI-UNIFY1.TERMS (MI=EXPRESSION_STANDARDTERM SUBTERM) STANDARDTERM NIL T)
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SUBTERM)))))
            (MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS)))
          (MAPC
            (FUNCTION
              (LAMBDA (SUBTERM)
                (COND
                  ((UNI-UNIFY1.TERMS (MI=EXPRESSION_STANDARDTERM SUBTERM) STANDARDTERM NIL T)
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SUBTERM)))))
            (MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_THEORYTERMS SINGLETERMS))))
        (THEORYTERM ;; SUBSUMED BY:  VARIABLES, THEORYTERMS
          (SETQ DUMMY (DT-TERM.SORT STANDARDTERM))
          (MAPC
            (FUNCTION
              (LAMBDA (SINGLETERM)
                (COND
                  ((DT-SORT.IS.SUBSORT DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)))))
            (MI=SINGLETERMS_VARIABLES SINGLETERMS))
          (MAPC
            (FUNCTION
              (LAMBDA (SINGLETERM)
                (COND
                  ((SETQ UNIFIERS
			 (UNI-UNIFY1.TERMS (MI=EXPRESSION_STANDARDTERM SINGLETERM) STANDARDTERM T NIL))
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)
		   (COND
		     ((AND FIRST (MI=UNIFIER.IS.VARIABLE.RENAMING (CAR UNIFIERS))) (SETQ EQUAL.TERM SINGLETERM)))))))
            (MI=SINGLETERMS_THEORYTERMS SINGLETERMS)))
        (COMPOSEDTERM ;; SUBSUMED BY:  VARIABLES, COMPOSEDTERMS
          (SETQ DUMMY (DT-FUNCTION.SORT (CAR STANDARDTERM)))
          (MAPC
            (FUNCTION
              (LAMBDA (SINGLETERM)
                (COND
                  ((DT-SORT.IS.SUBSORT DUMMY (MI=EXPRESSION_STANDARDTERM SINGLETERM))
		   (MI=EXPRESSION_INCREMENT.SUPERTERMS SINGLETERM)))))
            (MI=SINGLETERMS_VARIABLES SINGLETERMS))
          (SETQ EQUAL.TERM (COPY-TREE STANDARDTERM))
          (MI=SUBTERMSTRUCTURE_INSTANCETEST (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS) EQUAL.TERM
					    STANDARDTERM))
        (OTHERWISE (ERROR "ILLEGAL TYPE IN MI=INSTANCE.TEST: ~A" (MI=TYPE STANDARDTERM))))
      (COND (FIRST (QCONC1 DESCRIPTORS EQUAL.TERM))))
    (SETQ DUMMY T) (SETQ PATTERN (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE))
    (MAPC
      (FUNCTION
        (LAMBDA (EXPRESSION)
          (COND
            ((AND DUMMY (EQL ARITY (MI=EXPRESSION_AUXILIARY EXPRESSION))
		  (COND
		    (FULL (UNI-UNIFY1.TERMLISTS (MI=EXPRESSION_STANDARDTERM EXPRESSION) STANDARDTERMLIST T T))
		    (T
		     (UNI-UNIFY1.TERMLISTS (MI=SUBSET (MI=EXPRESSION_STANDARDTERM EXPRESSION) PATTERN)
					   (MI=SUBSET STANDARDTERMLIST PATTERN) T T))))
	     (SETQ DUMMY NIL)))
          (MI=EXPRESSION_RESET.AUXILIARY EXPRESSION)))
      (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE))
    (UNI-CLEAR.VARIABLES.AS.CONSTANTS) (COND ((NOT DUMMY) (RETURN T)))
    (COND
      ((SETQ TRANSFORMATION (CAR TRANSFORMATIONS)) (SETQ TRANSFORMATIONS (CDR TRANSFORMATIONS)) (SETQ FIRST NIL)
       (SETQ TERMSTRUCTURE (CAR TRANSFORMATION)) (SETQ STD.TERMLIST (FUNCALL (CDR TRANSFORMATION) STANDARDTERMLIST))
       (SETQ STANDARDTERMLIST STD.TERMLIST) (SETQ ARITY (MI=TERMSTRUCTURE_ARITY TERMSTRUCTURE))
       (SETQ PATTERN (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE))
       (SETQ VARIABLES (MI=TERMLIST.VARIABLES STD.TERMLIST PATTERN))
       (SETQ POSITIONLIST (MI=TERMSTRUCTURE_POSITIONLIST TERMSTRUCTURE)) (GO START))
      (T (RETURN (CAR DESCRIPTORS))))))

(DEFUN MI=MERGE.DISJOINT.TERMSTRUCTURES
       (TERMSTRUCTURE1 TERMSTRUCTURE2 NEW.TERMSTRUCTURE CONNECTION CONDITION1 CONDITION2 PROPERTY.CONNECTION
	INSTANCETEST)
  ;; EDITED: 28-FEB-83 12:19:11
  ;; INPUT:  SEE MI-MERGE.TERMSTRUCTURES
  ;; EFFECT: ALL ADMISSIBLE PAIRS OF TERMLISTS           " * *)
  ;;         ARE TRANSMITTED TO THE NEW TERMSTRUCTURE
  ;; VALUE:  NEW.TERMSTRUCTURE.
  (MAPC
    (FUNCTION
      (LAMBDA (TERMLIST1)
        (MAPC
          (FUNCTION
            (LAMBDA (TERMLIST2)
              (COND
                ((FUNCALL CONNECTION (FUNCALL CONDITION1 (MI=EXPRESSION_PROPERTY TERMLIST1))
			  (FUNCALL CONDITION2 (MI=EXPRESSION_PROPERTY TERMLIST2)))
		 (PROG
		   ((TL1 (MI=EXPRESSION_STANDARDTERM TERMLIST1)) (TL2 (MI=EXPRESSION_STANDARDTERM TERMLIST2))
		    TERMLIST UNIFIERS)
		   (COND
		     ((SETQ UNIFIERS (UNI-UNIFY.TERMLISTS TL1 TL2))
		      (SETQ TERMLIST (UNI-APPLY.SUBSTITUTION (CAR UNIFIERS) TL1 T))
		      (MI-INSERT.TERMLIST.INTO.TERMSTRUCTURE NEW.TERMSTRUCTURE TERMLIST
							     (FUNCALL PROPERTY.CONNECTION (MI=EXPRESSION_PROPERTY TERMLIST1)
								      (MI=EXPRESSION_PROPERTY TERMLIST2) TERMLIST1 TERMLIST2)
							     NIL INSTANCETEST)
		      (RETURN T))))))))
          (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE2))))
    (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE1))
  (COND ((MI=TERMSTRUCTURE_EXPRESSIONS NEW.TERMSTRUCTURE) NEW.TERMSTRUCTURE)))

(DEFUN MI=MERGE.DISJOINT (TERMSTRUCTURE1 TERMSTRUCTURE2 NEW.TERMSTRUCTURE CONNECTION CONDITION1 CONDITION2 POSTCONDITION
			  PROPERTY.CONNECTION INSTANCETEST &optional ABBREVIATION.SCHEME)
  ;; EDITED: 28-FEB-83 12:19:11
  ;; INPUT:  SEE MI-MERGE
  ;; EFFECT: ALL ADMISSIBLE PAIRS OF TERMLISTS
  ;;         ARE TRANSMITTED TO THE NEW TERMSTRUCTURE
  ;; VALUE:  NEW.TERMSTRUCTURE.
  (PROG
    ((VARIABLES1 (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE1))
     (VARIABLES2 (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE2))
     (VARIABLES (MI=TERMSTRUCTURE_PATTERN NEW.TERMSTRUCTURE)) TERMLIST TERMS1)
    (MAPC
      (FUNCTION
        (LAMBDA (TERMLIST1) (SETQ TERMS1 (MI=EXPRESSION_STANDARDTERM TERMLIST1))
		(MAPC
		  (FUNCTION
		    (LAMBDA (TERMLIST2)
		      (COND
			((FUNCALL CONNECTION (FUNCALL CONDITION1 (MI=EXPRESSION_PROPERTY TERMLIST1))
				  (FUNCALL CONDITION2 (MI=EXPRESSION_PROPERTY TERMLIST2)))
			 (MAPC
			   (FUNCTION
			     (LAMBDA (UNIFIER)
			       (SETQ TERMLIST
				     (UNI-APPLY.SUBSTITUTION UNIFIER (SUBPAIR TERMS1 VARIABLES1 VARIABLES) T))
			       (SETQ UNIFIER
				     (FUNCALL PROPERTY.CONNECTION (MI=EXPRESSION_PROPERTY TERMLIST1)
					      (MI=EXPRESSION_PROPERTY TERMLIST2) TERMLIST1 TERMLIST2))
			       (COND
				 ((OR (NULL POSTCONDITION) (FUNCALL POSTCONDITION UNIFIER TERMLIST))
				  (COND
				    (ABBREVIATION.SCHEME
				     (SETQ TERMLIST (CAR (DT-ABBREVIATION.COMPRESS.TERMLIST TERMLIST)))))
				  (MI-INSERT.TERMLIST.INTO.TERMSTRUCTURE NEW.TERMSTRUCTURE TERMLIST UNIFIER NIL
									 INSTANCETEST)))))
			   (UNI-UNIFY.TERMLISTS VARIABLES2
						(SUBPAIR TERMS1 VARIABLES1 (MI=EXPRESSION_STANDARDTERM TERMLIST2))))))))
		  (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE2))))
      (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE1)))
  (COND ((MI=TERMSTRUCTURE_EXPRESSIONS NEW.TERMSTRUCTURE) NEW.TERMSTRUCTURE)))

(DEFUN MI=TERMLIST.VARIABLES (TERMLIST PATTERN)
  ;; EDITED: 10-MAR-83 10:51:51
  ;; INPUT:  A STANDARD TERMLIST AND TH CORRESPONDING
  ;;         PATTERN.
  ;; VALUE:  A LIST WITH THE VARIABLES OCCURING IN THE
  ;;         TERMS OF TERMLIST CORRESPONDING TO THE T'S
  ;;         IN PATTERN.
  (PROG (VARIABLES)
	(MAPC
	  (FUNCTION
	    (LAMBDA (TERM PAT) (COND (PAT (SETQ VARIABLES (NCONC VARIABLES (DT-TERMLIST.VARIABLES TERM)))))))
	  TERMLIST PATTERN)
	(RETURN (REMOVE-DUPLICATES VARIABLES))))

(DEFUN MI=CREATE.TLINKS (POSITIONLIST1 POSITIONLIST2)
  ;; EDITED: 16-NOV-82 09:36:11
  ;; INPUT:  TWO MI-POSITIONLISTS
  ;; EFFECT: ALL T-LINKS FROM EACH TERM OF SINGLETERMS1
  ;;         TO SINGLETERMS2 ARE CREATED.
  ;; VALUE:  UNDEFINED.
  (MAPC
    (FUNCTION
      (LAMBDA (SINGLETERMS1 SINGLETERMS2)
        (PROG (TERM1 SORT)
	      ;; CONSTANTS -> CONSTANTS, VARIABLES
	      (MAPC
		(FUNCTION
		  (LAMBDA (SINGLETERM1) (SETQ TERM1 (MI=EXPRESSION_STANDARDTERM SINGLETERM1))
			  (MEMBER-IF
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((EQL TERM1 (MI=EXPRESSION_STANDARDTERM SINGLETERM2))
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SINGLETERM2) T))))
			    (MI=SINGLETERMS_CONSTANTS SINGLETERMS2))
			  (SETQ SORT (DT-CONSTANT.SORT TERM1))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((DT-SORT.IS.SUBSORT SORT (MI=EXPRESSION_STANDARDTERM SINGLETERM2))
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SINGLETERM2)))))
			    (MI=SINGLETERMS_VARIABLES SINGLETERMS2))))
		(MI=SINGLETERMS_CONSTANTS SINGLETERMS1))
	      ;; VARIABLES -> ALL
	      (MAPC
		(FUNCTION
		  (LAMBDA (SINGLETERM1) (SETQ TERM1 (MI=EXPRESSION_STANDARDTERM SINGLETERM1))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((DT-SORT.IS.SUBSORT (DT-CONSTANT.SORT (MI=EXPRESSION_STANDARDTERM SINGLETERM2)) TERM1)
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SINGLETERM2)))))
			    (MI=SINGLETERMS_CONSTANTS SINGLETERMS2))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((DT-SORT.GREATEST.COMMON.SUBSORTS TERM1 (MI=EXPRESSION_STANDARDTERM SINGLETERM2))
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SINGLETERM2)))))
			    (MI=SINGLETERMS_VARIABLES SINGLETERMS2))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((DT-SORT.IS.SUBSORT (DT-ABBREVIATION.SORT (MI=EXPRESSION_STANDARDTERM SINGLETERM2)) TERM1)
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SINGLETERM2)))))
			    (MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS2))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((OR
				     (DT-SORT.IS.SUBSORT (DT-TERM.SORT (MI=EXPRESSION_STANDARDTERM SINGLETERM2)) TERM1)
				     (DT-TERM.IS.WEAKENABLE (MI=EXPRESSION_STANDARDTERM SINGLETERM2) TERM1))
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SINGLETERM2)))))
			    (MI=SINGLETERMS_THEORYTERMS SINGLETERMS2))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SUBTERM)
				(COND
				  ((DT-SORT.IS.SUBSORT (DT-FUNCTION.SORT (MI=EXPRESSION_FUNCTION SUBTERM)) TERM1)
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SUBTERM)))))
			    (MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS2)))))
		(MI=SINGLETERMS_VARIABLES SINGLETERMS1))
	      ;; ABBREVIATIONS -> ABBREVIATIONS, VARIABLES,
	      ;;                  COMPOSEDTERMS,THEORYTERMS
	      (MAPC
		(FUNCTION
		  (LAMBDA (SINGLETERM1) (SETQ TERM1 (MI=EXPRESSION_STANDARDTERM SINGLETERM1))
			  (SETQ SORT (DT-ABBREVIATION.SORT TERM1)) (DT-PUTPROP TERM1 'MI-SINGLETERM SINGLETERM1)
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((DT-SORT.IS.SUBSORT SORT (MI=EXPRESSION_STANDARDTERM SINGLETERM2))
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SINGLETERM2)))))
			    (MI=SINGLETERMS_VARIABLES SINGLETERMS2))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SUBTERM2)
				(COND
				  ((UNI-UNIFY.QUICK.TEST TERM1 (MI=EXPRESSION_STANDARDTERM SUBTERM2))
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SUBTERM2)))))
			    (MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS2)))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SUBTERM2)
				(COND
				  ((UNI-UNIFY.QUICK.TEST TERM1 (MI=EXPRESSION_STANDARDTERM SUBTERM2))
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SUBTERM2)))))
			    (MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_THEORYTERMS SINGLETERMS2)))))
		(MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS1))
	      (MAPC
		(FUNCTION
		  (LAMBDA (SINGLETERM2)
		    (COND
		      ((SETQ TERM1 (DT-GETPROP (MI=EXPRESSION_STANDARDTERM SINGLETERM2) 'MI-SINGLETERM))
		       (MI=EXPRESSION_INSERT.TLINK TERM1 SINGLETERM2)))))
		(MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS2))
	      (MAPC
		(FUNCTION
		  (LAMBDA (SINGLETERM1) (DT-REMPROP (MI=EXPRESSION_STANDARDTERM SINGLETERM1) 'MI-SINGLETERM)))
		(MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS1))
	      ;; THEORYTERMS -> VARIABLES, THEORYTERMS, ABBREVIATIONS
	      (MAPC
		(FUNCTION
		  (LAMBDA (SINGLETERM1) (SETQ TERM1 (MI=EXPRESSION_STANDARDTERM SINGLETERM1))
			  (SETQ SORT (DT-TERM.SORT TERM1))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((DT-SORT.IS.SUBSORT SORT (MI=EXPRESSION_STANDARDTERM SINGLETERM2))
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SINGLETERM2)))))
			    (MI=SINGLETERMS_VARIABLES SINGLETERMS2))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((UNI-UNIFY.TERMS TERM1 (MI=EXPRESSION_STANDARDTERM SINGLETERM2) T)
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SINGLETERM2)))))
			    (MI=SINGLETERMS_THEORYTERMS SINGLETERMS2))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((UNI-UNIFY.TERMS TERM1 (MI=EXPRESSION_STANDARDTERM SINGLETERM2) T)
				   (MI=EXPRESSION_INSERT.TLINK SINGLETERM1 SINGLETERM2)))))
			    (MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS2))))
		(MI=SINGLETERMS_THEORYTERMS SINGLETERMS1))
	      ;; COMPOSEDTERMS -> VARIABLES, ABBREVIATIONS
	      ;;                  COMPOSEDTERMS
	      (MI=SUBTERMSTRUCTURE_CREATE.TLINKS (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS1)
						 (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS2))
	      (MAPC
		(FUNCTION
		  (LAMBDA (SUBTERM1) (SETQ TERM1 (MI=EXPRESSION_STANDARDTERM SUBTERM1))
			  (SETQ SORT (DT-FUNCTION.SORT (CAR TERM1)))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((DT-SORT.IS.SUBSORT SORT (MI=EXPRESSION_STANDARDTERM SINGLETERM2))
				   (MI=EXPRESSION_INSERT.TLINK SUBTERM1 SINGLETERM2)))))
			    (MI=SINGLETERMS_VARIABLES SINGLETERMS2))
			  (MAPC
			    (FUNCTION
			      (LAMBDA (SINGLETERM2)
				(COND
				  ((UNI-UNIFY.QUICK.TEST TERM1 (MI=EXPRESSION_STANDARDTERM SINGLETERM2))
				   (MI=EXPRESSION_INSERT.TLINK SUBTERM1 SINGLETERM2)))))
			    (MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS2))))
		(MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS1))))))
    POSITIONLIST1 POSITIONLIST2))

(DEFUN MI=MERGE.CLEAR.AUXILIARY (TERMSTRUCTURE1 TERMSTRUCTURE2)
  ;; EDITED:  8-FEB-83 12:24:43
  ;; INPUT:   TWO TERMSTRUCTURES
  ;; EFFECT:  THE SINGLETERM AUXILIARY CELLS OF
  ;;          TERMSTRUCTURE1 AND THE TERMLIST AUXILIARY
  ;;          CELLS OF TERMSTRUCTURE2 ARE CLEARED.
  (MAPC
    (FUNCTION
      (LAMBDA (SINGLETERMS)
        (MAPC #'(lambda (expr) (MI=EXPRESSION_RESET.AUXILIARY expr)) (MI=SINGLETERMS_CONSTANTS SINGLETERMS))
        (MAPC #'(lambda (expr) (MI=EXPRESSION_RESET.AUXILIARY expr)) (MI=SINGLETERMS_VARIABLES SINGLETERMS))
        (MAPC #'(lambda (expr) (MI=EXPRESSION_RESET.AUXILIARY expr)) (MI=SINGLETERMS_ABBREVIATIONS SINGLETERMS))
        (MAPC #'(lambda (expr) (MI=EXPRESSION_RESET.AUXILIARY expr)) (MI=SINGLETERMS_THEORYTERMS SINGLETERMS))
        (MAPC #'(lambda (expr) (MI=EXPRESSION_RESET.AUXILIARY expr))
	      (MI=SUBTERMSTRUCTURE_EXPRESSIONS (MI=SINGLETERMS_COMPOSEDTERMS SINGLETERMS)))))
    (MI=TERMSTRUCTURE_POSITIONLIST TERMSTRUCTURE1))
  (MAPC (FUNCTION (lambda (expr) (MI=EXPRESSION_RESET.AUXILIARY expr))) (MI=TERMSTRUCTURE_EXPRESSIONS TERMSTRUCTURE2)))

(DEFUN MI=SUBSET (TERMLIST PATTERN)
  ;; EDITED:  9. 11. 1983
  ;; INPUT:   A STANDARDTERMLIST AND A PATTERN WITH THE
  ;;          SAME LENGTH AS TERMLIST.
  ;; VALUE:   THE ELEMENTS OF TERMLIST BELONGING
  ;;          TO NON-NIL VALUES IN PATTERN.
  (MAPC (FUNCTION (LAMBDA (TERM PAT) (COND (PAT (SETQ TERMLIST (NCONC1 TERMLIST TERM))))))
	(PROG1 TERMLIST (SETQ TERMLIST NIL)) PATTERN)
  TERMLIST)

(DEFUN MI=INTERSECT (TERMSTRUCTURE1 TERMSTRUCTURE2)
  ;; EDITED: 10-NOV-83 19:51:13
  ;; INPUT:  TWO TERMSTRUCTURES WITH VARIABLE PATTERNS
  ;; EFFECT: THE VARIABLES
  ;;         POSITIONLIST1, POSITIONLIST2, TERM.PATTERN
  ;;         DEFINED IN MI-MERGE ARE CALULATED.
  ;; VALUE:  UNDEFINED
  ;; EXAMPLE: PATTERN1 = (X Y Z)
  ;;          PATTERN2 = (Z U X V)
  ;;          POSITIONLIST1 -> (1. 3.) SINGLETERMS
  ;;          POSITIONLIST2 -> (3. 1.) SINGLETMRMS
  ;;          TERM.PATTERN  -> (T NIL T)
  (PROG
    ((VARIABLES1 (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE1)) TERM.PATTERN POSITIONLIST1 POSITIONLIST2
     (VARIABLES2 (MI=TERMSTRUCTURE_PATTERN TERMSTRUCTURE2))
     (POSLIST1 (MI=TERMSTRUCTURE_POSITIONLIST TERMSTRUCTURE1))
     (POSLIST2 (MI=TERMSTRUCTURE_POSITIONLIST TERMSTRUCTURE2)) POSITION)
    (DECLARE (SPECIAL TERM.PATTERN POSITIONLIST1 POSITIONLIST2))
    (SETQ TERM.PATTERN
	  (MAPCAR
	    (FUNCTION
	      (LAMBDA (VARIABLE)
		(PROG1
		  (COND
		    ((SETQ POSITION (LISTPOS VARIABLE VARIABLES2))
		     (SETQ POSITIONLIST1 (NCONC1 POSITIONLIST1 (CAR POSLIST1)))
		     (SETQ POSITIONLIST2 (NCONC1 POSITIONLIST2 (CAR (NTHCDR (1- POSITION) POSLIST2)))) T))
		  (SETQ POSLIST1 (CDR POSLIST1)))))
	    VARIABLES1))))

(DEFUN MI=TERMSTRUCTURE_INITIALIZE (PATTERN)
  ;; EDITED: 26-OCT-82 18:05:24
  ;; INPUT:  PATTERN IS A LIST WITH ELEMENTS T OR NIL
  ;;         OR A LIST WITH VARIABLES.
  ;;         FOR EVERY POSITION REPRESENTED BY T, A
  ;;         TERM CAN BE INSERTED INTO THE NEW
  ;;         TERMSTRUCTURE. (PATTERN MAY BE NIL).
  ;; VALUE:  THE NEW EMPTY TERMSTRUCTURE
  (COND
    ((DT-VARIABLE.IS (CAR PATTERN))
     (LIST (MAPCAR (FUNCTION (LAMBDA (ELEMENT) (MI=SINGLETERMS_INITIALIZE))) PATTERN) PATTERN (LIST-LENGTH PATTERN)
	   'VARIABLES NIL))
    (T
     (PROG ((COUNTER 0))
	   (RETURN
	     (LIST
	       (MAPCAN
		 (FUNCTION
		   (LAMBDA (ELEMENT)
		     (COND (ELEMENT (SETQ COUNTER (1+ COUNTER)) (LIST (MI=SINGLETERMS_INITIALIZE))))))
		 PATTERN)
	       (COPY-TREE PATTERN) (LIST-LENGTH PATTERN) COUNTER NIL))))))

(DEFMACRO MI=TERMSTRUCTURE_ADD.EXPRESSION (TERMSTRUCTURE EXPRESSION)
  ;; EDITED: 11-NOV-82 13:59:33
  ;; INPUT:  AN MI-TERMSTRUCTURE AND AN MI-TERMLIST
  ;; EFFECT: THE MI-TERMLIST IS INSERTED INTO
  ;;         TERMSTRUCTURE'S TERMLIST.
  ;; VALUE:  UNDEFINED.
  `(QCONC1 (CDDDDR ,TERMSTRUCTURE) ,EXPRESSION))

(DEFMACRO MI=TERMSTRUCTURE_POSITIONLIST (TERMSTRUCTURE)
  ;; EDITED: 26-OCT-82 18:20:48
  ;; INPUT:  AN MI-TERMSTRUCTURE
  ;; VALUE:  ITS POSITIONLIST.
  `(CAR ,TERMSTRUCTURE))

(DEFMACRO MI=TERMSTRUCTURE_PATTERN (TERMSTRUCTURE)
  ;; EDITED: 26-OCT-82 18:18:10
  ;; INPUT:  AN MI-TERMSTRUCTURE
  ;; VALUE:  ITS PATTERN.
  `(SECOND ,TERMSTRUCTURE))

(DEFMACRO MI=TERMSTRUCTURE_EXPRESSIONS (TERMSTRUCTURE)
  ;; EDITED:  9-NOV-82 10:33:54
  ;; INPUT:   AN MI-TERMSTRUCTURE
  ;; VALUE:   ITS TERMLISTS.
  `(CAR (CDDDDR ,TERMSTRUCTURE)))

(DEFMACRO MI=TERMSTRUCTURE_PATTERN.LENGTH (TERMSTRUCTURE)
  ;; EDITED: 28-FEB-83 12:08:23
  ;; INPUT:  AN MI-TERMSTRUCTURE
  ;; VALUE:  THE LENGTH OF ITS PATTERN.
  `(THIRD ,TERMSTRUCTURE))

(DEFMACRO MI=TERMSTRUCTURE_T.LENGTH (TERMSTRUCTURE)
  ;; EDITED: 28-FEB-83 12:08:23
  ;; INPUT:  AN MI-TERMSTRUCTURE
  ;; VALUE:  THE NUMBER OF T'S IN ITS PATTERN.
  `(FOURTH ,TERMSTRUCTURE))

(DEFMACRO MI=TERMSTRUCTURE_VARIABLE.PATTERN (TERMSTRUCTURE)
  ;; EDITED: 10-OCT-83 16:13:58
  ;; INPUT:  A TERMSTRUCTURE
  ;; VALUE:  NOT NIL, IF THE PATTERN IS A LIST OF
  ;;         VARIABLES
  `(EQL 'VARIABLES (MI=TERMSTRUCTURE_T.LENGTH ,TERMSTRUCTURE)))

(DEFUN MI=TERMSTRUCTURE_ARITY (TERMSTRUCTURE)
  ;; EDITED: 10-OCT-83 16:51:53
  ;; INPUT:  A TERMSTRUCTURE
  ;; VALUE:  THE NUMBER OF POSITIONLISTS
  (COND
    ((MI=TERMSTRUCTURE_VARIABLE.PATTERN TERMSTRUCTURE) (MI=TERMSTRUCTURE_PATTERN.LENGTH TERMSTRUCTURE))
    (T (MI=TERMSTRUCTURE_T.LENGTH TERMSTRUCTURE))))

(DEFMACRO MI=SINGLETERMS_INITIALIZE NIL
  ;; EDITED: 11-OCT-83 16:38:41
  ;; VALUE:  AN EMPTY SINGLETERMS-LIST:
  ;;         COMPONENTS: CONSTANTS
  ;;                     VARIABLES
  ;;                     ABBREVIATIONS
  ;;                     THEORYTERMS
  ;;                     COMPOSEDTERMS (SUBTERMSTRUCTURE)
  `(LIST NIL NIL NIL NIL NIL))

(DEFMACRO MI=SINGLETERMS_CONSTANTS (SINGLETERMS)
  ;; EDITED:  9-NOV-82 10:47:46
  ;; INPUT:   MI-SINGLETERMS
  ;; VALUE:   THE LIST OF MI-CONSTANTS.
  `(CAR ,SINGLETERMS))

(DEFMACRO MI=SINGLETERMS_VARIABLES (SINGLETERMS)
  ;; EDITED:  9-NOV-82 10:47:46
  ;; INPUT:   MI-SINGLETERMS
  ;; VALUE:   THE LIST OF MI-VARIABLES.
  `(SECOND ,SINGLETERMS))

(DEFMACRO MI=SINGLETERMS_ABBREVIATIONS (SINGLETERMS)
  ;; EDITED:  9-NOV-82 10:47:46
  ;; INPUT:   MI-SINGLETERMS
  ;; VALUE:   THE LIST OF MI-ABBREVIATIONS.
  `(THIRD ,SINGLETERMS))

(DEFMACRO MI=SINGLETERMS_THEORYTERMS (SINGLETERMS)
  ;; EDITED:  3-SEP-83 14:42:16
  ;; INPUT:   SINGLETERMS-LIST
  ;; VALUE:   THE SINGLETERMS WITH TOP FUNCTION SYMBOLS
  ;;          FOR WHICH A THEORY IS DEFINED.
  `(FOURTH ,SINGLETERMS))

(DEFMACRO MI=SINGLETERMS_COMPOSEDTERMS (SINGLETERMS)
  ;; EDITED:  9-NOV-82 10:47:46
  ;; INPUT:   MI-SINGLETERMS
  ;; VALUE:   THE LIST OF MI-COMPOSED TERMS.
  `(CDDDDR ,SINGLETERMS))

(DEFUN MI=SINGLETERMS_ADD.EXPRESSION (SINGLETERMS SINGLETERM TYPE)
  ;; EDITED:  3-SEP-83 14:45:29
  ;; INPUT:   SINGLETERMS, A SINGLETERM AND ONE OF THE
  ;;          ATOMS: CONSTANT, VARIABLE, ABBREVIATION,
  ;;          THEORYTERM.
  ;; EFFECT:  THE SINGLETERM IS ADDED TO THE
  ;;          CORRESPONDING TYPELIST
  ;; VALUE:   UNDEFINED.
  (SETQ SINGLETERMS
	(CASE TYPE (CONSTANT SINGLETERMS) (VARIABLE (CDR SINGLETERMS)) (ABBREVIATION (CDDR SINGLETERMS))
	      (THEORYTERM (CDDDR SINGLETERMS))
	      (OTHERWISE (ERROR "ILLEGAL TYPE IN MI=SINGLETERMS_ADD.SUB.SINGLETERM: ~A" TYPE))))
  (RPLACA SINGLETERMS (CONS SINGLETERM (CAR SINGLETERMS))))

(DEFUN MI=SUBTERMSTRUCTURE_CREATE.EMPTY.FUNCTIONLIST (SUBTERMSTRUCTURE FUNCTION ARITY)
  ;; EDITED: 24-AUG-83 09:04:17
  ;; INPUT:  A SUBTERMSTRUCTURE, A FUNCTION SYMBOL AND
  ;;         THE ARITY OF THE FUNCTION
  ;; EFFECT: AN EMPTY SUB.FUNCTIONLIST FOR FUNCTION
  ;;         IS CREATED AND INSERTED INTO
  ;;         SUBTERMSTRUCTURE.
  ;; VALUE:  THE EMPTY SINGLETERMS.LIST OF THE
  ;;         NEW FUNCTIONLIST
  (PROG ((SINGLETERMS (MI=SINGLETERMS_INITIALIZE)) SINGLETERMS.LIST)
	(DODOWN (RPTN (1- ARITY)) (SETQ SINGLETERMS.LIST (cons (COPY-TREE SINGLETERMS) SINGLETERMS.LIST)))
	(SETQ SINGLETERMS.LIST (cons SINGLETERMS  SINGLETERMS.list))
	(MI=SUBTERMSTRUCTURE_ADD.FUNCTIONLIST SUBTERMSTRUCTURE (cons FUNCTION  SINGLETERMS.list))
	(RETURN SINGLETERMS.LIST)))

(DEFMACRO MI=SUBTERMSTRUCTURE_ADD.FUNCTIONLIST (SUBTERMSTRUCTURE SUB.FUNCTIONLIST)
  ;; EDITED: 24-AUG-83 09:01:05
  ;; INPUT:  A SUBTERMSTRUCTURE AND A SUB.FUNCTIONLIST
  ;; EFFECT: THE SUB.FUNCTIONLIST IS ATTACHED AT THE
  ;;         FRONT OF THE SUB.FUNCTIONLIST
  ;; VALUE:  UNDEFINED.
  `(let ((MI=SUBTERMSTRUCTURE_ADD.FUNCTIONLISTsubtermstructure , subtermstructure))
     (RPLACA SUBTERMSTRUCTURE (cons ,SUB.FUNCTIONLIST
				    (mi=subtermstructure_functionlist MI=SUBTERMSTRUCTURE_ADD.FUNCTIONLISTsubtermstructure)))))

(DEFMACRO MI=SUBTERMSTRUCTURE_ADD.EXPRESSION (SUBTERMSTRUCTURE SUBTERM)
  ;; EDITED: 25-AUG-83 15:35:15
  ;; INPUT:  A SUBTERMSTRUCTURE AND A SUBTERM
  ;; EFFECT: THE SUBTERM IS ATTACHED AT THE FRONT OF
  ;;         THE SUBTERMLIST OF SUBTERMSTRUCTURE.
  ;; VALUE:  UNDEFINED.
  `(let ((SUBTERMSTRUCTURE_ADD.EXPRESSIONsubtermstructure , subtermstructure))
     (RPLACd SUBTERMSTRUCTURE (cons ,SUBterm (mi=subtermstructure_expressions SUBTERMSTRUCTURE_ADD.EXPRESSIONsubtermstructure)))))

(DEFMACRO MI=SUBTERMSTRUCTURE_EXPRESSIONS (SUBTERMSTRUCTURE)
  ;; EDITED: 23-AUG-83 11:08:05
  ;; INPUT:  A SUBTERMSTRUCTURE
  ;; VALUE:  A LIST OF SUBTERMS.
  ;;         EACH SUBTERM CONSISTS OF:
  ;;         STANDARDTERM, AUXILIARY, SUB.SINGLETERMS
  `(CDR ,SUBTERMSTRUCTURE))

(DEFMACRO MI=SUBTERMSTRUCTURE_FUNCTIONLIST (SUBTERMSTRUCTURE)
  ;; EDITED: 23-AUG-83 11:17:09
  ;; INPUT:  A SUBTERMSTRUCTURE
  ;; VALUE:  THE SUB.FUNCTIONLIST, AN ASSOCIATIONLIST_
  ;;         ((FUNCTION SUB.SINGLETERMS1 SUB.SINGLTERMS2)
  ;;          (FUNCTION ...
  `(CAR ,SUBTERMSTRUCTURE))

(DEFMACRO MI=EXPRESSION_INITIALIZE (STANDARDTERM SUPERTERMS.OR.PROPERTY)
  ;; EDITED: 25-AUG-83 15:49:00
  ;; INPUT:  A STANDARDTERM AND EITHER THE PROPERTY
  ;;         BELONGING TO THE TOP EXPRESSION OF A
  ;;         TERMSTRUCTURE OR A LIST OF SUPERTERMS
  ;;         (EXPRESSIONS) IN WHICH THE TERM OCCURS.
  ;; VALUE:  THE NEW SUB.SINGLETERM
  `(LIST ,STANDARDTERM 0 ,SUPERTERMS.OR.PROPERTY))

(DEFMACRO MI=EXPRESSION_PROPERTY (EXPRESSION)
  ;; EDITED:  3-SEP-83 14:26:23
  ;; INPUT:   AN EXPRESSION
  ;; VALUE:   IT'S PROPERTY
  `(THIRD ,EXPRESSION))

(DEFMACRO MI=EXPRESSION_PUT.PROPERTY (EXPRESSION VALUE)
  ;; EDITED:  3-SEP-83 14:26:23
  ;; INPUT:   AN EXPRESSION AND AN S-EXPRESSION
  ;; EFFECT:  THE VALUE IS PUT TO THE PROPERTY CELL
  ;; VALUE:   UNDEFINED
  `(RPLACA (CDDR ,EXPRESSION) ,VALUE))

(DEFMACRO MI=EXPRESSION_FUNCTION (EXPRESSION)
  ;; EDITED: 23-AUG-83 11:11:35
  ;; INPUT:  AN EXPRESSION.
  ;; VALUE:  THE TOP FUNCTIONSYMBOL
  `(CAR (MI=EXPRESSION_STANDARDTERM ,EXPRESSION)))

(DEFMACRO MI=EXPRESSION_STANDARDTERM (EXPRESSION)
  ;; EDITED: 23-AUG-83 11:40:09
  ;; INPUT:  AN EXPRESSION
  ;; VALUE:  THE CORRESPONDING TERM
  `(CAR ,EXPRESSION))

(DEFMACRO MI=EXPRESSION_AUXILIARY (EXPRESSION)
  ;; EDITED: 23-AUG-83 11:41:19
  ;; INPUT:  AN EXPRESSION.
  ;; VALUE:  THE AUXILIARY CELL
  `(SECOND ,EXPRESSION))

(DEFMACRO MI=EXPRESSION_PUT.AUXILIARY (EXPRESSION VALUE)
  ;; EDITED: 25-AUG-83 12:54:12
  ;; INPUT:  AN EXPRESSION AND AN S-EXPRESSION
  ;; EFFECT: VALUE IS PUT INTO THE AUXILIARY CELL
  ;; VALUE:  UNDEFINED
  `(RPLACA (CDR ,EXPRESSION) ,VALUE))

(DEFUN MI=EXPRESSION_INCREMENT.AUXILIARY (EXPRESSION)
  ;; EDITED: 31-AUG-83 13:13:39
  ;; INPUT:  AN EXPRESSION.
  ;; EFFECT: ITS AUXILIARY CELL IS INCREMENTED BY 1.
  ;; VALUE:  UNDEFINED
  (SETQ EXPRESSION (CDR EXPRESSION))
  (RPLACA EXPRESSION (1+ (CAR EXPRESSION))))

(DEFMACRO MI=EXPRESSION_RESET.AUXILIARY (EXPRESSION)
  ;; EDITED: 19-OCT-83 16:46:19
  ;; INPUT:  AN EXPRESSION.
  ;; EFFECT: THE AUXILIARY CELL IS SET TO ZERO
  ;; VALUE:  UNDEFINED.
  `(RPLACA (CDR ,EXPRESSION) 0))

(DEFUN MI=EXPRESSION_INSERT.TLINK (EXPRESSION TLINK)
  ;; EDITED: 19-OCT-83 16:46:19
  ;; INPUT:  AN EXPRESSION AND A TLINK.
  ;;         AUXILIARY CELL.
  ;; EFFECT: THE TLINK IS INSERTED INTO THE
  ;;         AUXILIARY CELL.
  ;; VALUE:  UNDEFINED.
  (SETQ EXPRESSION (CDR EXPRESSION))
  (RPLACA EXPRESSION (CONS TLINK (CAR EXPRESSION))))

(DEFMACRO MI=EXPRESSION_TLINKS (EXPRESSION)
  ;; EDITED: 19-OCT-83 16:46:19
  ;; INPUT:  AN EXPRESSION.
  ;; VALUE:  THE TLINKS, LOCATED AT THE AUXILIARY CELL.
  `(MI=EXPRESSION_AUXILIARY ,EXPRESSION))

(DEFMACRO MI=EXPRESSION_SUBTERMS (EXPRESSION)
  ;; EDITED: 23-AUG-83 11:12:49
  ;; INPUT:  AN EXPRESSION
  ;; VALUE:  THE CORRESPONDING SUBTERMS.
  `(CDDDR ,EXPRESSION))

(DEFMACRO MI=EXPRESSION_PUT.SUBTERMS (EXPRESSION SUBTERMS)
  ;; EDITED: 25-AUG-83 15:37:21
  ;; INPUT:  AN EXPRESSION AND THE CORRESPONDING LIST OF
  ;;         SUBTERMS.
  ;; EFFECT: THE SUBTERMS ARE INSERTED INTO THE
  ;;         SUBTERM CELL OF EXPRESSION.
  ;; VALUE:  UNDEFINED.
  `(RPLACD (CDDR ,EXPRESSION) ,SUBTERMS))

(DEFMACRO MI=EXPRESSION_SUPERTERMS (EXPRESSION)
  ;; EDITED: 23-AUG-83 14:11:24
  ;; INPUT:  AN EXPRESSION
  ;; VALUE:  LIST OF SUPERTERMS IN WHICH EXPRESSION
  ;;         OCCURS.
  `(THIRD ,EXPRESSION))

(DEFUN MI=EXPRESSION_ADD.SUPERTERM (EXPRESSION SUPERTERM)
  ;; EDITED:  3-NOV-83 09:54:01
  ;; INPUT:   AN EXPRESSION (NO TOP ELEMENT OF
  ;;          A TERMSTRUCTURE) AND ANOTHER EXPRESSION
  ;; EFFECT:  SUPERTERM IS INSERTED INTO
  ;;          THE BACKPOINTERLIST OF EXPRESSION.
  ;; VALUE:   UNDEFINED.
  (SETQ EXPRESSION (CDDR EXPRESSION))
  (RPLACA EXPRESSION (cons SUPERTERM (car expression))))

(DEFMACRO MI=EXPRESSION_INCREMENT.SUPERTERMS (EXPRESSION)
  ;; EDITED:  3-SEP-83 12:02:45
  ;; INPUT:   AN EXPRESSION
  ;; EFFECT:  THE AUXILIARY CELLS OF ALL SUPERTERMS
  ;;          CONTAINING EXPRESSION ARE INCREMENTED BY 1.
  ;; VALUE:   UNDEFINED
  `(MAPC (FUNCTION MI=EXPRESSION_INCREMENT.AUXILIARY) (MI=EXPRESSION_SUPERTERMS ,EXPRESSION)))

(DEFMACRO MI=EXPRESSION_CREATE.EMPTY.SINGLETERMS (ARITY)
  ;; EDITED:  8-NOV-83 15:54:20
  ;; INPUT:   A NATURAL NUMBER > 0
  ;; VALUE:   A LIST WITH 'ARITY' EMPTY ELEMENTS
  `(make-list ,arity))