;;; -*- Mode: LISP; Syntax: Common-lisp; Package: MKRP -*-

(IN-PACKAGE "MKRP" :use '("CL"))

(DEFUN QCONC1 (POINTER ITEM)
  (IF POINTER
      (LET ((LAST.CELL (CDR POINTER)))
	(IF LAST.CELL
	    (SETF (CDR LAST.CELL) (LIST ITEM)
		  (CDR POINTER)   (CDR LAST.CELL))
	    (SETF (CAR POINTER)   (LIST ITEM)
		  (CDR POINTER)   (CAR POINTER))))
      (SETf POINTER       (LIST (LIST ITEM))
	    (CDR POINTER) (CAR POINTER)))
  POINTER)


(DEFUN QCONC (POINTER ITEMLIST)
  (IF POINTER
      (LET ((LAST.CELL (CDR POINTER)))
	(IF LAST.CELL
	    (PROGN (SETF (CDR LAST.CELL) ITEMLIST)
		   (IF ITEMLIST (SETF (CDR POINTER) (LAST ITEMLIST))))
	    (SETF (CAR POINTER) ITEMLIST
		  (CDR POINTER) (LAST ITEMLIST))))
      (SETf POINTER (LIST ITEMLIST)
	    (CDR POINTER) (LAST ITEMLIST)))
  POINTER)


(DEFUN QCONS (ITEM QPOINTER)
						; INPUT:  AN ATOM AND A LIST IN QCONC FORMAT.
						; EFFECT: DESTRUCTIVELY ATTACHES THE ATOM TO THE FRONT
						;         OF THE LIST.
						; VALUE:  THE NEW LIST IN QCONC FORMAT.
  (IF QPOINTER
      (LET ((LIST (CAR QPOINTER)))
	(COND ((NULL LIST)
	       ;; ITEM BECOMES ONLY ELEMENT OF LIST
	       (SETQ LIST (LIST ITEM))
	       (RPLACA QPOINTER LIST)
	       (RPLACD QPOINTER LIST))
	      (T (RPLACA QPOINTER (CONS ITEM LIST))))
	QPOINTER)
      (QCONC1 NIL ITEM)))


(DEFUN Qdelete (QPOINTER ITEM &KEY (TEST (FUNCTION EQL)) (COUNT -1))
						; INPUT   A LIST IN QCONC FORMAT AND AN ITEM.
						; EFFECT  DESTRUCTIVELY REMOVES ALL count OCCURRENCES
						;	    OF THE ITEM FROM THE LIST.
						; VALUE   THE NEW LIST IN QCONC FORMAT
  (LET ((LIST (CAR QPOINTER)) POINTER)
    (WHILE (AND LIST (FUNCALL TEST ITEM (CAR LIST)) (/= count 0))
      (SETQ LIST (CDR LIST))
      (SETQ COUNT (1- COUNT)))
    (RPLACA QPOINTER LIST)
    (IF LIST
	(PROGN (SETQ POINTER (CDR LIST))
	       (WHILE POINTER
		 (COND ((FUNCALL TEST ITEM (CAR POINTER))
			(SETQ POINTER (CDR POINTER))
			(RPLACD LIST POINTER)
			(setq count (1- count))
			(when (null pointer) (RPLACD QPOINTER LIST))
			(WHEN (= count 0) (SETQ POINTER NIL)))
		       (T (SETQ LIST POINTER
				POINTER (CDR POINTER))))))
	(RPLACD QPOINTER NIL))
    QPOINTER))


(DEFUN QINSERT-NTH (QCONCLIST POSITION ELEMENT)
						; EDITED:23-FEB-83.
						; INPUT: 'QCONCLIST' IS A QCONCLIST (NOT NIL).
						;        INTEGER 'POSITION', 1 <= |'POSITION'| <=
						;        LENGTH OF 'QCONCLIST'+1.
						;        'ELEMENT' IS A S-TREEESSION.
						; EFFECT:INSERTS 'ELEMENT' IN 'QCONCLIST' BEFORE THE
						;        'POSITION'TH ELEMENT OF THE LIST. NEGATIVE
						;        'POSITION'S ARE COUNTED FROM BEHIND.
						; VALUE: THE MODIFIED QCONCLIST.
						; REMARK:NO INPUT-ERROR-CHECK.
  (LET (HELPING.POINTER)
    ;; (1) TRANSMITTING NEG. POSITION TO THE CORRESPONDING
    ;;     POSITIVE.
    (COND ((MINUSP POSITION)
	   (SETQ POSITION (+ 2 POSITION (LENGTH (CAR QCONCLIST))))))
    ;; (2) CONDITIONAL RESPECTING THE POSITION.
    (COND ((< POSITION 2)
	   ;; (2A) INSERT AT FRONT.
	   (QCONS ELEMENT QCONCLIST))
	  ((< (LENGTH (CAR QCONCLIST)) POSITION)
	   ;; (2B) INSERT AT THE END.
	   (QCONC1 QCONCLIST ELEMENT))
	  (T
	   ;; (2C) INSERT AT ANOTHER PLACE.
	   (RPLACD (SETQ HELPING.POINTER (NTHCDR (- POSITION 2) (CAR QCONCLIST)))
		   (CONS ELEMENT (CDR HELPING.POINTER)))))
    QCONCLIST))

(DEFUN Qdelete-NTH (QCONCLIST POSITION)
						; EDITED:23-FEB-83.
						; INPUT: 'QCONCLIST' IS A QCONCLIST (NOT NIL).
						;        INTEGER 'POSITION', 1 <= /'POSITION'/ <=
						;        LENGTH OF 'QCONCLIST.
						; EFFECT:REMOVES THE 'POSITION'TH ELEMENT OUT OF THE
						;        LIST. NEGATIVE 'POSITION'S ARE COUNTED FROM
						;        BEHIND.
						; VALUE: THE MODIFIED QCONCLIST.
						; REMARK:NO INPUT-ERROR-CHECK.
  (if (zerop position) qconclist
      (LET ((LENGTH (LENGTH (CAR QCONCLIST)))
	    HELPING.POINTER)
	;; (1) TRANSMITTING A NEGATIVE POSITION IN THE CORRESP.
	;;     POSITIVE.
	(COND ((MINUSP POSITION)
	       (SETQ POSITION (+ 1 POSITION LENGTH))))
	;; (2) CONDITIONAL RESPECTING THE POSITION.
	(UNLESS (OR (MINUSP POSITION) (> POSITION LENGTH))
	  (COND ((= LENGTH 1)
		 ;; (2A) ONLY ONE ELEMENT IN THE LIST.
		 (RPLACA QCONCLIST NIL)
		 (RPLACD QCONCLIST NIL))
		((< POSITION 2)
		 ;; (2B) DELETE THE FIRST ELEMENT.
		 (RPLACA QCONCLIST (CDAR QCONCLIST)))
		((< LENGTH (1+ POSITION))
		 ;; (2C) DELETE THE LAST ELEMENT.
		 (RPLACD QCONCLIST (NTHCDR (- LENGTH 2) (CAR QCONCLIST)))
		 (RPLACD (CDR QCONCLIST) NIL))
		(T
		 ;; (2D) DELETE AN ELEMENT AT ANOTHER POSITION.
		 (RPLACD (SETQ HELPING.POINTER (NTHCDR (- POSITION 2) (CAR QCONCLIST)))
			 (CDDR HELPING.POINTER)))))
	QCONCLIST)))

