;;; -*- Package: MKRP; Syntax: Common-lisp; Mode: LISP -*-

(IN-PACKAGE "MKRP" :use '("CL"))

(DEFMACRO RDS-RULES (INDICATOR)
  (let ((RULES (if (constantp indicator)
		   (eval `(RDS==RULES ,INDICATOR))
		   'error)))
    (if (Not (eql RULES 'ERROR))
	(if (or (every #'symbolp rules)
		(equal INDICATOR ''INITIAL.RULE.COMPONENTS))
	    `',RULES
	    rules)
	`(RDS==RULES ,INDICATOR))))

(DEFUN RDS==RULES (INDICATOR)
						; EDITED:  9-JUL-84 13:48:34
						; INPUT:  'INDICATOR' IS ONE OF THE
						;         SELECTQ-INDICATORS OF THIS FUNCTION.
						; EFFECT: -
						; VALUE:  A LIST OF REDUCTION RULE DESCRIPTORS OR
						;         A LIST OF STATIC INITIAL
						;         DATA FOR REDUCTION RULE DESCRIPTORS.
  (CASE INDICATOR
    (ALL
      '(RED*CLAUSE.PURITY
	 RED*CLAUSE.TAUTOLOGY RED*CLAUSE.SUBSUMPTION.OBJECT RED*CLAUSE.MULTIPLE.LITERALS	 
	 RED*CLAUSE.SUBSUMPTION.SUBJECT RED*CLAUSE.REPL.FACTORING RED*CLAUSE.REPL.RESOLUTION.OBJECT
	 RED*CLAUSE.REPL.RESOLUTION.SUBJECT RED*CLAUSE.REWRITING
	 RED*LINK.TAUTOLOGY RED*LINK.INCOMPATIBILITY
	 RED*LINK.SUBSUMPTION.SUBJECT RED*LINK.SUBSUMPTION.OBJECT))
    (INITIAL.RULE.COMPONENTS
      '((RED*CLAUSE.MULTIPLE.LITERALS INS RED=APPLY_CLAUSE.MULTIPLE.LITERALS.TO.CLAUSE
				      RED=APPLY_CLAUSE.MULTIPLE.LITERALS.TO.LINK NIL)
        (RED*CLAUSE.PURITY INS RED=APPLY_CLAUSE.PURITY.TO.CLAUSE NIL NIL)
        (RED*CLAUSE.TAUTOLOGY INS RED=APPLY_CLAUSE.TAUTOLOGY.TO.CLAUSE RED=APPLY_CLAUSE.TAUTOLOGY.TO.LINK
			      RED=APPLY_CLAUSE.TAUTOLOGY.TO.RECHECK)
        (RED*CLAUSE.REPL.FACTORING INS RED=APPLY_CLAUSE.REPL.FACTORING.TO.CLAUSE
				   RED=APPLY_CLAUSE.REPL.FACTORING.TO.LINK NIL)
        (RED*CLAUSE.REPL.RESOLUTION.OBJECT RDS-AGENDA.INSERT.CLAUSE.GREATER
					   RED=APPLY_CLAUSE.REPL.RESOLUTION.OBJECT.TO.CLAUSE NIL NIL)
        (RED*CLAUSE.REPL.RESOLUTION.SUBJECT RDS-AGENDA.INSERT.CLAUSE.LESS
					    RED=APPLY_CLAUSE.REPL.RESOLUTION.SUBJECT.TO.CLAUSE
					    RED=APPLY_CLAUSE.REPL.RESOLUTION.SUBJECT.TO.LINK NIL)
        (RED*CLAUSE.SUBSUMPTION.OBJECT RDS-AGENDA.INSERT.CLAUSE.GREATER
				       RED=APPLY_CLAUSE.SUBSUMPTION.OBJECT.TO.CLAUSE NIL NIL)
        (RED*CLAUSE.REWRITING INS RED=APPLY_CLAUSE.REWRITING.TO.CLAUSE)
        (RED*LINK.INCOMPATIBILITY INS RED=APPLY_LINK.INCOMPATIBILITY.TO.CLAUSE
				  RED=APPLY_LINK.INCOMPATIBILITY.TO.LINK NIL)
        (RED*CLAUSE.SUBSUMPTION.SUBJECT RDS-AGENDA.INSERT.CLAUSE.LESS
					RED=APPLY_CLAUSE.SUBSUMPTION.SUBJECT.TO.CLAUSE RED=APPLY_CLAUSE.SUBSUMPTION.SUBJECT.TO.LINK
					RED=APPLY_CLAUSE.SUBSUMPTION.SUBJECT.TO.RECHECK)
        (RED*LINK.TAUTOLOGY INS RED=APPLY_LINK.TAUTOLOGY.TO.CLAUSE RED=APPLY_LINK.TAUTOLOGY.TO.LINK
			    RED=APPLY_LINK.TAUTOLOGY.TO.RECHECK)
        (RED*LINK.SUBSUMPTION.SUBJECT RDS-AGENDA.INSERT.CLAUSE.LESS
				      RED=APPLY_LINK.SUBSUMPTION.SUBJECT.TO.CLAUSE RED=APPLY_LINK.SUBSUMPTION.SUBJECT.TO.LINK
				      RED=APPLY_LINK.SUBSUMPTION.SUBJECT.TO.RECHECK)
        (RED*LINK.SUBSUMPTION.OBJECT RDS-AGENDA.INSERT.CLAUSE.GREATER
				     RED=APPLY_LINK.SUBSUMPTION.OBJECT.TO.CLAUSE RED=APPLY_LINK.SUBSUMPTION.OBJECT.TO.LINK NIL)))
    (DEDUCED.PARTIAL
      '(RED*CLAUSE.REPL.FACTORING red*clause.rewriting RED*CLAUSE.REPL.RESOLUTION.OBJECT RED*CLAUSE.SUBSUMPTION.OBJECT
				  RED*CLAUSE.TAUTOLOGY RED*CLAUSE.MULTIPLE.LITERALS))
    (DEDUCED
      '(RED*CLAUSE.REPL.FACTORING red*clause.rewriting RED*CLAUSE.REPL.RESOLUTION.OBJECT RED*CLAUSE.REPL.RESOLUTION.SUBJECT
				  RED*CLAUSE.SUBSUMPTION.OBJECT RED*CLAUSE.SUBSUMPTION.SUBJECT RED*CLAUSE.PURITY
				  RED*LINK.INCOMPATIBILITY RED*LINK.SUBSUMPTION.OBJECT RED*LINK.SUBSUMPTION.SUBJECT
				  RED*LINK.TAUTOLOGY))
    (INITIAL.PARTIAL
      '(RED*CLAUSE.MULTIPLE.LITERALS RED*CLAUSE.TAUTOLOGY RED*CLAUSE.SUBSUMPTION.OBJECT
				     RED*CLAUSE.SUBSUMPTION.SUBJECT RED*CLAUSE.REPL.FACTORING
				     RED*CLAUSE.REPL.RESOLUTION.OBJECT
				     RED*CLAUSE.REPL.RESOLUTION.SUBJECT RED*CLAUSE.REWRITING))
    (INITIAL '(RED*LINK.TAUTOLOGY RED*LINK.INCOMPATIBILITY RED*LINK.SUBSUMPTION.SUBJECT RED*CLAUSE.PURITY))
    (RULE
      '(RED*CLAUSE.MULTIPLE.LITERALS RED*CLAUSE.TAUTOLOGY RED*CLAUSE.SUBSUMPTION.OBJECT
				     RED*CLAUSE.REPL.FACTORING RED*CLAUSE.REPL.RESOLUTION.OBJECT RED*LINK.SUBSUMPTION.OBJECT))
    (SUBSUMPTION '(RED*CLAUSE.SUBSUMPTION.SUBJECT))
    (DEDUCED.SUPPRESSED
      '(RED*CLAUSE.REPL.RESOLUTION.OBJECT RED*CLAUSE.SUBSUMPTION.OBJECT RED*CLAUSE.REPL.FACTORING))
    (SUCCESSOR.STANDARD '(RED*CLAUSE.PURITY RED*LINK.INCOMPATIBILITY))
    (SUCCESSOR.LINK.INCOMPATIBILITY '(RED*CLAUSE.PURITY))
    (SUCCESSOR.LITERAL.REMOVAL
      `(if (opt-is.kz.completion)
	   (cons 'RED*CLAUSE.SUBSUMPTION.object
		 '(RED*CLAUSE.SUBSUMPTION.SUBJECT RED*LINK.SUBSUMPTION.SUBJECT RED*CLAUSE.REPL.RESOLUTION.SUBJECT
						  RED*CLAUSE.REPL.RESOLUTION.OBJECT RED*CLAUSE.REWRITING))
	   '(RED*CLAUSE.SUBSUMPTION.SUBJECT RED*LINK.SUBSUMPTION.SUBJECT RED*CLAUSE.REPL.RESOLUTION.SUBJECT
					    RED*CLAUSE.REPL.RESOLUTION.OBJECT RED*CLAUSE.REWRITING)))
    (SUCCESSOR.GENERALIZING
      '(RED*CLAUSE.PURITY RED*CLAUSE.REPL.RESOLUTION.SUBJECT RED*CLAUSE.REPL.RESOLUTION.OBJECT
			  RED*CLAUSE.SUBSUMPTION.SUBJECT RED*LINK.SUBSUMPTION.SUBJECT RED*CLAUSE.REWRITING
			  RED*LINK.SUBSUMPTION.OBJECT))
    (RECHECK
      '(RED*CLAUSE.TAUTOLOGY RED*CLAUSE.REPL.RESOLUTION.SUBJECT RED*CLAUSE.SUBSUMPTION.SUBJECT
			     RED*LINK.SUBSUMPTION.SUBJECT RED*LINK.TAUTOLOGY))
    (OTHERWISE (ERROR "RED-CHECK - ILLEGAL INDICATOR IN RDS-RULES: : ~A" INDICATOR))))

(DEFMACRO RDS-LINK.COLOURS (INDICATOR)
  (let ((RULES (if (constantp indicator) (RDS==LINK.COLOURS  (second INDICATOR)) 'error)))

    (if (NEQ RULES 'ERROR) (list 'quote RULES) `(RDS==LINK.COLOURS  ,INDICATOR))))

(DEFUN RDS==LINK.COLOURS (INDICATOR)
						; EDITED:  9-JUL-84 13:49:34
						; INPUT:  'INDICATOR' IS ONE OF THE
						;         SELECTQ-INDICATORS OF THIS FUNCTION.
						; EFFECT: -
						; VALUE:  A LIST OF LINK COLOURS.
  (CASE INDICATOR (INCOMPATIBILITY.REASON '(RIW R P)) (TAUTOLOGY.DETECTION '(R RD T TI))
	((RESOLUTION TAUTOLOGY.CONDITION.EXTERNAL RECHECK.CLAUSE.EXTERNAL SUBSUMPTION.LINK.CONDITION.EXTERNAL) '(R))
	(SLC.INTERNAL.WEAK '(SIW RIW)) (SLC.STRONG '(SI NIL)) (SLC.DELETED.STRONG '(SID NIL))
	(SUBSUMPTION.LINK.CONDITION '(R SI RIW))
	(EQUALITY.REASONING '(RE REIW)) ((REPL.RESOLUTION R.IFF.T) '(R RD)) (TAUTOLOGY.DETECTION.EXTERNAL '(T R RD))
	(TAUTOLOGY.DETECTION.INTERNAL '(TI))
	((RECHECK.CLAUSE RESOLUTION.ALL TAUTOLOGY.CONDITION SLC.WEAK.INHERITANCE) '(R RIW))
	(SUBSUMPTION.LINK.CONDITION.EXT.INT '(S R)) (SUBSUMPTION.LINK.CONDITION.INTERNAL '(SI RIW))
	(NOT.COMPLEMENTARY.INTERNAL '(SI SID)) (NOT.COMPLEMENTARY '(S SI SID)) (NOT.COMPLEMENTARY.EXTERNAL '(S))
	(OPERATION.EXTERNAL '(P R))
	(OPERATION.INTERNAL '(SI piw))
	(OPERATION (DS-LINK.COLOURS.FOR 'OPERATION))
	((SLC.RECHECK.SUBSUMENT RECHECK.LINK) '(R RIW S SI))
	((RESOLUTION.INTERNAL SUBSUMPTION.LINK.CONDITION.INT.EXT RECHECK.CLAUSE.INTERNAL
			      TAUTOLOGY.CONDITION.INTERNAL)
	 '(RIW))
	(OTHERWISE (ERROR "RED-CHECK - ILLEGAL INDICATOR IN RDS-LINK.COLOURS: : ~A" INDICATOR))))

(DEFVAR RED*LINK.SUBSUMPTION.SUBJECT (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*LINK.SUBSUMPTION.OBJECT (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*LINK.TAUTOLOGY (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*LINK.INCOMPATIBILITY (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*CLAUSE.REWRITING (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*CLAUSE.REPL.RESOLUTION.SUBJECT (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*CLAUSE.REPL.RESOLUTION.OBJECT (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*CLAUSE.SUBSUMPTION.OBJECT (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*CLAUSE.SUBSUMPTION.SUBJECT (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*CLAUSE.REPL.FACTORING (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*CLAUSE.TAUTOLOGY (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*CLAUSE.PURITY (MAKE-ARRAY (LIST 20)))

(DEFVAR RED*CLAUSE.MULTIPLE.LITERALS (MAKE-ARRAY (LIST 20)))

(DEFUN RDS==RULE (INDICATOR RULE)
						; EDITED: 10-JUL-84 10:21:12
						; INPUT:  'INDICATOR' SELECTS ONE OF THE COMPONENTS
						;         OF REDUCTION RULE DESCRIPTOR 'RULE'
						;         (MEMBER OF '(RDS-RULES 'ALL)').
						; EFFECT: -
						; VALUE:  THE SELECTED COMPONENT.
						; REMARK: FOR EACH OBJECT TYPE (CLAUSE, LINK, RECHECK
						;         = REMOVED LINK) EXISTS ONE CELL FOR AGENDA,
						;         OPTION, OPTION CONTROL, AND APPLY FUNCTION.
						;         IN THE OPTION CELLS THE OPTIONS ACCORDING
						;         TO LAST CALL OF 'RED-RESET' ARE STORED.
						;         IN THE CONTROL CELLS THE OPTIONS FOR THE
						;         CURRENT CALL OF REDUCTION ARE SET, THEY
						;         ARE NOT NECESSARILY EQUAL TO THE OPTIONS
						;         IN THE OPTION CELLS.
  (CASE INDICATOR (APPLY.TO.CLAUSE.FUNCTION (AREF (SYMBOL-VALUE RULE) 1))
	(APPLY.TO.LINK.FUNCTION (AREF (SYMBOL-VALUE RULE) 2)) (APPLY.TO.RECHECK.FUNCTION (AREF (SYMBOL-VALUE RULE) 3))
	(CLAUSE.AGENDA (AREF (SYMBOL-VALUE RULE) 4)) (LINK.AGENDA (AREF (SYMBOL-VALUE RULE) 5))
	(RECHECK.AGENDA (AREF (SYMBOL-VALUE RULE) 6)) (CONDITION (AREF (SYMBOL-VALUE RULE) 7)) (LINK (AREF (SYMBOL-VALUE RULE) 8))
	(RECHECK (AREF (SYMBOL-VALUE RULE) 9)) (CONDITION.OPTION (AREF (SYMBOL-VALUE RULE) 10))
	(LINK.OPTION (AREF (SYMBOL-VALUE RULE) 11)) (RECHECK.OPTION (AREF (SYMBOL-VALUE RULE) 12))
	(RECHECK.INFO (AREF (SYMBOL-VALUE RULE) 13)) (INSERT.CLAUSE.FUNCTION (AREF (SYMBOL-VALUE RULE) 14))
	(TOT.TIME (AREF (SYMBOL-VALUE RULE) 15)) (TOT.TIMES (AREF (SYMBOL-VALUE RULE) 16)) (TOT.SPACE (AREF (SYMBOL-VALUE RULE) 17))
	(TIME (AREF (SYMBOL-VALUE RULE) 18)) (TIMES (AREF (SYMBOL-VALUE RULE) 19)) (SPACE (AREF (SYMBOL-VALUE RULE) 20))
	(OTHERWISE (ERROR "RED-CHECK - ILLEGAL RULE COMPONENT INDICATOR IN RDS-RULE: : ~A" INDICATOR))))

(defmacro rds-rule (indicator rule)
  (if (constantp indicator)
      (case (cadr INDICATOR)
	(APPLY.TO.CLAUSE.FUNCTION `(ELT (SYMBOL-VALUE ,RULE) 1))
	(APPLY.TO.LINK.FUNCTION `(ELT (SYMBOL-VALUE ,RULE) 2))
	(APPLY.TO.RECHECK.FUNCTION `(ELT (SYMBOL-VALUE ,RULE) 3))
	(CLAUSE.AGENDA `(ELT (SYMBOL-VALUE ,RULE) 4))
	(LINK.AGENDA `(ELT (SYMBOL-VALUE ,RULE) 5))
	(RECHECK.AGENDA `(ELT (SYMBOL-VALUE ,RULE) 6))
	(CONDITION `(ELT (SYMBOL-VALUE ,RULE) 7))
	(LINK `(ELT (SYMBOL-VALUE ,RULE) 8))
	(RECHECK `(ELT (SYMBOL-VALUE ,RULE) 9))
	(CONDITION.OPTION `(ELT (SYMBOL-VALUE ,RULE) 10))
	(LINK.OPTION `(ELT (SYMBOL-VALUE ,RULE) 11))
	(RECHECK.OPTION `(ELT (SYMBOL-VALUE ,RULE) 12))
	(RECHECK.INFO `(ELT (SYMBOL-VALUE ,RULE) 13))
	(INSERT.CLAUSE.FUNCTION `(ELT (SYMBOL-VALUE ,RULE) 14))
	(TOT.TIME `(ELT (SYMBOL-VALUE ,RULE) 15))
	(TOT.TIMES `(ELT (SYMBOL-VALUE ,RULE) 16))
	(TOT.SPACE `(ELT (SYMBOL-VALUE ,RULE) 17))
	(TIME `(ELT (SYMBOL-VALUE ,RULE) 18))
	(TIMES `(ELT (SYMBOL-VALUE ,RULE) 19))
	(SPACE `(ELT (SYMBOL-VALUE ,RULE) 20))
	(otherwise (ERROR "RED-CHECK - ILLEGAL RULE COMPONENT INDICATOR IN RDS-RULE: ~A"
			  INDICATOR)))
      `(rds==rule ,indicator ,rule)))

(DEFUN RDS==RULE.PUT (INDICATOR RULE VALUE)
						; EDITED: 10-JUL-84 10:24:12
						; INPUT:  'INDICATOR' SELECTS ONE OF THE COMPONENTS
						;         OF REDUCTION RULE DESCRIPTOR 'RULE'
						;         (MEMBER OF '(RDS-RULES 'ALL)').
						;         'VALUE' IS A LEGAL EXPRESSION WHICH CAN BE
						;         SET AS VALUE OF THIS COMPONENT.
						; EFFECT: SETS 'VALUE' AS COMPONENT.
						; VALUE:  'VALUE'.
						; REMARK: FOR EACH OBJECT TYPE (CLAUSE, LINK, RECHECK
						;         = REMOVED LINK) EXISTS ONE CELL FOR AGENDA,
						;         OPTION, OPTION CONTROL, AND APPLY FUNCTION.
						;         IN THE OPTION CELLS THE OPTIONS ACCORDING
						;         TO LAST CALL OF 'RED-RESET' ARE STORED.
						;         IN THE CONTROL CELLS THE OPTIONS FOR THE
						;         CURRENT CALL OF REDUCTION ARE SET, THEY
						;         ARE NOT NECESSARILY EQUAL TO THE OPTIONS
						;         IN THE OPTION CELLS.
  (CASE INDICATOR (APPLY.TO.CLAUSE.FUNCTION (SETF (AREF (SYMBOL-VALUE RULE) 1) VALUE))
	(APPLY.TO.LINK.FUNCTION (SETF (AREF (SYMBOL-VALUE RULE) 2) VALUE))
	(APPLY.TO.RECHECK.FUNCTION (SETF (AREF (SYMBOL-VALUE RULE) 3) VALUE))
	(CLAUSE.AGENDA (SETF (AREF (SYMBOL-VALUE RULE) 4) VALUE)) (LINK.AGENDA (SETF (AREF (SYMBOL-VALUE RULE) 5) VALUE))
	(RECHECK.AGENDA (SETF (AREF (SYMBOL-VALUE RULE) 6) VALUE)) (CONDITION (SETF (AREF (SYMBOL-VALUE RULE) 7) VALUE))
	(LINK (SETF (AREF (SYMBOL-VALUE RULE) 8) VALUE)) (RECHECK (SETF (AREF (SYMBOL-VALUE RULE) 9) VALUE))
	(CONDITION.OPTION (SETF (AREF (SYMBOL-VALUE RULE) 10) VALUE)) (LINK.OPTION (SETF (AREF (SYMBOL-VALUE RULE) 11) VALUE))
	(RECHECK.OPTION (SETF (AREF (SYMBOL-VALUE RULE) 12) VALUE)) (RECHECK.INFO (SETF (AREF (SYMBOL-VALUE RULE) 13) VALUE))
	(INSERT.CLAUSE.FUNCTION (SETF (AREF (SYMBOL-VALUE RULE) 14) VALUE))
	(TOT.TIME (SETF (AREF (SYMBOL-VALUE RULE) 15) VALUE)) (TOT.TIMES (SETF (AREF (SYMBOL-VALUE RULE) 16) VALUE))
	(TOT.SPACE (SETF (AREF (SYMBOL-VALUE RULE) 17) VALUE)) (TIME (SETF (AREF (SYMBOL-VALUE RULE) 18) VALUE))
	(TIMES (SETF (AREF (SYMBOL-VALUE RULE) 19) VALUE)) (SPACE (SETF (AREF (SYMBOL-VALUE RULE) 20) VALUE))
	(OTHERWISE (ERROR "RED-CHECK - ILLEGAL RULE COMPONENT INDICATOR IN RDS-RULE.PUT: : ~A" INDICATOR))))

(defmacro rds-rule.put (indicator rule value)
  (if (constantp indicator)
      (case (cadr indicator)
	(APPLY.TO.CLAUSE.FUNCTION `(SETF (AREF (SYMBOL-VALUE ,RULE) 1) ,VALUE))
	(APPLY.TO.LINK.FUNCTION `(SETF (AREF (SYMBOL-VALUE ,RULE) 2) ,VALUE))
	(APPLY.TO.RECHECK.FUNCTION `(SETF (AREF (SYMBOL-VALUE ,RULE) 3) ,VALUE))
	(CLAUSE.AGENDA `(SETF (AREF (SYMBOL-VALUE ,RULE) 4) ,VALUE))
	(LINK.AGENDA `(SETF (AREF (SYMBOL-VALUE ,RULE) 5) ,VALUE))
	(RECHECK.AGENDA `(SETF (AREF (SYMBOL-VALUE ,RULE) 6) ,VALUE))
	(CONDITION `(SETF (AREF (SYMBOL-VALUE ,RULE) 7) ,VALUE))
	(LINK `(SETF (AREF (SYMBOL-VALUE ,RULE) 8) ,VALUE))
	(RECHECK `(SETF (AREF (SYMBOL-VALUE ,RULE) 9) ,VALUE))
	(CONDITION.OPTION `(SETF (AREF (SYMBOL-VALUE ,RULE) 10) ,VALUE))
	(LINK.OPTION `(SETF (AREF (SYMBOL-VALUE ,RULE) 11) ,VALUE))
	(RECHECK.OPTION `(SETF (AREF (SYMBOL-VALUE ,RULE) 12) ,VALUE))
	(RECHECK.INFO `(SETF (AREF (SYMBOL-VALUE ,RULE) 13) ,VALUE))
	(INSERT.CLAUSE.FUNCTION `(SETF (AREF (SYMBOL-VALUE ,RULE) 14) ,VALUE))
	(TOT.TIME `(SETF (AREF (SYMBOL-VALUE ,RULE) 15) ,VALUE))
	(TOT.TIMES `(SETF (AREF (SYMBOL-VALUE ,RULE) 16) ,VALUE))
	(TOT.SPACE `(SETF (AREF (SYMBOL-VALUE ,RULE) 17) ,VALUE))
	(TIME `(SETF (AREF (SYMBOL-VALUE ,RULE) 18) ,VALUE))
	(TIMES `(SETF (AREF (SYMBOL-VALUE ,RULE) 19) ,VALUE))
	(SPACE `(SETF (AREF (SYMBOL-VALUE ,RULE) 20) ,VALUE))
	(OTHERWISE (ERROR "RED-CHECK - ILLEGAL RULE COMPONENT INDICATOR IN RDS-RULE.PUT: : ~A" INDICATOR)))
      `(rds==rule.put ,indicator ,rule ,value)))

(DEFVAR RED*RULES.SWITCHED.ON NIL)

(DEFMACRO RDS-RULES.SWITCHED.ON NIL
						; EDITED: 10-AUG-84 04:22:14
						; INPUT:  -
						; EFFECT: -
						; VALUE:  THE LIST 'RED*RULES.SWITCHED.ON'.
  'RED*RULES.SWITCHED.ON)

(DEFMACRO RDS-RULES.SWITCHED.ON.PUT (RULES)
						; EDITED: 10-AUG-84 04:22:14
						; INPUT:  A LIST OF RULE DESCRIPTORS.
						; EFFECT: SETS THE LIST INTO 'RED*RULES.SWITCHED.ON'.
						; VALUE:  THE LIST 'RED*RULES.SWITCHED.ON'.
  `(SETQ RED*RULES.SWITCHED.ON ,RULES))

(DEFVAR RED*BINDING.STACK NIL)

(DEFMACRO RDS-BINDING.STACK.RESET NIL	; EDITED: 12-SEP-84 12:59:59
						; INPUT:  -
						; EFFECT: BINDING STACK IS SET TO NIL.
						; VALUE:  NIL.
  '(SETQ RED*BINDING.STACK NIL))

(DEFUN RDS-BINDING.RESET NIL			; EDITED: 14-APR-84 08:26:24
						; INPUT:  -
						; EFFECT: ALL BINDINGS OF VARIABLES SET BY THE
						;         REDUCTION MODULE WILL BE DELETED AND ALL
						;         INFORMATION ABOUT EARLIER BINDINGS IS
						;         REMOVED BY SETTING BINDINGSTACK EMPTY.
						; VALUE:  NIL.
  (UNI-RESET.BINDINGS.OF.SUBSTITUTION (CAR RED*BINDING.STACK)) (SETQ RED*BINDING.STACK NIL))

(DEFUN RDS-BINDING.PUSH (UNI)
						; EDITED: 14-APR-84 08:29:15
						; INPUT:  'UNI' IS A SUBSTITUTION.
						; EFFECT: LAST BINDINGS SET BY 'RDS-BINDING.PUSH'
						;         WILL BE DELETED AND 'UNI' IS SET AS NEW
						;         BINDINGS. IT IS PUSHED ONTO BINDINGSTACK.
						; VALUE:  NEW BINDINGSTACK.
  (UNI-RESET.BINDINGS.OF.SUBSTITUTION (CAR RED*BINDING.STACK))
  (UNI-SET.BINDINGS.OF.SUBSTITUTION UNI)
  (SETQ RED*BINDING.STACK (CONS UNI RED*BINDING.STACK)))

(DEFUN RDS-BINDING.POP (&optional DUMMY)
  (declare (ignore dummy))
						; EDITED: 14-APR-84 08:31:59
						; INPUT:  -
						; EFFECT: DELETES LAST BINDINGS SET BY
						;         'RDS-BINDING.PUSH'. REMOVES THE TOP
						;         (THESE BINDINGS) FROM BINDINGSTACK AND SETS
						;         THE NEW FIRST ELEMENT OF BINDINGSTACK AS
						;         NEW BINDINGS.
						; VALUE:  THE UNIFIER WHICH REPRESENTS THE DELETED
						;         BINDINGS.
  (UNI-RESET.BINDINGS.OF.SUBSTITUTION (CAR    RED*BINDING.STACK))
  (UNI-SET.BINDINGS.OF.SUBSTITUTION   (SECOND RED*BINDING.STACK))
  (PROG1 (CAR RED*BINDING.STACK) (SETQ RED*BINDING.STACK (CDR RED*BINDING.STACK))))

(DEFMACRO RDS-BINDING.TOP NIL		; EDITED: 14-APR-84 08:36:00
						; INPUT:  -
						; EFFECT: -
						; VALUE:  THE UNIFIER SET AS BINDINGS BY THE LAST CALL
						;         OF 'RDS-BINDING.PUSH' OR
						;         'RDS-BINDING.POP', E.G. THE FIRST ELEMENT
						;         OF BINDINGSTACK REPRESENTING THE CURRENT
						;         BINDINGS.
  '(CAR RED*BINDING.STACK))

(DEFVAR RDS*BUFFERS (BUFFER.CREATE 0))

(DEFMACRO RDS-BUFFER NIL
  'RDS*BUFFERS)

(DEFVAR RDS*MARKS
	(LIST (MAKE-ARRAY (LIST 5)) (MAKE-ARRAY (LIST 5)) (MAKE-ARRAY (LIST 5)) (MAKE-ARRAY (LIST 5))
	      (MAKE-ARRAY (LIST 5)) (MAKE-ARRAY (LIST 5))))

(DEFVAR RDS*MARKS.ALL RDS*MARKS)

(DEFMACRO RDS-MARK (MARK.ARRAY INDEX)
						; EDITED: 10-JUL-84 10:29:12
						; INPUT:  SAME AS LISP FUNCTION 'ELT'.
						; EFFECT: -
						; VALUE:  SAME AS LISP FUNCTION 'ELT'.
  `(AREF ,MARK.ARRAY ,(if (and (consp index)
			       (eq (first index) '1+))
			  (second index)
			  `(1- ,INDEX))))

(DEFMACRO RDS-MARK.PUT (MARK.ARRAY INDEX VALUE)
						; EDITED: 10-JUL-84 10:42:14
						; INPUT:  SAME AS LISP FUNCTION 'SETA'.
						; EFFECT: SAME AS LISP FUNCTION 'SETA'.
						; VALUE:  SAME AS LISP FUNCTION 'SETA'.
  `(SETF (AREF ,MARK.ARRAY ,(if (and (consp index)
				     (eq (first index) '1+))
				(second index)
				`(1- ,INDEX)))
	 ,VALUE))

(DEFUN RDS-MARKS.CREATE (LENGTH)
						; EDITED: 25-SEP-84 13:03:25
						; INPUT:  LENGTH IS A NATURAL NUMBER.
						; EFFECT: REMOVES FIRST ELEMENT FROM 'RDS*MARKS'.
						; VALUE:  THIS ELEMENT IF IT IS AN ARRAY GREATER OR
						;         EQUAL THAN 'LENGTH', ELSE A NEW ARRAY WITH
						;         LENGTH 'LENGTH'.
  (COND (RDS*MARKS)
	(T (let ((list (list (MAKE-ARRAY LENGTH))))
	     (SETQ RDS*MARKS list  RDS*MARKS.ALL (nconc RDS*MARKS.ALL list)))))
  (let ((FIRST (pop RDS*MARKS)))
    (COND ((> LENGTH (ARRAY-DIMENSION FIRST 0)) (MAKE-ARRAY LENGTH))
	  (T (DODOWN (RPTN LENGTH) (SETF (AREF FIRST RPTN) NIL))
	     FIRST))))

(DEFMACRO RDS-MARKS.RESET (MARKS VALUE)
						; EDITED: 25-SEP-84 13:11:09
						; INPUT:  'MARKS' IS AN ARRAY, 'VALUE' AN
						;         ARBITRARY S-EXPRESSION.
						; EFFECT: ALL CELLS OF 'MARKS' ARE SET TO 'VALUE'.
  `(let ((marks ,marks))
     (DODOWN (RPTN (ARRAY-DIMENSION MARKS 0))
       (SETF (AREF MARKS RPTN) ,VALUE))))

(DEFUN RDS-MARKS.DESTROY (NUMBER)
						; EDITED: 25-SEP-84 13:07:34
						; INPUT:  AN ARRAY.
						; EFFECT: INSERTS 'MARK.ARRAY' INTO 'RDS*MARKS'.
						; VALUE:  NEW 'RDS*MARKS'.
  (SETQ RDS*MARKS RDS*MARKS.ALL)
  (DODOWN (rptn number) (SETQ RDS*MARKS (CDR RDS*MARKS))))

(DEFUN RDS-AGENDA.INSERT.CLAUSE.GREATER (CLAUSE CLAUSE.AGENDA)
						; EDITED: 10-JUL-84 09:08:46
						; INPUT:  'CLAUSE' IS A CLAUSE, 'CLAUSE.AGENDA' IS A
						;         SORTED LIST OF CLAUSES (C1 ... CN) WHERE
						;         !CI+1! <= !CI!, 1 <= I <= N-1;
						;         CJ NOT NECESSARYLY IN CONNECTION GRAPH,
						;         1 <= J <= N.
						; EFFECT: 'CLAUSE' WILL BE INSERTED INTO 'CLAUSE.-
						;         AGENDA', SO THAT IN THE NEW LIST
						;         (C1 ... CJ 'CLAUSE' CJ+1 ... CN):
						;         !CJ! >= !'CLAUSE'! > !CJ+1!, IF CLAUSE IS
						;         NOT IN 'CLAUSE.AGENDA', ELSE NO EFFECT.
						; VALUE:  MODIFIED OR UNCHANGED LIST.
  (COND
    ((OR (NULL CLAUSE.AGENDA) (< (DS-CLAUSE.NOLIT (CAR CLAUSE.AGENDA)) (DS-CLAUSE.NOLIT CLAUSE)))
     (SETQ CLAUSE.AGENDA (CONS CLAUSE CLAUSE.AGENDA)))
    ((NEQ CLAUSE (CAR CLAUSE.AGENDA))
     (PROG ((SUCCESSOR (CDR CLAUSE.AGENDA)) (PREDECESSOR CLAUSE.AGENDA))
	   (WHILE PREDECESSOR
	     (COND ((EQL CLAUSE (CAR SUCCESSOR)) (SETQ PREDECESSOR NIL))
		   ((OR (NULL SUCCESSOR) (< (DS-CLAUSE.NOLIT (CAR SUCCESSOR)) (DS-CLAUSE.NOLIT CLAUSE)))
		    (RPLACD PREDECESSOR (CONS CLAUSE SUCCESSOR)) (SETQ PREDECESSOR NIL))
		   (T (SETQ PREDECESSOR SUCCESSOR) (SETQ SUCCESSOR (CDR PREDECESSOR))))))))
  CLAUSE.AGENDA)

(DEFUN RDS-AGENDA.INSERT.CLAUSE.LESS (CLAUSE CLAUSE.AGENDA)
						; EDITED: 10-JUL-84 09:08:46
						; INPUT:  'CLAUSE' IS A CLAUSE, 'CLAUSE.AGENDA' IS A
						;         SORTED LIST OF CLAUSES (C1 ... CN) WHERE
						;         !CI+1! >= !CI!, 1 <= I <= N-1;
						;         CJ NOT NECESSARYLY IN CONNECTION GRAPH,
						;         1 <= J <= N.
						; EFFECT: 'CLAUSE' WILL BE INSERTED INTO 'CLAUSE.-
						;         AGENDA', SO THAT IN THE NEW LIST
						;         (C1 ... CJ 'CLAUSE' CJ+1 ... CN):
						;         !CJ! < !'CLAUSE'! <= !CJ+1!, IF CLAUSE IS
						;         NOT IN 'CLAUSE.AGENDA', ELSE NO EFFECT.
						; VALUE:  MODIFIED OR UNCHANGED LIST.
  (COND
    ((OR (NULL CLAUSE.AGENDA) (> (DS-CLAUSE.NOLIT (CAR CLAUSE.AGENDA)) (DS-CLAUSE.NOLIT CLAUSE)))
     (COND ((NOT (MEMBER CLAUSE CLAUSE.AGENDA)) (SETQ CLAUSE.AGENDA (CONS CLAUSE CLAUSE.AGENDA)))))
    ((NEQ CLAUSE (CAR CLAUSE.AGENDA))
     (PROG ((SUCCESSOR (CDR CLAUSE.AGENDA)) (PREDECESSOR CLAUSE.AGENDA))
	   (WHILE PREDECESSOR
	     (COND ((EQL CLAUSE (CAR SUCCESSOR)) (SETQ PREDECESSOR NIL))
		   ((OR (NULL SUCCESSOR) (> (DS-CLAUSE.NOLIT (CAR SUCCESSOR)) (DS-CLAUSE.NOLIT CLAUSE)))
		    (COND ((NOT (MEMBER CLAUSE SUCCESSOR)) (RPLACD PREDECESSOR (CONS CLAUSE SUCCESSOR)))) (SETQ PREDECESSOR NIL))
		   (T (SETQ PREDECESSOR SUCCESSOR) (SETQ SUCCESSOR (CDR PREDECESSOR))))))))
  CLAUSE.AGENDA)


(defstruct (rds-rw_rule (:type list) (:conc-name rds-rw_rule.) (:constructor rds=rw_rule.make))
  clause
  application
  (counter 0 :type integer)
  left
  right
  c.tree)


(defvar rds*rw_variables nil)
(defvar rds*rw_assign nil)

(defun rds=rw_get.var (variable)
  (or (cassoc variable rds*rw_assign)
      (let ((list (assoc (dt-variable.sort variable) rds*rw_variables)))
	(unless list
	  (setq list (list (dt-variable.sort variable) nil nil))
	  (push list rds*rw_variables))
	(unless (second list)
	  (push (dt-variable.create (dt-variable.sort variable)) (second list))
	  (setf (third list) (second list)))
	(unless (third list)
	  (let ((rest (list (dt-variable.create (dt-variable.sort variable)))))
	    (nconc (second list) rest)
	    (setf (third list) rest)))
	(let ((new.var (pop (third list))))
	  (push (cons variable new.var) rds*rw_assign)
	  new.var))))

(defun rds=rw_reset.var ()
  (setq rds*rw_assign nil)
  (mapc #'(lambda (list) (setf (third list) (second list))) rds*rw_variables))

(defun rds=rw_cons.term (term)
  (cond ((dt-variable.is term)
	 (rds=rw_get.var term))
	((dt-constant.is term) term)
	(t (cons (dt-term_topsymbol term) (mapcar #'rds=rw_cons.term (dt-term_arguments term))))))

(defun rds-rw_rule.create (&key clause application counter left right c.tree)
  (prog1 (rds=rw_rule.make :clause clause
			   :application application
			   :counter (or counter 0)
			   :left (rds=rw_cons.term left)
			   :right (rds=rw_cons.term right)
			   :c.tree c.tree)
	 (rds=rw_reset.var)))